/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.diff.tools.util;

import com.intellij.diff.DiffContext;
import com.intellij.diff.impl.DiffSettingsHolder;
import com.intellij.diff.requests.DiffRequest;
import com.intellij.diff.tools.holders.BinaryEditorHolder;
import com.intellij.icons.AllIcons;
import com.intellij.openapi.Disposable;
import com.intellij.openapi.actionSystem.AnAction;
import com.intellij.openapi.actionSystem.AnActionEvent;
import com.intellij.openapi.fileEditor.FileEditor;
import com.intellij.openapi.fileEditor.FileEditorState;
import com.intellij.openapi.fileEditor.FileEditorStateLevel;
import com.intellij.openapi.fileEditor.TransferableFileEditorState;
import com.intellij.openapi.project.DumbAware;
import com.intellij.openapi.util.Condition;
import com.intellij.openapi.util.Disposer;
import com.intellij.openapi.util.Key;
import com.intellij.ui.ToggleActionButton;
import com.intellij.util.containers.ContainerUtil;
import java.awt.Dimension;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class TransferableFileEditorStateSupport {
    @NotNull
    private static final Key<MyState> TRANSFERABLE_FILE_EDITOR_STATE = Key.create((String)"Diff.TransferableFileEditorState");
    private static final Condition<BinaryEditorHolder> IS_SUPPORTED = holder -> TransferableFileEditorStateSupport.getEditorState(holder.getEditor()) != null;
    @NotNull
    private final DiffSettingsHolder.DiffSettings mySettings;
    @NotNull
    private final List<BinaryEditorHolder> myHolders;
    @NotNull
    private final List<? extends FileEditor> myEditors;
    private final boolean mySupported;
    private int myMasterIndex;
    private boolean myDuringUpdate;

    public TransferableFileEditorStateSupport(@NotNull DiffSettingsHolder.DiffSettings settings, @NotNull List<BinaryEditorHolder> holders, @NotNull Disposable disposable) {
        if (settings == null) {
            TransferableFileEditorStateSupport.$$$reportNull$$$0(0);
        }
        if (holders == null) {
            TransferableFileEditorStateSupport.$$$reportNull$$$0(1);
        }
        if (disposable == null) {
            TransferableFileEditorStateSupport.$$$reportNull$$$0(2);
        }
        this.myMasterIndex = 0;
        this.myDuringUpdate = true;
        this.mySettings = settings;
        this.myHolders = holders;
        this.myEditors = ContainerUtil.map((Collection)ContainerUtil.filter(holders, IS_SUPPORTED), holder -> holder.getEditor());
        this.mySupported = this.myEditors.size() > 0;
        new MySynchronizer().install(disposable);
    }

    public boolean isSupported() {
        return this.mySupported;
    }

    public boolean isEnabled() {
        return this.mySettings.isSyncBinaryEditorSettings();
    }

    public void setEnabled(boolean enabled) {
        this.mySettings.setSyncBinaryEditorSettings(enabled);
    }

    public void syncStatesNow() {
        if (this.myEditors.size() < 2) {
            return;
        }
        FileEditor masterEditor = this.myHolders.get(this.myMasterIndex).getEditor();
        this.syncStateFrom(masterEditor);
    }

    @NotNull
    public AnAction createToggleAction() {
        ToggleSynchronousEditorStatesAction toggleSynchronousEditorStatesAction = new ToggleSynchronousEditorStatesAction(this);
        if (toggleSynchronousEditorStatesAction == null) {
            TransferableFileEditorStateSupport.$$$reportNull$$$0(3);
        }
        return toggleSynchronousEditorStatesAction;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void processContextHints(@NotNull DiffRequest request, @NotNull DiffContext context) {
        if (request == null) {
            TransferableFileEditorStateSupport.$$$reportNull$$$0(4);
        }
        if (context == null) {
            TransferableFileEditorStateSupport.$$$reportNull$$$0(5);
        }
        this.myDuringUpdate = false;
        if (!this.isEnabled()) {
            return;
        }
        MyState state2 = (MyState)context.getUserData(TRANSFERABLE_FILE_EDITOR_STATE);
        if (state2 == null) {
            return;
        }
        int newMasterIndex = state2.getMasterIndex();
        if (newMasterIndex < this.myHolders.size()) {
            this.myMasterIndex = newMasterIndex;
        }
        try {
            this.myDuringUpdate = true;
            for (BinaryEditorHolder holder : this.myHolders) {
                state2.restoreContextData(holder.getEditor());
            }
            this.syncStatesNow();
        }
        finally {
            this.myDuringUpdate = false;
        }
    }

    public void updateContextHints(@NotNull DiffRequest request, @NotNull DiffContext context) {
        if (request == null) {
            TransferableFileEditorStateSupport.$$$reportNull$$$0(6);
        }
        if (context == null) {
            TransferableFileEditorStateSupport.$$$reportNull$$$0(7);
        }
        if (!this.isEnabled()) {
            return;
        }
        MyState state2 = new MyState(this.myMasterIndex);
        context.putUserData(TRANSFERABLE_FILE_EDITOR_STATE, (Object)state2);
        state2.storeContextData(this.myHolders.get(this.myMasterIndex).getEditor());
        for (BinaryEditorHolder holder : this.myHolders) {
            state2.storeContextData(holder.getEditor());
        }
    }

    private void syncStateFrom(@NotNull FileEditor sourceEditor) {
        TransferableFileEditorState sourceState;
        if (sourceEditor == null) {
            TransferableFileEditorStateSupport.$$$reportNull$$$0(8);
        }
        if ((sourceState = TransferableFileEditorStateSupport.getEditorState(sourceEditor)) == null) {
            return;
        }
        Map options = sourceState.getTransferableOptions();
        String id = sourceState.getEditorId();
        for (FileEditor fileEditor : this.myEditors) {
            if (sourceEditor == fileEditor) continue;
            this.updateEditor(fileEditor, id, options);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void updateEditor(@NotNull FileEditor editor, @NotNull String id, @NotNull Map<String, String> options) {
        if (editor == null) {
            TransferableFileEditorStateSupport.$$$reportNull$$$0(9);
        }
        if (id == null) {
            TransferableFileEditorStateSupport.$$$reportNull$$$0(10);
        }
        if (options == null) {
            TransferableFileEditorStateSupport.$$$reportNull$$$0(11);
        }
        try {
            this.myDuringUpdate = true;
            TransferableFileEditorState state2 = TransferableFileEditorStateSupport.getEditorState(editor);
            if (state2 != null && state2.getEditorId().equals(id)) {
                state2.setTransferableOptions(options);
                state2.setCopiedFromMasterEditor();
                editor.setState((FileEditorState)state2);
            }
        }
        finally {
            this.myDuringUpdate = false;
        }
    }

    @Nullable
    private static TransferableFileEditorState getEditorState(@NotNull FileEditor editor) {
        FileEditorState state2;
        if (editor == null) {
            TransferableFileEditorStateSupport.$$$reportNull$$$0(12);
        }
        return (state2 = editor.getState(FileEditorStateLevel.FULL)) instanceof TransferableFileEditorState ? (TransferableFileEditorState)state2 : null;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 3: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 3: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "settings";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "holders";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "disposable";
                break;
            }
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/diff/tools/util/TransferableFileEditorStateSupport";
                break;
            }
            case 4: 
            case 6: {
                objectArray2 = objectArray3;
                objectArray3[0] = "request";
                break;
            }
            case 5: 
            case 7: {
                objectArray2 = objectArray3;
                objectArray3[0] = "context";
                break;
            }
            case 8: {
                objectArray2 = objectArray3;
                objectArray3[0] = "sourceEditor";
                break;
            }
            case 9: 
            case 12: {
                objectArray2 = objectArray3;
                objectArray3[0] = "editor";
                break;
            }
            case 10: {
                objectArray2 = objectArray3;
                objectArray3[0] = "id";
                break;
            }
            case 11: {
                objectArray2 = objectArray3;
                objectArray3[0] = "options";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/diff/tools/util/TransferableFileEditorStateSupport";
                break;
            }
            case 3: {
                objectArray = objectArray2;
                objectArray2[1] = "createToggleAction";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 3: {
                break;
            }
            case 4: 
            case 5: {
                objectArray = objectArray;
                objectArray[2] = "processContextHints";
                break;
            }
            case 6: 
            case 7: {
                objectArray = objectArray;
                objectArray[2] = "updateContextHints";
                break;
            }
            case 8: {
                objectArray = objectArray;
                objectArray[2] = "syncStateFrom";
                break;
            }
            case 9: 
            case 10: 
            case 11: {
                objectArray = objectArray;
                objectArray[2] = "updateEditor";
                break;
            }
            case 12: {
                objectArray = objectArray;
                objectArray[2] = "getEditorState";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 3: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }

    private static class MyState {
        private final Map<String, Map<String, String>> myMap = new HashMap<String, Map<String, String>>();
        private final int myMasterIndex;

        public MyState(int masterIndex) {
            this.myMasterIndex = masterIndex;
        }

        public int getMasterIndex() {
            return this.myMasterIndex;
        }

        public void restoreContextData(@NotNull FileEditor editor) {
            TransferableFileEditorState editorState;
            if (editor == null) {
                MyState.$$$reportNull$$$0(0);
            }
            if ((editorState = TransferableFileEditorStateSupport.getEditorState(editor)) == null) {
                return;
            }
            Map<String, String> options = this.myMap.get(editorState.getEditorId());
            if (options == null) {
                return;
            }
            editorState.setTransferableOptions(options);
            editor.setState((FileEditorState)editorState);
        }

        public void storeContextData(@NotNull FileEditor editor) {
            TransferableFileEditorState editorState;
            if (editor == null) {
                MyState.$$$reportNull$$$0(1);
            }
            if ((editorState = TransferableFileEditorStateSupport.getEditorState(editor)) == null) {
                return;
            }
            if (!this.myMap.containsKey(editorState.getEditorId())) {
                this.myMap.put(editorState.getEditorId(), editorState.getTransferableOptions());
            }
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2 = new Object[3];
            objectArray2[0] = "editor";
            objectArray2[1] = "com/intellij/diff/tools/util/TransferableFileEditorStateSupport$MyState";
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[2] = "restoreContextData";
                    break;
                }
                case 1: {
                    objectArray = objectArray2;
                    objectArray2[2] = "storeContextData";
                    break;
                }
            }
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
        }
    }

    private static class ToggleSynchronousEditorStatesAction
    extends ToggleActionButton
    implements DumbAware {
        @NotNull
        private final TransferableFileEditorStateSupport mySupport;

        public ToggleSynchronousEditorStatesAction(@NotNull TransferableFileEditorStateSupport support) {
            if (support == null) {
                ToggleSynchronousEditorStatesAction.$$$reportNull$$$0(0);
            }
            super("Synchronize Editors Settings", AllIcons.Actions.SyncPanels);
            this.mySupport = support;
        }

        public boolean isVisible() {
            return this.mySupport.isSupported();
        }

        public boolean isSelected(AnActionEvent e) {
            return this.mySupport.isEnabled();
        }

        public void setSelected(AnActionEvent e, boolean state2) {
            this.mySupport.setEnabled(state2);
            if (state2) {
                this.mySupport.syncStatesNow();
            }
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "support", "com/intellij/diff/tools/util/TransferableFileEditorStateSupport$ToggleSynchronousEditorStatesAction", "<init>"));
        }
    }

    private class MySynchronizer
    implements PropertyChangeListener {
        private MySynchronizer() {
        }

        public void install(@NotNull Disposable disposable) {
            if (disposable == null) {
                MySynchronizer.$$$reportNull$$$0(0);
            }
            if (TransferableFileEditorStateSupport.this.myEditors.size() < 2) {
                return;
            }
            for (FileEditor editor : TransferableFileEditorStateSupport.this.myEditors) {
                editor.addPropertyChangeListener((PropertyChangeListener)this);
            }
            Disposer.register((Disposable)disposable, (Disposable)new Disposable(){

                public void dispose() {
                    for (FileEditor editor : TransferableFileEditorStateSupport.this.myEditors) {
                        editor.removePropertyChangeListener((PropertyChangeListener)MySynchronizer.this);
                    }
                }
            });
        }

        @Override
        public void propertyChange(PropertyChangeEvent evt) {
            if (TransferableFileEditorStateSupport.this.myDuringUpdate || !TransferableFileEditorStateSupport.this.isEnabled()) {
                return;
            }
            if (!(evt.getSource() instanceof FileEditor)) {
                return;
            }
            FileEditor editor = (FileEditor)evt.getSource();
            if (!editor.getComponent().isShowing()) {
                return;
            }
            Dimension size = editor.getComponent().getSize();
            if (size.width <= 0 || size.height <= 0) {
                return;
            }
            int holderIndex = ContainerUtil.indexOf((List)TransferableFileEditorStateSupport.this.myHolders, holder -> editor.equals(holder.getEditor()));
            if (holderIndex != -1) {
                TransferableFileEditorStateSupport.this.myMasterIndex = holderIndex;
            }
            TransferableFileEditorStateSupport.this.syncStateFrom(editor);
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "disposable", "com/intellij/diff/tools/util/TransferableFileEditorStateSupport$MySynchronizer", "install"));
        }
    }
}

