/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.diff.tools.util;

import com.intellij.diff.util.TextDiffType;
import com.intellij.openapi.diff.DiffBundle;
import com.intellij.ui.EditorNotificationPanel;
import com.intellij.ui.HyperlinkLabel;
import java.awt.Color;
import javax.swing.JPanel;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class DiffNotifications {
    @NotNull
    public static JPanel createInsertedContent() {
        JPanel jPanel = DiffNotifications.createNotification("Content added", TextDiffType.INSERTED.getColor(null));
        if (jPanel == null) {
            DiffNotifications.$$$reportNull$$$0(0);
        }
        return jPanel;
    }

    @NotNull
    public static JPanel createRemovedContent() {
        JPanel jPanel = DiffNotifications.createNotification("Content removed", TextDiffType.DELETED.getColor(null));
        if (jPanel == null) {
            DiffNotifications.$$$reportNull$$$0(1);
        }
        return jPanel;
    }

    @NotNull
    public static JPanel createEqualContents() {
        JPanel jPanel = DiffNotifications.createEqualContents(true, true);
        if (jPanel == null) {
            DiffNotifications.$$$reportNull$$$0(2);
        }
        return jPanel;
    }

    @NotNull
    public static JPanel createEqualContents(boolean equalCharsets, boolean equalSeparators) {
        if (!equalCharsets && !equalSeparators) {
            JPanel jPanel = DiffNotifications.createNotification(DiffBundle.message((String)"diff.contents.have.differences.only.in.charset.and.line.separators.message.text", (Object[])new Object[0]));
            if (jPanel == null) {
                DiffNotifications.$$$reportNull$$$0(3);
            }
            return jPanel;
        }
        if (!equalSeparators) {
            JPanel jPanel = DiffNotifications.createNotification(DiffBundle.message((String)"diff.contents.have.differences.only.in.line.separators.message.text", (Object[])new Object[0]));
            if (jPanel == null) {
                DiffNotifications.$$$reportNull$$$0(4);
            }
            return jPanel;
        }
        if (!equalCharsets) {
            JPanel jPanel = DiffNotifications.createNotification(DiffBundle.message((String)"diff.contents.have.differences.only.in.charset.message.text", (Object[])new Object[0]));
            if (jPanel == null) {
                DiffNotifications.$$$reportNull$$$0(5);
            }
            return jPanel;
        }
        JPanel jPanel = DiffNotifications.createNotification(DiffBundle.message((String)"diff.contents.are.identical.message.text", (Object[])new Object[0]));
        if (jPanel == null) {
            DiffNotifications.$$$reportNull$$$0(6);
        }
        return jPanel;
    }

    @NotNull
    public static JPanel createError() {
        JPanel jPanel = DiffNotifications.createNotification("Can not calculate diff");
        if (jPanel == null) {
            DiffNotifications.$$$reportNull$$$0(7);
        }
        return jPanel;
    }

    @NotNull
    public static JPanel createOperationCanceled() {
        JPanel jPanel = DiffNotifications.createNotification("Can not calculate diff. Operation canceled.");
        if (jPanel == null) {
            DiffNotifications.$$$reportNull$$$0(8);
        }
        return jPanel;
    }

    @NotNull
    public static JPanel createDiffTooBig() {
        JPanel jPanel = DiffNotifications.createNotification("Can not calculate diff. File is too big and there are too many changes.");
        if (jPanel == null) {
            DiffNotifications.$$$reportNull$$$0(9);
        }
        return jPanel;
    }

    @NotNull
    public static JPanel createNotification(@NotNull String text2) {
        if (text2 == null) {
            DiffNotifications.$$$reportNull$$$0(10);
        }
        JPanel jPanel = DiffNotifications.createNotification(text2, null);
        if (jPanel == null) {
            DiffNotifications.$$$reportNull$$$0(11);
        }
        return jPanel;
    }

    @NotNull
    public static JPanel createNotification(@NotNull String text2, @Nullable Color background) {
        if (text2 == null) {
            DiffNotifications.$$$reportNull$$$0(12);
        }
        JPanel jPanel = DiffNotifications.createNotification(text2, background, true);
        if (jPanel == null) {
            DiffNotifications.$$$reportNull$$$0(13);
        }
        return jPanel;
    }

    @NotNull
    public static JPanel createNotification(@NotNull String text2, @Nullable Color background, boolean showHideAction) {
        if (text2 == null) {
            DiffNotifications.$$$reportNull$$$0(14);
        }
        EditorNotificationPanel panel2 = new EditorNotificationPanel(background);
        panel2.text(text2);
        if (showHideAction) {
            HyperlinkLabel link = panel2.createActionLabel("Hide", () -> panel2.setVisible(false));
            link.setToolTipText("Hide this notification");
        }
        EditorNotificationPanel editorNotificationPanel = panel2;
        if (editorNotificationPanel == null) {
            DiffNotifications.$$$reportNull$$$0(15);
        }
        return editorNotificationPanel;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
            case 10: 
            case 12: 
            case 14: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 2;
                break;
            }
            case 10: 
            case 12: 
            case 14: {
                n2 = 3;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/diff/tools/util/DiffNotifications";
                break;
            }
            case 10: 
            case 12: 
            case 14: {
                objectArray2 = objectArray3;
                objectArray3[0] = "text";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "createInsertedContent";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[1] = "createRemovedContent";
                break;
            }
            case 2: 
            case 3: 
            case 4: 
            case 5: 
            case 6: {
                objectArray = objectArray2;
                objectArray2[1] = "createEqualContents";
                break;
            }
            case 7: {
                objectArray = objectArray2;
                objectArray2[1] = "createError";
                break;
            }
            case 8: {
                objectArray = objectArray2;
                objectArray2[1] = "createOperationCanceled";
                break;
            }
            case 9: {
                objectArray = objectArray2;
                objectArray2[1] = "createDiffTooBig";
                break;
            }
            case 10: 
            case 12: 
            case 14: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/diff/tools/util/DiffNotifications";
                break;
            }
            case 11: 
            case 13: 
            case 15: {
                objectArray = objectArray2;
                objectArray2[1] = "createNotification";
                break;
            }
        }
        switch (n) {
            default: {
                break;
            }
            case 10: 
            case 12: 
            case 14: {
                objectArray = objectArray;
                objectArray[2] = "createNotification";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
            case 10: 
            case 12: 
            case 14: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

