/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.diagnostic;

import com.intellij.diagnostic.DiagnosticBundle;
import com.intellij.diagnostic.IdeErrorsDialog;
import com.intellij.diagnostic.IdeErrorsIcon;
import com.intellij.diagnostic.LogMessage;
import com.intellij.diagnostic.MessagePool;
import com.intellij.diagnostic.MessagePoolListener;
import com.intellij.icons.AllIcons;
import com.intellij.notification.Notification;
import com.intellij.notification.NotificationAction;
import com.intellij.notification.NotificationType;
import com.intellij.notification.impl.NotificationsManagerImpl;
import com.intellij.openapi.Disposable;
import com.intellij.openapi.actionSystem.AnAction;
import com.intellij.openapi.actionSystem.AnActionEvent;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.ui.popup.Balloon;
import com.intellij.openapi.util.Disposer;
import com.intellij.openapi.util.Ref;
import com.intellij.openapi.wm.IconLikeCustomStatusBarWidget;
import com.intellij.openapi.wm.IdeFrame;
import com.intellij.openapi.wm.StatusBar;
import com.intellij.openapi.wm.StatusBarWidget;
import com.intellij.ui.BalloonLayout;
import com.intellij.ui.BalloonLayoutData;
import com.intellij.ui.ClickListener;
import com.intellij.ui.JBColor;
import com.intellij.util.concurrency.EdtExecutorService;
import com.intellij.util.ui.UIUtil;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.KeyboardFocusManager;
import java.awt.Window;
import java.awt.event.MouseEvent;
import java.util.concurrent.TimeUnit;
import javax.swing.JComponent;
import javax.swing.JDialog;
import javax.swing.JPanel;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class IdeMessagePanel
extends JPanel
implements MessagePoolListener,
IconLikeCustomStatusBarWidget {
    public static final String FATAL_ERROR = "FatalError";
    private final IdeErrorsIcon myIcon;
    private final IdeFrame myFrame;
    private final MessagePool myMessagePool;
    private Balloon myBalloon;
    private IdeErrorsDialog myDialog;
    private boolean myOpeningInProgress;
    private boolean myNotificationPopupAlreadyShown;
    private static final String ERROR_TITLE = DiagnosticBundle.message("error.new.notification.title", new Object[0]);
    private static final String ERROR_LINK = DiagnosticBundle.message("error.new.notification.link", new Object[0]);

    public IdeMessagePanel(@Nullable IdeFrame frame, @NotNull MessagePool messagePool) {
        if (messagePool == null) {
            IdeMessagePanel.$$$reportNull$$$0(0);
        }
        super(new BorderLayout());
        this.myIcon = new IdeErrorsIcon(frame != null);
        this.myIcon.setVerticalAlignment(0);
        this.add((Component)this.myIcon, "Center");
        new ClickListener(){

            public boolean onClick(@NotNull MouseEvent event, int clickCount) {
                if (event == null) {
                    1.$$$reportNull$$$0(0);
                }
                IdeMessagePanel.this.openErrorsDialog(null);
                return true;
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "event", "com/intellij/diagnostic/IdeMessagePanel$1", "onClick"));
            }
        }.installOn((Component)this.myIcon);
        this.myFrame = frame;
        this.myMessagePool = messagePool;
        messagePool.addListener(this);
        this.updateIconAndNotify();
        this.setOpaque(false);
    }

    @NotNull
    public String ID() {
        if (FATAL_ERROR == null) {
            IdeMessagePanel.$$$reportNull$$$0(1);
        }
        return FATAL_ERROR;
    }

    public StatusBarWidget.WidgetPresentation getPresentation(@NotNull StatusBarWidget.PlatformType type) {
        if (type == null) {
            IdeMessagePanel.$$$reportNull$$$0(2);
        }
        return null;
    }

    public void dispose() {
        this.myMessagePool.removeListener(this);
    }

    public void install(@NotNull StatusBar statusBar) {
        if (statusBar == null) {
            IdeMessagePanel.$$$reportNull$$$0(3);
        }
    }

    public JComponent getComponent() {
        return this;
    }

    public void openFatals(@Nullable LogMessage message) {
        this.openErrorsDialog(message);
    }

    public void openErrorsDialog(final @Nullable LogMessage message) {
        if (this.myDialog != null) {
            return;
        }
        if (this.myOpeningInProgress) {
            return;
        }
        this.myOpeningInProgress = true;
        new Runnable(){

            @Override
            public void run() {
                if (!IdeMessagePanel.this.isOtherModalWindowActive()) {
                    try {
                        IdeMessagePanel.this.doOpenErrorsDialog(message);
                    }
                    finally {
                        IdeMessagePanel.this.myOpeningInProgress = false;
                    }
                } else if (IdeMessagePanel.this.myDialog == null) {
                    EdtExecutorService.getScheduledExecutorInstance().schedule(this, 300L, TimeUnit.MILLISECONDS);
                }
            }
        }.run();
    }

    private void doOpenErrorsDialog(@Nullable LogMessage message) {
        Project project = this.myFrame != null ? this.myFrame.getProject() : null;
        this.myDialog = new IdeErrorsDialog(this.myMessagePool, project, message){

            @Override
            protected void dispose() {
                super.dispose();
                IdeMessagePanel.this.myDialog = null;
                IdeMessagePanel.this.updateIconAndNotify();
            }

            @Override
            protected void updateOnSubmit() {
                super.updateOnSubmit();
                IdeMessagePanel.this.updateIcon(IdeMessagePanel.this.myMessagePool.getState());
            }
        };
        this.myDialog.show();
    }

    private void updateIcon(MessagePool.State state2) {
        this.myIcon.setState(state2);
        UIUtil.invokeLaterIfNeeded(() -> this.setVisible(state2 != MessagePool.State.NoErrors));
    }

    @Override
    public void newEntryAdded() {
        this.updateIconAndNotify();
    }

    @Override
    public void poolCleared() {
        this.updateIconAndNotify();
    }

    @Override
    public void entryWasRead() {
        this.updateIconAndNotify();
    }

    private boolean isOtherModalWindowActive() {
        Window activeWindow = KeyboardFocusManager.getCurrentKeyboardFocusManager().getActiveWindow();
        return activeWindow instanceof JDialog && ((JDialog)activeWindow).isModal() && (this.myDialog == null || this.myDialog.getWindow() != activeWindow);
    }

    private void updateIconAndNotify() {
        Project project;
        MessagePool.State state2 = this.myMessagePool.getState();
        this.updateIcon(state2);
        if (state2 == MessagePool.State.NoErrors) {
            this.myNotificationPopupAlreadyShown = false;
            if (this.myBalloon != null) {
                this.myBalloon.hide();
            }
        } else if (state2 == MessagePool.State.UnreadErrors && !this.myNotificationPopupAlreadyShown && IdeMessagePanel.isActive(this.myFrame) && (project = this.myFrame.getProject()) != null) {
            ApplicationManager.getApplication().invokeLater(() -> this.showErrorNotification(project), project.getDisposed());
            this.myNotificationPopupAlreadyShown = true;
        }
    }

    private static boolean isActive(IdeFrame frame) {
        return frame instanceof Window && ((Window)frame).isActive();
    }

    private void showErrorNotification(@NotNull Project project) {
        if (project == null) {
            IdeMessagePanel.$$$reportNull$$$0(4);
        }
        Notification notification2 = new Notification("", AllIcons.Ide.FatalError, ERROR_TITLE, null, null, NotificationType.ERROR, null);
        notification2.addAction((AnAction)new NotificationAction(ERROR_LINK){

            public void actionPerformed(@NotNull AnActionEvent e, @NotNull Notification notification2) {
                if (e == null) {
                    4.$$$reportNull$$$0(0);
                }
                if (notification2 == null) {
                    4.$$$reportNull$$$0(1);
                }
                notification2.expire();
                IdeMessagePanel.this.openErrorsDialog(null);
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                Object[] objectArray;
                Object[] objectArray2 = new Object[3];
                switch (n) {
                    default: {
                        objectArray = objectArray2;
                        objectArray2[0] = "e";
                        break;
                    }
                    case 1: {
                        objectArray = objectArray2;
                        objectArray2[0] = "notification";
                        break;
                    }
                }
                objectArray[1] = "com/intellij/diagnostic/IdeMessagePanel$4";
                objectArray[2] = "actionPerformed";
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
            }
        });
        BalloonLayout layout = this.myFrame.getBalloonLayout();
        assert (layout != null);
        BalloonLayoutData layoutData = BalloonLayoutData.createEmpty();
        layoutData.fadeoutTime = 5000L;
        layoutData.fillColor = new JBColor(16115431, 5848385);
        layoutData.borderColor = new JBColor(14723241, 7554379);
        assert (this.myBalloon == null);
        this.myBalloon = NotificationsManagerImpl.createBalloon(this.myFrame, notification2, false, false, (Ref<BalloonLayoutData>)new Ref((Object)layoutData), (Disposable)project);
        Disposer.register((Disposable)this.myBalloon, () -> {
            this.myBalloon = null;
        });
        layout.add(this.myBalloon);
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 1: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 1: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "messagePool";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/diagnostic/IdeMessagePanel";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "type";
                break;
            }
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "statusBar";
                break;
            }
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "project";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/diagnostic/IdeMessagePanel";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[1] = "ID";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 1: {
                break;
            }
            case 2: {
                objectArray = objectArray;
                objectArray[2] = "getPresentation";
                break;
            }
            case 3: {
                objectArray = objectArray;
                objectArray[2] = "install";
                break;
            }
            case 4: {
                objectArray = objectArray;
                objectArray[2] = "showErrorNotification";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 1: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

