/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.codeInsight.editorActions;

import com.intellij.codeInsight.editorActions.FoldingData;
import com.intellij.codeInsight.editorActions.TextBlockTransferableData;
import java.awt.datatransfer.DataFlavor;
import java.io.Serializable;

public class FoldingTransferableData
implements TextBlockTransferableData,
Serializable {
    private final FoldingData[] myFoldingDatas;

    public FoldingTransferableData(FoldingData[] foldingDatas) {
        this.myFoldingDatas = foldingDatas;
    }

    @Override
    public DataFlavor getFlavor() {
        return FoldingData.getDataFlavor();
    }

    @Override
    public int getOffsetCount() {
        return this.myFoldingDatas.length * 2;
    }

    @Override
    public int getOffsets(int[] offsets, int index) {
        for (FoldingData data : this.myFoldingDatas) {
            offsets[index++] = data.startOffset;
            offsets[index++] = data.endOffset;
        }
        return index;
    }

    @Override
    public int setOffsets(int[] offsets, int index) {
        for (FoldingData data : this.myFoldingDatas) {
            data.startOffset = offsets[index++];
            data.endOffset = offsets[index++];
        }
        return index;
    }

    protected FoldingTransferableData clone() {
        FoldingData[] newFoldingData = new FoldingData[this.myFoldingDatas.length];
        for (int i = 0; i < this.myFoldingDatas.length; ++i) {
            newFoldingData[i] = (FoldingData)this.myFoldingDatas[i].clone();
        }
        return new FoldingTransferableData(newFoldingData);
    }

    public FoldingData[] getData() {
        return this.myFoldingDatas;
    }
}

