/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.codeInsight.completion;

import com.intellij.codeInsight.completion.CompletionAssertions;
import com.intellij.codeInsight.completion.CompletionContext;
import com.intellij.codeInsight.completion.CompletionContributor;
import com.intellij.codeInsight.completion.CompletionInitializationContext;
import com.intellij.codeInsight.completion.CompletionInitializationContextImpl;
import com.intellij.codeInsight.completion.CompletionParameters;
import com.intellij.codeInsight.completion.CompletionProcess;
import com.intellij.codeInsight.completion.CompletionProcessEx;
import com.intellij.codeInsight.completion.CompletionType;
import com.intellij.codeInsight.completion.OffsetMap;
import com.intellij.codeInsight.completion.OffsetTranslator;
import com.intellij.codeInsight.completion.OffsetsInFile;
import com.intellij.injected.editor.DocumentWindow;
import com.intellij.lang.Language;
import com.intellij.lang.injection.InjectedLanguageManager;
import com.intellij.openapi.application.WriteAction;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.editor.Caret;
import com.intellij.openapi.editor.Document;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.editor.ex.util.EditorUtil;
import com.intellij.openapi.editor.impl.DocumentImpl;
import com.intellij.openapi.fileEditor.FileDocumentManager;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Key;
import com.intellij.openapi.util.Pair;
import com.intellij.openapi.util.Ref;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.psi.PsiDocumentManager;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.impl.PsiFileEx;
import com.intellij.psi.impl.source.PsiFileImpl;
import com.intellij.psi.impl.source.tree.injected.InjectedLanguageUtil;
import com.intellij.psi.util.PsiTreeUtil;
import com.intellij.psi.util.PsiUtilBase;
import com.intellij.reference.SoftReference;
import java.lang.ref.Reference;
import java.util.Objects;
import org.jetbrains.annotations.NotNull;

public class CompletionInitializationUtil {
    private static final Logger LOG = Logger.getInstance((String)"#com.intellij.codeInsight.completion.CompletionServiceUtil");
    private static final Key<SoftReference<Pair<PsiFile, Document>>> FILE_COPY_KEY = Key.create((String)"CompletionFileCopy");

    public static CompletionInitializationContextImpl createCompletionInitializationContext(@NotNull Project project, @NotNull Editor editor, @NotNull Caret caret, int invocationCount, CompletionType completionType) {
        if (project == null) {
            CompletionInitializationUtil.$$$reportNull$$$0(0);
        }
        if (editor == null) {
            CompletionInitializationUtil.$$$reportNull$$$0(1);
        }
        if (caret == null) {
            CompletionInitializationUtil.$$$reportNull$$$0(2);
        }
        return (CompletionInitializationContextImpl)((Object)WriteAction.compute(() -> {
            if (editor == null) {
                CompletionInitializationUtil.$$$reportNull$$$0(8);
            }
            if (project == null) {
                CompletionInitializationUtil.$$$reportNull$$$0(9);
            }
            if (caret == null) {
                CompletionInitializationUtil.$$$reportNull$$$0(10);
            }
            EditorUtil.fillVirtualSpaceUntilCaret(editor);
            PsiDocumentManager.getInstance((Project)project).commitAllDocuments();
            CompletionAssertions.checkEditorValid(editor);
            PsiFile psiFile = PsiUtilBase.getPsiFileInEditor((Caret)caret, (Project)project);
            assert (psiFile != null) : "no PSI file: " + FileDocumentManager.getInstance().getFile(editor.getDocument());
            psiFile.putUserData(PsiFileEx.BATCH_REFERENCE_PROCESSING, (Object)Boolean.TRUE);
            CompletionAssertions.assertCommitSuccessful(editor, psiFile);
            return CompletionInitializationUtil.runContributorsBeforeCompletion(editor, psiFile, invocationCount, caret, completionType);
        }));
    }

    private static CompletionInitializationContextImpl runContributorsBeforeCompletion(Editor editor, PsiFile psiFile, int invocationCount, @NotNull Caret caret, CompletionType completionType) {
        if (caret == null) {
            CompletionInitializationUtil.$$$reportNull$$$0(3);
        }
        final Ref current = Ref.create(null);
        CompletionInitializationContextImpl context = new CompletionInitializationContextImpl(editor, caret, psiFile, completionType, invocationCount){
            CompletionContributor dummyIdentifierChanger;

            public void setDummyIdentifier(@NotNull String dummyIdentifier) {
                if (dummyIdentifier == null) {
                    1.$$$reportNull$$$0(0);
                }
                super.setDummyIdentifier(dummyIdentifier);
                if (this.dummyIdentifierChanger != null) {
                    LOG.error("Changing the dummy identifier twice, already changed by " + this.dummyIdentifierChanger);
                }
                this.dummyIdentifierChanger = (CompletionContributor)current.get();
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "dummyIdentifier", "com/intellij/codeInsight/completion/CompletionInitializationUtil$1", "setDummyIdentifier"));
            }
        };
        Project project = psiFile.getProject();
        for (CompletionContributor contributor : CompletionContributor.forLanguageHonorDumbness((Language)context.getPositionLanguage(), (Project)project)) {
            current.set((Object)contributor);
            contributor.beforeCompletion((CompletionInitializationContext)context);
            CompletionAssertions.checkEditorValid(editor);
            assert (!PsiDocumentManager.getInstance((Project)project).isUncommited(editor.getDocument())) : "Contributor " + contributor + " left the document uncommitted";
        }
        return context;
    }

    public static CompletionParameters prepareCompletionParameters(CompletionInitializationContext initContext, CompletionProcessEx indicator) {
        OffsetsInFile hostCopyOffsets = CompletionInitializationUtil.insertDummyIdentifier(initContext, indicator, indicator.getHostOffsets());
        if (hostCopyOffsets == null) {
            return null;
        }
        indicator.registerChildDisposable(hostCopyOffsets::getOffsets);
        OffsetsInFile finalOffsets = CompletionInitializationUtil.toInjectedIfAny(initContext.getFile(), hostCopyOffsets);
        indicator.registerChildDisposable(finalOffsets::getOffsets);
        CompletionParameters parameters2 = CompletionInitializationUtil.createCompletionParameters(initContext, indicator, finalOffsets);
        indicator.setParameters(parameters2);
        return parameters2;
    }

    @NotNull
    private static CompletionParameters createCompletionParameters(CompletionInitializationContext initContext, CompletionProcessEx indicator, OffsetsInFile finalOffsets) {
        int offset = finalOffsets.getOffsets().getOffset(CompletionInitializationContext.START_OFFSET);
        PsiFile fileCopy = finalOffsets.getFile();
        PsiFile originalFile = fileCopy.getOriginalFile();
        PsiElement insertedElement = CompletionInitializationUtil.findCompletionPositionLeaf(finalOffsets, offset, originalFile);
        insertedElement.putUserData(CompletionContext.COMPLETION_CONTEXT_KEY, (Object)new CompletionContext(fileCopy, finalOffsets.getOffsets()));
        CompletionParameters completionParameters = new CompletionParameters(insertedElement, originalFile, initContext.getCompletionType(), offset, initContext.getInvocationCount(), initContext.getEditor(), (CompletionProcess)indicator);
        if (completionParameters == null) {
            CompletionInitializationUtil.$$$reportNull$$$0(4);
        }
        return completionParameters;
    }

    private static OffsetsInFile insertDummyIdentifier(CompletionInitializationContext initContext, CompletionProcessEx indicator, OffsetsInFile topLevelOffsets) {
        CompletionAssertions.checkEditorValid(initContext.getEditor());
        Editor hostEditor = InjectedLanguageUtil.getTopLevelEditor(initContext.getEditor());
        OffsetMap hostMap = topLevelOffsets.getOffsets();
        PsiFile hostCopy = CompletionInitializationUtil.obtainFileCopy(topLevelOffsets.getFile());
        Document copyDocument = Objects.requireNonNull(hostCopy.getViewProvider().getDocument());
        String dummyIdentifier = initContext.getDummyIdentifier();
        int startOffset = hostMap.getOffset(CompletionInitializationContext.START_OFFSET);
        int endOffset = hostMap.getOffset(CompletionInitializationContext.SELECTION_END_OFFSET);
        indicator.registerChildDisposable(() -> new OffsetTranslator(hostEditor.getDocument(), initContext.getFile(), copyDocument, startOffset, endOffset, dummyIdentifier));
        OffsetsInFile copyOffsets = topLevelOffsets.replaceInCopy(hostCopy, startOffset, endOffset, dummyIdentifier);
        return hostCopy.isValid() ? copyOffsets : null;
    }

    private static OffsetsInFile toInjectedIfAny(PsiFile originalFile, OffsetsInFile hostCopyOffsets) {
        CompletionAssertions.assertHostInfo(hostCopyOffsets.getFile(), hostCopyOffsets.getOffsets());
        int hostStartOffset = hostCopyOffsets.getOffsets().getOffset(CompletionInitializationContext.START_OFFSET);
        OffsetsInFile translatedOffsets = hostCopyOffsets.toInjectedIfAny(hostStartOffset);
        if (translatedOffsets != hostCopyOffsets) {
            PsiFile injected = translatedOffsets.getFile();
            if (injected instanceof PsiFileImpl && InjectedLanguageManager.getInstance((Project)originalFile.getProject()).isInjectedFragment(originalFile)) {
                ((PsiFileImpl)injected).setOriginalFile(originalFile);
            }
            DocumentWindow documentWindow = InjectedLanguageUtil.getDocumentWindow((PsiElement)injected);
            CompletionAssertions.assertInjectedOffsets(hostStartOffset, injected, documentWindow);
            if (injected.getTextRange().contains(translatedOffsets.getOffsets().getOffset(CompletionInitializationContext.START_OFFSET))) {
                return translatedOffsets;
            }
        }
        return hostCopyOffsets;
    }

    @NotNull
    private static PsiElement findCompletionPositionLeaf(OffsetsInFile offsets, int offset, PsiFile originalFile) {
        PsiElement insertedElement = offsets.getFile().findElementAt(offset);
        if (insertedElement == null && offsets.getFile().getTextLength() == 0) {
            insertedElement = PsiTreeUtil.getDeepestLast((PsiElement)offsets.getFile());
        }
        CompletionAssertions.assertCompletionPositionPsiConsistent(offsets, offset, originalFile, insertedElement);
        PsiElement psiElement = insertedElement;
        if (psiElement == null) {
            CompletionInitializationUtil.$$$reportNull$$$0(5);
        }
        return psiElement;
    }

    private static PsiFile obtainFileCopy(PsiFile file2) {
        Pair cached;
        boolean mayCacheCopy;
        VirtualFile virtualFile = file2.getVirtualFile();
        boolean bl = mayCacheCopy = file2.isPhysical() && virtualFile != null && virtualFile.isInLocalFileSystem();
        if (mayCacheCopy && (cached = (Pair)SoftReference.dereference((Reference)((Reference)file2.getUserData(FILE_COPY_KEY)))) != null && CompletionInitializationUtil.isCopyUpToDate((Document)cached.second, (PsiFile)cached.first, file2)) {
            PsiFile copy = (PsiFile)cached.first;
            CompletionAssertions.assertCorrectOriginalFile("Cached", file2, copy);
            return copy;
        }
        PsiFile copy = (PsiFile)file2.copy();
        if (copy.isPhysical() || copy.getViewProvider().isEventSystemEnabled()) {
            LOG.error("File copy should be non-physical and non-event-system-enabled! Language=" + file2.getLanguage() + "; file=" + file2 + " of " + file2.getClass());
        }
        CompletionAssertions.assertCorrectOriginalFile("New", file2, copy);
        if (mayCacheCopy) {
            Document document = copy.getViewProvider().getDocument();
            assert (document != null);
            CompletionInitializationUtil.syncAcceptSlashR(file2.getViewProvider().getDocument(), document);
            file2.putUserData(FILE_COPY_KEY, (Object)new SoftReference((Object)Pair.create((Object)copy, (Object)document)));
        }
        return copy;
    }

    private static boolean isCopyUpToDate(Document document, @NotNull PsiFile copyFile, @NotNull PsiFile originalFile) {
        if (copyFile == null) {
            CompletionInitializationUtil.$$$reportNull$$$0(6);
        }
        if (originalFile == null) {
            CompletionInitializationUtil.$$$reportNull$$$0(7);
        }
        if (!(copyFile.getClass().equals(originalFile.getClass()) && copyFile.isValid() && copyFile.getName().equals(originalFile.getName()))) {
            return false;
        }
        PsiFile current = PsiDocumentManager.getInstance((Project)copyFile.getProject()).getPsiFile(document);
        return current != null && current.getViewProvider().getPsi(copyFile.getLanguage()) == copyFile;
    }

    private static void syncAcceptSlashR(Document originalDocument, Document documentCopy) {
        if (!(originalDocument instanceof DocumentImpl) || !(documentCopy instanceof DocumentImpl)) {
            return;
        }
        ((DocumentImpl)documentCopy).setAcceptSlashR(((DocumentImpl)originalDocument).acceptsSlashR());
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 4: 
            case 5: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 4: 
            case 5: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "project";
                break;
            }
            case 1: 
            case 8: {
                objectArray2 = objectArray3;
                objectArray3[0] = "editor";
                break;
            }
            case 2: 
            case 3: 
            case 10: {
                objectArray2 = objectArray3;
                objectArray3[0] = "caret";
                break;
            }
            case 4: 
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/codeInsight/completion/CompletionInitializationUtil";
                break;
            }
            case 6: {
                objectArray2 = objectArray3;
                objectArray3[0] = "copyFile";
                break;
            }
            case 7: {
                objectArray2 = objectArray3;
                objectArray3[0] = "originalFile";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/codeInsight/completion/CompletionInitializationUtil";
                break;
            }
            case 4: {
                objectArray = objectArray2;
                objectArray2[1] = "createCompletionParameters";
                break;
            }
            case 5: {
                objectArray = objectArray2;
                objectArray2[1] = "findCompletionPositionLeaf";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "createCompletionInitializationContext";
                break;
            }
            case 3: {
                objectArray = objectArray;
                objectArray[2] = "runContributorsBeforeCompletion";
                break;
            }
            case 4: 
            case 5: {
                break;
            }
            case 6: 
            case 7: {
                objectArray = objectArray;
                objectArray[2] = "isCopyUpToDate";
                break;
            }
            case 8: 
            case 9: 
            case 10: {
                objectArray = objectArray;
                objectArray[2] = "lambda$createCompletionInitializationContext$0";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 4: 
            case 5: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

