/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.analysis;

import com.intellij.analysis.AnalysisActionUtils;
import com.intellij.analysis.AnalysisScope;
import com.intellij.analysis.AnalysisScopeBundle;
import com.intellij.analysis.AnalysisUIOptions;
import com.intellij.analysis.BaseAnalysisActionDialog;
import com.intellij.codeInspection.ui.InspectionResultsView;
import com.intellij.openapi.actionSystem.ActionPlaces;
import com.intellij.openapi.actionSystem.AnAction;
import com.intellij.openapi.actionSystem.AnActionEvent;
import com.intellij.openapi.actionSystem.CommonDataKeys;
import com.intellij.openapi.actionSystem.DataContext;
import com.intellij.openapi.actionSystem.LangDataKeys;
import com.intellij.openapi.fileEditor.FileDocumentManager;
import com.intellij.openapi.module.Module;
import com.intellij.openapi.project.DumbService;
import com.intellij.openapi.project.Project;
import com.intellij.psi.PsiElement;
import javax.swing.JComponent;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public abstract class BaseAnalysisAction
extends AnAction {
    private static final String DIMENSION_KEY_PREFIX = "ANALYSIS_DLG_";
    private final String myTitle;
    private final String myAnalysisNoon;

    protected BaseAnalysisAction(String title, String analysisNoon) {
        this.myTitle = title;
        this.myAnalysisNoon = analysisNoon;
    }

    public void update(AnActionEvent e) {
        Project project = e.getProject();
        e.getPresentation().setEnabled(project != null && !DumbService.isDumb((Project)project) && this.getInspectionScope(e.getDataContext(), project) != null);
    }

    public void actionPerformed(AnActionEvent e) {
        PsiElement element;
        AnalysisUIOptions uiOptions;
        boolean rememberScope;
        Module module2;
        Project project = e.getProject();
        if (project == null) {
            return;
        }
        DataContext dataContext = e.getDataContext();
        AnalysisScope scope = this.getInspectionScope(dataContext, project);
        if (scope == null) {
            return;
        }
        String title = AnalysisScopeBundle.message((String)"specify.analysis.scope", (Object[])new Object[]{this.myTitle});
        String noon = AnalysisScopeBundle.message((String)"analysis.scope.title", (Object[])new Object[]{this.myAnalysisNoon});
        BaseAnalysisActionDialog dlg = new BaseAnalysisActionDialog(title, noon, project, scope, module2 = BaseAnalysisAction.getModuleFromContext(dataContext), rememberScope = ActionPlaces.isMainMenuOrActionSearch((String)e.getPlace()), uiOptions = AnalysisUIOptions.getInstance(project), element = (PsiElement)CommonDataKeys.PSI_ELEMENT.getData(dataContext)){

            protected String getDimensionServiceKey() {
                return BaseAnalysisAction.DIMENSION_KEY_PREFIX + ((Object)((Object)this)).getClass().getName();
            }

            @Override
            protected JComponent getAdditionalActionSettings(Project project) {
                return BaseAnalysisAction.this.getAdditionalActionSettings(project, this);
            }

            protected String getHelpId() {
                return BaseAnalysisAction.this.getHelpTopic();
            }
        };
        if (!dlg.showAndGet()) {
            this.canceled();
            return;
        }
        int oldScopeType = uiOptions.SCOPE_TYPE;
        scope = dlg.getScope(uiOptions, scope, project, module2);
        if (!rememberScope) {
            uiOptions.SCOPE_TYPE = oldScopeType;
        }
        uiOptions.ANALYZE_TEST_SOURCES = dlg.isInspectTestSources();
        FileDocumentManager.getInstance().saveAllDocuments();
        this.analyze(project, scope);
    }

    protected String getHelpTopic() {
        return "reference.dialogs.analyzeDependencies.scope";
    }

    protected void canceled() {
    }

    protected abstract void analyze(@NotNull Project var1, @NotNull AnalysisScope var2);

    @Nullable
    private AnalysisScope getInspectionScope(@NotNull DataContext dataContext, @NotNull Project project) {
        if (dataContext == null) {
            BaseAnalysisAction.$$$reportNull$$$0(0);
        }
        if (project == null) {
            BaseAnalysisAction.$$$reportNull$$$0(1);
        }
        return AnalysisActionUtils.getInspectionScope(dataContext, project, this.acceptNonProjectDirectories());
    }

    protected boolean acceptNonProjectDirectories() {
        return false;
    }

    @Nullable
    protected JComponent getAdditionalActionSettings(Project project, BaseAnalysisActionDialog dialog2) {
        return null;
    }

    @Nullable
    private static Module getModuleFromContext(@NotNull DataContext dataContext) {
        AnalysisScope scope;
        InspectionResultsView inspectionView;
        if (dataContext == null) {
            BaseAnalysisAction.$$$reportNull$$$0(2);
        }
        if ((inspectionView = (InspectionResultsView)dataContext.getData(InspectionResultsView.DATA_KEY)) != null && (scope = inspectionView.getScope()).getScopeType() == 4 && scope.isValid()) {
            return scope.getModule();
        }
        return (Module)dataContext.getData(LangDataKeys.MODULE);
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[3];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "dataContext";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "project";
                break;
            }
        }
        objectArray2[1] = "com/intellij/analysis/BaseAnalysisAction";
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[2] = "getInspectionScope";
                break;
            }
            case 2: {
                objectArray = objectArray2;
                objectArray2[2] = "getModuleFromContext";
                break;
            }
        }
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
    }
}

