/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.idea.svn.dialogs;

import com.intellij.openapi.help.HelpManager;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.ui.DialogWrapper;
import com.intellij.ui.OrderPanel;
import com.intellij.ui.ScrollPaneFactory;
import com.intellij.util.ArrayUtil;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.FlowLayout;
import java.awt.Font;
import java.awt.FontMetrics;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.Map;
import java.util.TreeMap;
import java.util.TreeSet;
import javax.swing.Action;
import javax.swing.JButton;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JPanel;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.idea.svn.SvnBundle;

public class SelectFilesDialog
extends DialogWrapper
implements ActionListener {
    private final String[] myFiles;
    private FilesList myFilesList;
    private JButton mySelectAllButton;
    private JButton myDeselectAllButton;
    private final String myLabel;
    private final String myHelpID;

    public SelectFilesDialog(Project project, String label, String title, String actionName, String[] paths, @NonNls String helpID) {
        super(project, true);
        this.myHelpID = helpID;
        this.setOKButtonText(actionName);
        this.setTitle(title);
        this.setResizable(true);
        this.myFiles = paths;
        this.myLabel = label;
        this.getHelpAction().setEnabled(this.myHelpID != null);
        this.init();
    }

    protected void doHelpAction() {
        if (this.myHelpID != null) {
            HelpManager.getInstance().invokeHelp(this.myHelpID);
        }
    }

    @NotNull
    protected Action[] createActions() {
        Action[] actionArray = new Action[]{this.getOKAction(), this.getCancelAction(), this.getHelpAction()};
        if (actionArray == null) {
            SelectFilesDialog.$$$reportNull$$$0(0);
        }
        return actionArray;
    }

    protected void init() {
        super.init();
        this.mySelectAllButton.addActionListener(this);
        this.myDeselectAllButton.addActionListener(this);
        this.myFilesList.addListener(() -> this.getOKAction().setEnabled(this.isOKActionEnabled()));
    }

    protected String getDimensionServiceKey() {
        return "svn.selectFilesDialog";
    }

    public boolean shouldCloseOnCross() {
        return true;
    }

    public JComponent getPreferredFocusedComponent() {
        return this.myFilesList;
    }

    public boolean isOKActionEnabled() {
        return this.myFilesList.getSelectedPaths().length > 0;
    }

    protected JComponent createCenterPanel() {
        JPanel panel = new JPanel(new BorderLayout(5, 5));
        JLabel label = new JLabel(this.myLabel);
        panel.add((Component)label, "North");
        this.myFilesList = new FilesList(this.myFiles);
        this.myFilesList.setCheckboxColumnName("");
        this.myFilesList.setEntriesEditable(false);
        for (String myFile : this.myFiles) {
            this.myFilesList.add(myFile);
        }
        Font font = this.myFilesList.getFont();
        FontMetrics fm = this.myFilesList.getFontMetrics(font);
        int height = fm.getHeight();
        this.myFilesList.setPreferredSize(new Dimension(this.myFilesList.getPreferredSize().width, height * 7));
        panel.add((Component)ScrollPaneFactory.createScrollPane((Component)((Object)this.myFilesList)), "Center");
        JPanel buttonsPanel = new JPanel(new FlowLayout(0));
        this.mySelectAllButton = new JButton(SvnBundle.message("button.text.select.all", new Object[0]));
        this.myDeselectAllButton = new JButton(SvnBundle.message("button.text.deselect.all", new Object[0]));
        buttonsPanel.add(this.mySelectAllButton);
        buttonsPanel.add(this.myDeselectAllButton);
        panel.add((Component)buttonsPanel, "South");
        return panel;
    }

    @Override
    public void actionPerformed(ActionEvent e) {
        for (String file : this.myFiles) {
            this.myFilesList.setChecked(file, e.getSource() == this.mySelectAllButton);
        }
        this.myFilesList.refresh();
        this.setOKActionEnabled(this.isOKActionEnabled());
    }

    public String[] getSelectedPaths() {
        return this.myFilesList.getSelectedPaths();
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/idea/svn/dialogs/SelectFilesDialog", "createActions"));
    }

    private class FilesList
    extends OrderPanel<String> {
        private final Map<String, Boolean> mySelectedFiles;

        protected FilesList(String[] files) {
            super(String.class, true);
            this.mySelectedFiles = new TreeMap<String, Boolean>();
            for (String file : files) {
                this.mySelectedFiles.put(file, Boolean.TRUE);
            }
        }

        public boolean isCheckable(String entry) {
            return true;
        }

        public boolean isChecked(String entry) {
            return Boolean.TRUE.equals(this.mySelectedFiles.get(entry));
        }

        public void setChecked(String entry, boolean checked) {
            this.mySelectedFiles.put(entry, checked);
            SelectFilesDialog.this.getOKAction().setEnabled(SelectFilesDialog.this.isOKActionEnabled());
        }

        public void refresh() {
            this.clear();
            for (String path : this.mySelectedFiles.keySet()) {
                this.add(path);
            }
        }

        public String[] getSelectedPaths() {
            TreeSet<String> selected = new TreeSet<String>();
            for (String path : this.mySelectedFiles.keySet()) {
                if (!this.isChecked(path)) continue;
                selected.add(path);
            }
            return ArrayUtil.toStringArray(selected);
        }
    }
}

