/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.util.xml;

import com.intellij.psi.PsiElement;
import com.intellij.psi.meta.PsiMetaData;
import com.intellij.psi.meta.PsiPresentableMetaData;
import com.intellij.psi.meta.PsiWritableMetaData;
import com.intellij.psi.xml.XmlTag;
import com.intellij.util.IncorrectOperationException;
import com.intellij.util.xml.DomElement;
import com.intellij.util.xml.DomManager;
import com.intellij.util.xml.DomUtil;
import com.intellij.util.xml.ElementPresentationManager;
import com.intellij.util.xml.GenericDomValue;
import javax.swing.Icon;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class DomMetaData<T extends DomElement>
implements PsiWritableMetaData,
PsiPresentableMetaData,
PsiMetaData {
    private T myElement;
    @Nullable
    private GenericDomValue myNameElement;

    @Override
    public final PsiElement getDeclaration() {
        return this.myElement.getXmlTag();
    }

    public T getElement() {
        return this.myElement;
    }

    @Override
    @NonNls
    public String getName(PsiElement context) {
        return this.getName();
    }

    @Override
    @NonNls
    public final String getName() {
        String s = ElementPresentationManager.getElementName(this.myElement);
        if (s != null) {
            return s;
        }
        GenericDomValue value = this.getNameElement(this.myElement);
        return value == null ? null : value.getStringValue();
    }

    @Override
    public void init(PsiElement element) {
        this.myElement = DomManager.getDomManager(element.getProject()).getDomElement((XmlTag)element);
        assert (this.myElement != null) : element;
        this.myNameElement = this.getNameElement(this.myElement);
    }

    public void setElement(T element) {
        this.myElement = element;
    }

    @Nullable
    protected GenericDomValue getNameElement(T t) {
        return this.myElement.getGenericInfo().getNameDomElement((DomElement)t);
    }

    @Override
    @NotNull
    public Object[] getDependences() {
        PsiElement declaration = this.getDeclaration();
        if (this.myElement != null && this.myElement.isValid()) {
            Object[] objectArray = new Object[]{DomUtil.getRoot(this.myElement), declaration};
            if (objectArray == null) {
                DomMetaData.$$$reportNull$$$0(0);
            }
            return objectArray;
        }
        Object[] objectArray = new Object[]{declaration};
        if (objectArray == null) {
            DomMetaData.$$$reportNull$$$0(1);
        }
        return objectArray;
    }

    @Override
    public void setName(String name) throws IncorrectOperationException {
        if (this.myNameElement != null) {
            this.myNameElement.setStringValue(name);
        }
    }

    @Override
    public String getTypeName() {
        return ElementPresentationManager.getTypeNameForObject(this.myElement);
    }

    @Override
    public Icon getIcon() {
        return ElementPresentationManager.getIcon(this.myElement);
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/util/xml/DomMetaData", "getDependences"));
    }
}

