/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.ui.components.fields;

import com.intellij.openapi.util.text.StringUtil;
import com.intellij.ui.Expandable;
import com.intellij.ui.components.JBScrollPane;
import com.intellij.ui.components.fields.ExpandableSupport;
import com.intellij.ui.components.fields.ExtendableTextComponent;
import com.intellij.ui.components.fields.ExtendableTextField;
import com.intellij.util.Function;
import com.intellij.util.execution.ParametersListUtil;
import com.intellij.util.ui.JBInsets;
import com.intellij.util.ui.JBUI;
import com.intellij.util.ui.UIUtil;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.FontMetrics;
import java.awt.Insets;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import javax.swing.BorderFactory;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JTextArea;
import javax.swing.border.Border;
import javax.swing.text.JTextComponent;
import org.jetbrains.annotations.NotNull;

public class ExpandableTextField
extends ExtendableTextField
implements Expandable {
    private final ExpandableSupport support;

    public ExpandableTextField() {
        this((Function<String, List<String>>)ParametersListUtil.DEFAULT_LINE_PARSER, (Function<List<String>, String>)ParametersListUtil.DEFAULT_LINE_JOINER);
    }

    public ExpandableTextField(@NotNull Function<String, List<String>> parser, @NotNull Function<List<String>, String> joiner) {
        if (parser == null) {
            ExpandableTextField.$$$reportNull$$$0(0);
        }
        if (joiner == null) {
            ExpandableTextField.$$$reportNull$$$0(1);
        }
        Function onShow = text -> {
            if (parser == null) {
                ExpandableTextField.$$$reportNull$$$0(4);
            }
            return StringUtil.join((Collection)((Collection)parser.fun(text)), (String)"\n");
        };
        Function onHide = text -> {
            if (joiner == null) {
                ExpandableTextField.$$$reportNull$$$0(3);
            }
            return (String)joiner.fun(Arrays.asList(StringUtil.splitByLines((String)text)));
        };
        this.support = new ExpandableSupport<JTextComponent>((JTextComponent)this, onShow, onHide){

            @Override
            @NotNull
            protected ExpandableSupport.Content prepare(final @NotNull JTextComponent field, @NotNull Function<? super String, String> onShow) {
                Font font;
                if (field == null) {
                    1.$$$reportNull$$$0(0);
                }
                if (onShow == null) {
                    1.$$$reportNull$$$0(1);
                }
                FontMetrics metrics = (font = field.getFont()) == null ? null : field.getFontMetrics(font);
                int height = metrics == null ? 16 : metrics.getHeight();
                Dimension size = new Dimension(height * 32, height * 16);
                final JTextArea area = new JTextArea((String)onShow.fun((Object)field.getText()));
                area.putClientProperty(Expandable.class, this);
                area.setEditable(field.isEditable());
                area.setBackground(field.getBackground());
                area.setForeground(field.getForeground());
                area.setFont(font);
                area.setWrapStyleWord(true);
                area.setLineWrap(true);
                ExpandableTextField.copyCaretPosition(field, area);
                UIUtil.addUndoRedoActions((JTextComponent)area);
                JLabel label = 1.createLabel(this.createCollapseExtension());
                label.setBorder((Border)JBUI.Borders.empty((int)5, (int)0, (int)5, (int)5));
                final JBScrollPane pane = new JBScrollPane(area);
                pane.setVerticalScrollBarPolicy(22);
                pane.getVerticalScrollBar().add("JB_SCROLL_BAR_LEADING_COMPONENT", label);
                pane.getVerticalScrollBar().setBackground(area.getBackground());
                Insets insets = field.getInsets();
                Insets margin = field.getMargin();
                if (margin != null) {
                    insets.top += margin.top;
                    insets.left += margin.left;
                    insets.right += margin.right;
                    insets.bottom += margin.bottom;
                }
                JBInsets.addTo((Dimension)size, (Insets)insets);
                JBInsets.addTo((Dimension)size, (Insets)pane.getInsets());
                pane.setPreferredSize(size);
                pane.setViewportBorder(insets != null ? BorderFactory.createEmptyBorder(insets.top, insets.left, insets.bottom, insets.right) : BorderFactory.createEmptyBorder());
                ExpandableSupport.Content content = new ExpandableSupport.Content(){

                    @Override
                    @NotNull
                    public JComponent getContentComponent() {
                        JBScrollPane jBScrollPane = pane;
                        if (jBScrollPane == null) {
                            1.$$$reportNull$$$0(0);
                        }
                        return jBScrollPane;
                    }

                    @Override
                    public JComponent getFocusableComponent() {
                        return area;
                    }

                    @Override
                    public void cancel(@NotNull Function<? super String, String> onHide) {
                        if (onHide == null) {
                            1.$$$reportNull$$$0(1);
                        }
                        if (field.isEditable()) {
                            field.setText((String)onHide.fun((Object)area.getText()));
                            ExpandableTextField.copyCaretPosition(area, field);
                        }
                    }

                    private static /* synthetic */ void $$$reportNull$$$0(int n) {
                        RuntimeException runtimeException;
                        Object[] objectArray;
                        Object[] objectArray2;
                        int n2;
                        String string;
                        switch (n) {
                            default: {
                                string = "@NotNull method %s.%s must not return null";
                                break;
                            }
                            case 1: {
                                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                                break;
                            }
                        }
                        switch (n) {
                            default: {
                                n2 = 2;
                                break;
                            }
                            case 1: {
                                n2 = 3;
                                break;
                            }
                        }
                        Object[] objectArray3 = new Object[n2];
                        switch (n) {
                            default: {
                                objectArray2 = objectArray3;
                                objectArray3[0] = "com/intellij/ui/components/fields/ExpandableTextField$1$1";
                                break;
                            }
                            case 1: {
                                objectArray2 = objectArray3;
                                objectArray3[0] = "onHide";
                                break;
                            }
                        }
                        switch (n) {
                            default: {
                                objectArray = objectArray2;
                                objectArray2[1] = "getContentComponent";
                                break;
                            }
                            case 1: {
                                objectArray = objectArray2;
                                objectArray2[1] = "com/intellij/ui/components/fields/ExpandableTextField$1$1";
                                break;
                            }
                        }
                        switch (n) {
                            default: {
                                break;
                            }
                            case 1: {
                                objectArray = objectArray;
                                objectArray[2] = "cancel";
                                break;
                            }
                        }
                        String string2 = String.format(string, objectArray);
                        switch (n) {
                            default: {
                                runtimeException = new IllegalStateException(string2);
                                break;
                            }
                            case 1: {
                                runtimeException = new IllegalArgumentException(string2);
                                break;
                            }
                        }
                        throw runtimeException;
                    }
                };
                if (content == null) {
                    1.$$$reportNull$$$0(2);
                }
                return content;
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                RuntimeException runtimeException;
                Object[] objectArray;
                Object[] objectArray2;
                int n2;
                String string;
                switch (n) {
                    default: {
                        string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                        break;
                    }
                    case 2: {
                        string = "@NotNull method %s.%s must not return null";
                        break;
                    }
                }
                switch (n) {
                    default: {
                        n2 = 3;
                        break;
                    }
                    case 2: {
                        n2 = 2;
                        break;
                    }
                }
                Object[] objectArray3 = new Object[n2];
                switch (n) {
                    default: {
                        objectArray2 = objectArray3;
                        objectArray3[0] = "field";
                        break;
                    }
                    case 1: {
                        objectArray2 = objectArray3;
                        objectArray3[0] = "onShow";
                        break;
                    }
                    case 2: {
                        objectArray2 = objectArray3;
                        objectArray3[0] = "com/intellij/ui/components/fields/ExpandableTextField$1";
                        break;
                    }
                }
                switch (n) {
                    default: {
                        objectArray = objectArray2;
                        objectArray2[1] = "com/intellij/ui/components/fields/ExpandableTextField$1";
                        break;
                    }
                    case 2: {
                        objectArray = objectArray2;
                        objectArray2[1] = "prepare";
                        break;
                    }
                }
                switch (n) {
                    default: {
                        objectArray = objectArray;
                        objectArray[2] = "prepare";
                        break;
                    }
                    case 2: {
                        break;
                    }
                }
                String string2 = String.format(string, objectArray);
                switch (n) {
                    default: {
                        runtimeException = new IllegalArgumentException(string2);
                        break;
                    }
                    case 2: {
                        runtimeException = new IllegalStateException(string2);
                        break;
                    }
                }
                throw runtimeException;
            }
        };
        this.putClientProperty("monospaced", true);
        this.setExtensions(this.createExtensions());
    }

    @NotNull
    protected List<ExtendableTextComponent.Extension> createExtensions() {
        List<ExtendableTextComponent.Extension> list = Collections.singletonList(this.support.createExpandExtension());
        if (list == null) {
            ExpandableTextField.$$$reportNull$$$0(2);
        }
        return list;
    }

    public String getTitle() {
        return this.support.getTitle();
    }

    public void setTitle(String title) {
        this.support.setTitle(title);
    }

    @Override
    public void setEnabled(boolean enabled) {
        if (!enabled) {
            this.support.collapse();
        }
        super.setEnabled(enabled);
    }

    @Override
    public void collapse() {
        this.support.collapse();
    }

    @Override
    public boolean isExpanded() {
        return this.support.isExpanded();
    }

    @Override
    public void expand() {
        this.support.expand();
    }

    private static void copyCaretPosition(JTextComponent source, JTextComponent destination) {
        try {
            destination.setCaretPosition(source.getCaretPosition());
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 2: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 2: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "parser";
                break;
            }
            case 1: 
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "joiner";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/ui/components/fields/ExpandableTextField";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/ui/components/fields/ExpandableTextField";
                break;
            }
            case 2: {
                objectArray = objectArray2;
                objectArray2[1] = "createExtensions";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 2: {
                break;
            }
            case 3: {
                objectArray = objectArray;
                objectArray[2] = "lambda$new$1";
                break;
            }
            case 4: {
                objectArray = objectArray;
                objectArray[2] = "lambda$new$0";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 2: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

