/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.openapi.vfs.newvfs;

import com.intellij.openapi.util.io.FileUtil;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.openapi.vfs.newvfs.ManagingFS;
import com.intellij.util.containers.ContainerUtil;
import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.util.Set;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class FileAttribute {
    private static final Set<String> ourRegisteredIds = ContainerUtil.newConcurrentSet();
    private static final int UNDEFINED_VERSION = -1;
    private final String myId;
    private final int myVersion;
    private final boolean myFixedSize;

    public FileAttribute(@NonNls @NotNull String id) {
        if (id == null) {
            FileAttribute.$$$reportNull$$$0(0);
        }
        this(id, -1, false);
    }

    public FileAttribute(@NonNls @NotNull String id, int version) {
        if (id == null) {
            FileAttribute.$$$reportNull$$$0(1);
        }
        this(id, version, false);
    }

    public FileAttribute(@NonNls @NotNull String id, int version, boolean fixedSize) {
        if (id == null) {
            FileAttribute.$$$reportNull$$$0(2);
        }
        this(version, fixedSize, id);
        boolean added = ourRegisteredIds.add(id);
        assert (added) : "Attribute id='" + id + "' is not unique";
    }

    private FileAttribute(int version, boolean fixedSize, @NotNull String id) {
        if (id == null) {
            FileAttribute.$$$reportNull$$$0(3);
        }
        this.myId = id;
        this.myVersion = version;
        this.myFixedSize = fixedSize;
    }

    @Nullable
    public DataInputStream readAttribute(@NotNull VirtualFile file) {
        if (file == null) {
            FileAttribute.$$$reportNull$$$0(4);
        }
        return ManagingFS.getInstance().readAttribute(file, this);
    }

    @NotNull
    public DataOutputStream writeAttribute(@NotNull VirtualFile file) {
        if (file == null) {
            FileAttribute.$$$reportNull$$$0(5);
        }
        DataOutputStream dataOutputStream = ManagingFS.getInstance().writeAttribute(file, this);
        if (dataOutputStream == null) {
            FileAttribute.$$$reportNull$$$0(6);
        }
        return dataOutputStream;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Nullable
    public byte[] readAttributeBytes(VirtualFile file) throws IOException {
        DataInputStream stream = this.readAttribute(file);
        if (stream == null) {
            return null;
        }
        try {
            int len = stream.readInt();
            byte[] byArray = FileUtil.loadBytes((InputStream)stream, (int)len);
            return byArray;
        }
        finally {
            stream.close();
        }
    }

    public void writeAttributeBytes(VirtualFile file, @NotNull byte[] bytes) throws IOException {
        if (bytes == null) {
            FileAttribute.$$$reportNull$$$0(7);
        }
        this.writeAttributeBytes(file, bytes, 0, bytes.length);
    }

    public void writeAttributeBytes(VirtualFile file, byte[] bytes, int offset, int len) throws IOException {
        try (DataOutputStream stream = this.writeAttribute(file);){
            stream.writeInt(len);
            stream.write(bytes, offset, len);
        }
    }

    @NotNull
    public String getId() {
        String string = this.myId;
        if (string == null) {
            FileAttribute.$$$reportNull$$$0(8);
        }
        return string;
    }

    public boolean isFixedSize() {
        return this.myFixedSize;
    }

    @NotNull
    public FileAttribute newVersion(int newVersion) {
        FileAttribute fileAttribute = new FileAttribute(newVersion, this.myFixedSize, this.myId);
        if (fileAttribute == null) {
            FileAttribute.$$$reportNull$$$0(9);
        }
        return fileAttribute;
    }

    public int getVersion() {
        return this.myVersion;
    }

    public boolean isVersioned() {
        return this.myVersion != -1;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 6: 
            case 8: 
            case 9: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 6: 
            case 8: 
            case 9: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "id";
                break;
            }
            case 4: 
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "file";
                break;
            }
            case 6: 
            case 8: 
            case 9: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/openapi/vfs/newvfs/FileAttribute";
                break;
            }
            case 7: {
                objectArray2 = objectArray3;
                objectArray3[0] = "bytes";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/openapi/vfs/newvfs/FileAttribute";
                break;
            }
            case 6: {
                objectArray = objectArray2;
                objectArray2[1] = "writeAttribute";
                break;
            }
            case 8: {
                objectArray = objectArray2;
                objectArray2[1] = "getId";
                break;
            }
            case 9: {
                objectArray = objectArray2;
                objectArray2[1] = "newVersion";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 4: {
                objectArray = objectArray;
                objectArray[2] = "readAttribute";
                break;
            }
            case 5: {
                objectArray = objectArray;
                objectArray[2] = "writeAttribute";
                break;
            }
            case 6: 
            case 8: 
            case 9: {
                break;
            }
            case 7: {
                objectArray = objectArray;
                objectArray[2] = "writeAttributeBytes";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 6: 
            case 8: 
            case 9: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

