/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.openapi.ui.panel;

import com.intellij.openapi.ui.ComponentWithBrowseButton;
import com.intellij.openapi.ui.LabeledComponent;
import com.intellij.openapi.ui.panel.ComponentPanel;
import com.intellij.openapi.ui.panel.GridBagPanelBuilder;
import com.intellij.openapi.util.SystemInfo;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.ui.ColorUtil;
import com.intellij.ui.ContextHelpLabel;
import com.intellij.ui.JBColor;
import com.intellij.ui.TextComponent;
import com.intellij.ui.components.JBLabel;
import com.intellij.ui.components.panels.NonOpaquePanel;
import com.intellij.util.SystemProperties;
import com.intellij.util.ui.JBEmptyBorder;
import com.intellij.util.ui.JBInsets;
import com.intellij.util.ui.JBUI;
import com.intellij.util.ui.UI;
import com.intellij.util.ui.UIUtil;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import javax.swing.Box;
import javax.swing.BoxLayout;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JComboBox;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JRadioButton;
import javax.swing.JTextField;
import javax.swing.border.Border;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class ComponentPanelBuilder
implements GridBagPanelBuilder {
    private final JComponent myComponent;
    private String myLabelText;
    private boolean myLabelOnTop;
    private String myCommentText;
    private boolean myCommentBelow = true;
    private String myHTDescription;
    private String myHTLinkText;
    private Runnable myHTAction;
    private JComponent myTopRightComponent;
    private UI.Anchor myAnchor = UI.Anchor.Center;
    private boolean myResizeY;
    private boolean myResizeX = true;
    private boolean valid = true;

    public ComponentPanelBuilder(JComponent component) {
        this.myComponent = component;
    }

    public ComponentPanelBuilder resizeY(boolean resize) {
        this.myResizeY = resize;
        return this;
    }

    public ComponentPanelBuilder resizeX(boolean resize) {
        this.myResizeX = resize;
        return this;
    }

    public ComponentPanelBuilder withLabel(@NotNull String labelText) {
        if (labelText == null) {
            ComponentPanelBuilder.$$$reportNull$$$0(0);
        }
        this.myLabelText = labelText;
        return this;
    }

    public ComponentPanelBuilder moveLabelOnTop() {
        this.myLabelOnTop = true;
        this.valid = StringUtil.isEmpty((String)this.myCommentText) || StringUtil.isEmpty((String)this.myHTDescription);
        return this;
    }

    public ComponentPanelBuilder anchorLabelOn(UI.Anchor anchor) {
        this.myAnchor = anchor;
        return this;
    }

    public ComponentPanelBuilder withComment(@NotNull String comment) {
        if (comment == null) {
            ComponentPanelBuilder.$$$reportNull$$$0(1);
        }
        this.myCommentText = comment;
        this.valid = StringUtil.isEmpty((String)comment) || StringUtil.isEmpty((String)this.myHTDescription);
        return this;
    }

    public ComponentPanelBuilder withTopRightComponent(@NotNull JComponent topRightComponent) {
        if (topRightComponent == null) {
            ComponentPanelBuilder.$$$reportNull$$$0(2);
        }
        this.myTopRightComponent = topRightComponent;
        this.valid = StringUtil.isEmpty((String)this.myCommentText) || StringUtil.isEmpty((String)this.myHTDescription);
        return this;
    }

    public ComponentPanelBuilder moveCommentRight() {
        this.myCommentBelow = false;
        return this;
    }

    public ComponentPanelBuilder withTooltip(@NotNull String description) {
        if (description == null) {
            ComponentPanelBuilder.$$$reportNull$$$0(3);
        }
        this.myHTDescription = description;
        this.valid = StringUtil.isEmpty((String)this.myCommentText) || StringUtil.isEmpty((String)description);
        return this;
    }

    public ComponentPanelBuilder withTooltipLink(@NotNull String linkText, @NotNull Runnable action) {
        if (linkText == null) {
            ComponentPanelBuilder.$$$reportNull$$$0(4);
        }
        if (action == null) {
            ComponentPanelBuilder.$$$reportNull$$$0(5);
        }
        this.myHTLinkText = linkText;
        this.myHTAction = action;
        return this;
    }

    @Override
    @NotNull
    public JPanel createPanel() {
        NonOpaquePanel panel = new NonOpaquePanel(new GridBagLayout());
        GridBagConstraints gc = new GridBagConstraints(0, 0, 1, 1, 0.0, 0.0, 21, 2, null, 0, 0);
        this.addToPanel(panel, gc);
        NonOpaquePanel nonOpaquePanel = panel;
        if (nonOpaquePanel == null) {
            ComponentPanelBuilder.$$$reportNull$$$0(6);
        }
        return nonOpaquePanel;
    }

    @Override
    public boolean constrainsValid() {
        return this.valid;
    }

    @Override
    public int gridWidth() {
        return 2;
    }

    @Override
    public void addToPanel(JPanel panel, GridBagConstraints gc) {
        if (this.constrainsValid()) {
            new ComponentPanelImpl().addToPanel(panel, gc);
        }
    }

    private Border getCommentBorder() {
        if (StringUtil.isNotEmpty((String)this.myCommentText)) {
            return new JBEmptyBorder(ComponentPanelBuilder.computeCommentInsets(this.myComponent, this.myCommentBelow));
        }
        return JBUI.Borders.empty();
    }

    @NotNull
    public static Insets computeCommentInsets(@NotNull JComponent component, boolean commentBelow) {
        if (component == null) {
            ComponentPanelBuilder.$$$reportNull$$$0(7);
        }
        boolean isMacDefault = UIUtil.isUnderDefaultMacTheme();
        boolean isWin10 = UIUtil.isUnderWin10LookAndFeel();
        if (commentBelow) {
            int top = 8;
            int left = 2;
            int bottom = 0;
            if (component instanceof JRadioButton || component instanceof JCheckBox) {
                top = 0;
                int n = isMacDefault ? 26 : (left = isWin10 ? 17 : 23);
                bottom = isWin10 ? 10 : (isMacDefault ? 8 : 9);
            } else if (component instanceof JTextField || component instanceof TextComponent || component instanceof JComboBox || component instanceof ComponentWithBrowseButton) {
                int n = top = isWin10 ? 3 : 4;
                int n2 = isWin10 ? 2 : (left = isMacDefault ? 5 : 4);
                bottom = isWin10 ? 10 : (isMacDefault ? 8 : 9);
            } else if (component instanceof JButton) {
                int n = top = isWin10 ? 2 : 4;
                left = isWin10 ? 2 : (isMacDefault ? 5 : 4);
                bottom = 0;
            }
            JBInsets jBInsets = JBUI.insets((int)top, (int)left, (int)bottom, (int)0);
            if (jBInsets == null) {
                ComponentPanelBuilder.$$$reportNull$$$0(8);
            }
            return jBInsets;
        }
        int left = 14;
        if (component instanceof JRadioButton || component instanceof JCheckBox) {
            left = isMacDefault ? 8 : 13;
        } else if (component instanceof JTextField || component instanceof TextComponent || component instanceof JComboBox || component instanceof ComponentWithBrowseButton) {
            left = isMacDefault ? 13 : 14;
        }
        JBInsets jBInsets = JBUI.insetsLeft((int)left);
        if (jBInsets == null) {
            ComponentPanelBuilder.$$$reportNull$$$0(9);
        }
        return jBInsets;
    }

    @NotNull
    public static JLabel createCommentComponent(@Nullable String commentText, boolean isCommentBelow) {
        boolean isCopyable = SystemProperties.getBooleanProperty((String)"idea.ui.comment.copyable", (boolean)true);
        JBLabel component = new JBLabel("").setCopyable(isCopyable).setAllowAutoWrapping(true);
        ((JLabel)component).setVerticalTextPosition(1);
        ((Component)component).setFocusable(false);
        ((JComponent)component).setForeground(UIUtil.getContextHelpForeground());
        if (SystemInfo.isMac) {
            Font font = component.getFont();
            float size = font.getSize2D();
            Font smallFont = font.deriveFont(size - 2.0f);
            ((JComponent)component).setFont(smallFont);
        }
        if (isCopyable) {
            ComponentPanelBuilder.setCommentText(component, commentText, isCommentBelow);
        } else {
            ((JLabel)component).setText(commentText);
        }
        JBLabel jBLabel = component;
        if (jBLabel == null) {
            ComponentPanelBuilder.$$$reportNull$$$0(10);
        }
        return jBLabel;
    }

    private static void setCommentText(@NotNull JLabel component, @Nullable String commentText, boolean isCommentBelow) {
        if (component == null) {
            ComponentPanelBuilder.$$$reportNull$$$0(11);
        }
        if (commentText != null) {
            String css = "<head><style type=\"text/css\">\na, a:link {color:#" + ColorUtil.toHex((Color)JBColor.link()) + ";}\na:visited {color:#" + ColorUtil.toHex((Color)JBColor.linkVisited()) + ";}\na:hover {color:#" + ColorUtil.toHex((Color)JBColor.linkHover()) + ";}\na:active {color:#" + ColorUtil.toHex((Color)JBColor.linkPressed()) + ";}\n</style>\n</head>";
            if (commentText.length() > 70 && isCommentBelow) {
                int width = component.getFontMetrics(component.getFont()).stringWidth(commentText.substring(0, 70));
                component.setText(String.format("<html>" + css + "<body><div width=%d>%s</div></body></html>", width, commentText));
            } else {
                component.setText(String.format("<html>" + css + "<body><div>%s</div></body></html>", commentText));
            }
        }
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 6: 
            case 8: 
            case 9: 
            case 10: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 6: 
            case 8: 
            case 9: 
            case 10: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "labelText";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "comment";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "topRightComponent";
                break;
            }
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "description";
                break;
            }
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "linkText";
                break;
            }
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "action";
                break;
            }
            case 6: 
            case 8: 
            case 9: 
            case 10: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/openapi/ui/panel/ComponentPanelBuilder";
                break;
            }
            case 7: 
            case 11: {
                objectArray2 = objectArray3;
                objectArray3[0] = "component";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/openapi/ui/panel/ComponentPanelBuilder";
                break;
            }
            case 6: {
                objectArray = objectArray2;
                objectArray2[1] = "createPanel";
                break;
            }
            case 8: 
            case 9: {
                objectArray = objectArray2;
                objectArray2[1] = "computeCommentInsets";
                break;
            }
            case 10: {
                objectArray = objectArray2;
                objectArray2[1] = "createCommentComponent";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "withLabel";
                break;
            }
            case 1: {
                objectArray = objectArray;
                objectArray[2] = "withComment";
                break;
            }
            case 2: {
                objectArray = objectArray;
                objectArray[2] = "withTopRightComponent";
                break;
            }
            case 3: {
                objectArray = objectArray;
                objectArray[2] = "withTooltip";
                break;
            }
            case 4: 
            case 5: {
                objectArray = objectArray;
                objectArray[2] = "withTooltipLink";
                break;
            }
            case 6: 
            case 8: 
            case 9: 
            case 10: {
                break;
            }
            case 7: {
                objectArray = objectArray;
                objectArray[2] = "computeCommentInsets";
                break;
            }
            case 11: {
                objectArray = objectArray;
                objectArray[2] = "setCommentText";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 6: 
            case 8: 
            case 9: 
            case 10: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }

    private class ComponentPanelImpl
    extends ComponentPanel {
        private final JLabel label;
        private final JLabel comment;

        private ComponentPanelImpl() {
            if (StringUtil.isNotEmpty((String)ComponentPanelBuilder.this.myLabelText)) {
                this.label = new JLabel();
                LabeledComponent.TextWithMnemonic.fromTextWithMnemonic(ComponentPanelBuilder.this.myLabelText).setToLabel(this.label);
                this.label.setLabelFor(ComponentPanelBuilder.this.myComponent);
            } else {
                this.label = new JLabel("");
            }
            this.comment = ComponentPanelBuilder.createCommentComponent(ComponentPanelBuilder.this.myCommentText, ComponentPanelBuilder.this.myCommentBelow);
            this.comment.setBorder(ComponentPanelBuilder.this.getCommentBorder());
        }

        @Override
        public String getCommentText() {
            return ComponentPanelBuilder.this.myCommentText;
        }

        @Override
        public void setCommentText(String commentText) {
            if (!StringUtil.equals((CharSequence)ComponentPanelBuilder.this.myCommentText, (CharSequence)commentText)) {
                ComponentPanelBuilder.this.myCommentText = commentText;
                this.setCommentTextImpl(commentText);
            }
        }

        private void setCommentTextImpl(String commentText) {
            ComponentPanelBuilder.setCommentText(this.comment, commentText, ComponentPanelBuilder.this.myCommentBelow);
        }

        private void addToPanel(JPanel panel, GridBagConstraints gc) {
            gc.gridx = 0;
            gc.gridwidth = 1;
            gc.weightx = 0.0;
            gc.anchor = 21;
            if (StringUtil.isNotEmpty((String)ComponentPanelBuilder.this.myLabelText)) {
                if (ComponentPanelBuilder.this.myLabelOnTop || ComponentPanelBuilder.this.myTopRightComponent != null) {
                    gc.insets = JBUI.insetsBottom((int)4);
                    gc.gridx = 1;
                    JPanel topPanel = new JPanel();
                    topPanel.setLayout(new BoxLayout(topPanel, 0));
                    if (ComponentPanelBuilder.this.myLabelOnTop) {
                        topPanel.add(this.label);
                    }
                    if (ComponentPanelBuilder.this.myTopRightComponent != null) {
                        topPanel.add(new Box.Filler((Dimension)JBUI.size((int)10, (int)0), (Dimension)JBUI.size((int)10, (int)0), (Dimension)JBUI.size((int)Integer.MAX_VALUE)));
                        topPanel.add(ComponentPanelBuilder.this.myTopRightComponent);
                    }
                    panel.add((Component)topPanel, gc);
                    ++gc.gridy;
                }
                if (!ComponentPanelBuilder.this.myLabelOnTop) {
                    gc.gridx = 0;
                    switch (ComponentPanelBuilder.this.myAnchor) {
                        case Top: {
                            gc.anchor = 19;
                            gc.insets = JBUI.insets((int)4, (int)0, (int)0, (int)8);
                            break;
                        }
                        case Center: {
                            gc.anchor = 21;
                            gc.insets = JBUI.insetsRight((int)8);
                            break;
                        }
                        case Bottom: {
                            gc.anchor = 20;
                            gc.insets = JBUI.insets((int)0, (int)0, (int)4, (int)8);
                        }
                    }
                    panel.add((Component)this.label, gc);
                }
            }
            gc.gridx = gc.gridx + (ComponentPanelBuilder.this.myLabelOnTop ? 0 : 1);
            gc.weightx = 1.0;
            gc.insets = JBUI.emptyInsets();
            gc.fill = ComponentPanelBuilder.this.myResizeY ? 1 : (ComponentPanelBuilder.this.myResizeX ? 2 : 0);
            double d = gc.weighty = ComponentPanelBuilder.this.myResizeY ? 1.0 : 0.0;
            if (StringUtil.isNotEmpty((String)ComponentPanelBuilder.this.myHTDescription) || !ComponentPanelBuilder.this.myCommentBelow) {
                JPanel componentPanel = new JPanel();
                componentPanel.setLayout(new BoxLayout(componentPanel, 0));
                componentPanel.add(ComponentPanelBuilder.this.myComponent);
                if (StringUtil.isNotEmpty((String)ComponentPanelBuilder.this.myHTDescription)) {
                    ContextHelpLabel lbl = StringUtil.isNotEmpty((String)ComponentPanelBuilder.this.myHTLinkText) && ComponentPanelBuilder.this.myHTAction != null ? ContextHelpLabel.createWithLink(null, ComponentPanelBuilder.this.myHTDescription, ComponentPanelBuilder.this.myHTLinkText, ComponentPanelBuilder.this.myHTAction) : ContextHelpLabel.create(ComponentPanelBuilder.this.myHTDescription);
                    componentPanel.add(Box.createRigidArea((Dimension)JBUI.size((int)7, (int)0)));
                    componentPanel.add(lbl);
                } else if (!ComponentPanelBuilder.this.myCommentBelow) {
                    this.comment.setBorder(ComponentPanelBuilder.this.getCommentBorder());
                    componentPanel.add(this.comment);
                }
                panel.add((Component)componentPanel, gc);
            } else {
                panel.add((Component)ComponentPanelBuilder.this.myComponent, gc);
            }
            gc.fill = 2;
            gc.weighty = 0.0;
            if (ComponentPanelBuilder.this.myCommentBelow) {
                gc.gridx = 1;
                ++gc.gridy;
                gc.weightx = 0.0;
                gc.anchor = 18;
                gc.insets = JBUI.emptyInsets();
                this.comment.setBorder(ComponentPanelBuilder.this.getCommentBorder());
                panel.add((Component)this.comment, gc);
            }
            ComponentPanelBuilder.this.myComponent.putClientProperty("JComponent.decoratedPanel", this);
            ++gc.gridy;
        }
    }
}

