/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.openapi;

import com.intellij.util.NullableFunction;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import org.jetbrains.annotations.NotNull;

public class ListSelection<T> {
    @NotNull
    private final List<T> myList;
    private final int mySelectedIndex;

    private ListSelection(@NotNull List<T> list, int selectedIndex) {
        if (list == null) {
            ListSelection.$$$reportNull$$$0(0);
        }
        this.myList = list;
        this.mySelectedIndex = this.myList.isEmpty() ? -1 : (selectedIndex >= 0 && selectedIndex < list.size() ? selectedIndex : 0);
    }

    @NotNull
    public static <V> ListSelection<V> createAt(@NotNull List<V> list, int selectedIndex) {
        if (list == null) {
            ListSelection.$$$reportNull$$$0(1);
        }
        ListSelection<V> listSelection = new ListSelection<V>(list, selectedIndex);
        if (listSelection == null) {
            ListSelection.$$$reportNull$$$0(2);
        }
        return listSelection;
    }

    @NotNull
    public static <V> ListSelection<V> create(@NotNull List<V> list, V selected) {
        if (list == null) {
            ListSelection.$$$reportNull$$$0(3);
        }
        ListSelection<V> listSelection = ListSelection.createAt(list, list.indexOf(selected));
        if (listSelection == null) {
            ListSelection.$$$reportNull$$$0(4);
        }
        return listSelection;
    }

    @NotNull
    public static <V> ListSelection<V> create(@NotNull V[] array, V selected) {
        if (array == null) {
            ListSelection.$$$reportNull$$$0(5);
        }
        ListSelection<V> listSelection = ListSelection.create(Arrays.asList(array), selected);
        if (listSelection == null) {
            ListSelection.$$$reportNull$$$0(6);
        }
        return listSelection;
    }

    @NotNull
    public static <V> ListSelection<V> createSingleton(@NotNull V element) {
        if (element == null) {
            ListSelection.$$$reportNull$$$0(7);
        }
        ListSelection<V> listSelection = ListSelection.createAt(Collections.singletonList(element), 0);
        if (listSelection == null) {
            ListSelection.$$$reportNull$$$0(8);
        }
        return listSelection;
    }

    @NotNull
    public List<T> getList() {
        List<T> list = this.myList;
        if (list == null) {
            ListSelection.$$$reportNull$$$0(9);
        }
        return list;
    }

    public int getSelectedIndex() {
        return this.mySelectedIndex;
    }

    public boolean isEmpty() {
        return this.myList.isEmpty();
    }

    @NotNull
    public <V> ListSelection<V> map(@NotNull NullableFunction<T, V> convertor) {
        if (convertor == null) {
            ListSelection.$$$reportNull$$$0(10);
        }
        int newSelectionIndex = -1;
        ArrayList<Object> result2 = new ArrayList<Object>();
        for (int i = 0; i < this.myList.size(); ++i) {
            Object out;
            if (i == this.mySelectedIndex) {
                newSelectionIndex = result2.size();
            }
            if ((out = convertor.fun(this.myList.get(i))) == null) continue;
            result2.add(out);
        }
        ListSelection listSelection = new ListSelection(result2, newSelectionIndex);
        if (listSelection == null) {
            ListSelection.$$$reportNull$$$0(11);
        }
        return listSelection;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 2: 
            case 4: 
            case 6: 
            case 8: 
            case 9: 
            case 11: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 2: 
            case 4: 
            case 6: 
            case 8: 
            case 9: 
            case 11: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "list";
                break;
            }
            case 2: 
            case 4: 
            case 6: 
            case 8: 
            case 9: 
            case 11: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/openapi/ListSelection";
                break;
            }
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "array";
                break;
            }
            case 7: {
                objectArray2 = objectArray3;
                objectArray3[0] = "element";
                break;
            }
            case 10: {
                objectArray2 = objectArray3;
                objectArray3[0] = "convertor";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/openapi/ListSelection";
                break;
            }
            case 2: {
                objectArray = objectArray2;
                objectArray2[1] = "createAt";
                break;
            }
            case 4: 
            case 6: {
                objectArray = objectArray2;
                objectArray2[1] = "create";
                break;
            }
            case 8: {
                objectArray = objectArray2;
                objectArray2[1] = "createSingleton";
                break;
            }
            case 9: {
                objectArray = objectArray2;
                objectArray2[1] = "getList";
                break;
            }
            case 11: {
                objectArray = objectArray2;
                objectArray2[1] = "map";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 1: {
                objectArray = objectArray;
                objectArray[2] = "createAt";
                break;
            }
            case 2: 
            case 4: 
            case 6: 
            case 8: 
            case 9: 
            case 11: {
                break;
            }
            case 3: 
            case 5: {
                objectArray = objectArray;
                objectArray[2] = "create";
                break;
            }
            case 7: {
                objectArray = objectArray;
                objectArray[2] = "createSingleton";
                break;
            }
            case 10: {
                objectArray = objectArray;
                objectArray[2] = "map";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 2: 
            case 4: 
            case 6: 
            case 8: 
            case 9: 
            case 11: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

