/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.ide;

import com.intellij.execution.configurations.GeneralCommandLine;
import com.intellij.execution.util.ExecUtil;
import com.intellij.ide.browsers.BrowserLauncher;
import com.intellij.ide.browsers.BrowserLauncherAppless;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.SystemInfo;
import com.intellij.openapi.vfs.VfsUtilCore;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.util.containers.ContainerUtilRt;
import java.io.File;
import java.net.MalformedURLException;
import java.net.URI;
import java.net.URL;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Locale;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class BrowserUtil {
    private static final Pattern ourExternalPrefix = Pattern.compile("^[\\w+.\\-]{2,}:");
    private static final Pattern ourAnchorSuffix = Pattern.compile("#(.*)$");

    private BrowserUtil() {
    }

    public static boolean isAbsoluteURL(String url) {
        return ourExternalPrefix.matcher(url.toLowerCase(Locale.ENGLISH)).find();
    }

    public static String getDocURL(String url) {
        Matcher anchorMatcher = ourAnchorSuffix.matcher(url);
        return anchorMatcher.find() ? anchorMatcher.reset().replaceAll("") : url;
    }

    @Nullable
    public static URL getURL(String url) throws MalformedURLException {
        return BrowserUtil.isAbsoluteURL(url) ? VfsUtilCore.convertToURL(url) : new URL("file", "", url);
    }

    public static void browse(@NotNull VirtualFile file) {
        if (file == null) {
            BrowserUtil.$$$reportNull$$$0(0);
        }
        BrowserUtil.browse(file.getUrl());
    }

    public static void browse(@NotNull File file) {
        if (file == null) {
            BrowserUtil.$$$reportNull$$$0(1);
        }
        BrowserUtil.getBrowserLauncher().browse(file);
    }

    public static void browse(@NotNull URL url) {
        if (url == null) {
            BrowserUtil.$$$reportNull$$$0(2);
        }
        BrowserUtil.browse(url.toExternalForm());
    }

    @Deprecated
    public static void launchBrowser(@NotNull String url) {
        if (url == null) {
            BrowserUtil.$$$reportNull$$$0(3);
        }
        BrowserUtil.browse(url);
    }

    public static void browse(@NotNull @NonNls String url) {
        if (url == null) {
            BrowserUtil.$$$reportNull$$$0(4);
        }
        BrowserUtil.getBrowserLauncher().browse(url, null);
    }

    private static BrowserLauncher getBrowserLauncher() {
        BrowserLauncher launcher = ApplicationManager.getApplication() == null ? null : BrowserLauncher.getInstance();
        return launcher == null ? new BrowserLauncherAppless() : launcher;
    }

    public static void open(@NotNull String url) {
        if (url == null) {
            BrowserUtil.$$$reportNull$$$0(5);
        }
        BrowserUtil.getBrowserLauncher().open(url);
    }

    public static void browse(@NotNull URI uri) {
        if (uri == null) {
            BrowserUtil.$$$reportNull$$$0(6);
        }
        BrowserUtil.getBrowserLauncher().browse(uri);
    }

    public static void browse(@NotNull String url, @Nullable Project project) {
        if (url == null) {
            BrowserUtil.$$$reportNull$$$0(7);
        }
        BrowserUtil.getBrowserLauncher().browse(url, null, project);
    }

    @NotNull
    public static List<String> getOpenBrowserCommand(@NonNls @NotNull String browserPathOrName, boolean newWindowIfPossible) {
        if (browserPathOrName == null) {
            BrowserUtil.$$$reportNull$$$0(8);
        }
        if (new File(browserPathOrName).isFile()) {
            List<String> list = Collections.singletonList(browserPathOrName);
            if (list == null) {
                BrowserUtil.$$$reportNull$$$0(9);
            }
            return list;
        }
        if (SystemInfo.isMac) {
            ArrayList command = ContainerUtilRt.newArrayList((Object[])new String[]{ExecUtil.getOpenCommandPath(), "-a", browserPathOrName});
            if (newWindowIfPossible) {
                command.add("-n");
            }
            ArrayList arrayList = command;
            if (arrayList == null) {
                BrowserUtil.$$$reportNull$$$0(10);
            }
            return arrayList;
        }
        if (SystemInfo.isWindows) {
            List<String> list = Arrays.asList(ExecUtil.getWindowsShellName(), "/c", "start", GeneralCommandLine.inescapableQuote(""), browserPathOrName);
            if (list == null) {
                BrowserUtil.$$$reportNull$$$0(11);
            }
            return list;
        }
        List<String> list = Collections.singletonList(browserPathOrName);
        if (list == null) {
            BrowserUtil.$$$reportNull$$$0(12);
        }
        return list;
    }

    public static boolean isOpenCommandSupportArgs() {
        return SystemInfo.isMacOSSnowLeopard;
    }

    @NotNull
    public static String getDefaultAlternativeBrowserPath() {
        if (SystemInfo.isWindows) {
            if ("C:\\Program Files\\Internet Explorer\\IExplore.exe" == null) {
                BrowserUtil.$$$reportNull$$$0(13);
            }
            return "C:\\Program Files\\Internet Explorer\\IExplore.exe";
        }
        if (SystemInfo.isMac) {
            if ("open" == null) {
                BrowserUtil.$$$reportNull$$$0(14);
            }
            return "open";
        }
        if (SystemInfo.isUnix) {
            if ("/usr/bin/firefox" == null) {
                BrowserUtil.$$$reportNull$$$0(15);
            }
            return "/usr/bin/firefox";
        }
        if ("" == null) {
            BrowserUtil.$$$reportNull$$$0(16);
        }
        return "";
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 9: 
            case 10: 
            case 11: 
            case 12: 
            case 13: 
            case 14: 
            case 15: 
            case 16: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 9: 
            case 10: 
            case 11: 
            case 12: 
            case 13: 
            case 14: 
            case 15: 
            case 16: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "file";
                break;
            }
            case 2: 
            case 3: 
            case 4: 
            case 5: 
            case 7: {
                objectArray2 = objectArray3;
                objectArray3[0] = "url";
                break;
            }
            case 6: {
                objectArray2 = objectArray3;
                objectArray3[0] = "uri";
                break;
            }
            case 8: {
                objectArray2 = objectArray3;
                objectArray3[0] = "browserPathOrName";
                break;
            }
            case 9: 
            case 10: 
            case 11: 
            case 12: 
            case 13: 
            case 14: 
            case 15: 
            case 16: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/ide/BrowserUtil";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/ide/BrowserUtil";
                break;
            }
            case 9: 
            case 10: 
            case 11: 
            case 12: {
                objectArray = objectArray2;
                objectArray2[1] = "getOpenBrowserCommand";
                break;
            }
            case 13: 
            case 14: 
            case 15: 
            case 16: {
                objectArray = objectArray2;
                objectArray2[1] = "getDefaultAlternativeBrowserPath";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "browse";
                break;
            }
            case 3: {
                objectArray = objectArray;
                objectArray[2] = "launchBrowser";
                break;
            }
            case 5: {
                objectArray = objectArray;
                objectArray[2] = "open";
                break;
            }
            case 8: {
                objectArray = objectArray;
                objectArray[2] = "getOpenBrowserCommand";
                break;
            }
            case 9: 
            case 10: 
            case 11: 
            case 12: 
            case 13: 
            case 14: 
            case 15: 
            case 16: {
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 9: 
            case 10: 
            case 11: 
            case 12: 
            case 13: 
            case 14: 
            case 15: 
            case 16: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

