/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.codeInspection;

import com.intellij.codeHighlighting.HighlightDisplayLevel;
import com.intellij.codeInspection.BatchSuppressableTool;
import com.intellij.codeInspection.InjectionAwareSuppressQuickFix;
import com.intellij.codeInspection.InspectionSuppressor;
import com.intellij.codeInspection.InspectionsBundle;
import com.intellij.codeInspection.LanguageInspectionSuppressors;
import com.intellij.codeInspection.SuppressQuickFix;
import com.intellij.codeInspection.ex.InspectionElementsMerger;
import com.intellij.lang.Language;
import com.intellij.lang.injection.InjectedLanguageManager;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.DefaultJDOMExternalizer;
import com.intellij.openapi.util.InvalidDataException;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.psi.FileViewProvider;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiLanguageInjectionHost;
import com.intellij.psi.templateLanguages.TemplateLanguageFileViewProvider;
import com.intellij.util.ResourceUtil;
import com.intellij.util.ThreeState;
import com.intellij.util.containers.ContainerUtil;
import com.intellij.util.xmlb.SerializationFilter;
import com.intellij.util.xmlb.SkipDefaultValuesSerializationFilters;
import com.intellij.util.xmlb.XmlSerializationException;
import com.intellij.util.xmlb.XmlSerializer;
import gnu.trove.THashSet;
import gnu.trove.TObjectHashingStrategy;
import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStreamReader;
import java.net.URL;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Set;
import javax.swing.JComponent;
import org.jdom.Element;
import org.jetbrains.annotations.Nls;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public abstract class InspectionProfileEntry
implements BatchSuppressableTool {
    public static final String GENERAL_GROUP_NAME = InspectionsBundle.message("inspection.general.tools.group.name", new Object[0]);
    private static final Logger LOG = Logger.getInstance((String)"#com.intellij.codeInspection.InspectionProfileEntry");
    private static final SerializationFilter DEFAULT_FILTER = new SkipDefaultValuesSerializationFilters();
    private static Set<String> ourBlackList;
    private static final Object BLACK_LIST_LOCK;
    private Boolean myUseNewSerializer;
    protected volatile DefaultNameProvider myNameProvider;

    @NonNls
    @Nullable
    public String getAlternativeID() {
        return null;
    }

    @Override
    public boolean isSuppressedFor(@NotNull PsiElement element) {
        if (element == null) {
            InspectionProfileEntry.$$$reportNull$$$0(0);
        }
        Set<InspectionSuppressor> suppressors = InspectionProfileEntry.getSuppressors(element);
        String toolId = this.getSuppressId();
        for (InspectionSuppressor suppressor : suppressors) {
            if (!this.isSuppressed(toolId, suppressor, element)) continue;
            return true;
        }
        InspectionElementsMerger merger = InspectionElementsMerger.getMerger(this.getShortName());
        if (merger != null) {
            String[] sourceToolIds;
            String[] suppressIds = merger.getSuppressIds();
            for (String sourceToolId : sourceToolIds = suppressIds.length != 0 ? suppressIds : merger.getSourceToolNames()) {
                for (InspectionSuppressor suppressor : suppressors) {
                    if (!suppressor.isSuppressedFor(element, sourceToolId)) continue;
                    return true;
                }
            }
        }
        return false;
    }

    @NotNull
    protected String getSuppressId() {
        String string = this.getShortName();
        if (string == null) {
            InspectionProfileEntry.$$$reportNull$$$0(1);
        }
        return string;
    }

    @Override
    @NotNull
    public SuppressQuickFix[] getBatchSuppressActions(@Nullable PsiElement element) {
        if (element == null) {
            if (SuppressQuickFix.EMPTY_ARRAY == null) {
                InspectionProfileEntry.$$$reportNull$$$0(2);
            }
            return SuppressQuickFix.EMPTY_ARRAY;
        }
        THashSet fixes = new THashSet((TObjectHashingStrategy)new TObjectHashingStrategy<SuppressQuickFix>(){

            public int computeHashCode(SuppressQuickFix object) {
                int result2 = object instanceof InjectionAwareSuppressQuickFix ? ((InjectionAwareSuppressQuickFix)object).isShouldBeAppliedToInjectionHost().hashCode() : 0;
                return 31 * result2 + object.getName().hashCode();
            }

            public boolean equals(SuppressQuickFix o1, SuppressQuickFix o2) {
                if (o1 instanceof InjectionAwareSuppressQuickFix && o2 instanceof InjectionAwareSuppressQuickFix && ((InjectionAwareSuppressQuickFix)o1).isShouldBeAppliedToInjectionHost() != ((InjectionAwareSuppressQuickFix)o2).isShouldBeAppliedToInjectionHost()) {
                    return false;
                }
                return o1.getName().equals(o2.getName());
            }
        });
        Set<InspectionSuppressor> suppressors = InspectionProfileEntry.getSuppressors(element);
        PsiLanguageInjectionHost injectionHost = InjectedLanguageManager.getInstance(element.getProject()).getInjectionHost(element);
        if (injectionHost != null) {
            Set<InspectionSuppressor> injectionHostSuppressors = InspectionProfileEntry.getSuppressors(injectionHost);
            for (InspectionSuppressor suppressor : injectionHostSuppressors) {
                InspectionProfileEntry.addAllSuppressActions((Collection<? super SuppressQuickFix>)fixes, injectionHost, suppressor, ThreeState.YES, this.getSuppressId());
            }
        }
        for (InspectionSuppressor suppressor : suppressors) {
            InspectionProfileEntry.addAllSuppressActions((Collection<? super SuppressQuickFix>)fixes, element, suppressor, injectionHost != null ? ThreeState.NO : ThreeState.UNSURE, this.getSuppressId());
        }
        SuppressQuickFix[] suppressQuickFixArray = fixes.toArray(SuppressQuickFix.EMPTY_ARRAY);
        if (suppressQuickFixArray == null) {
            InspectionProfileEntry.$$$reportNull$$$0(3);
        }
        return suppressQuickFixArray;
    }

    private static void addAllSuppressActions(@NotNull Collection<? super SuppressQuickFix> fixes, @NotNull PsiElement element, @NotNull InspectionSuppressor suppressor, @NotNull ThreeState appliedToInjectionHost, @NotNull String toolId) {
        SuppressQuickFix[] actions;
        if (fixes == null) {
            InspectionProfileEntry.$$$reportNull$$$0(4);
        }
        if (element == null) {
            InspectionProfileEntry.$$$reportNull$$$0(5);
        }
        if (suppressor == null) {
            InspectionProfileEntry.$$$reportNull$$$0(6);
        }
        if (appliedToInjectionHost == null) {
            InspectionProfileEntry.$$$reportNull$$$0(7);
        }
        if (toolId == null) {
            InspectionProfileEntry.$$$reportNull$$$0(8);
        }
        for (SuppressQuickFix action : actions = suppressor.getSuppressActions(element, toolId)) {
            if (action instanceof InjectionAwareSuppressQuickFix) {
                ((InjectionAwareSuppressQuickFix)action).setShouldBeAppliedToInjectionHost(appliedToInjectionHost);
            }
            fixes.add(action);
        }
    }

    private boolean isSuppressed(@NotNull String toolId, @NotNull InspectionSuppressor suppressor, @NotNull PsiElement element) {
        if (toolId == null) {
            InspectionProfileEntry.$$$reportNull$$$0(9);
        }
        if (suppressor == null) {
            InspectionProfileEntry.$$$reportNull$$$0(10);
        }
        if (element == null) {
            InspectionProfileEntry.$$$reportNull$$$0(11);
        }
        if (suppressor.isSuppressedFor(element, toolId)) {
            return true;
        }
        String alternativeId = this.getAlternativeID();
        return alternativeId != null && !alternativeId.equals(toolId) && suppressor.isSuppressedFor(element, alternativeId);
    }

    @NotNull
    public static Set<InspectionSuppressor> getSuppressors(@NotNull PsiElement element) {
        if (element == null) {
            InspectionProfileEntry.$$$reportNull$$$0(12);
        }
        FileViewProvider viewProvider = element.getContainingFile().getViewProvider();
        List elementLanguageSuppressor = LanguageInspectionSuppressors.INSTANCE.allForLanguage(element.getLanguage());
        if (viewProvider instanceof TemplateLanguageFileViewProvider) {
            LinkedHashSet<InspectionSuppressor> suppressors = new LinkedHashSet<InspectionSuppressor>();
            ContainerUtil.addAllNotNull(suppressors, LanguageInspectionSuppressors.INSTANCE.allForLanguage(viewProvider.getBaseLanguage()));
            for (Language language : viewProvider.getLanguages()) {
                ContainerUtil.addAllNotNull(suppressors, LanguageInspectionSuppressors.INSTANCE.allForLanguage(language));
            }
            ContainerUtil.addAllNotNull(suppressors, elementLanguageSuppressor);
            LinkedHashSet<InspectionSuppressor> linkedHashSet = suppressors;
            if (linkedHashSet == null) {
                InspectionProfileEntry.$$$reportNull$$$0(13);
            }
            return linkedHashSet;
        }
        if (!element.getLanguage().isKindOf(viewProvider.getBaseLanguage())) {
            LinkedHashSet<InspectionSuppressor> suppressors = new LinkedHashSet<InspectionSuppressor>();
            ContainerUtil.addAllNotNull(suppressors, LanguageInspectionSuppressors.INSTANCE.allForLanguage(viewProvider.getBaseLanguage()));
            ContainerUtil.addAllNotNull(suppressors, elementLanguageSuppressor);
            LinkedHashSet<InspectionSuppressor> linkedHashSet = suppressors;
            if (linkedHashSet == null) {
                InspectionProfileEntry.$$$reportNull$$$0(14);
            }
            return linkedHashSet;
        }
        int size = elementLanguageSuppressor.size();
        switch (size) {
            case 0: {
                Set<InspectionSuppressor> set = Collections.emptySet();
                if (set == null) {
                    InspectionProfileEntry.$$$reportNull$$$0(15);
                }
                return set;
            }
            case 1: {
                Set<InspectionSuppressor> set = Collections.singleton(elementLanguageSuppressor.get(0));
                if (set == null) {
                    InspectionProfileEntry.$$$reportNull$$$0(16);
                }
                return set;
            }
        }
        HashSet<InspectionSuppressor> hashSet = new HashSet<InspectionSuppressor>(elementLanguageSuppressor);
        if (hashSet == null) {
            InspectionProfileEntry.$$$reportNull$$$0(17);
        }
        return hashSet;
    }

    public void cleanup(@NotNull Project project) {
        if (project == null) {
            InspectionProfileEntry.$$$reportNull$$$0(18);
        }
    }

    @Nls
    @NotNull
    public String getGroupDisplayName() {
        String name;
        if (this.myNameProvider != null && (name = this.myNameProvider.getDefaultGroupDisplayName()) != null) {
            String string = name;
            if (string == null) {
                InspectionProfileEntry.$$$reportNull$$$0(19);
            }
            return string;
        }
        LOG.error(this.getClass() + ": group display name should be overridden or configured via XML " + this.getClass());
        if ("" == null) {
            InspectionProfileEntry.$$$reportNull$$$0(20);
        }
        return "";
    }

    @NotNull
    public String[] getGroupPath() {
        String groupDisplayName = this.getGroupDisplayName();
        if (groupDisplayName.isEmpty()) {
            groupDisplayName = GENERAL_GROUP_NAME;
        }
        String[] stringArray = new String[]{groupDisplayName};
        if (stringArray == null) {
            InspectionProfileEntry.$$$reportNull$$$0(21);
        }
        return stringArray;
    }

    @Nls
    @NotNull
    public String getDisplayName() {
        String name;
        if (this.myNameProvider != null && (name = this.myNameProvider.getDefaultDisplayName()) != null) {
            String string = name;
            if (string == null) {
                InspectionProfileEntry.$$$reportNull$$$0(22);
            }
            return string;
        }
        LOG.error(this.getClass() + ": display name should be overridden or configured via XML " + this.getClass());
        if ("" == null) {
            InspectionProfileEntry.$$$reportNull$$$0(23);
        }
        return "";
    }

    @NonNls
    @NotNull
    public String getShortName() {
        String name;
        if (this.myNameProvider != null && (name = this.myNameProvider.getDefaultShortName()) != null) {
            String string = name;
            if (string == null) {
                InspectionProfileEntry.$$$reportNull$$$0(24);
            }
            return string;
        }
        String string = InspectionProfileEntry.getShortName(this.getClass().getSimpleName());
        if (string == null) {
            InspectionProfileEntry.$$$reportNull$$$0(25);
        }
        return string;
    }

    @NotNull
    public static String getShortName(@NotNull String className) {
        if (className == null) {
            InspectionProfileEntry.$$$reportNull$$$0(26);
        }
        String string = StringUtil.trimEnd((String)StringUtil.trimEnd((String)className, (String)"Inspection"), (String)"InspectionBase");
        if (string == null) {
            InspectionProfileEntry.$$$reportNull$$$0(27);
        }
        return string;
    }

    @NotNull
    public HighlightDisplayLevel getDefaultLevel() {
        HighlightDisplayLevel highlightDisplayLevel = HighlightDisplayLevel.WARNING;
        if (highlightDisplayLevel == null) {
            InspectionProfileEntry.$$$reportNull$$$0(28);
        }
        return highlightDisplayLevel;
    }

    public boolean isEnabledByDefault() {
        return false;
    }

    @Nullable
    public JComponent createOptionsPanel() {
        return null;
    }

    public void readSettings(@NotNull Element node) {
        if (node == null) {
            InspectionProfileEntry.$$$reportNull$$$0(29);
        }
        if (this.useNewSerializer()) {
            try {
                XmlSerializer.deserializeInto((Object)this, (Element)node);
            }
            catch (XmlSerializationException e) {
                throw new InvalidDataException((Throwable)e);
            }
        } else {
            DefaultJDOMExternalizer.readExternal((Object)this, (Element)node);
        }
    }

    public void writeSettings(@NotNull Element node) {
        if (node == null) {
            InspectionProfileEntry.$$$reportNull$$$0(30);
        }
        if (this.useNewSerializer()) {
            XmlSerializer.serializeInto((Object)this, (Element)node, (SerializationFilter)this.getSerializationFilter());
        } else {
            DefaultJDOMExternalizer.writeExternal((Object)this, (Element)node);
        }
    }

    private synchronized boolean useNewSerializer() {
        if (this.myUseNewSerializer == null) {
            this.myUseNewSerializer = !InspectionProfileEntry.getBlackList().contains(this.getClass().getName());
        }
        return this.myUseNewSerializer;
    }

    private static void loadBlackList() {
        ourBlackList = ContainerUtil.newHashSet();
        URL url = InspectionProfileEntry.class.getResource("inspection-black-list.txt");
        if (url == null) {
            LOG.error("Resource not found");
            return;
        }
        try (BufferedReader reader = new BufferedReader(new InputStreamReader(url.openStream()));){
            String line;
            while ((line = reader.readLine()) != null) {
                if ((line = line.trim()).isEmpty()) continue;
                ourBlackList.add(line);
            }
        }
        catch (IOException e) {
            LOG.error("Unable to load resource: " + url, (Throwable)e);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     * Converted monitor instructions to comments
     * Lifted jumps to return sites
     */
    @NotNull
    public static Collection<String> getBlackList() {
        Object object = BLACK_LIST_LOCK;
        // MONITORENTER : object
        if (ourBlackList == null) {
            InspectionProfileEntry.loadBlackList();
        }
        Set<String> set = ourBlackList;
        // MONITOREXIT : object
        if (set != null) return set;
        InspectionProfileEntry.$$$reportNull$$$0(31);
        return set;
    }

    @Nullable
    protected SerializationFilter getSerializationFilter() {
        return DEFAULT_FILTER;
    }

    @Nullable
    public String getStaticDescription() {
        return null;
    }

    @Nullable
    public String getDescriptionFileName() {
        return null;
    }

    @Nullable
    protected URL getDescriptionUrl() {
        String fileName = this.getDescriptionFileName();
        if (fileName == null) {
            return null;
        }
        return ResourceUtil.getResource(this.getDescriptionContextClass(), (String)"/inspectionDescriptions", (String)fileName);
    }

    @NotNull
    protected Class<? extends InspectionProfileEntry> getDescriptionContextClass() {
        Class<?> clazz = this.getClass();
        if (clazz == null) {
            InspectionProfileEntry.$$$reportNull$$$0(32);
        }
        return clazz;
    }

    public boolean isInitialized() {
        return true;
    }

    @Nullable
    public String getMainToolId() {
        return null;
    }

    @Nullable
    public String loadDescription() {
        String description = this.getStaticDescription();
        if (description != null) {
            return description;
        }
        try {
            URL descriptionUrl = this.getDescriptionUrl();
            if (descriptionUrl == null) {
                return null;
            }
            return ResourceUtil.loadText((URL)descriptionUrl);
        }
        catch (IOException iOException) {
            return null;
        }
    }

    static {
        BLACK_LIST_LOCK = new Object();
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 1: 
            case 2: 
            case 3: 
            case 13: 
            case 14: 
            case 15: 
            case 16: 
            case 17: 
            case 19: 
            case 20: 
            case 21: 
            case 22: 
            case 23: 
            case 24: 
            case 25: 
            case 27: 
            case 28: 
            case 31: 
            case 32: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 1: 
            case 2: 
            case 3: 
            case 13: 
            case 14: 
            case 15: 
            case 16: 
            case 17: 
            case 19: 
            case 20: 
            case 21: 
            case 22: 
            case 23: 
            case 24: 
            case 25: 
            case 27: 
            case 28: 
            case 31: 
            case 32: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "element";
                break;
            }
            case 1: 
            case 2: 
            case 3: 
            case 13: 
            case 14: 
            case 15: 
            case 16: 
            case 17: 
            case 19: 
            case 20: 
            case 21: 
            case 22: 
            case 23: 
            case 24: 
            case 25: 
            case 27: 
            case 28: 
            case 31: 
            case 32: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/codeInspection/InspectionProfileEntry";
                break;
            }
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "fixes";
                break;
            }
            case 6: 
            case 10: {
                objectArray2 = objectArray3;
                objectArray3[0] = "suppressor";
                break;
            }
            case 7: {
                objectArray2 = objectArray3;
                objectArray3[0] = "appliedToInjectionHost";
                break;
            }
            case 8: 
            case 9: {
                objectArray2 = objectArray3;
                objectArray3[0] = "toolId";
                break;
            }
            case 18: {
                objectArray2 = objectArray3;
                objectArray3[0] = "project";
                break;
            }
            case 26: {
                objectArray2 = objectArray3;
                objectArray3[0] = "className";
                break;
            }
            case 29: 
            case 30: {
                objectArray2 = objectArray3;
                objectArray3[0] = "node";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/codeInspection/InspectionProfileEntry";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[1] = "getSuppressId";
                break;
            }
            case 2: 
            case 3: {
                objectArray = objectArray2;
                objectArray2[1] = "getBatchSuppressActions";
                break;
            }
            case 13: 
            case 14: 
            case 15: 
            case 16: 
            case 17: {
                objectArray = objectArray2;
                objectArray2[1] = "getSuppressors";
                break;
            }
            case 19: 
            case 20: {
                objectArray = objectArray2;
                objectArray2[1] = "getGroupDisplayName";
                break;
            }
            case 21: {
                objectArray = objectArray2;
                objectArray2[1] = "getGroupPath";
                break;
            }
            case 22: 
            case 23: {
                objectArray = objectArray2;
                objectArray2[1] = "getDisplayName";
                break;
            }
            case 24: 
            case 25: 
            case 27: {
                objectArray = objectArray2;
                objectArray2[1] = "getShortName";
                break;
            }
            case 28: {
                objectArray = objectArray2;
                objectArray2[1] = "getDefaultLevel";
                break;
            }
            case 31: {
                objectArray = objectArray2;
                objectArray2[1] = "getBlackList";
                break;
            }
            case 32: {
                objectArray = objectArray2;
                objectArray2[1] = "getDescriptionContextClass";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "isSuppressedFor";
                break;
            }
            case 1: 
            case 2: 
            case 3: 
            case 13: 
            case 14: 
            case 15: 
            case 16: 
            case 17: 
            case 19: 
            case 20: 
            case 21: 
            case 22: 
            case 23: 
            case 24: 
            case 25: 
            case 27: 
            case 28: 
            case 31: 
            case 32: {
                break;
            }
            case 4: 
            case 5: 
            case 6: 
            case 7: 
            case 8: {
                objectArray = objectArray;
                objectArray[2] = "addAllSuppressActions";
                break;
            }
            case 9: 
            case 10: 
            case 11: {
                objectArray = objectArray;
                objectArray[2] = "isSuppressed";
                break;
            }
            case 12: {
                objectArray = objectArray;
                objectArray[2] = "getSuppressors";
                break;
            }
            case 18: {
                objectArray = objectArray;
                objectArray[2] = "cleanup";
                break;
            }
            case 26: {
                objectArray = objectArray;
                objectArray[2] = "getShortName";
                break;
            }
            case 29: {
                objectArray = objectArray;
                objectArray[2] = "readSettings";
                break;
            }
            case 30: {
                objectArray = objectArray;
                objectArray[2] = "writeSettings";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 1: 
            case 2: 
            case 3: 
            case 13: 
            case 14: 
            case 15: 
            case 16: 
            case 17: 
            case 19: 
            case 20: 
            case 21: 
            case 22: 
            case 23: 
            case 24: 
            case 25: 
            case 27: 
            case 28: 
            case 31: 
            case 32: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }

    static interface DefaultNameProvider {
        @Nullable
        public String getDefaultShortName();

        @Nullable
        public String getDefaultDisplayName();

        @Nullable
        public String getDefaultGroupDisplayName();
    }
}

