/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.plantuml.ugraphic.tikz;

import java.io.IOException;
import java.io.OutputStream;
import net.sourceforge.plantuml.FileFormat;
import net.sourceforge.plantuml.TikzFontDistortion;
import net.sourceforge.plantuml.Url;
import net.sourceforge.plantuml.creole.AtomText;
import net.sourceforge.plantuml.graphic.StringBounder;
import net.sourceforge.plantuml.posimo.DotPath;
import net.sourceforge.plantuml.tikz.TikzGraphics;
import net.sourceforge.plantuml.ugraphic.AbstractCommonUGraphic;
import net.sourceforge.plantuml.ugraphic.AbstractUGraphic;
import net.sourceforge.plantuml.ugraphic.ClipContainer;
import net.sourceforge.plantuml.ugraphic.ColorMapper;
import net.sourceforge.plantuml.ugraphic.UCenteredCharacter;
import net.sourceforge.plantuml.ugraphic.UEllipse;
import net.sourceforge.plantuml.ugraphic.UGraphic2;
import net.sourceforge.plantuml.ugraphic.UImage;
import net.sourceforge.plantuml.ugraphic.UImageSvg;
import net.sourceforge.plantuml.ugraphic.ULine;
import net.sourceforge.plantuml.ugraphic.UPath;
import net.sourceforge.plantuml.ugraphic.UPolygon;
import net.sourceforge.plantuml.ugraphic.URectangle;
import net.sourceforge.plantuml.ugraphic.UText;
import net.sourceforge.plantuml.ugraphic.tikz.DriverAtomTextTikz;
import net.sourceforge.plantuml.ugraphic.tikz.DriverCenteredCharacterTikz2;
import net.sourceforge.plantuml.ugraphic.tikz.DriverDotPathTikz;
import net.sourceforge.plantuml.ugraphic.tikz.DriverEllipseTikz;
import net.sourceforge.plantuml.ugraphic.tikz.DriverLineTikz;
import net.sourceforge.plantuml.ugraphic.tikz.DriverNoneTikz;
import net.sourceforge.plantuml.ugraphic.tikz.DriverPolygonTikz;
import net.sourceforge.plantuml.ugraphic.tikz.DriverRectangleTikz;
import net.sourceforge.plantuml.ugraphic.tikz.DriverUPathTikz;
import net.sourceforge.plantuml.ugraphic.tikz.DriverUTextTikz;

public class UGraphicTikz
extends AbstractUGraphic<TikzGraphics>
implements ClipContainer,
UGraphic2 {
    private final StringBounder stringBounder;
    private final TikzFontDistortion tikzFontDistortion;

    private UGraphicTikz(ColorMapper colorMapper, TikzGraphics tikz, TikzFontDistortion tikzFontDistortion) {
        super(colorMapper, tikz);
        this.tikzFontDistortion = tikzFontDistortion;
        this.stringBounder = FileFormat.LATEX.getDefaultStringBounder(tikzFontDistortion);
        this.register();
    }

    public UGraphicTikz(ColorMapper colorMapper, double scale, boolean withPreamble, TikzFontDistortion tikzFontDistortion) {
        this(colorMapper, new TikzGraphics(scale, withPreamble), tikzFontDistortion);
    }

    @Override
    protected AbstractCommonUGraphic copyUGraphic() {
        return new UGraphicTikz(this);
    }

    private UGraphicTikz(UGraphicTikz other) {
        super(other);
        this.tikzFontDistortion = other.tikzFontDistortion;
        this.stringBounder = other.stringBounder;
        this.register();
    }

    private void register() {
        this.registerDriver(URectangle.class, new DriverRectangleTikz());
        this.registerDriver(UText.class, new DriverUTextTikz());
        this.registerDriver(AtomText.class, new DriverAtomTextTikz());
        this.registerDriver(ULine.class, new DriverLineTikz());
        this.registerDriver(UPolygon.class, new DriverPolygonTikz());
        this.registerDriver(UEllipse.class, new DriverEllipseTikz());
        this.registerDriver(UImage.class, new DriverNoneTikz());
        this.registerDriver(UImageSvg.class, new DriverNoneTikz());
        this.registerDriver(UPath.class, new DriverUPathTikz());
        this.registerDriver(DotPath.class, new DriverDotPathTikz());
        this.registerDriver(UCenteredCharacter.class, new DriverCenteredCharacterTikz2());
    }

    @Override
    public StringBounder getStringBounder() {
        return this.stringBounder;
    }

    @Override
    public void startUrl(Url url) {
        ((TikzGraphics)this.getGraphicObject()).openLink(url.getUrl(), url.getTooltip());
    }

    @Override
    public void closeAction() {
        ((TikzGraphics)this.getGraphicObject()).closeLink();
    }

    @Override
    public void writeImageTOBEMOVED(OutputStream os, String metadata, int dpi) throws IOException {
        this.createTikz(os);
    }

    public void createTikz(OutputStream os) throws IOException {
        ((TikzGraphics)this.getGraphicObject()).createData(os);
    }

    @Override
    public boolean matchesProperty(String propertyName) {
        return "SPECIALTXT".equalsIgnoreCase(propertyName);
    }
}

