/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.plantuml.project3;

import net.sourceforge.plantuml.command.Command;
import net.sourceforge.plantuml.command.CommandExecutionResult;
import net.sourceforge.plantuml.command.SingleLineCommand2;
import net.sourceforge.plantuml.command.regex.RegexConcat;
import net.sourceforge.plantuml.command.regex.RegexLeaf;
import net.sourceforge.plantuml.command.regex.RegexResult;
import net.sourceforge.plantuml.project3.Complement;
import net.sourceforge.plantuml.project3.ComplementPattern;
import net.sourceforge.plantuml.project3.Failable;
import net.sourceforge.plantuml.project3.GanttDiagram;
import net.sourceforge.plantuml.project3.Subject;
import net.sourceforge.plantuml.project3.SubjectPattern;
import net.sourceforge.plantuml.project3.Verb;
import net.sourceforge.plantuml.project3.VerbPattern;

public class NaturalCommandAnd
extends SingleLineCommand2<GanttDiagram> {
    private final SubjectPattern subjectPattern;
    private final VerbPattern verbPattern1;
    private final ComplementPattern complementPattern1;
    private final VerbPattern verbPattern2;
    private final ComplementPattern complementPattern2;

    private NaturalCommandAnd(RegexConcat pattern, SubjectPattern subject, VerbPattern verb1, ComplementPattern complement1, VerbPattern verb2, ComplementPattern complement2) {
        super(pattern);
        this.subjectPattern = subject;
        this.verbPattern1 = verb1;
        this.complementPattern1 = complement1;
        this.verbPattern2 = verb2;
        this.complementPattern2 = complement2;
    }

    public String toString() {
        return this.subjectPattern.toString() + " " + this.verbPattern1.toString() + " " + this.complementPattern1.toString() + " and " + this.verbPattern2.toString() + " " + this.complementPattern2.toString();
    }

    @Override
    protected CommandExecutionResult executeArg(GanttDiagram system, RegexResult arg) {
        Subject subject = this.subjectPattern.getSubject(system, arg);
        Verb verb1 = this.verbPattern1.getVerb(system, arg);
        Failable<Complement> complement1 = this.complementPattern1.getComplement(system, arg, "1");
        if (complement1.isFail()) {
            return CommandExecutionResult.error(complement1.getError());
        }
        CommandExecutionResult result1 = verb1.execute(subject, complement1.get());
        if (!result1.isOk()) {
            return result1;
        }
        Verb verb2 = this.verbPattern2.getVerb(system, arg);
        Failable<Complement> complement2 = this.complementPattern2.getComplement(system, arg, "2");
        if (complement2.isFail()) {
            return CommandExecutionResult.error(complement2.getError());
        }
        return verb2.execute(subject, complement2.get());
    }

    public static Command create(SubjectPattern subject, VerbPattern verb1, ComplementPattern complement1, VerbPattern verb2, ComplementPattern complement2) {
        RegexConcat pattern = new RegexConcat(new RegexLeaf("^"), subject.toRegex(), new RegexLeaf("[%s]+"), verb1.toRegex(), new RegexLeaf("[%s]+"), complement1.toRegex("1"), new RegexLeaf("[%s]+"), new RegexLeaf("and"), new RegexLeaf("[%s]+"), verb2.toRegex(), new RegexLeaf("[%s]+"), complement2.toRegex("2"), new RegexLeaf("$"));
        return new NaturalCommandAnd(pattern, subject, verb1, complement1, verb2, complement2);
    }
}

