/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.plantuml.project3;

import java.io.IOException;
import java.io.OutputStream;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import net.sourceforge.plantuml.AbstractPSystem;
import net.sourceforge.plantuml.FileFormatOption;
import net.sourceforge.plantuml.SpriteContainerEmpty;
import net.sourceforge.plantuml.core.DiagramDescription;
import net.sourceforge.plantuml.core.ImageData;
import net.sourceforge.plantuml.cucadiagram.Display;
import net.sourceforge.plantuml.graphic.FontConfiguration;
import net.sourceforge.plantuml.graphic.HorizontalAlignment;
import net.sourceforge.plantuml.graphic.HtmlColorSetSimple;
import net.sourceforge.plantuml.graphic.HtmlColorUtils;
import net.sourceforge.plantuml.graphic.IHtmlColorSet;
import net.sourceforge.plantuml.graphic.TextBlock;
import net.sourceforge.plantuml.graphic.UDrawable;
import net.sourceforge.plantuml.project3.DayAsDate;
import net.sourceforge.plantuml.project3.GCalendar;
import net.sourceforge.plantuml.project3.GCalendarSimple;
import net.sourceforge.plantuml.project3.GanttConstraint;
import net.sourceforge.plantuml.project3.Instant;
import net.sourceforge.plantuml.project3.InstantDay;
import net.sourceforge.plantuml.project3.Month;
import net.sourceforge.plantuml.project3.Subject;
import net.sourceforge.plantuml.project3.Task;
import net.sourceforge.plantuml.project3.TaskCode;
import net.sourceforge.plantuml.project3.TaskCodeSimpleOrder;
import net.sourceforge.plantuml.project3.TaskDraw;
import net.sourceforge.plantuml.project3.TaskImpl;
import net.sourceforge.plantuml.project3.TimeScale;
import net.sourceforge.plantuml.project3.TimeScaleBasic;
import net.sourceforge.plantuml.ugraphic.ColorMapperIdentity;
import net.sourceforge.plantuml.ugraphic.ImageBuilder;
import net.sourceforge.plantuml.ugraphic.UChangeColor;
import net.sourceforge.plantuml.ugraphic.UFont;
import net.sourceforge.plantuml.ugraphic.UGraphic;
import net.sourceforge.plantuml.ugraphic.ULine;
import net.sourceforge.plantuml.ugraphic.UTranslate;

public class GanttDiagram
extends AbstractPSystem
implements Subject {
    private final Map<TaskCode, Task> tasks = new LinkedHashMap<TaskCode, Task>();
    private final Map<String, Task> byShortName = new HashMap<String, Task>();
    private final List<GanttConstraint> constraints = new ArrayList<GanttConstraint>();
    private final IHtmlColorSet colorSet = new HtmlColorSetSimple();
    private GCalendar calendar;
    private Instant min;
    private Instant max;

    @Override
    public DiagramDescription getDescription() {
        return new DiagramDescription("(Project)");
    }

    @Override
    protected ImageData exportDiagramNow(OutputStream os, int index, FileFormatOption fileFormatOption, long seed) throws IOException {
        double dpiFactor = 1.0;
        double margin = 10.0;
        this.sortTasks();
        ImageBuilder imageBuilder = new ImageBuilder(new ColorMapperIdentity(), 1.0, null, "", "", 0.0, 0.0, null, false);
        imageBuilder.setUDrawable(this.getUDrawable());
        return imageBuilder.writeImageTOBEMOVED(fileFormatOption, seed, os);
    }

    private void sortTasks() {
        final TaskCodeSimpleOrder order = this.getCanonicalOrder(1);
        ArrayList<Task> list = new ArrayList<Task>(this.tasks.values());
        Collections.sort(list, new Comparator<Task>(){

            @Override
            public int compare(Task task1, Task task2) {
                return order.compare(task1.getCode(), task2.getCode());
            }
        });
        this.tasks.clear();
        for (Task task : list) {
            this.tasks.put(task.getCode(), task);
        }
    }

    private UDrawable getUDrawable() {
        return new UDrawable(){

            @Override
            public void drawU(UGraphic ug) {
                GanttDiagram.this.initMinMax();
                TimeScale timeScale = GanttDiagram.this.getTimeScale();
                GanttDiagram.this.drawTimeHeader(ug, timeScale);
                GanttDiagram.this.drawTasks(ug, timeScale);
                GanttDiagram.this.drawConstraints(ug, timeScale);
            }
        };
    }

    private TimeScale getTimeScale() {
        return new TimeScaleBasic();
    }

    private void drawConstraints(UGraphic ug, TimeScale timeScale) {
        for (GanttConstraint constraint : this.constraints) {
            constraint.getUDrawable(timeScale).drawU(ug);
        }
    }

    private void drawTimeHeader(UGraphic ug, TimeScale timeScale) {
        double yTotal = this.initTaskDraws(timeScale);
        double xmin = timeScale.getStartingPosition(this.min);
        double xmax = timeScale.getStartingPosition(this.max.increment());
        ug.apply(new UChangeColor(HtmlColorUtils.LIGHT_GRAY)).draw(new ULine(xmax - xmin, 0.0));
        ug.apply(new UChangeColor(HtmlColorUtils.LIGHT_GRAY)).apply(new UTranslate(0.0, this.getHeaderHeight() - 3.0)).draw(new ULine(xmax - xmin, 0.0));
        if (this.calendar == null) {
            this.drawSimpleDayCounter(ug, timeScale, yTotal);
        } else {
            this.drawCalendar(ug, timeScale, yTotal);
        }
    }

    private void drawCalendar(UGraphic ug, TimeScale timeScale, double yTotal) {
        int magic = 12;
        ULine vbar = new ULine(0.0, yTotal - 12.0);
        Month lastMonth = null;
        Instant i = this.min;
        while (i.compareTo(this.max.increment()) <= 0) {
            DayAsDate day = this.calendar.toDayAsDate((InstantDay)i);
            String d1 = "" + day.getDayOfMonth();
            TextBlock num = Display.getWithNewlines(d1).create(this.getFontConfiguration(), HorizontalAlignment.LEFT, new SpriteContainerEmpty());
            double x1 = timeScale.getStartingPosition(i);
            double x2 = timeScale.getStartingPosition(i.increment());
            if (i.compareTo(this.max.increment()) < 0) {
                TextBlock weekDay = Display.getWithNewlines(day.getDayOfWeek().shortName()).create(this.getFontConfiguration(), HorizontalAlignment.LEFT, new SpriteContainerEmpty());
                this.drawCenter(ug.apply(new UTranslate(0.0, 24.0)), num, x1, x2);
                this.drawCenter(ug.apply(new UTranslate(0.0, 12.0)), weekDay, x1, x2);
                if (lastMonth != day.getMonth()) {
                    TextBlock month = Display.getWithNewlines(day.getMonth().name()).create(this.getFontConfiguration(), HorizontalAlignment.LEFT, new SpriteContainerEmpty());
                    month.drawU(ug.apply(new UTranslate(x1, 0.0)));
                }
                lastMonth = day.getMonth();
            }
            ug.apply(new UChangeColor(HtmlColorUtils.LIGHT_GRAY)).apply(new UTranslate(x1, 12.0)).draw(vbar);
            i = i.increment();
        }
    }

    private double getHeaderHeight() {
        if (this.calendar != null) {
            return 40.0;
        }
        return 16.0;
    }

    private void drawCenter(UGraphic ug, TextBlock text, double x1, double x2) {
        double width = text.calculateDimension(ug.getStringBounder()).getWidth();
        double delta = x2 - x1 - width;
        if (delta < 0.0) {
            return;
        }
        text.drawU(ug.apply(new UTranslate(x1 + delta / 2.0, 0.0)));
    }

    private void drawSimpleDayCounter(UGraphic ug, TimeScale timeScale, double yTotal) {
        ULine vbar = new ULine(0.0, yTotal);
        Instant i = this.min;
        while (i.compareTo(this.max.increment()) <= 0) {
            TextBlock num = Display.getWithNewlines(i.toShortString()).create(this.getFontConfiguration(), HorizontalAlignment.LEFT, new SpriteContainerEmpty());
            double x1 = timeScale.getStartingPosition(i);
            double x2 = timeScale.getStartingPosition(i.increment());
            double width = num.calculateDimension(ug.getStringBounder()).getWidth();
            double delta = x2 - x1 - width;
            if (i.compareTo(this.max.increment()) < 0) {
                num.drawU(ug.apply(new UTranslate(x1 + delta / 2.0, 0.0)));
            }
            ug.apply(new UChangeColor(HtmlColorUtils.LIGHT_GRAY)).apply(new UTranslate(x1, 0.0)).draw(vbar);
            i = i.increment();
        }
    }

    private double initTaskDraws(TimeScale timeScale) {
        double y = this.getHeaderHeight();
        for (Task task : this.tasks.values()) {
            TaskDraw draw = new TaskDraw(task, timeScale, y);
            task.setTaskDraw(draw);
            y += draw.getHeight();
        }
        return y;
    }

    private void initMinMax() {
        this.min = this.tasks.values().iterator().next().getStart();
        this.max = this.tasks.values().iterator().next().getEnd();
        for (Task task : this.tasks.values()) {
            Instant start = task.getStart();
            Instant end = task.getEnd();
            if (this.min.compareTo(start) > 0) {
                this.min = start;
            }
            if (this.max.compareTo(end) >= 0) continue;
            this.max = end;
        }
    }

    private void drawTasks(UGraphic ug, TimeScale timeScale) {
        for (Task task : this.tasks.values()) {
            TaskDraw draw = task.getTaskDraw();
            draw.drawU(ug.apply(new UTranslate(0.0, draw.getY())));
            draw.getTitle().drawU(ug.apply(new UTranslate(timeScale.getStartingPosition(task.getStart().increment()), draw.getY())));
        }
    }

    private FontConfiguration getFontConfiguration() {
        UFont font = UFont.serif(10);
        return new FontConfiguration(font, HtmlColorUtils.LIGHT_GRAY, HtmlColorUtils.LIGHT_GRAY, false);
    }

    public Task getExistingTask(String id) {
        if (id == null) {
            throw new IllegalArgumentException();
        }
        Task result = this.byShortName.get(id);
        if (result != null) {
            return result;
        }
        TaskCode code = new TaskCode(id);
        return this.tasks.get(code);
    }

    public Task getOrCreateTask(String codeOrShortName, String shortName) {
        Task result;
        if (codeOrShortName == null) {
            throw new IllegalArgumentException();
        }
        Task task = result = shortName == null ? null : this.byShortName.get(shortName);
        if (result != null) {
            return result;
        }
        result = this.byShortName.get(codeOrShortName);
        if (result != null) {
            return result;
        }
        TaskCode code = new TaskCode(codeOrShortName);
        result = this.tasks.get(code);
        if (result == null) {
            result = new TaskImpl(code);
            this.tasks.put(code, result);
            if (this.byShortName != null) {
                this.byShortName.put(shortName, result);
            }
        }
        return result;
    }

    private TaskCodeSimpleOrder getCanonicalOrder(int hierarchyHeader) {
        ArrayList<TaskCode> codes = new ArrayList<TaskCode>();
        for (TaskCode code : this.tasks.keySet()) {
            if (code.getHierarchySize() < hierarchyHeader) continue;
            codes.add(code.truncateHierarchy(hierarchyHeader));
        }
        return new TaskCodeSimpleOrder(codes, hierarchyHeader);
    }

    private int getMaxHierarchySize() {
        int max = Integer.MIN_VALUE;
        for (TaskCode code : this.tasks.keySet()) {
            max = Math.max(max, code.getHierarchySize());
        }
        return max;
    }

    public void addContraint(GanttConstraint constraint) {
        this.constraints.add(constraint);
    }

    public IHtmlColorSet getIHtmlColorSet() {
        return this.colorSet;
    }

    public void setStartingDate(DayAsDate start) {
        this.calendar = new GCalendarSimple(start);
    }
}

