/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.plantuml.preproc;

import java.io.File;
import java.text.SimpleDateFormat;
import java.util.Arrays;
import java.util.Date;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import net.sourceforge.plantuml.Log;
import net.sourceforge.plantuml.preproc.Define;
import net.sourceforge.plantuml.preproc.EvalBoolean;
import net.sourceforge.plantuml.preproc.Truth;
import net.sourceforge.plantuml.version.Version;

public class Defines
implements Truth {
    private final Map<String, String> environment = new LinkedHashMap<String, String>();
    private final Map<String, Define> values = new LinkedHashMap<String, Define>();
    private final Map<String, Define> savedState = new LinkedHashMap<String, Define>();
    private static final String DATE = "(?i)%date(\\[(.+?)\\])?%";
    private static final Pattern datePattern = Pattern.compile("(?i)%date(\\[(.+?)\\])?%");

    @Deprecated
    public Defines() {
        this.environment.put("PLANTUML_VERSION", "" + Version.versionString());
    }

    public String toString() {
        return this.values.keySet().toString();
    }

    public static Defines createEmpty() {
        return new Defines();
    }

    public void importFrom(Defines other) {
        this.environment.putAll(other.environment);
        this.values.putAll(other.values);
    }

    public Defines cloneMe() {
        Defines result = new Defines();
        result.importFrom(this);
        return result;
    }

    public static Defines createWithFileName(File file) {
        if (file == null) {
            throw new IllegalArgumentException();
        }
        Defines result = Defines.createEmpty();
        result.environment.put("filedate", new Date(file.lastModified()).toString());
        result.environment.put("filename", file.getName());
        result.environment.put("filenameNoExtension", Defines.nameNoExtension(file));
        result.environment.put("dirpath", file.getAbsoluteFile().getParentFile().getAbsolutePath().replace('\\', '/'));
        return result;
    }

    private static String nameNoExtension(File file) {
        String name = file.getName();
        int x = name.lastIndexOf(46);
        if (x == -1) {
            return name;
        }
        return name.substring(0, x);
    }

    public void define(String name, List<String> value, boolean emptyParentheses) {
        this.values.put(name, new Define(name, value, emptyParentheses));
    }

    public boolean isDefine(String expression) {
        try {
            EvalBoolean eval = new EvalBoolean(expression, this);
            return eval.eval();
        }
        catch (IllegalArgumentException e) {
            Log.info("Error in " + expression);
            return false;
        }
    }

    @Override
    public boolean isTrue(String name) {
        for (String key : this.values.keySet()) {
            if (!key.equals(name) && !key.startsWith(name + "(")) continue;
            return true;
        }
        return false;
    }

    public void undefine(String name) {
        this.values.remove(name);
    }

    public List<String> applyDefines(String line) {
        line = this.manageDate(line);
        line = this.manageEnvironment(line);
        for (Map.Entry<String, Define> ent : this.values.entrySet()) {
            Define def = ent.getValue();
            line = def.apply(line);
        }
        return Arrays.asList(line.split("\n"));
    }

    private String manageEnvironment(String line) {
        for (Map.Entry<String, String> ent : this.environment.entrySet()) {
            String key = Pattern.quote("%" + ent.getKey() + "%");
            line = line.replaceAll(key, ent.getValue());
        }
        return line;
    }

    private String manageDate(String line) {
        Matcher m = datePattern.matcher(line);
        if (m.find()) {
            String replace;
            String format = m.group(2);
            if (format == null) {
                replace = new Date().toString();
            } else {
                try {
                    replace = new SimpleDateFormat(format).format(new Date());
                }
                catch (Exception e) {
                    replace = "(BAD DATE PATTERN:" + format + ")";
                }
            }
            line = line.replaceAll(DATE, replace);
        }
        return line;
    }

    public void saveState() {
        if (this.savedState.size() > 0) {
            throw new IllegalStateException();
        }
        this.savedState.putAll(this.values);
    }

    public void restoreState() {
        this.values.clear();
        this.values.putAll(this.savedState);
    }
}

