/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.plantuml.dedication;

import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.math.BigInteger;

public class QBlock {
    private final BigInteger big;

    public static QBlock read(InputStream source, int size) throws IOException {
        byte[] block2 = new byte[size + 1];
        for (int i = 0; i < size; ++i) {
            int read = source.read();
            if (read == -1) {
                if (i != 0) break;
                return null;
            }
            block2[i + 1] = (byte)read;
        }
        return new QBlock(new BigInteger(block2));
    }

    public QBlock(BigInteger number) {
        this.big = number;
    }

    public QBlock change(BigInteger E, BigInteger N) {
        BigInteger changed = this.big.modPow(E, N);
        return new QBlock(changed);
    }

    public byte[] getData() {
        return this.big.toByteArray();
    }

    public String toString() {
        return this.big.toByteArray().length + " " + this.big.toString();
    }

    public void write(OutputStream os, int size) throws IOException {
        int i;
        byte[] data = this.big.toByteArray();
        int start = data.length - size;
        if (start < 0) {
            for (i = 0; i < -start; ++i) {
                os.write(0);
            }
        }
        for (i = Math.max(start, 0); i < data.length; ++i) {
            byte b = data[i];
            os.write(b);
        }
    }
}

