/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.plantuml.dedication;

import java.io.IOException;
import java.io.InputStream;
import java.util.HashMap;
import java.util.Map;
import net.sourceforge.plantuml.SignatureUtils;
import net.sourceforge.plantuml.dedication.Dedication;

public class Dedications {
    private static final Map<String, Dedication> normal = new HashMap<String, Dedication>();
    private static final Map<String, Dedication> crypted = new HashMap<String, Dedication>();

    private static void addNormal(String sentence, String name) {
        normal.put(Dedications.keepLetter(sentence), new Dedication(name));
    }

    private static void addCrypted(String name, String contentKey) {
        crypted.put(contentKey, new Dedication(name));
    }

    private Dedications() {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static Dedication get(String line) {
        String keepLetter = Dedications.keepLetter(line);
        Dedication result = normal.get(keepLetter);
        if (result != null) {
            return result;
        }
        for (Map.Entry<String, Dedication> ent : crypted.entrySet()) {
            Dedication dedication = ent.getValue();
            InputStream is = null;
            try {
                is = dedication.getInputStream(keepLetter);
                String signature = SignatureUtils.getSignatureSha512(is);
                if (!signature.equals(ent.getKey())) continue;
                Dedication dedication2 = dedication;
                return dedication2;
            }
            catch (IOException e) {
                e.printStackTrace();
            }
            finally {
                try {
                    if (is == null) continue;
                    is.close();
                }
                catch (IOException e) {
                    e.printStackTrace();
                }
            }
        }
        return null;
    }

    public static String keepLetter(String s) {
        StringBuilder sb = new StringBuilder();
        for (int i = 0; i < s.length(); ++i) {
            char c = s.charAt(i);
            if (!Character.isLetterOrDigit(c)) continue;
            sb.append(c);
        }
        return sb.toString();
    }

    static {
        Dedications.addNormal("Write your own dedication!", "dedication");
        Dedications.addNormal("linux_china", "linux_china");
        Dedications.addCrypted("0", "pOhci6rKgPXw32AeYXhOpSY0suoauHq5VUSwFqHLHsLYgSO6WaJ7BW5vtHBAoU6ePbcW7d8Flx99MWjPSKQTDm00");
        Dedications.addCrypted("1", "LTxN3hdnhSJ515qcA7IQ841axt4GXfUd3n2wgNirYCdLnyX2360Gv1OEOnJ1-gwFzRW5B3HAqLBkR6Ge0WW_Z000");
    }
}

