/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.plantuml.code;

import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.util.zip.GZIPInputStream;
import java.util.zip.GZIPOutputStream;
import net.sourceforge.plantuml.code.Compression;

public class CompressionGZip
implements Compression {
    @Override
    public byte[] compress(byte[] in) {
        ByteArrayOutputStream baos = new ByteArrayOutputStream();
        try {
            MyGZIPOutputStream gz = new MyGZIPOutputStream(baos);
            gz.write(in);
            gz.close();
            baos.close();
            return baos.toByteArray();
        }
        catch (IOException e) {
            throw new IllegalStateException(e.toString());
        }
    }

    @Override
    public byte[] decompress(byte[] in) throws IOException {
        int read;
        ByteArrayOutputStream baos = new ByteArrayOutputStream();
        ByteArrayInputStream bais = new ByteArrayInputStream(in);
        GZIPInputStream gz = new GZIPInputStream(bais);
        while ((read = gz.read()) != -1) {
            baos.write(read);
        }
        gz.close();
        bais.close();
        baos.close();
        return baos.toByteArray();
    }

    class MyGZIPOutputStream
    extends GZIPOutputStream {
        public MyGZIPOutputStream(OutputStream baos) throws IOException {
            super(baos);
            this.def.setLevel(9);
        }
    }
}

