/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.plantuml.bpm;

import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import net.sourceforge.plantuml.ISkinParam;
import net.sourceforge.plantuml.bpm.BpmElement;
import net.sourceforge.plantuml.bpm.Cell;
import net.sourceforge.plantuml.bpm.Chain;
import net.sourceforge.plantuml.bpm.ChainImpl;
import net.sourceforge.plantuml.bpm.Col;
import net.sourceforge.plantuml.bpm.ConnectorPuzzle;
import net.sourceforge.plantuml.bpm.ConnectorPuzzleEmpty;
import net.sourceforge.plantuml.bpm.Coord;
import net.sourceforge.plantuml.bpm.GridArray;
import net.sourceforge.plantuml.bpm.Line;
import net.sourceforge.plantuml.bpm.Navigator;
import net.sourceforge.plantuml.bpm.Navigators;
import net.sourceforge.plantuml.bpm.Placeable;

public class Grid {
    private final Chain<Line> lines;
    private final Chain<Col> cols;
    private final Coord root;
    private final Map<Coord, Cell> cells = new HashMap<Coord, Cell>();

    public Grid() {
        this.root = new Coord(new Line(), new Col());
        this.lines = new ChainImpl<Line>(this.root.getLine());
        this.cols = new ChainImpl<Col>(this.root.getCol());
        this.cells.put(this.root, new Cell());
    }

    private Grid(Grid other) {
        this.lines = ((ChainImpl)other.lines).cloneMe();
        this.cols = ((ChainImpl)other.cols).cloneMe();
        this.root = other.root;
        this.cells.putAll(other.cells);
    }

    public Grid cloneMe() {
        return new Grid(this);
    }

    public Cell getCell(Coord coord) {
        return this.getCell(coord.getLine(), coord.getCol());
    }

    public Cell getCell(Line line, Col col) {
        if (!this.lines.contains(line)) {
            throw new IllegalArgumentException();
        }
        if (!this.cols.contains(col)) {
            throw new IllegalArgumentException();
        }
        Coord coord = new Coord(line, col);
        Cell result = this.cells.get(coord);
        if (result == null) {
            result = new Cell();
            this.cells.put(coord, result);
        }
        return result;
    }

    public Coord getById(String id) {
        for (Map.Entry<Coord, Cell> ent : this.cells.entrySet()) {
            Cell cell2 = ent.getValue();
            if (cell2 == null || cell2.getData() == null || !id.equals(cell2.getData().getId())) continue;
            return ent.getKey();
        }
        return null;
    }

    public final Coord getRoot() {
        return this.root;
    }

    public final Chain<Line> lines() {
        return this.lines;
    }

    public final Chain<Col> cols() {
        return this.cols;
    }

    public final Coord getCoord(Cell cell2) {
        for (Map.Entry<Coord, Cell> ent : this.cells.entrySet()) {
            if (ent.getValue() != cell2) continue;
            return ent.getKey();
        }
        throw new IllegalArgumentException();
    }

    private Coord getCoord(Placeable placeable) {
        for (Map.Entry<Coord, Cell> ent : this.cells.entrySet()) {
            if (ent.getValue().getData() != placeable) continue;
            return ent.getKey();
        }
        throw new IllegalArgumentException();
    }

    public final Navigator<Line> linesOf(Coord coord) {
        return this.lines.navigator(coord.getLine());
    }

    public final Navigator<Col> colsOf(Coord coord) {
        return this.cols.navigator(coord.getCol());
    }

    public final Navigator<Line> linesOf(Cell cell2) {
        return this.linesOf(this.getCoord(cell2));
    }

    public final Navigator<Col> colsOf(Cell cell2) {
        return this.colsOf(this.getCoord(cell2));
    }

    public final GridArray toArray(ISkinParam skinParam) {
        List<Line> lines = this.lines.toList();
        List<Col> cols = this.cols.toList();
        GridArray result = new GridArray(skinParam, lines.size(), cols.size());
        for (Map.Entry<Coord, Cell> ent : this.cells.entrySet()) {
            int l = lines.indexOf(ent.getKey().getLine());
            int c = cols.indexOf(ent.getKey().getCol());
            if (c == -1) {
                throw new IllegalStateException("col=" + ent.getKey().getCol());
            }
            if (l == -1) {
                throw new IllegalStateException("line=" + ent.getKey().getLine());
            }
            result.setData(l, c, ent.getValue().getData());
        }
        return result;
    }

    public Set<Col> usedColsOf(Line line) {
        HashSet<Col> result = new HashSet<Col>();
        for (Map.Entry<Coord, Cell> ent : this.cells.entrySet()) {
            Cell cell2 = ent.getValue();
            if (cell2 == null || cell2.getData() == null || ent.getKey().getLine() != line) continue;
            result.add(ent.getKey().getCol());
        }
        return Collections.unmodifiableSet(result);
    }

    public void removeLine(Line line) {
        assert (this.usedColsOf(line).isEmpty());
        Iterator<Map.Entry<Coord, Cell>> it = this.cells.entrySet().iterator();
        while (it.hasNext()) {
            Map.Entry<Coord, Cell> ent = it.next();
            if (ent.getKey().getLine() != line) continue;
            Cell cell2 = ent.getValue();
            if (cell2 == null || cell2.getData() == null) {
                it.remove();
                continue;
            }
            throw new IllegalStateException();
        }
        boolean done = this.lines.remove(line);
        if (!done) {
            throw new IllegalArgumentException();
        }
    }

    public void addConnections() {
        for (Map.Entry<Coord, Cell> ent : new HashMap<Coord, Cell>(this.cells).entrySet()) {
            List<Placeable> dests2 = ent.getValue().getDestinations2();
            Coord src = ent.getKey();
            for (int i = 0; i < dests2.size(); ++i) {
                boolean startHorizontal;
                Coord dest = this.getCoord(dests2.get(i));
                boolean bl = startHorizontal = i == 0;
                if (startHorizontal) {
                    this.drawStartHorizontal(src, dest);
                    continue;
                }
                this.drawStartVertical(src, dest);
            }
        }
    }

    private void drawStartVertical(Coord src, Coord dest) {
        Object cur;
        if (src.getLine() == dest.getLine() && src.getCol() == dest.getCol()) {
            throw new IllegalStateException();
        }
        BpmElement start = (BpmElement)this.getCell(src).getData();
        int compare = this.lines.compare(src.getLine(), dest.getLine());
        if (compare == 0) {
            throw new IllegalStateException();
        }
        start.append(compare < 0 ? ConnectorPuzzle.Where.SOUTH : ConnectorPuzzle.Where.NORTH);
        Navigator<Line> itLine = Navigators.iterate(this.lines, src.getLine(), dest.getLine());
        while (itLine.get() != dest.getLine()) {
            cur = itLine.next();
            if (cur == dest.getLine()) continue;
            this.addPuzzle((Line)cur, src.getCol(), "NS");
        }
        Navigator<Col> itCol = Navigators.iterate(this.cols, src.getCol(), dest.getCol());
        while (itCol.get() != dest.getCol()) {
            cur = itCol.next();
            if (cur == dest.getCol()) continue;
            this.addPuzzle(dest.getLine(), (Col)cur, "EW");
        }
        BpmElement end = (BpmElement)this.getCell(dest).getData();
        if (src.getLine() == dest.getLine()) {
            end.append(compare < 0 ? ConnectorPuzzle.Where.NORTH : ConnectorPuzzle.Where.SOUTH);
        }
        if (src.getLine() != dest.getLine() && src.getCol() != dest.getCol()) {
            if (this.lines.compare(dest.getLine(), src.getLine()) > 0) {
                this.addPuzzle(dest.getLine(), src.getCol(), "N");
            } else {
                this.addPuzzle(dest.getLine(), src.getCol(), "S");
            }
            if (this.cols.compare(dest.getCol(), src.getCol()) > 0) {
                this.addPuzzle(dest.getLine(), src.getCol(), "E");
            } else {
                this.addPuzzle(dest.getLine(), src.getCol(), "W");
            }
            end.append(this.cols.compare(src.getCol(), dest.getCol()) > 0 ? ConnectorPuzzle.Where.EAST : ConnectorPuzzle.Where.WEST);
        }
    }

    private void drawStartHorizontal(Coord src, Coord dest) {
        Object cur;
        if (src.getLine() == dest.getLine() && src.getCol() == dest.getCol()) {
            throw new IllegalStateException();
        }
        BpmElement start = (BpmElement)this.getCell(src).getData();
        int compare = this.cols.compare(src.getCol(), dest.getCol());
        if (compare == 0) {
            throw new IllegalStateException();
        }
        start.append(compare < 0 ? ConnectorPuzzle.Where.EAST : ConnectorPuzzle.Where.WEST);
        Navigator<Col> itCol = Navigators.iterate(this.cols, src.getCol(), dest.getCol());
        while (itCol.get() != dest.getCol()) {
            cur = itCol.next();
            if (cur == dest.getCol()) continue;
            this.addPuzzle(src.getLine(), (Col)cur, "EW");
        }
        Navigator<Line> itLine = Navigators.iterate(this.lines, src.getLine(), dest.getLine());
        while (itLine.get() != dest.getLine()) {
            cur = itLine.next();
            if (cur == dest.getLine()) continue;
            this.addPuzzle((Line)cur, dest.getCol(), "NS");
        }
        BpmElement end = (BpmElement)this.getCell(dest).getData();
        if (src.getLine() == dest.getLine()) {
            end.append(compare < 0 ? ConnectorPuzzle.Where.WEST : ConnectorPuzzle.Where.EAST);
        }
        if (src.getLine() != dest.getLine() && src.getCol() != dest.getCol()) {
            if (this.cols.compare(dest.getCol(), src.getCol()) > 0) {
                this.addPuzzle(src.getLine(), dest.getCol(), "W");
            } else {
                this.addPuzzle(src.getLine(), dest.getCol(), "E");
            }
            if (this.lines.compare(dest.getLine(), src.getLine()) > 0) {
                this.addPuzzle(src.getLine(), dest.getCol(), "S");
            } else {
                this.addPuzzle(src.getLine(), dest.getCol(), "N");
            }
            end.append(this.lines.compare(src.getLine(), dest.getLine()) > 0 ? ConnectorPuzzle.Where.SOUTH : ConnectorPuzzle.Where.NORTH);
        }
    }

    private void addPuzzle(Line line, Col col, String direction) {
        Cell cell2 = this.getCell(line, col);
        ConnectorPuzzleEmpty connector = (ConnectorPuzzleEmpty)cell2.getData();
        if (connector == null) {
            connector = new ConnectorPuzzleEmpty();
            cell2.setData(connector);
        }
        connector.append(ConnectorPuzzleEmpty.get(direction));
    }
}

