/*
 * Decompiled with CFR 0.152.
 */
package gnu.classpath.tools.gjdoc;

import java.io.FileWriter;
import java.io.IOException;
import java.io.PrintWriter;

public class Timer {
    private static long startTime;
    private static long beforeDocletTime;
    private static long stopTime;
    private static long memoryUsed;
    private static long maxDriverHeap;
    private static long maxDocletHeap;

    static {
        maxDriverHeap = -1L;
        maxDocletHeap = -1L;
    }

    static void shutdown() {
        try {
            if (stopTime == 0L) {
                return;
            }
            PrintWriter pw = new PrintWriter(new FileWriter("timer.out"));
            pw.println("Preparation (driver) took " + (double)(beforeDocletTime - startTime) / 1000.0 + " s");
            pw.println("Generation (doclet) took " + (double)(stopTime - beforeDocletTime) / 1000.0 + " s");
            pw.println("");
            pw.println("Memory used for documentation tree: " + memoryUsed / 0x100000L + " MB");
            pw.println("Max. heap used for driver: " + (maxDriverHeap < 0L ? "N/A" : String.valueOf(maxDriverHeap / 0x100000L) + " MB"));
            pw.println("Max. heap used for doclet: " + (maxDocletHeap < 0L ? "N/A" : String.valueOf(maxDocletHeap / 0x100000L) + " MB"));
            pw.println("");
            pw.println("TOTAL TIME: " + (double)(stopTime - startTime) / 1000.0 + " s");
            pw.println("TOTAL HEAP: " + (maxDocletHeap < 0L ? "N/A" : String.valueOf(Math.max(maxDocletHeap, maxDriverHeap) / 0x100000L) + " MB"));
            pw.close();
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }

    public static void setStartTime() {
        startTime = System.currentTimeMillis();
    }

    public static void setStopTime() {
        stopTime = System.currentTimeMillis();
    }

    public static void setBeforeDocletTime() {
        beforeDocletTime = System.currentTimeMillis();
        memoryUsed = Runtime.getRuntime().totalMemory() - Runtime.getRuntime().freeMemory();
    }

    public static void setMaxDocletHeap(long maximumHeap) {
        maxDocletHeap = maximumHeap;
    }

    public static void setMaxDriverHeap(long maximumHeap) {
        maxDriverHeap = maximumHeap;
    }
}

