/*
 * Decompiled with CFR 0.152.
 */
package java.lang;

import gnu.classpath.Configuration;
import java.util.Random;

public strictfp final class StrictMath {
    private static Random rand;
    public static final double E = Math.E;
    public static final double PI = Math.PI;
    private static final double TWO_16 = 65536.0;
    private static final double TWO_20 = 1048576.0;
    private static final double TWO_24 = 1.6777216E7;
    private static final double TWO_27 = 1.34217728E8;
    private static final double TWO_28 = 2.68435456E8;
    private static final double TWO_29 = 5.36870912E8;
    private static final double TWO_31 = 2.147483648E9;
    private static final double TWO_49 = 5.62949953421312E14;
    private static final double TWO_52 = 4.503599627370496E15;
    private static final double TWO_54 = 1.8014398509481984E16;
    private static final double TWO_57 = 1.4411518807585587E17;
    private static final double TWO_60 = 1.152921504606847E18;
    private static final double TWO_64 = 1.8446744073709552E19;
    private static final double TWO_66 = 7.378697629483821E19;
    private static final double TWO_1023 = 8.98846567431158E307;
    private static final int[] TWO_OVER_PI;
    private static final double[] PI_OVER_TWO;
    private static final double PI_L = 1.2246467991473532E-16;
    private static final double PIO2_1 = 1.5707963267341256;
    private static final double PIO2_1L = 6.077100506506192E-11;
    private static final double PIO2_2 = 6.077100506303966E-11;
    private static final double PIO2_2L = 2.0222662487959506E-21;
    private static final double PIO2_3 = 2.0222662487111665E-21;
    private static final double PIO2_3L = 8.4784276603689E-32;
    private static final double SQRT_1_5 = 1.224744871391589;
    private static final double SQRT_2 = 1.4142135623730951;
    private static final double SQRT_3 = 1.7320508075688772;
    private static final double EXP_LIMIT_H = 709.782712893384;
    private static final double EXP_LIMIT_L = -745.1332191019411;
    private static final double CP = 0.9617966939259756;
    private static final double CP_H = 0.9617967009544373;
    private static final double CP_L = -7.028461650952758E-9;
    private static final double LN2 = 0.6931471805599453;
    private static final double LN2_H = 0.6931471803691238;
    private static final double LN2_L = 1.9082149292705877E-10;
    private static final double INV_LN2 = 1.4426950408889634;
    private static final double INV_LN2_H = (double)1.442695f;
    private static final double INV_LN2_L = 1.9259629911266175E-8;
    private static final double LG1 = 0.6666666666666735;
    private static final double LG2 = 0.3999999999940942;
    private static final double LG3 = 0.2857142874366239;
    private static final double LG4 = 0.22222198432149784;
    private static final double LG5 = 0.1818357216161805;
    private static final double LG6 = 0.15313837699209373;
    private static final double LG7 = 0.14798198605116586;
    private static final double L1 = 0.5999999999999946;
    private static final double L2 = 0.4285714285785502;
    private static final double L3 = 0.33333332981837743;
    private static final double L4 = 0.272728123808534;
    private static final double L5 = 0.23066074577556175;
    private static final double L6 = 0.20697501780033842;
    private static final double P1 = 0.16666666666666602;
    private static final double P2 = -0.0027777777777015593;
    private static final double P3 = 6.613756321437934E-5;
    private static final double P4 = -1.6533902205465252E-6;
    private static final double P5 = 4.1381367970572385E-8;
    private static final double DP_H = 0.5849624872207642;
    private static final double DP_L = 1.350039202129749E-8;
    private static final double OVT = 8.008566259537294E-17;
    private static final double S1 = -0.16666666666666632;
    private static final double S2 = 0.00833333333332249;
    private static final double S3 = -1.984126982985795E-4;
    private static final double S4 = 2.7557313707070068E-6;
    private static final double S5 = -2.5050760253406863E-8;
    private static final double S6 = 1.58969099521155E-10;
    private static final double C1 = 0.0416666666666666;
    private static final double C2 = -0.001388888888887411;
    private static final double C3 = 2.480158728947673E-5;
    private static final double C4 = -2.7557314351390663E-7;
    private static final double C5 = 2.087572321298175E-9;
    private static final double C6 = -1.1359647557788195E-11;
    private static final double T0 = 0.3333333333333341;
    private static final double T1 = 0.13333333333320124;
    private static final double T2 = 0.05396825397622605;
    private static final double T3 = 0.021869488294859542;
    private static final double T4 = 0.0088632398235993;
    private static final double T5 = 0.0035920791075913124;
    private static final double T6 = 0.0014562094543252903;
    private static final double T7 = 5.880412408202641E-4;
    private static final double T8 = 2.464631348184699E-4;
    private static final double T9 = 7.817944429395571E-5;
    private static final double T10 = 7.140724913826082E-5;
    private static final double T11 = -1.8558637485527546E-5;
    private static final double T12 = 2.590730518636337E-5;
    private static final double PS0 = 0.16666666666666666;
    private static final double PS1 = -0.3255658186224009;
    private static final double PS2 = 0.20121253213486293;
    private static final double PS3 = -0.04005553450067941;
    private static final double PS4 = 7.915349942898145E-4;
    private static final double PS5 = 3.479331075960212E-5;
    private static final double QS1 = -2.403394911734414;
    private static final double QS2 = 2.0209457602335057;
    private static final double QS3 = -0.6882839716054533;
    private static final double QS4 = 0.07703815055590194;
    private static final double ATAN_0_5H = 0.4636476090008061;
    private static final double ATAN_0_5L = 2.2698777452961687E-17;
    private static final double ATAN_1_5H = 0.982793723247329;
    private static final double ATAN_1_5L = 1.3903311031230998E-17;
    private static final double AT0 = 0.3333333333333293;
    private static final double AT1 = -0.19999999999876483;
    private static final double AT2 = 0.14285714272503466;
    private static final double AT3 = -0.11111110405462356;
    private static final double AT4 = 0.09090887133436507;
    private static final double AT5 = -0.0769187620504483;
    private static final double AT6 = 0.06661073137387531;
    private static final double AT7 = -0.058335701337905735;
    private static final double AT8 = 0.049768779946159324;
    private static final double AT9 = -0.036531572744216916;
    private static final double AT10 = 0.016285820115365782;
    private static final int CBRT_B1 = 715094163;
    private static final int CBRT_B2 = 696219795;
    private static final double CBRT_C = 0.5428571428571428;
    private static final double CBRT_D = -0.7053061224489796;
    private static final double CBRT_E = 1.4142857142857144;
    private static final double CBRT_F = 1.6071428571428572;
    private static final double CBRT_G = 0.35714285714285715;
    private static final double EXPM1_Q1 = -0.03333333333333313;
    private static final double EXPM1_Q2 = 0.0015873015872548146;
    private static final double EXPM1_Q3 = -7.93650757867488E-5;
    private static final double EXPM1_Q4 = 4.008217827329362E-6;
    private static final double EXPM1_Q5 = -2.0109921818362437E-7;

    static {
        TWO_OVER_PI = new int[]{10680707, 0x6E4E44, 1387004, 2578385, 16069853, 12639074, 9804092, 4427841, 16666979, 11263675, 12935607, 2387514, 0x424DD2, 14681673, 3074569, 13734428, 16653803, 1880361, 10960616, 8533493, 3062596, 8710556, 7349940, 6258241, 3772886, 3769171, 3798172, 8675211, 12450088, 3874808, 9961438, 366607, 15675153, 9132554, 7151469, 3571407, 2607881, 12013382, 4155038, 6285869, 7677882, 13102053, 15825725, 473591, 9065106, 15363067, 6271263, 9264392, 5636912, 4652155, 7056368, 13614112, 10155062, 1944035, 9527646, 15080200, 6658437, 6231200, 6832269, 16767104, 5075751, 3212806, 1398474, 7579849, 6349435, 12618859};
        PI_OVER_TWO = new double[]{1.570796251296997, 7.549789415861596E-8, 5.390302529957765E-15, 3.282003415807913E-22, 1.270655753080676E-29, 1.2293330898111133E-36, 2.7337005381646456E-44, 2.1674168387780482E-51};
    }

    private StrictMath() {
    }

    public static int abs(int i) {
        return i < 0 ? -i : i;
    }

    public static long abs(long l) {
        return l < 0L ? -l : l;
    }

    public static float abs(float f) {
        return f <= 0.0f ? 0.0f - f : f;
    }

    public static double abs(double d) {
        return d <= 0.0 ? 0.0 - d : d;
    }

    public static int min(int a, int b) {
        return a < b ? a : b;
    }

    public static long min(long a, long b) {
        return a < b ? a : b;
    }

    public static float min(float a, float b) {
        if (a != a) {
            return a;
        }
        if (a == 0.0f && b == 0.0f) {
            return -(-a - b);
        }
        return a < b ? a : b;
    }

    public static double min(double a, double b) {
        if (a != a) {
            return a;
        }
        if (a == 0.0 && b == 0.0) {
            return -(-a - b);
        }
        return a < b ? a : b;
    }

    public static int max(int a, int b) {
        return a > b ? a : b;
    }

    public static long max(long a, long b) {
        return a > b ? a : b;
    }

    public static float max(float a, float b) {
        if (a != a) {
            return a;
        }
        if (a == 0.0f && b == 0.0f) {
            return a - -b;
        }
        return a > b ? a : b;
    }

    public static double max(double a, double b) {
        if (a != a) {
            return a;
        }
        if (a == 0.0 && b == 0.0) {
            return a - -b;
        }
        return a > b ? a : b;
    }

    public static double sin(double a) {
        if (a == Double.NEGATIVE_INFINITY || !(a < Double.POSITIVE_INFINITY)) {
            return Double.NaN;
        }
        if (StrictMath.abs(a) <= 0.7853981633974483) {
            return StrictMath.sin(a, 0.0);
        }
        double[] y = new double[2];
        int n = StrictMath.remPiOver2(a, y);
        switch (n & 3) {
            case 0: {
                return StrictMath.sin(y[0], y[1]);
            }
            case 1: {
                return StrictMath.cos(y[0], y[1]);
            }
            case 2: {
                return -StrictMath.sin(y[0], y[1]);
            }
        }
        return -StrictMath.cos(y[0], y[1]);
    }

    public static double cos(double a) {
        if (a == Double.NEGATIVE_INFINITY || !(a < Double.POSITIVE_INFINITY)) {
            return Double.NaN;
        }
        if (StrictMath.abs(a) <= 0.7853981633974483) {
            return StrictMath.cos(a, 0.0);
        }
        double[] y = new double[2];
        int n = StrictMath.remPiOver2(a, y);
        switch (n & 3) {
            case 0: {
                return StrictMath.cos(y[0], y[1]);
            }
            case 1: {
                return -StrictMath.sin(y[0], y[1]);
            }
            case 2: {
                return -StrictMath.cos(y[0], y[1]);
            }
        }
        return StrictMath.sin(y[0], y[1]);
    }

    public static double tan(double a) {
        if (a == Double.NEGATIVE_INFINITY || !(a < Double.POSITIVE_INFINITY)) {
            return Double.NaN;
        }
        if (StrictMath.abs(a) <= 0.7853981633974483) {
            return StrictMath.tan(a, 0.0, false);
        }
        double[] y = new double[2];
        int n = StrictMath.remPiOver2(a, y);
        return StrictMath.tan(y[0], y[1], (n & 1) == 1);
    }

    public static double asin(double x) {
        boolean negative;
        boolean bl = negative = x < 0.0;
        if (negative) {
            x = -x;
        }
        if (!(x <= 1.0)) {
            return Double.NaN;
        }
        if (x == 1.0) {
            return negative ? -1.5707963267948966 : 1.5707963267948966;
        }
        if (x < 0.5) {
            if (x < 7.450580596923828E-9) {
                return negative ? -x : x;
            }
            double t = x * x;
            double p = t * (0.16666666666666666 + t * (-0.3255658186224009 + t * (0.20121253213486293 + t * (-0.04005553450067941 + t * (7.915349942898145E-4 + t * 3.479331075960212E-5)))));
            double q = 1.0 + t * (-2.403394911734414 + t * (2.0209457602335057 + t * (-0.6882839716054533 + t * 0.07703815055590194)));
            return negative ? -x - x * (p / q) : x + x * (p / q);
        }
        double w = 1.0 - x;
        double t = w * 0.5;
        double p = t * (0.16666666666666666 + t * (-0.3255658186224009 + t * (0.20121253213486293 + t * (-0.04005553450067941 + t * (7.915349942898145E-4 + t * 3.479331075960212E-5)))));
        double q = 1.0 + t * (-2.403394911734414 + t * (2.0209457602335057 + t * (-0.6882839716054533 + t * 0.07703815055590194)));
        double s = StrictMath.sqrt(t);
        if (x >= 0.975) {
            w = p / q;
            t = 1.5707963267948966 - (2.0 * (s + s * w) - 6.123233995736766E-17);
        } else {
            w = (float)s;
            double c = (t - w * w) / (s + w);
            p = 2.0 * s * (p / q) - (6.123233995736766E-17 - 2.0 * c);
            q = 0.7853981633974483 - 2.0 * w;
            t = 0.7853981633974483 - (p - q);
        }
        return negative ? -t : t;
    }

    public static double acos(double x) {
        boolean negative;
        boolean bl = negative = x < 0.0;
        if (negative) {
            x = -x;
        }
        if (!(x <= 1.0)) {
            return Double.NaN;
        }
        if (x == 1.0) {
            return negative ? Math.PI : 0.0;
        }
        if (x < 0.5) {
            if (x < 6.938893903907228E-18) {
                return 1.5707963267948966;
            }
            double z = x * x;
            double p = z * (0.16666666666666666 + z * (-0.3255658186224009 + z * (0.20121253213486293 + z * (-0.04005553450067941 + z * (7.915349942898145E-4 + z * 3.479331075960212E-5)))));
            double q = 1.0 + z * (-2.403394911734414 + z * (2.0209457602335057 + z * (-0.6882839716054533 + z * 0.07703815055590194)));
            double r = x - (6.123233995736766E-17 - x * (p / q));
            return negative ? 1.5707963267948966 + r : 1.5707963267948966 - r;
        }
        if (negative) {
            double z = (1.0 + x) * 0.5;
            double p = z * (0.16666666666666666 + z * (-0.3255658186224009 + z * (0.20121253213486293 + z * (-0.04005553450067941 + z * (7.915349942898145E-4 + z * 3.479331075960212E-5)))));
            double q = 1.0 + z * (-2.403394911734414 + z * (2.0209457602335057 + z * (-0.6882839716054533 + z * 0.07703815055590194)));
            double s = StrictMath.sqrt(z);
            double w = p / q * s - 6.123233995736766E-17;
            return Math.PI - 2.0 * (s + w);
        }
        double z = (1.0 - x) * 0.5;
        double s = StrictMath.sqrt(z);
        double df = (float)s;
        double c = (z - df * df) / (s + df);
        double p = z * (0.16666666666666666 + z * (-0.3255658186224009 + z * (0.20121253213486293 + z * (-0.04005553450067941 + z * (7.915349942898145E-4 + z * 3.479331075960212E-5)))));
        double q = 1.0 + z * (-2.403394911734414 + z * (2.0209457602335057 + z * (-0.6882839716054533 + z * 0.07703815055590194)));
        double w = p / q * s + c;
        return 2.0 * (df + w);
    }

    public static double atan(double x) {
        double lo;
        double hi;
        boolean negative;
        boolean bl = negative = x < 0.0;
        if (negative) {
            x = -x;
        }
        if (x >= 7.378697629483821E19) {
            return negative ? -1.5707963267948966 : 1.5707963267948966;
        }
        if (!(x >= 0.4375)) {
            if (!(x >= 1.862645149230957E-9)) {
                return negative ? -x : x;
            }
            hi = 0.0;
            lo = 0.0;
        } else if (x < 1.1875) {
            if (x < 0.6875) {
                x = (2.0 * x - 1.0) / (2.0 + x);
                hi = 0.4636476090008061;
                lo = 2.2698777452961687E-17;
            } else {
                x = (x - 1.0) / (x + 1.0);
                hi = 0.7853981633974483;
                lo = 3.061616997868383E-17;
            }
        } else if (x < 2.4375) {
            x = (x - 1.5) / (1.0 + 1.5 * x);
            hi = 0.982793723247329;
            lo = 1.3903311031230998E-17;
        } else {
            x = -1.0 / x;
            hi = 1.5707963267948966;
            lo = 6.123233995736766E-17;
        }
        double z = x * x;
        double w = z * z;
        double s1 = z * (0.3333333333333293 + w * (0.14285714272503466 + w * (0.09090887133436507 + w * (0.06661073137387531 + w * (0.049768779946159324 + w * 0.016285820115365782)))));
        double s2 = w * (-0.19999999999876483 + w * (-0.11111110405462356 + w * (-0.0769187620504483 + w * (-0.058335701337905735 + w * -0.036531572744216916))));
        if (hi == 0.0) {
            return negative ? x * (s1 + s2) - x : x - x * (s1 + s2);
        }
        z = hi - (x * (s1 + s2) - lo - x);
        return negative ? -z : z;
    }

    public static double atan2(double y, double x) {
        if (x != x || y != y) {
            return Double.NaN;
        }
        if (x == 1.0) {
            return StrictMath.atan(y);
        }
        if (x == Double.POSITIVE_INFINITY) {
            if (y == Double.POSITIVE_INFINITY) {
                return 0.7853981633974483;
            }
            if (y == Double.NEGATIVE_INFINITY) {
                return -0.7853981633974483;
            }
            return 0.0 * y;
        }
        if (x == Double.NEGATIVE_INFINITY) {
            if (y == Double.POSITIVE_INFINITY) {
                return 2.356194490192345;
            }
            if (y == Double.NEGATIVE_INFINITY) {
                return -2.356194490192345;
            }
            return 1.0 / (0.0 * y) == Double.POSITIVE_INFINITY ? Math.PI : -Math.PI;
        }
        if (y == 0.0) {
            if (1.0 / (0.0 * x) == Double.POSITIVE_INFINITY) {
                return y;
            }
            return 1.0 / y == Double.POSITIVE_INFINITY ? Math.PI : -Math.PI;
        }
        if (y == Double.POSITIVE_INFINITY || y == Double.NEGATIVE_INFINITY || x == 0.0) {
            return y < 0.0 ? -1.5707963267948966 : 1.5707963267948966;
        }
        double z = StrictMath.abs(y / x);
        z = z > 1.152921504606847E18 ? 1.5707963267948966 : (x < 0.0 && z < 8.673617379884035E-19 ? 0.0 : StrictMath.atan(z));
        if (x > 0.0) {
            return y > 0.0 ? z : -z;
        }
        return y > 0.0 ? Math.PI - (z - 1.2246467991473532E-16) : z - 1.2246467991473532E-16 - Math.PI;
    }

    public static double sinh(double x) {
        if (x != x) {
            return x;
        }
        if (x == Double.POSITIVE_INFINITY) {
            return Double.POSITIVE_INFINITY;
        }
        if (x == Double.NEGATIVE_INFINITY) {
            return Double.NEGATIVE_INFINITY;
        }
        double h = x < 0.0 ? -0.5 : 0.5;
        long bits = Double.doubleToLongBits(x);
        long h_bits = StrictMath.getHighDWord(bits) & Integer.MAX_VALUE;
        long l_bits = StrictMath.getLowDWord(bits);
        if (h_bits < 1077280768L) {
            if (h_bits < 0x3E300000L) {
                return x;
            }
            double t = StrictMath.expm1(StrictMath.abs(x));
            if (h_bits < 0x3FF00000L) {
                return h * (2.0 * t - t * t / (t + 1.0));
            }
            return h * (t + t / (t + 1.0));
        }
        if (h_bits < 1082535490L) {
            return h * StrictMath.exp(StrictMath.abs(x));
        }
        if (h_bits < 1082536910L || h_bits == 1082536910L && l_bits <= 2411329661L) {
            double w = StrictMath.exp(0.5 * StrictMath.abs(x));
            double t = h * w;
            return t * w;
        }
        return h * Double.POSITIVE_INFINITY;
    }

    public static double cosh(double x) {
        if (x != x) {
            return x;
        }
        if (x == Double.POSITIVE_INFINITY) {
            return Double.POSITIVE_INFINITY;
        }
        if (x == Double.NEGATIVE_INFINITY) {
            return Double.POSITIVE_INFINITY;
        }
        long bits = Double.doubleToLongBits(x);
        long hx = StrictMath.getHighDWord(bits) & Integer.MAX_VALUE;
        long lx = StrictMath.getLowDWord(bits);
        if (hx < 1071001155L) {
            double t = StrictMath.expm1(StrictMath.abs(x));
            double w = 1.0 + t;
            if (hx < 1015021568L) {
                return w;
            }
            return 1.0 + t * t / (w + w);
        }
        if (hx < 1077280768L) {
            double t = StrictMath.exp(StrictMath.abs(x));
            return 0.5 * t + 0.5 / t;
        }
        if (hx < 1082535490L) {
            return 0.5 * StrictMath.exp(StrictMath.abs(x));
        }
        if (hx < 1082536910L || hx == 1082536910L && lx <= 2411329661L) {
            double w = StrictMath.exp(0.5 * StrictMath.abs(x));
            double t = 0.5 * w;
            return t * w;
        }
        return Double.POSITIVE_INFINITY;
    }

    public static double tanh(double x) {
        double z;
        if (x != x) {
            return x;
        }
        if (x == Double.POSITIVE_INFINITY) {
            return 1.0;
        }
        if (x == Double.NEGATIVE_INFINITY) {
            return -1.0;
        }
        long bits = Double.doubleToLongBits(x);
        long h_bits = StrictMath.getHighDWord(bits) & Integer.MAX_VALUE;
        if (h_bits < 1077280768L) {
            if (h_bits < 1015021568L) {
                return x * (1.0 + x);
            }
            if (h_bits >= 0x3FF00000L) {
                double t = StrictMath.expm1(2.0 * StrictMath.abs(x));
                z = 1.0 - 2.0 / (t + 2.0);
            } else {
                double t = StrictMath.expm1(-2.0 * StrictMath.abs(x));
                z = -t / (t + 2.0);
            }
        } else {
            z = 1.0;
        }
        return x >= 0.0 ? z : -z;
    }

    private static long getLowDWord(long x) {
        return x & 0xFFFFFFFFL;
    }

    private static long getHighDWord(long x) {
        return (x & 0xFFFFFFFF00000000L) >> 32;
    }

    private static double buildDouble(long lowDWord, long highDWord) {
        return Double.longBitsToDouble((highDWord & 0xFFFFFFFFL) << 32 | lowDWord & 0xFFFFFFFFL);
    }

    public static double cbrt(double x) {
        long l;
        long h;
        double t;
        boolean negative;
        boolean bl = negative = x < 0.0;
        if (x != x) {
            return x;
        }
        if (x == Double.POSITIVE_INFINITY) {
            return Double.POSITIVE_INFINITY;
        }
        if (x == Double.NEGATIVE_INFINITY) {
            return Double.NEGATIVE_INFINITY;
        }
        if (x == 0.0) {
            return x;
        }
        long bits = Double.doubleToLongBits(x = StrictMath.abs(x));
        if (bits < 0x10000000000000L) {
            t = 1.8014398509481984E16;
            bits = Double.doubleToLongBits(t *= x);
            h = StrictMath.getHighDWord(bits);
            l = StrictMath.getLowDWord(bits);
            h = h / 3L + 696219795L;
            t = StrictMath.buildDouble(l, h);
        } else {
            h = StrictMath.getHighDWord(bits);
            l = 0L;
            h = h / 3L + 715094163L;
            t = StrictMath.buildDouble(l, h);
        }
        double r = t * t / x;
        double s = 0.5428571428571428 + r * t;
        bits = Double.doubleToLongBits(t *= 0.35714285714285715 + 1.6071428571428572 / (s + 1.4142857142857144 + -0.7053061224489796 / s));
        h = StrictMath.getHighDWord(bits);
        l = 0L;
        t = StrictMath.buildDouble(l, ++h);
        s = t * t;
        r = x / s;
        double w = t + t;
        r = (r - t) / (w + r);
        t += t * r;
        return negative ? -t : t;
    }

    public static double exp(double x) {
        int k;
        double lo;
        double hi;
        if (x != x) {
            return x;
        }
        if (x > 709.782712893384) {
            return Double.POSITIVE_INFINITY;
        }
        if (x < -745.1332191019411) {
            return 0.0;
        }
        double t = StrictMath.abs(x);
        if (t > 0.34657359027997264) {
            if (t < 1.0397207708399179) {
                hi = t - 0.6931471803691238;
                lo = 1.9082149292705877E-10;
                k = 1;
            } else {
                k = (int)(1.4426950408889634 * t + 0.5);
                hi = t - (double)k * 0.6931471803691238;
                lo = (double)k * 1.9082149292705877E-10;
            }
            if (x < 0.0) {
                hi = -hi;
                lo = -lo;
                k = -k;
            }
            x = hi - lo;
        } else {
            if (t < 3.725290298461914E-9) {
                return 1.0;
            }
            k = 0;
            lo = hi = (double)0;
        }
        t = x * x;
        double c = x - t * (0.16666666666666602 + t * (-0.0027777777777015593 + t * (6.613756321437934E-5 + t * (-1.6533902205465252E-6 + t * 4.1381367970572385E-8))));
        if (k == 0) {
            return 1.0 - (x * c / (c - 2.0) - x);
        }
        double y = 1.0 - (lo - x * c / (2.0 - c) - hi);
        return StrictMath.scale(y, k);
    }

    public static double expm1(double x) {
        double t;
        int k;
        boolean negative = x < 0.0;
        double c = 0.0;
        double y = StrictMath.abs(x);
        long bits = Double.doubleToLongBits(y);
        long h_bits = StrictMath.getHighDWord(bits);
        long l_bits = StrictMath.getLowDWord(bits);
        if (h_bits >= 1078159482L) {
            if (h_bits >= 1082535490L) {
                if (h_bits >= 0x7FF00000L) {
                    if ((h_bits & 0xFFFFFL | l_bits & 0xFFFFFFFFL) != 0L) {
                        return x;
                    }
                    return negative ? -1.0 : x;
                }
                if (x > 709.782712893384) {
                    return Double.POSITIVE_INFINITY;
                }
            }
            if (negative) {
                return -1.0;
            }
        }
        if (h_bits > 1071001154L) {
            double lo;
            double hi;
            if (h_bits < 1072734898L) {
                if (negative) {
                    hi = x + 0.6931471803691238;
                    lo = -1.9082149292705877E-10;
                    k = -1;
                } else {
                    hi = x - 0.6931471803691238;
                    lo = 1.9082149292705877E-10;
                    k = 1;
                }
            } else {
                k = (int)(1.4426950408889634 * x + (negative ? -0.5 : 0.5));
                t = k;
                hi = x - t * 0.6931471803691238;
                lo = t * 1.9082149292705877E-10;
            }
            x = hi - lo;
            c = hi - x - lo;
        } else {
            if (h_bits < 1016070144L) {
                return x;
            }
            k = 0;
        }
        double hfx = 0.5 * x;
        double hxs = x * hfx;
        double r1 = 1.0 + hxs * (-0.03333333333333313 + hxs * (0.0015873015872548146 + hxs * (-7.93650757867488E-5 + hxs * (4.008217827329362E-6 + hxs * -2.0109921818362437E-7))));
        t = 3.0 - r1 * hfx;
        double e = hxs * ((r1 - t) / (6.0 - x * t));
        if (k == 0) {
            return x - (x * e - hxs);
        }
        e = x * (e - c) - c;
        e -= hxs;
        if (k == -1) {
            return 0.5 * (x - e) - 0.5;
        }
        if (k == 1) {
            if (x < -0.25) {
                return -2.0 * (e - (x + 0.5));
            }
            return 1.0 + 2.0 * (x - e);
        }
        if (k <= -2 || k > 56) {
            y = 1.0 - (e - x);
            bits = Double.doubleToLongBits(y);
            h_bits = StrictMath.getHighDWord(bits);
            l_bits = StrictMath.getLowDWord(bits);
            y = StrictMath.buildDouble(l_bits, h_bits += (long)(k << 20));
            return y - 1.0;
        }
        t = 1.0;
        if (k < 20) {
            bits = Double.doubleToLongBits(t);
            h_bits = 0x3FF00000L - (0x200000L >> k);
            l_bits = StrictMath.getLowDWord(bits);
            t = StrictMath.buildDouble(l_bits, h_bits);
            y = t - (e - x);
            bits = Double.doubleToLongBits(y);
            h_bits = StrictMath.getHighDWord(bits);
            l_bits = StrictMath.getLowDWord(bits);
            y = StrictMath.buildDouble(l_bits, h_bits += (long)(k << 20));
        } else {
            bits = Double.doubleToLongBits(t);
            h_bits = 1023L - (long)k << 20;
            l_bits = StrictMath.getLowDWord(bits);
            t = StrictMath.buildDouble(l_bits, h_bits);
            y = x - (e + t);
            bits = Double.doubleToLongBits(y += 1.0);
            h_bits = StrictMath.getHighDWord(bits);
            l_bits = StrictMath.getLowDWord(bits);
            y = StrictMath.buildDouble(l_bits, h_bits += (long)(k << 20));
        }
        return y;
    }

    public static double log(double x) {
        if (x == 0.0) {
            return Double.NEGATIVE_INFINITY;
        }
        if (x < 0.0) {
            return Double.NaN;
        }
        if (!(x < Double.POSITIVE_INFINITY)) {
            return x;
        }
        long bits = Double.doubleToLongBits(x);
        int exp = (int)(bits >> 52);
        if (exp == 0) {
            bits = Double.doubleToLongBits(x *= 1.8014398509481984E16);
            exp = (int)(bits >> 52) - 54;
        }
        exp -= 1023;
        x = Double.longBitsToDouble(bits = bits & 0xFFFFFFFFFFFFFL | 0x3FF0000000000000L);
        if (x >= 1.4142135623730951) {
            x *= 0.5;
            ++exp;
        }
        if (StrictMath.abs(x -= 1.0) < 9.5367431640625E-7) {
            if (x == 0.0) {
                return (double)exp * 0.6931471803691238 + (double)exp * 1.9082149292705877E-10;
            }
            double r = x * x * (0.5 - 0.3333333333333333 * x);
            if (exp == 0) {
                return x - r;
            }
            return (double)exp * 0.6931471803691238 - (r - (double)exp * 1.9082149292705877E-10 - x);
        }
        double s = x / (2.0 + x);
        double z = s * s;
        double w = z * z;
        double t1 = w * (0.3999999999940942 + w * (0.22222198432149784 + w * 0.15313837699209373));
        double t2 = z * (0.6666666666666735 + w * (0.2857142874366239 + w * (0.1818357216161805 + w * 0.14798198605116586)));
        double r = t2 + t1;
        if (bits >= 4608896875255300096L && bits < 4609073930987110400L) {
            double h = 0.5 * x * x;
            if (exp == 0) {
                return x - (h - s * (h + r));
            }
            return (double)exp * 0.6931471803691238 - (h - (s * (h + r) + (double)exp * 1.9082149292705877E-10) - x);
        }
        if (exp == 0) {
            return x - s * (x - r);
        }
        return (double)exp * 0.6931471803691238 - (s * (x - r) - (double)exp * 1.9082149292705877E-10 - x);
    }

    public static double sqrt(double x) {
        if (x < 0.0) {
            return Double.NaN;
        }
        if (x == 0.0 || !(x < Double.POSITIVE_INFINITY)) {
            return x;
        }
        long bits = Double.doubleToLongBits(x);
        int exp = (int)(bits >> 52);
        if (exp == 0) {
            bits = Double.doubleToLongBits(x *= 1.8014398509481984E16);
            exp = (int)(bits >> 52) - 54;
        }
        bits = bits & 0xFFFFFFFFFFFFFL | 0x10000000000000L;
        if (((exp -= 1023) & 1) == 1) {
            bits <<= 1;
        }
        exp >>= 1;
        bits <<= 1;
        long q = 0L;
        long s = 0L;
        long r = 0x20000000000000L;
        while (r != 0L) {
            long t = s + r;
            if (t <= bits) {
                s = t + r;
                bits -= t;
                q += r;
            }
            bits <<= 1;
            r >>= 1;
        }
        if (bits != 0L) {
            q += q & 1L;
        }
        return Double.longBitsToDouble((q >> 1) + ((long)exp + 1022L << 52));
    }

    public static double pow(double x, double y) {
        double t2;
        double t1;
        double v;
        double u;
        double w;
        double t;
        if (y == 0.0) {
            return 1.0;
        }
        if (y == 1.0) {
            return x;
        }
        if (y == -1.0) {
            return 1.0 / x;
        }
        if (x != x || y != y) {
            return Double.NaN;
        }
        int yisint = 0;
        if (x < 0.0 && StrictMath.floor(y) == y) {
            yisint = y % 2.0 == 0.0 ? 2 : 1;
        }
        double ax = StrictMath.abs(x);
        double ay = StrictMath.abs(y);
        if (ay == Double.POSITIVE_INFINITY) {
            if (ax == 1.0) {
                return Double.NaN;
            }
            if (ax > 1.0) {
                return y > 0.0 ? y : 0.0;
            }
            return y < 0.0 ? -y : 0.0;
        }
        if (y == 2.0) {
            return x * x;
        }
        if (y == 0.5) {
            return StrictMath.sqrt(x);
        }
        if (x == 0.0 || ax == Double.POSITIVE_INFINITY || ax == 1.0) {
            if (y < 0.0) {
                ax = 1.0 / ax;
            }
            if (x < 0.0) {
                if (x == -1.0 && yisint == 0) {
                    ax = Double.NaN;
                } else if (yisint == 1) {
                    ax = -ax;
                }
            }
            return ax;
        }
        if (x < 0.0 && yisint == 0) {
            return Double.NaN;
        }
        if (ay > 2.147483648E9) {
            if (ay > 1.8446744073709552E19) {
                return (ax < 1.0 ? y < 0.0 : y > 0.0) ? Double.POSITIVE_INFINITY : 0.0;
            }
            if (ax < 0.9999995231628418) {
                return y < 0.0 ? Double.POSITIVE_INFINITY : 0.0;
            }
            if (ax >= (double)1.000001f) {
                return y > 0.0 ? Double.POSITIVE_INFINITY : 0.0;
            }
            t = x - 1.0;
            w = t * t * (0.5 - t * (0.3333333333333333 - t * 0.25));
            u = (double)1.442695f * t;
            v = t * 1.9259629911266175E-8 - w * 1.4426950408889634;
            t1 = (float)(u + v);
            t2 = v - (t1 - u);
        } else {
            boolean k;
            long bits = Double.doubleToLongBits(ax);
            int exp = (int)(bits >> 52);
            if (exp == 0) {
                bits = Double.doubleToLongBits(ax *= 1.8014398509481984E16);
                exp = (int)(bits >> 52) - 54;
            }
            exp -= 1023;
            ax = Double.longBitsToDouble(bits & 0xFFFFFFFFFFFFFL | 0x3FF0000000000000L);
            if (ax < 1.224744871391589) {
                k = false;
            } else if (ax < 1.7320508075688772) {
                k = true;
            } else {
                k = false;
                ax *= 0.5;
                ++exp;
            }
            u = ax - (k ? 1.5 : 1.0);
            v = 1.0 / (ax + (k ? 1.5 : 1.0));
            double s = u * v;
            double s_h = (float)s;
            double t_h = (float)(ax + (k ? 1.5 : 1.0));
            double t_l = ax - (t_h - (k ? 1.5 : 1.0));
            double s_l = v * (u - s_h * t_h - s_h * t_l);
            double s2 = s * s;
            double r = s_l * (s_h + s) + s2 * s2 * (0.5999999999999946 + s2 * (0.4285714285785502 + s2 * (0.33333332981837743 + s2 * (0.272728123808534 + s2 * (0.23066074577556175 + s2 * 0.20697501780033842)))));
            s2 = s_h * s_h;
            t_h = (float)(3.0 + s2 + r);
            t_l = r - (t_h - 3.0 - s2);
            u = s_h * t_h;
            v = s_l * t_h + t_l * s;
            double p_h = (float)(u + v);
            double p_l = v - (p_h - u);
            double z_h = 0.9617967009544373 * p_h;
            double z_l = -7.028461650952758E-9 * p_h + p_l * 0.9617966939259756 + (k ? 1.350039202129749E-8 : 0.0);
            t = exp;
            t1 = (float)(z_h + z_l + (k ? 0.5849624872207642 : 0.0) + t);
            t2 = z_l - (t1 - t - (k ? 0.5849624872207642 : 0.0) - z_h);
        }
        boolean negative = x < 0.0 && yisint == 1;
        double y1 = (float)y;
        double p_l = (y - y1) * t1 + y * t2;
        double p_h = y1 * t1;
        double z = p_l + p_h;
        if (z >= 1024.0) {
            if (z > 1024.0 || p_l + 8.008566259537294E-17 > z - p_h) {
                return negative ? Double.NEGATIVE_INFINITY : Double.POSITIVE_INFINITY;
            }
        } else if (z <= -1075.0 && (z < -1075.0 || p_l <= z - p_h)) {
            return negative ? -0.0 : 0.0;
        }
        int n = StrictMath.round((float)z);
        t = (float)(p_l + (p_h -= (double)n));
        u = t * 0.6931471803691238;
        v = (p_l - (t - p_h)) * 0.6931471805599453 + t * 1.9082149292705877E-10;
        z = u + v;
        w = v - (z - u);
        t = z * z;
        t1 = z - t * (0.16666666666666602 + t * (-0.0027777777777015593 + t * (6.613756321437934E-5 + t * (-1.6533902205465252E-6 + t * 4.1381367970572385E-8))));
        double r = z * t1 / (t1 - 2.0) - (w + z * w);
        z = StrictMath.scale(1.0 - (r - z), n);
        return negative ? -z : z;
    }

    public static double IEEEremainder(double x, double y) {
        if (x == Double.NEGATIVE_INFINITY || !(x < Double.POSITIVE_INFINITY) || y == 0.0 || y != y) {
            return Double.NaN;
        }
        boolean negative = x < 0.0;
        if ((x = StrictMath.abs(x)) == (y = StrictMath.abs(y)) || x == 0.0) {
            return 0.0 * x;
        }
        if (y < 8.98846567431158E307) {
            x %= y + y;
        }
        if (y < 4.450147717014403E-308) {
            if (x + x > y && (x -= y) + x >= y) {
                x -= y;
            }
        } else if (x > (y *= 0.5) && (x -= y) >= y) {
            x -= y;
        }
        return negative ? -x : x;
    }

    public static double ceil(double a) {
        return -StrictMath.floor(-a);
    }

    public static double floor(double a) {
        double x = StrictMath.abs(a);
        if (!(x < 4.503599627370496E15) || (double)((long)a) == a) {
            return a;
        }
        if (x < 1.0) {
            return a >= 0.0 ? 0.0 * a : -1.0;
        }
        return a < 0.0 ? (double)((long)a) - 1.0 : (double)((long)a);
    }

    public static double rint(double a) {
        double x = StrictMath.abs(a);
        if (!(x < 4.503599627370496E15)) {
            return a;
        }
        if (x <= 0.5) {
            return 0.0 * a;
        }
        if (x % 2.0 <= 0.5) {
            return (long)a;
        }
        return (long)(a + (a < 0.0 ? -0.5 : 0.5));
    }

    public static int round(float f) {
        return (int)StrictMath.floor(f + 0.5f);
    }

    public static long round(double d) {
        return (long)StrictMath.floor(d + 0.5);
    }

    public static synchronized double random() {
        if (rand == null) {
            rand = new Random();
        }
        return rand.nextDouble();
    }

    public static double toRadians(double degrees) {
        return degrees * Math.PI / 180.0;
    }

    public static double toDegrees(double rads) {
        return rads * 180.0 / Math.PI;
    }

    private static int remPiOver2(double x, double[] y) {
        int n;
        boolean negative = x < 0.0;
        x = StrictMath.abs(x);
        if (Configuration.DEBUG && (x <= 0.7853981633974483 || x != x || x == Double.POSITIVE_INFINITY)) {
            throw new InternalError("Assertion failure");
        }
        if (x < 2.356194490192345) {
            double z = x - 1.5707963267341256;
            if ((float)x != 1.5707964f) {
                y[0] = z - 6.077100506506192E-11;
                y[1] = z - y[0] - 6.077100506506192E-11;
            } else {
                y[0] = (z -= 6.077100506303966E-11) - 2.0222662487959506E-21;
                y[1] = z - y[0] - 2.0222662487959506E-21;
            }
            n = 1;
        } else if (x <= 1647099.3291652855) {
            n = (int)(0.6366197723675814 * x + 0.5);
            double z = x - (double)n * 1.5707963267341256;
            double w = (double)n * 6.077100506506192E-11;
            y[0] = z - w;
            if ((n >= 32 || (float)x == (float)w) && x / y[0] >= 65536.0) {
                double t = z;
                w = (double)n * 6.077100506303966E-11;
                z = t - w;
                w = (double)n * 2.0222662487959506E-21 - (t - z - w);
                y[0] = z - w;
                if (x / y[0] >= 5.62949953421312E14) {
                    t = z;
                    w = (double)n * 2.0222662487111665E-21;
                    z = t - w;
                    w = (double)n * 8.4784276603689E-32 - (t - z - w);
                    y[0] = z - w;
                }
            }
            y[1] = z - y[0] - w;
        } else {
            int e0 = (int)(Double.doubleToLongBits(x) >> 52) - 1046;
            double z = StrictMath.scale(x, -e0);
            double[] tx = new double[3];
            int i = 0;
            while (i < 2) {
                tx[i] = (int)z;
                z = (z - tx[i]) * 1.6777216E7;
                ++i;
            }
            tx[2] = z;
            int nx = 2;
            while (tx[nx] == 0.0) {
                --nx;
            }
            n = StrictMath.remPiOver2(tx, y, e0, nx);
        }
        if (negative) {
            y[0] = -y[0];
            y[1] = -y[1];
            return -n;
        }
        return n;
    }

    private static int remPiOver2(double[] x, double[] y, int e0, int nx) {
        int ih;
        int n;
        double z;
        double fw;
        int jk;
        int[] iq = new int[20];
        double[] f = new double[20];
        double[] q = new double[20];
        boolean recompute = false;
        int jz = jk = 4;
        int jv = StrictMath.max((e0 - 3) / 24, 0);
        int q0 = e0 - 24 * (jv + 1);
        int j = jv - nx;
        int m = nx + jk;
        int i = 0;
        while (i <= m) {
            f[i] = j < 0 ? 0 : TWO_OVER_PI[j];
            ++i;
            ++j;
        }
        i = 0;
        while (i <= jk) {
            j = 0;
            fw = 0.0;
            while (j <= nx) {
                fw += x[j] * f[nx + i - j];
                ++j;
            }
            q[i] = fw;
            ++i;
        }
        do {
            i = 0;
            j = jz;
            z = q[jz];
            while (j > 0) {
                fw = (int)(5.960464477539063E-8 * z);
                iq[i] = (int)(z - 1.6777216E7 * fw);
                z = q[j - 1] + fw;
                ++i;
                --j;
            }
            z = StrictMath.scale(z, q0);
            z -= 8.0 * StrictMath.floor(z * 0.125);
            n = (int)z;
            z -= (double)n;
            ih = 0;
            if (q0 > 0) {
                i = iq[jz - 1] >> 24 - q0;
                n += i;
                int n2 = jz - 1;
                iq[n2] = iq[n2] - (i << 24 - q0);
                ih = iq[jz - 1] >> 23 - q0;
            } else if (q0 == 0) {
                ih = iq[jz - 1] >> 23;
            } else if (z >= 0.5) {
                ih = 2;
            }
            if (ih > 0) {
                ++n;
                boolean carry = false;
                i = 0;
                while (i < jz) {
                    j = iq[i];
                    if (!carry) {
                        if (j != 0) {
                            carry = true;
                            iq[i] = 0x1000000 - j;
                        }
                    } else {
                        iq[i] = 0xFFFFFF - j;
                    }
                    ++i;
                }
                switch (q0) {
                    case 1: {
                        int n3 = jz - 1;
                        iq[n3] = iq[n3] & 0x7FFFFF;
                        break;
                    }
                    case 2: {
                        int n4 = jz - 1;
                        iq[n4] = iq[n4] & 0x3FFFFF;
                    }
                }
                if (ih == 2) {
                    z = 1.0 - z;
                    if (carry) {
                        z -= StrictMath.scale(1.0, q0);
                    }
                }
            }
            if (z != 0.0) continue;
            j = 0;
            i = jz - 1;
            while (i >= jk) {
                j |= iq[i];
                --i;
            }
            if (j != 0) continue;
            int k = 1;
            while (iq[jk - k] == 0) {
                ++k;
            }
            i = jz + 1;
            while (i <= jz + k) {
                f[nx + i] = TWO_OVER_PI[jv + i];
                j = 0;
                fw = 0.0;
                while (j <= nx) {
                    fw += x[j] * f[nx + i - j];
                    ++j;
                }
                q[i] = fw;
                ++i;
            }
            jz += k;
            recompute = true;
        } while (recompute);
        if (z == 0.0) {
            --jz;
            q0 -= 24;
            while (iq[jz] == 0) {
                --jz;
                q0 -= 24;
            }
        } else if ((z = StrictMath.scale(z, -q0)) >= 1.6777216E7) {
            fw = (int)(5.960464477539063E-8 * z);
            iq[jz] = (int)(z - 1.6777216E7 * fw);
            q0 += 24;
            iq[++jz] = (int)fw;
        } else {
            iq[jz] = (int)z;
        }
        fw = StrictMath.scale(1.0, q0);
        i = jz;
        while (i >= 0) {
            q[i] = fw * (double)iq[i];
            fw *= 5.960464477539063E-8;
            --i;
        }
        double[] fq = new double[20];
        i = jz;
        while (i >= 0) {
            fw = 0.0;
            int k = 0;
            while (k <= jk && k <= jz - i) {
                fw += PI_OVER_TWO[k] * q[i + k];
                ++k;
            }
            fq[jz - i] = fw;
            --i;
        }
        fw = 0.0;
        i = jz;
        while (i >= 0) {
            fw += fq[i];
            --i;
        }
        y[0] = ih == 0 ? fw : -fw;
        fw = fq[0] - fw;
        i = 1;
        while (i <= jz) {
            fw += fq[i];
            ++i;
        }
        y[1] = ih == 0 ? fw : -fw;
        return n;
    }

    private static double scale(double x, int n) {
        if (Configuration.DEBUG && StrictMath.abs(n) >= 2048) {
            throw new InternalError("Assertion failure");
        }
        if (x == 0.0 || x == Double.NEGATIVE_INFINITY || !(x < Double.POSITIVE_INFINITY) || n == 0) {
            return x;
        }
        long bits = Double.doubleToLongBits(x);
        int exp = (int)(bits >> 52) & 0x7FF;
        if (exp == 0) {
            exp = ((int)(Double.doubleToLongBits(x *= 1.8014398509481984E16) >> 52) & 0x7FF) - 54;
        }
        if ((exp += n) > 2046) {
            return Double.POSITIVE_INFINITY * x;
        }
        if (exp > 0) {
            return Double.longBitsToDouble(bits & 0x800FFFFFFFFFFFFFL | (long)exp << 52);
        }
        if (exp <= -54) {
            return 0.0 * x;
        }
        x = Double.longBitsToDouble(bits & 0x800FFFFFFFFFFFFFL | (long)(exp += 54) << 52);
        return x * 5.551115123125783E-17;
    }

    private static double sin(double x, double y) {
        if (Configuration.DEBUG && StrictMath.abs(x + y) > 0.7854) {
            throw new InternalError("Assertion failure");
        }
        if (StrictMath.abs(x) < 7.450580596923828E-9) {
            return x;
        }
        double z = x * x;
        double v = z * x;
        double r = 0.00833333333332249 + z * (-1.984126982985795E-4 + z * (2.7557313707070068E-6 + z * (-2.5050760253406863E-8 + z * 1.58969099521155E-10)));
        if (y == 0.0) {
            return x + v * (-0.16666666666666632 + z * r);
        }
        return x - (z * (0.5 * y - v * r) - y - v * -0.16666666666666632);
    }

    private static double cos(double x, double y) {
        if (Configuration.DEBUG && StrictMath.abs(x + y) > 0.7854) {
            throw new InternalError("Assertion failure");
        }
        if ((x = StrictMath.abs(x)) < 7.450580596923828E-9) {
            return 1.0;
        }
        double z = x * x;
        double r = z * (0.0416666666666666 + z * (-0.001388888888887411 + z * (2.480158728947673E-5 + z * (-2.7557314351390663E-7 + z * (2.087572321298175E-9 + z * -1.1359647557788195E-11)))));
        if (x < 0.3) {
            return 1.0 - (0.5 * z - (z * r - x * y));
        }
        double qx = x > 0.78125 ? 0.28125 : x * 0.25;
        return 1.0 - qx - (0.5 * z - qx - (z * r - x * y));
    }

    private static double tan(double x, double y, boolean invert) {
        double w;
        double z;
        boolean large;
        boolean negative;
        if (Configuration.DEBUG && (StrictMath.abs(x + y) > 0.7854 || x == 0.0 && invert)) {
            throw new InternalError("Assertion failure");
        }
        boolean bl = negative = x < 0.0;
        if (negative) {
            x = -x;
            y = -y;
        }
        if (x < 3.725290298461914E-9) {
            return (double)(negative ? -1 : 1) * (invert ? -1.0 / x : x);
        }
        boolean bl2 = large = x >= 0.6744;
        if (large) {
            z = 0.7853981633974483 - x;
            w = 3.061616997868383E-17 - y;
            x = z + w;
            y = 0.0;
        }
        z = x * x;
        w = z * z;
        double r = 0.13333333333320124 + w * (0.021869488294859542 + w * (0.0035920791075913124 + w * (5.880412408202641E-4 + w * (7.817944429395571E-5 + w * -1.8558637485527546E-5))));
        double v = z * (0.05396825397622605 + w * (0.0088632398235993 + w * (0.0014562094543252903 + w * (2.464631348184699E-4 + w * (7.140724913826082E-5 + w * 2.590730518636337E-5)))));
        double s = z * x;
        r = y + z * (s * (r + v) + y);
        w = x + (r += 0.3333333333333341 * s);
        if (large) {
            v = invert ? -1 : 1;
            return (double)(negative ? -1 : 1) * (v - 2.0 * (x - (w * w / (w + v) - r)));
        }
        if (!invert) {
            return w;
        }
        z = (float)w;
        v = r - (z - x);
        double a = -1.0 / w;
        double t = (float)a;
        return t + a * (1.0 + t * z + t * v);
    }

    public static double signum(double a) {
        return Math.signum(a);
    }

    public static float signum(float a) {
        return Math.signum(a);
    }

    public static double ulp(double d) {
        return Math.ulp(d);
    }

    public static float ulp(float f) {
        return Math.ulp(f);
    }
}

