/*
 * Decompiled with CFR 0.152.
 */
package java.awt.image;

import java.awt.image.ColorModel;
import java.awt.image.ImageConsumer;
import java.awt.image.ImageProducer;
import java.util.Hashtable;
import java.util.Vector;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class MemoryImageSource
implements ImageProducer {
    private boolean animated = false;
    private boolean fullbuffers = false;
    private int[] pixeli;
    private int width;
    private int height;
    private int offset;
    private int scansize;
    private byte[] pixelb;
    private ColorModel cm;
    private Hashtable props = new Hashtable();
    private Vector consumers = new Vector();

    public MemoryImageSource(int w, int h, ColorModel cm, byte[] pix, int off, int scan) {
        this(w, h, cm, pix, off, scan, (Hashtable<?, ?>)null);
    }

    public MemoryImageSource(int w, int h, ColorModel cm, byte[] pix, int off, int scan, Hashtable<?, ?> props) {
        this.width = w;
        this.height = h;
        this.cm = cm;
        this.offset = off;
        this.scansize = scan;
        this.props = props;
        if (this.scansize > this.width) {
            // empty if block
        }
        this.pixelb = pix;
    }

    public MemoryImageSource(int w, int h, ColorModel cm, int[] pix, int off, int scan) {
        this(w, h, cm, pix, off, scan, null);
    }

    public MemoryImageSource(int w, int h, ColorModel cm, int[] pix, int off, int scan, Hashtable<?, ?> props) {
        this.width = w;
        this.height = h;
        this.cm = cm;
        this.offset = off;
        this.scansize = scan;
        this.props = props;
        if (this.scansize > this.width) {
            // empty if block
        }
        this.pixeli = pix;
    }

    public MemoryImageSource(int w, int h, int[] pix, int off, int scan, Hashtable<?, ?> props) {
        this(w, h, ColorModel.getRGBdefault(), pix, off, scan, props);
    }

    public MemoryImageSource(int w, int h, int[] pix, int off, int scan) {
        this(w, h, ColorModel.getRGBdefault(), pix, off, scan, null);
    }

    @Override
    public synchronized void addConsumer(ImageConsumer ic) {
        if (this.consumers.contains(ic)) {
            return;
        }
        this.consumers.addElement(ic);
    }

    @Override
    public synchronized boolean isConsumer(ImageConsumer ic) {
        return this.consumers.contains(ic);
    }

    @Override
    public synchronized void removeConsumer(ImageConsumer ic) {
        this.consumers.removeElement(ic);
    }

    @Override
    public void startProduction(ImageConsumer ic) {
        if (!this.consumers.contains(ic)) {
            this.consumers.addElement(ic);
        }
        Vector list2 = (Vector)this.consumers.clone();
        int i = 0;
        while (i < list2.size()) {
            ic = (ImageConsumer)list2.elementAt(i);
            this.sendPicture(ic);
            if (this.animated) {
                ic.imageComplete(2);
            } else {
                ic.imageComplete(3);
            }
            ++i;
        }
    }

    @Override
    public void requestTopDownLeftRightResend(ImageConsumer ic) {
        this.startProduction(ic);
    }

    public synchronized void setAnimated(boolean animated) {
        this.animated = animated;
    }

    public synchronized void setFullBufferUpdates(boolean fullbuffers) {
        this.fullbuffers = fullbuffers;
    }

    public void newPixels() {
        if (this.animated) {
            Vector list2 = (Vector)this.consumers.clone();
            int i = 0;
            while (i < list2.size()) {
                ImageConsumer ic = (ImageConsumer)list2.elementAt(i);
                this.sendPicture(ic);
                ic.imageComplete(16);
                ++i;
            }
        }
    }

    private void sendPicture(ImageConsumer ic) {
        ic.setHints(2);
        if (this.props != null) {
            ic.setProperties(this.props);
        }
        ic.setDimensions(this.width, this.height);
        ic.setColorModel(this.cm);
        if (this.pixeli != null) {
            ic.setPixels(0, 0, this.width, this.height, this.cm, this.pixeli, this.offset, this.scansize);
        } else {
            ic.setPixels(0, 0, this.width, this.height, this.cm, this.pixelb, this.offset, this.scansize);
        }
    }

    public synchronized void newPixels(int x, int y, int w, int h) {
        if (this.animated) {
            if (this.fullbuffers) {
                this.newPixels();
            } else {
                Vector list2 = (Vector)this.consumers.clone();
                int i = 0;
                while (i < list2.size()) {
                    int row;
                    Object[] pixelbuf;
                    ImageConsumer ic = (ImageConsumer)list2.elementAt(i);
                    ic.setHints(2);
                    if (this.props != null) {
                        ic.setProperties(this.props);
                    }
                    if (this.pixeli != null) {
                        pixelbuf = new int[w * h];
                        row = y;
                        while (row < y + h) {
                            System.arraycopy(this.pixeli, row * this.scansize + x + this.offset, pixelbuf, 0, w * h);
                            ++row;
                        }
                        ic.setPixels(x, y, w, h, this.cm, (int[])pixelbuf, 0, w);
                    } else {
                        pixelbuf = new byte[w * h];
                        row = y;
                        while (row < y + h) {
                            System.arraycopy(this.pixelb, row * this.scansize + x + this.offset, pixelbuf, 0, w * h);
                            ++row;
                        }
                        ic.setPixels(x, y, w, h, this.cm, (byte[])pixelbuf, 0, w);
                    }
                    ic.imageComplete(16);
                    ++i;
                }
            }
        }
    }

    public synchronized void newPixels(int x, int y, int w, int h, boolean framenotify) {
        if (this.animated) {
            if (this.fullbuffers) {
                this.newPixels();
            } else {
                Vector list2 = (Vector)this.consumers.clone();
                int i = 0;
                while (i < list2.size()) {
                    int row;
                    Object[] pixelbuf;
                    ImageConsumer ic = (ImageConsumer)list2.elementAt(i);
                    ic.setHints(2);
                    if (this.props != null) {
                        ic.setProperties(this.props);
                    }
                    if (this.pixeli != null) {
                        pixelbuf = new int[w * h];
                        row = y;
                        while (row < y + h) {
                            System.arraycopy(this.pixeli, row * this.scansize + x + this.offset, pixelbuf, 0, w * h);
                            ++row;
                        }
                        ic.setPixels(x, y, w, h, this.cm, (int[])pixelbuf, 0, w);
                    } else {
                        pixelbuf = new byte[w * h];
                        row = y;
                        while (row < y + h) {
                            System.arraycopy(this.pixelb, row * this.scansize + x + this.offset, pixelbuf, 0, w * h);
                            ++row;
                        }
                        ic.setPixels(x, y, w, h, this.cm, (byte[])pixelbuf, 0, w);
                    }
                    if (framenotify) {
                        ic.imageComplete(16);
                    }
                    ++i;
                }
            }
        }
    }

    public synchronized void newPixels(byte[] newpix, ColorModel newmodel, int offset, int scansize) {
        this.pixeli = null;
        this.pixelb = newpix;
        this.cm = newmodel;
        this.offset = offset;
        this.scansize = scansize;
        if (this.animated) {
            this.newPixels();
        }
    }

    public synchronized void newPixels(int[] newpix, ColorModel newmodel, int offset, int scansize) {
        this.pixelb = null;
        this.pixeli = newpix;
        this.cm = newmodel;
        this.offset = offset;
        this.scansize = scansize;
        if (this.animated) {
            this.newPixels();
        }
    }
}

