/*
 * Decompiled with CFR 0.152.
 */
package java.awt;

import java.awt.GraphicsEnvironment;
import java.awt.HeadlessException;
import java.awt.Toolkit;
import java.awt.peer.DesktopPeer;
import java.io.File;
import java.io.IOException;
import java.net.URI;

public class Desktop {
    private DesktopPeer peer;

    private Desktop() {
    }

    public static Desktop getDesktop() throws UnsupportedOperationException, HeadlessException {
        if (GraphicsEnvironment.isHeadless()) {
            throw new HeadlessException();
        }
        if (!Desktop.isDesktopSupported()) {
            throw new UnsupportedOperationException();
        }
        Desktop desktop = new Desktop();
        desktop.peer = Toolkit.getDefaultToolkit().createDesktopPeer(desktop);
        return desktop;
    }

    public static boolean isDesktopSupported() {
        return !GraphicsEnvironment.isHeadless();
    }

    public boolean isSupported(Action action) {
        return this.peer.isSupported(action);
    }

    public void browse(URI uri) throws IOException {
        this.peer.browse(uri);
    }

    public void edit(File file) throws IOException {
        this.peer.edit(file);
    }

    public void mail() throws IOException {
        this.peer.mail();
    }

    public void mail(URI mailtoURI) throws IOException {
        this.peer.mail(mailtoURI);
    }

    public void open(File file) throws IOException {
        this.peer.open(file);
    }

    public void print(File file) throws IOException {
        this.peer.print(file);
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static enum Action {
        BROWSE,
        EDIT,
        MAIL,
        OPEN,
        PRINT;

    }
}

