/*
 * Decompiled with CFR 0.152.
 */
package gnu.xml.dom.html2;

import gnu.xml.dom.DomDOMException;
import gnu.xml.dom.DomDocument;
import gnu.xml.dom.html2.DomHTMLAnchorElement;
import gnu.xml.dom.html2.DomHTMLAppletElement;
import gnu.xml.dom.html2.DomHTMLAreaElement;
import gnu.xml.dom.html2.DomHTMLBRElement;
import gnu.xml.dom.html2.DomHTMLBaseElement;
import gnu.xml.dom.html2.DomHTMLBaseFontElement;
import gnu.xml.dom.html2.DomHTMLBodyElement;
import gnu.xml.dom.html2.DomHTMLButtonElement;
import gnu.xml.dom.html2.DomHTMLCollection;
import gnu.xml.dom.html2.DomHTMLDListElement;
import gnu.xml.dom.html2.DomHTMLDirectoryElement;
import gnu.xml.dom.html2.DomHTMLDivElement;
import gnu.xml.dom.html2.DomHTMLEmbedElement;
import gnu.xml.dom.html2.DomHTMLFieldSetElement;
import gnu.xml.dom.html2.DomHTMLFontElement;
import gnu.xml.dom.html2.DomHTMLFormElement;
import gnu.xml.dom.html2.DomHTMLFrameElement;
import gnu.xml.dom.html2.DomHTMLFrameSetElement;
import gnu.xml.dom.html2.DomHTMLHeadElement;
import gnu.xml.dom.html2.DomHTMLHeadingElement;
import gnu.xml.dom.html2.DomHTMLHtmlElement;
import gnu.xml.dom.html2.DomHTMLIFrameElement;
import gnu.xml.dom.html2.DomHTMLImageElement;
import gnu.xml.dom.html2.DomHTMLImpl;
import gnu.xml.dom.html2.DomHTMLInputElement;
import gnu.xml.dom.html2.DomHTMLIsIndexElement;
import gnu.xml.dom.html2.DomHTMLLIElement;
import gnu.xml.dom.html2.DomHTMLLabelElement;
import gnu.xml.dom.html2.DomHTMLLegendElement;
import gnu.xml.dom.html2.DomHTMLLinkElement;
import gnu.xml.dom.html2.DomHTMLMapElement;
import gnu.xml.dom.html2.DomHTMLMenuElement;
import gnu.xml.dom.html2.DomHTMLMetaElement;
import gnu.xml.dom.html2.DomHTMLModElement;
import gnu.xml.dom.html2.DomHTMLOListElement;
import gnu.xml.dom.html2.DomHTMLObjectElement;
import gnu.xml.dom.html2.DomHTMLOptGroupElement;
import gnu.xml.dom.html2.DomHTMLOptionElement;
import gnu.xml.dom.html2.DomHTMLParagraphElement;
import gnu.xml.dom.html2.DomHTMLParamElement;
import gnu.xml.dom.html2.DomHTMLPreElement;
import gnu.xml.dom.html2.DomHTMLQuoteElement;
import gnu.xml.dom.html2.DomHTMLScriptElement;
import gnu.xml.dom.html2.DomHTMLSelectElement;
import gnu.xml.dom.html2.DomHTMLStyleElement;
import gnu.xml.dom.html2.DomHTMLTableCaptionElement;
import gnu.xml.dom.html2.DomHTMLTableCellElement;
import gnu.xml.dom.html2.DomHTMLTableColElement;
import gnu.xml.dom.html2.DomHTMLTableElement;
import gnu.xml.dom.html2.DomHTMLTableRowElement;
import gnu.xml.dom.html2.DomHTMLTableSectionElement;
import gnu.xml.dom.html2.DomHTMLTextAreaElement;
import gnu.xml.dom.html2.DomHTMLTitleElement;
import gnu.xml.dom.html2.DomHTMLUListElement;
import java.lang.reflect.Constructor;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;
import org.w3c.dom.html2.HTMLCollection;
import org.w3c.dom.html2.HTMLDocument;
import org.w3c.dom.html2.HTMLElement;

public class DomHTMLDocument
extends DomDocument
implements HTMLDocument {
    private static final Class[] ELEMENT_PT = new Class[]{DomHTMLDocument.class, String.class, String.class};
    private static Map ELEMENT_CLASSES;
    private static Set HTML_NS_URIS;

    static {
        HashMap<String, Class> map = new HashMap<String, Class>();
        map.put("a", DomHTMLAnchorElement.class);
        map.put("applet", DomHTMLAppletElement.class);
        map.put("area", DomHTMLAreaElement.class);
        map.put("base", DomHTMLBaseElement.class);
        map.put("basefont", DomHTMLBaseFontElement.class);
        map.put("body", DomHTMLBodyElement.class);
        map.put("br", DomHTMLBRElement.class);
        map.put("button", DomHTMLButtonElement.class);
        map.put("dir", DomHTMLDirectoryElement.class);
        map.put("div", DomHTMLDivElement.class);
        map.put("dlist", DomHTMLDListElement.class);
        map.put("embed", DomHTMLEmbedElement.class);
        map.put("fieldset", DomHTMLFieldSetElement.class);
        map.put("font", DomHTMLFontElement.class);
        map.put("form", DomHTMLFormElement.class);
        map.put("frame", DomHTMLFrameElement.class);
        map.put("frameset", DomHTMLFrameSetElement.class);
        map.put("head", DomHTMLHeadElement.class);
        map.put("h1", DomHTMLHeadingElement.class);
        map.put("h2", DomHTMLHeadingElement.class);
        map.put("h3", DomHTMLHeadingElement.class);
        map.put("h4", DomHTMLHeadingElement.class);
        map.put("h5", DomHTMLHeadingElement.class);
        map.put("h6", DomHTMLHeadingElement.class);
        map.put("html", DomHTMLHtmlElement.class);
        map.put("iframe", DomHTMLIFrameElement.class);
        map.put("img", DomHTMLImageElement.class);
        map.put("input", DomHTMLInputElement.class);
        map.put("isindex", DomHTMLIsIndexElement.class);
        map.put("label", DomHTMLLabelElement.class);
        map.put("legend", DomHTMLLegendElement.class);
        map.put("li", DomHTMLLIElement.class);
        map.put("link", DomHTMLLinkElement.class);
        map.put("map", DomHTMLMapElement.class);
        map.put("menu", DomHTMLMenuElement.class);
        map.put("meta", DomHTMLMetaElement.class);
        map.put("ins", DomHTMLModElement.class);
        map.put("del", DomHTMLModElement.class);
        map.put("object", DomHTMLObjectElement.class);
        map.put("ol", DomHTMLOListElement.class);
        map.put("optgroup", DomHTMLOptGroupElement.class);
        map.put("option", DomHTMLOptionElement.class);
        map.put("p", DomHTMLParagraphElement.class);
        map.put("param", DomHTMLParamElement.class);
        map.put("pre", DomHTMLPreElement.class);
        map.put("q", DomHTMLQuoteElement.class);
        map.put("blockquote", DomHTMLQuoteElement.class);
        map.put("script", DomHTMLScriptElement.class);
        map.put("select", DomHTMLSelectElement.class);
        map.put("style", DomHTMLStyleElement.class);
        map.put("caption", DomHTMLTableCaptionElement.class);
        map.put("th", DomHTMLTableCellElement.class);
        map.put("td", DomHTMLTableCellElement.class);
        map.put("col", DomHTMLTableColElement.class);
        map.put("colgroup", DomHTMLTableColElement.class);
        map.put("table", DomHTMLTableElement.class);
        map.put("tr", DomHTMLTableRowElement.class);
        map.put("thead", DomHTMLTableSectionElement.class);
        map.put("tfoot", DomHTMLTableSectionElement.class);
        map.put("tbody", DomHTMLTableSectionElement.class);
        map.put("textarea", DomHTMLTextAreaElement.class);
        map.put("title", DomHTMLTitleElement.class);
        map.put("ul", DomHTMLUListElement.class);
        ELEMENT_CLASSES = Collections.unmodifiableMap(map);
        HashSet set = new HashSet();
        set.add("http://www.w3.org/TR/html4/strict");
        set.add("http://www.w3.org/TR/html4/loose");
        set.add("http://www.w3.org/TR/html4/frameset");
        set.add("http://www.w3.org/1999/xhtml");
        set.add("http://www.w3.org/TR/xhtml1/strict");
        set.add("http://www.w3.org/TR/xhtml1/loose");
        set.add("http://www.w3.org/TR/xhtml1/frameset");
        HTML_NS_URIS = Collections.unmodifiableSet(set);
    }

    public DomHTMLDocument() {
        this(new DomHTMLImpl());
    }

    public DomHTMLDocument(DomHTMLImpl impl) {
        super(impl);
    }

    private Node getChildNodeByName(Node parent, String name) {
        Node ctx = parent.getFirstChild();
        while (ctx != null) {
            if (name.equalsIgnoreCase(ctx.getNodeName())) {
                return ctx;
            }
            ctx = ctx.getNextSibling();
        }
        return null;
    }

    public String getTitle() {
        Node title;
        Node head;
        Element html = this.getDocumentElement();
        if (html != null && (head = this.getChildNodeByName(html, "head")) != null && (title = this.getChildNodeByName(head, "title")) != null) {
            return title.getTextContent();
        }
        return null;
    }

    public void setTitle(String title) {
        Node titleNode;
        Node head;
        Element html = this.getDocumentElement();
        if (html == null) {
            html = this.createElement("html");
            this.appendChild(html);
        }
        if ((head = this.getChildNodeByName(html, "head")) == null) {
            head = this.createElement("head");
            Node first = html.getFirstChild();
            if (first != null) {
                html.insertBefore(first, head);
            } else {
                html.appendChild(head);
            }
        }
        if ((titleNode = this.getChildNodeByName(head, "title")) == null) {
            titleNode = this.createElement("title");
            Node first = head.getFirstChild();
            if (first != null) {
                head.insertBefore(first, titleNode);
            } else {
                head.appendChild(titleNode);
            }
        }
        titleNode.setTextContent(title);
    }

    public String getReferrer() {
        return null;
    }

    public String getDomain() {
        try {
            URL url = new URL(this.getDocumentURI());
            return url.getHost();
        }
        catch (MalformedURLException malformedURLException) {
            return null;
        }
    }

    public String getURL() {
        return this.getDocumentURI();
    }

    public HTMLElement getBody() {
        Element html = this.getDocumentElement();
        if (html != null) {
            Node body = this.getChildNodeByName(html, "body");
            if (body == null) {
                body = this.getChildNodeByName(html, "frameset");
            }
            return (HTMLElement)body;
        }
        return null;
    }

    public void setBody(HTMLElement body) {
        HTMLElement ref;
        Element html = this.getDocumentElement();
        if (html == null) {
            html = this.createElement("html");
            this.appendChild(html);
        }
        if ((ref = this.getBody()) == null) {
            html.appendChild(body);
        } else {
            html.replaceChild(body, ref);
        }
    }

    public HTMLCollection getImages() {
        DomHTMLCollection ret = new DomHTMLCollection(this, this);
        ret.addNodeName("img");
        ret.evaluate();
        return ret;
    }

    public HTMLCollection getApplets() {
        DomHTMLCollection ret = new DomHTMLCollection(this, this);
        ret.addNodeName("embed");
        ret.addNodeName("object");
        ret.addNodeName("applet");
        ret.evaluate();
        return ret;
    }

    public HTMLCollection getLinks() {
        DomHTMLCollection ret = new DomHTMLCollection(this, this);
        ret.addNodeName("area");
        ret.addNodeName("a");
        ret.evaluate();
        return ret;
    }

    public HTMLCollection getForms() {
        DomHTMLCollection ret = new DomHTMLCollection(this, this);
        ret.addNodeName("form");
        ret.evaluate();
        return ret;
    }

    public HTMLCollection getAnchors() {
        DomHTMLCollection ret = new DomHTMLCollection(this, this);
        ret.addNodeName("a");
        ret.addAttributeName("name");
        ret.evaluate();
        return ret;
    }

    public String getCookie() {
        return null;
    }

    public void setCookie(String cookie) {
    }

    public void open() {
    }

    public void close() {
    }

    public void write(String text) {
    }

    public void writeln(String text) {
    }

    public NodeList getElementsByName(String name) {
        DomHTMLCollection ret = new DomHTMLCollection(this, this);
        ret.addNodeName(name);
        ret.evaluate();
        return ret;
    }

    public Element createElement(String tagName) {
        return this.createElementNS(null, tagName);
    }

    public Element createElementNS(String uri, String qName) {
        Class t;
        if (uri != null && !HTML_NS_URIS.contains(uri)) {
            return super.createElementNS(uri, qName);
        }
        String localName = qName.toLowerCase();
        int ci = qName.indexOf(58);
        if (ci != -1) {
            localName = qName.substring(ci + 1);
        }
        if ((t = (Class)ELEMENT_CLASSES.get(localName)) == null) {
            return super.createElementNS(uri, qName);
        }
        try {
            Constructor c = t.getDeclaredConstructor(ELEMENT_PT);
            Object[] args = new Object[]{this, uri, qName};
            return (Element)c.newInstance(args);
        }
        catch (Exception e) {
            DomDOMException e2 = new DomDOMException(17);
            e2.initCause(e);
            throw e2;
        }
    }
}

