/*
 * Decompiled with CFR 0.152.
 */
package gnu.javax.net.ssl.provider;

import gnu.javax.net.ssl.NullManagerParameters;
import gnu.javax.net.ssl.PrivateCredentials;
import gnu.javax.net.ssl.provider.Util;
import java.io.FileInputStream;
import java.io.IOException;
import java.net.Socket;
import java.security.InvalidAlgorithmParameterException;
import java.security.KeyStore;
import java.security.KeyStoreException;
import java.security.NoSuchAlgorithmException;
import java.security.Principal;
import java.security.PrivateKey;
import java.security.PublicKey;
import java.security.UnrecoverableKeyException;
import java.security.cert.Certificate;
import java.security.cert.CertificateException;
import java.security.cert.X509Certificate;
import java.security.interfaces.DSAPrivateKey;
import java.security.interfaces.DSAPublicKey;
import java.security.interfaces.RSAPrivateKey;
import java.security.interfaces.RSAPublicKey;
import java.util.Collections;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import javax.crypto.interfaces.DHPrivateKey;
import javax.crypto.interfaces.DHPublicKey;
import javax.net.ssl.KeyManager;
import javax.net.ssl.KeyManagerFactorySpi;
import javax.net.ssl.ManagerFactoryParameters;
import javax.net.ssl.SSLEngine;
import javax.net.ssl.X509ExtendedKeyManager;

public class X509KeyManagerFactory
extends KeyManagerFactorySpi {
    private Manager current;

    protected KeyManager[] engineGetKeyManagers() {
        if (this.current == null) {
            throw new IllegalStateException();
        }
        return new KeyManager[]{this.current};
    }

    protected void engineInit(ManagerFactoryParameters params) throws InvalidAlgorithmParameterException {
        if (params instanceof NullManagerParameters) {
            this.current = new Manager(Collections.EMPTY_MAP, Collections.EMPTY_MAP);
        } else if (params instanceof PrivateCredentials) {
            List<X509Certificate[]> chains = ((PrivateCredentials)params).getCertChains();
            List<PrivateKey> keys = ((PrivateCredentials)params).getPrivateKeys();
            int i = 0;
            HashMap<String, X509Certificate[]> certMap = new HashMap<String, X509Certificate[]>();
            HashMap<String, PrivateKey> keyMap = new HashMap<String, PrivateKey>();
            Iterator<X509Certificate[]> c = chains.iterator();
            Iterator<PrivateKey> k = keys.iterator();
            while (c.hasNext() && k.hasNext()) {
                certMap.put(String.valueOf(i), c.next());
                keyMap.put(String.valueOf(i), k.next());
                ++i;
            }
            this.current = new Manager(keyMap, certMap);
        } else {
            throw new InvalidAlgorithmParameterException();
        }
    }

    protected void engineInit(KeyStore store, char[] passwd) throws KeyStoreException, NoSuchAlgorithmException, UnrecoverableKeyException {
        if (store == null) {
            String s = Util.getProperty("javax.net.ssl.keyStoreType");
            if (s == null) {
                s = KeyStore.getDefaultType();
            }
            store = KeyStore.getInstance(s);
            s = Util.getProperty("javax.net.ssl.keyStore");
            if (s == null) {
                return;
            }
            String p = Util.getProperty("javax.net.ssl.keyStorePassword");
            try {
                store.load(new FileInputStream(s), p != null ? p.toCharArray() : null);
            }
            catch (IOException ioe) {
                throw new KeyStoreException(ioe.toString());
            }
            catch (CertificateException ce) {
                throw new KeyStoreException(ce.toString());
            }
        }
        HashMap<String, PrivateKey> p = new HashMap<String, PrivateKey>();
        HashMap<String, X509Certificate[]> c = new HashMap<String, X509Certificate[]>();
        Enumeration<String> aliases = store.aliases();
        UnrecoverableKeyException exception = null;
        while (aliases.hasMoreElements()) {
            String alias = aliases.nextElement();
            if (!store.isKeyEntry(alias)) continue;
            X509Certificate[] chain = null;
            Certificate[] chain2 = store.getCertificateChain(alias);
            if (chain2 == null || chain2.length <= 0 || !(chain2[0] instanceof X509Certificate)) continue;
            chain = X509KeyManagerFactory.toX509Chain(chain2);
            PrivateKey key = null;
            try {
                key = (PrivateKey)store.getKey(alias, passwd);
            }
            catch (UnrecoverableKeyException uke) {
                exception = uke;
                continue;
            }
            if (key == null) continue;
            p.put(alias, key);
            c.put(alias, chain);
        }
        if (p.isEmpty() && c.isEmpty()) {
            if (exception != null) {
                throw exception;
            }
            throw new KeyStoreException("no private credentials found");
        }
        X509KeyManagerFactory x509KeyManagerFactory = this;
        x509KeyManagerFactory.getClass();
        this.current = x509KeyManagerFactory.new Manager(p, c);
    }

    private static X509Certificate[] toX509Chain(Certificate[] chain) {
        if (chain instanceof X509Certificate[]) {
            return (X509Certificate[])chain;
        }
        X509Certificate[] _chain = new X509Certificate[chain.length];
        int i = 0;
        while (i < chain.length) {
            _chain[i] = (X509Certificate)chain[i];
            ++i;
        }
        return _chain;
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private class Manager
    extends X509ExtendedKeyManager {
        private final Map<String, PrivateKey> privateKeys;
        private final Map<String, X509Certificate[]> certChains;

        Manager(Map<String, PrivateKey> privateKeys, Map<String, X509Certificate[]> certChains) {
            this.privateKeys = privateKeys;
            this.certChains = certChains;
        }

        @Override
        public String chooseClientAlias(String[] keyTypes, Principal[] issuers, Socket socket) {
            int i = 0;
            while (i < keyTypes.length) {
                String[] s = this.getClientAliases(keyTypes[i], issuers);
                if (s.length > 0) {
                    return s[0];
                }
                ++i;
            }
            return null;
        }

        @Override
        public String chooseEngineClientAlias(String[] keyTypes, Principal[] issuers, SSLEngine engine) {
            String[] stringArray = keyTypes;
            int n = keyTypes.length;
            int n2 = 0;
            while (n2 < n) {
                String type = stringArray[n2];
                String[] s = this.getClientAliases(type, issuers);
                if (s.length > 0) {
                    return s[0];
                }
                ++n2;
            }
            return null;
        }

        @Override
        public String[] getClientAliases(String keyType, Principal[] issuers) {
            return this.getAliases(keyType, issuers);
        }

        @Override
        public String chooseServerAlias(String keyType, Principal[] issuers, Socket socket) {
            String[] s = this.getServerAliases(keyType, issuers);
            if (s.length > 0) {
                return s[0];
            }
            return null;
        }

        @Override
        public String chooseEngineServerAlias(String keyType, Principal[] issuers, SSLEngine engine) {
            String[] s = this.getServerAliases(keyType, issuers);
            if (s.length > 0) {
                return s[0];
            }
            return null;
        }

        @Override
        public String[] getServerAliases(String keyType, Principal[] issuers) {
            return this.getAliases(keyType, issuers);
        }

        private String[] getAliases(String keyType, Principal[] issuers) {
            LinkedList<String> l = new LinkedList<String>();
            block0: for (String alias : this.privateKeys.keySet()) {
                PrivateKey privKey;
                X509Certificate[] chain = this.getCertificateChain(alias);
                if (chain.length == 0 || (privKey = this.getPrivateKey(alias)) == null) continue;
                PublicKey pubKey = chain[0].getPublicKey();
                if (keyType.equalsIgnoreCase("RSA") || keyType.equalsIgnoreCase("DHE_RSA") || keyType.equalsIgnoreCase("SRP_RSA") || keyType.equalsIgnoreCase("rsa_sign") || keyType.equalsIgnoreCase("RSA_PSK")) {
                    if (!(privKey instanceof RSAPrivateKey) || !(pubKey instanceof RSAPublicKey)) {
                        continue;
                    }
                } else if (keyType.equalsIgnoreCase("DHE_DSS") || keyType.equalsIgnoreCase("dss_sign") || keyType.equalsIgnoreCase("SRP_DSS") || keyType.equalsIgnoreCase("DSA")) {
                    if (!(privKey instanceof DSAPrivateKey) || !(pubKey instanceof DSAPublicKey)) {
                        continue;
                    }
                } else if (!keyType.equalsIgnoreCase("DH_RSA") && !keyType.equalsIgnoreCase("rsa_fixed_dh") ? !keyType.equalsIgnoreCase("DH_DSS") && !keyType.equalsIgnoreCase("dss_fixed_dh") || !(privKey instanceof DHPrivateKey) || !(pubKey instanceof DHPublicKey) || !chain[0].getSigAlgName().equalsIgnoreCase("DSA") : !(privKey instanceof DHPrivateKey) || !(pubKey instanceof DHPublicKey) || !chain[0].getSigAlgName().equalsIgnoreCase("RSA")) continue;
                if (issuers == null || issuers.length == 0) {
                    l.add(alias);
                    continue;
                }
                Principal[] principalArray = issuers;
                int n = issuers.length;
                int n2 = 0;
                while (n2 < n) {
                    Principal issuer = principalArray[n2];
                    if (chain[0].getIssuerDN().equals(issuer)) {
                        l.add(alias);
                        continue block0;
                    }
                    ++n2;
                }
            }
            return l.toArray((S[])new String[l.size()]);
        }

        @Override
        public X509Certificate[] getCertificateChain(String alias) {
            X509Certificate[] c = this.certChains.get(alias);
            return c != null ? (X509Certificate[])c.clone() : null;
        }

        @Override
        public PrivateKey getPrivateKey(String alias) {
            return this.privateKeys.get(alias);
        }
    }
}

