/*
 * Decompiled with CFR 0.152.
 */
package gnu.java.security.sig.rsa;

import gnu.java.security.hash.HashFactory;
import gnu.java.security.hash.IMessageDigest;
import gnu.java.security.sig.ISignature;
import gnu.java.security.sig.rsa.RSAPKCS1V1_5Signature;
import gnu.java.security.sig.rsa.RSAPSSSignature;
import java.util.Collections;
import java.util.HashSet;
import java.util.Set;

public class RSASignatureFactory {
    private static Set names;

    private RSASignatureFactory() {
    }

    public static final ISignature getInstance(String name) {
        if (name == null) {
            return null;
        }
        if ((name = name.trim()).length() == 0) {
            return null;
        }
        if (!(name = name.toLowerCase()).startsWith("rsa-")) {
            return null;
        }
        if ((name = name.substring("rsa-".length()).trim()).startsWith("pss")) {
            return RSASignatureFactory.getPSSSignature(name);
        }
        if (name.startsWith("pkcs1-v1.5")) {
            return RSASignatureFactory.getPKCS1Signature(name);
        }
        return null;
    }

    public static final synchronized Set getNames() {
        if (names == null) {
            Set hashNames = HashFactory.getNames();
            HashSet<String> hs = new HashSet<String>();
            for (String mdName : hashNames) {
                hs.add("rsa-pss-" + mdName);
            }
            hs.add("rsa-pkcs1-v1.5-md2");
            hs.add("rsa-pkcs1-v1.5-md5");
            hs.add("rsa-pkcs1-v1.5-sha-160");
            hs.add("rsa-pkcs1-v1.5-sha-256");
            hs.add("rsa-pkcs1-v1.5-sha-384");
            hs.add("rsa-pkcs1-v1.5-sha-512");
            names = Collections.unmodifiableSet(hs);
        }
        return names;
    }

    private static final ISignature getPSSSignature(String name) {
        IMessageDigest md;
        if ((name = name.substring("pss".length()).trim()).startsWith("-")) {
            name = name.substring(1).trim();
        }
        if (name.length() == 0) {
            md = HashFactory.getInstance("sha-160");
        } else {
            md = HashFactory.getInstance(name);
            if (md == null) {
                return null;
            }
        }
        RSAPSSSignature result = new RSAPSSSignature(md, 0);
        return result;
    }

    private static final ISignature getPKCS1Signature(String name) {
        IMessageDigest md;
        if ((name = name.substring("pkcs1-v1.5".length()).trim()).startsWith("-")) {
            name = name.substring(1).trim();
        }
        if (name.length() == 0) {
            md = HashFactory.getInstance("sha-160");
        } else {
            md = HashFactory.getInstance(name);
            if (md == null) {
                return null;
            }
        }
        RSAPKCS1V1_5Signature result = new RSAPKCS1V1_5Signature(md);
        return result;
    }
}

