/*
 * Decompiled with CFR 0.152.
 */
package gnu.xml.validation.datatype;

import gnu.xml.validation.datatype.AtomicSimpleType;
import gnu.xml.validation.datatype.TypeLibrary;
import java.util.Arrays;
import java.util.Set;
import java.util.TreeSet;
import javax.xml.namespace.QName;
import org.relaxng.datatype.DatatypeException;
import org.relaxng.datatype.ValidationContext;

final class DoubleType
extends AtomicSimpleType {
    static final int[] CONSTRAINING_FACETS = new int[]{4, 5, 6, 7, 8, 10, 9};
    static final Set SPECIAL = new TreeSet<String>(Arrays.asList("INF", "-INF", "NaN"));

    DoubleType() {
        super(new QName("http://www.w3.org/2001/XMLSchema", "double"), TypeLibrary.ANY_SIMPLE_TYPE);
    }

    public int[] getConstrainingFacets() {
        return CONSTRAINING_FACETS;
    }

    public void checkValid(String value, ValidationContext context) throws DatatypeException {
        super.checkValid(value, context);
        if (SPECIAL.contains(value)) {
            return;
        }
        try {
            Double.parseDouble(value);
        }
        catch (NumberFormatException e) {
            DatatypeException e2 = new DatatypeException("invalid double value");
            e2.initCause(e);
            throw e2;
        }
    }

    public Object createValue(String literal, ValidationContext context) {
        try {
            return new Double(literal);
        }
        catch (NumberFormatException numberFormatException) {
            return null;
        }
    }
}

