/*
 * Decompiled with CFR 0.152.
 */
package gnu.javax.imageio.bmp;

import gnu.javax.imageio.bmp.BMPDecoder;
import gnu.javax.imageio.bmp.BMPException;
import gnu.javax.imageio.bmp.BMPFileHeader;
import gnu.javax.imageio.bmp.BMPInfoHeader;
import java.awt.Dimension;
import java.awt.image.BufferedImage;
import java.awt.image.DataBufferByte;
import java.awt.image.IndexColorModel;
import java.awt.image.MultiPixelPackedSampleModel;
import java.awt.image.Raster;
import java.awt.image.WritableRaster;
import java.io.IOException;
import javax.imageio.stream.ImageInputStream;

public class DecodeRGB1
extends BMPDecoder {
    public DecodeRGB1(BMPFileHeader fh, BMPInfoHeader ih) {
        super(fh, ih);
    }

    public BufferedImage decode(ImageInputStream in) throws IOException, BMPException {
        IndexColorModel palette = this.readPalette(in);
        this.skipToImage(in);
        Dimension d = this.infoHeader.getSize();
        int h = (int)d.getHeight();
        int w = (int)d.getWidth();
        int size = w * h >> 3;
        int scansize = w >> 3;
        byte[] data = new byte[size];
        int y = h - 1;
        while (y >= 0) {
            byte[] scanline;
            int readsize = scansize;
            if ((readsize & 3) != 0) {
                readsize += 4 - (scansize & 3);
            }
            if (in.read(scanline = new byte[readsize]) != readsize) {
                throw new IOException("Couldn't read image data.");
            }
            int x = 0;
            while (x < scansize) {
                data[x + y * scansize] = scanline[x];
                ++x;
            }
            --y;
        }
        MultiPixelPackedSampleModel sm = new MultiPixelPackedSampleModel(0, w, h, 1);
        DataBufferByte db = new DataBufferByte(data, size, 0);
        WritableRaster raster = Raster.createWritableRaster(sm, db, null);
        return new BufferedImage(palette, raster, false, null);
    }
}

