/*
 * Decompiled with CFR 0.152.
 */
package gnu.java.util;

import java.io.EOFException;
import java.io.IOException;
import java.io.InputStream;
import java.util.Date;
import java.util.GregorianCalendar;
import java.util.SimpleTimeZone;
import java.util.TimeZone;

public class ZoneInfo
extends TimeZone {
    private static final int SECS_SHIFT = 22;
    private static final long OFFSET_MASK = 0x1FFFFFL;
    private static final int OFFSET_SHIFT = 43;
    private static final long IS_DST = 0x200000L;
    private int rawOffset;
    private int dstSavings;
    private boolean useDaylight;
    private long[] transitions;
    private SimpleTimeZone lastRule;
    private static SimpleTimeZone gmtZone = null;
    static final long serialVersionUID = -3740626706860383657L;

    public ZoneInfo(int rawOffset, String id, long[] transitions, SimpleTimeZone lastRule) {
        if (transitions == null || transitions.length < 1) {
            throw new IllegalArgumentException("transitions must not be null");
        }
        if (lastRule == null) {
            throw new IllegalArgumentException("lastRule must not be null");
        }
        this.rawOffset = rawOffset;
        this.transitions = transitions;
        this.lastRule = lastRule;
        this.setID(id);
        this.computeDSTSavings();
    }

    public int getOffset(int era, int year, int month, int day, int dayOfWeek, int millis) {
        if (gmtZone == null) {
            gmtZone = new SimpleTimeZone(0, "GMT");
        }
        if (dayOfWeek < 1 || dayOfWeek > 7) {
            throw new IllegalArgumentException("dayOfWeek out of range");
        }
        if (month < 0 || month > 11) {
            throw new IllegalArgumentException("month out of range:" + month);
        }
        if (era != 1) {
            return (int)((this.transitions[0] << 43 >> 43) * 1000L);
        }
        GregorianCalendar cal = new GregorianCalendar(gmtZone);
        cal.set(year, month, day, 0, 0, 0);
        if (cal.get(5) != day) {
            throw new IllegalArgumentException("day out of range");
        }
        return this.getOffset(cal.getTimeInMillis() - (long)this.rawOffset + (long)millis);
    }

    private long findTransition(long secs) {
        if (secs < this.transitions[0] >> 22) {
            return this.transitions[0];
        }
        if (secs >= this.transitions[this.transitions.length - 1] >> 22) {
            return Long.MAX_VALUE;
        }
        long val = secs + 1L << 22;
        int lo = 1;
        int hi = this.transitions.length;
        int mid = 1;
        while (lo < hi) {
            mid = (lo + hi) / 2;
            if (val <= this.transitions[mid - 1]) {
                hi = mid;
                continue;
            }
            if (val <= this.transitions[mid]) break;
            lo = mid + 1;
        }
        return this.transitions[mid];
    }

    public int getOffset(long date) {
        long d = date >= 0L ? date / 1000L : (date + 1L) / 1000L - 1L;
        long transition = this.findTransition(d);
        if (transition == Long.MAX_VALUE) {
            return this.lastRule.getOffset(date);
        }
        return (int)((transition << 43 >> 43) * 1000L);
    }

    public int getRawOffset() {
        return this.rawOffset;
    }

    public void setRawOffset(int rawOffset) {
        this.rawOffset = rawOffset;
        this.lastRule.setRawOffset(rawOffset);
    }

    private void computeDSTSavings() {
        if (this.lastRule.useDaylightTime()) {
            this.dstSavings = this.lastRule.getDSTSavings();
            this.useDaylight = true;
        } else {
            this.dstSavings = 0;
            this.useDaylight = false;
            long currentSecs = System.currentTimeMillis() / 1000L;
            int i = this.transitions.length - 1;
            while (i >= 0 && currentSecs < this.transitions[i] >> 22) {
                if ((this.transitions[i] & 0x200000L) != 0L) {
                    this.dstSavings = (int)((this.transitions[i] << 43 >> 43) * 1000L) - this.rawOffset;
                    this.useDaylight = true;
                    break;
                }
                --i;
            }
        }
    }

    public int getDSTSavings() {
        return this.dstSavings;
    }

    public boolean useDaylightTime() {
        return this.useDaylight;
    }

    public boolean inDaylightTime(Date date) {
        long d = date.getTime();
        d = d >= 0L ? d / 1000L : (d + 1L) / 1000L - 1L;
        long transition = this.findTransition(d);
        if (transition == Long.MAX_VALUE) {
            return this.lastRule.inDaylightTime(date);
        }
        return (transition & 0x200000L) != 0L;
    }

    public synchronized int hashCode() {
        int hash = this.lastRule.hashCode();
        return hash;
    }

    public synchronized boolean equals(Object o) {
        if (!this.hasSameRules((TimeZone)o)) {
            return false;
        }
        ZoneInfo zone = (ZoneInfo)o;
        return this.getID().equals(zone.getID());
    }

    public boolean hasSameRules(TimeZone o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof ZoneInfo)) {
            return false;
        }
        ZoneInfo zone = (ZoneInfo)o;
        if (zone.hashCode() != this.hashCode() || this.rawOffset != zone.rawOffset) {
            return false;
        }
        return this.lastRule.equals(zone.lastRule);
    }

    public String toString() {
        return String.valueOf(this.getClass().getName()) + "[" + "id=" + this.getID() + ",offset=" + this.rawOffset + ",transitions=" + this.transitions.length + ",useDaylight=" + this.useDaylight + (this.useDaylight ? ",dstSavings=" + this.dstSavings : "") + ",lastRule=" + this.lastRule.toString() + "]";
    }

    /*
     * Exception decompiling
     */
    public static TimeZone readTZFile(String id, String file) {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Tried to end blocks [2[TRYBLOCK]], but top level block is 33[WHILELOOP]
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.processEndingBlocks(Op04StructuredStatement.java:435)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:484)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    private static void skipFully(InputStream is, long l) throws IOException {
        while (l > 0L) {
            long k = is.skip(l);
            if (k <= 0L) {
                throw new EOFException();
            }
            l -= k;
        }
    }

    private static SimpleTimeZone createLastRule(String tzstr) {
        String stdName = null;
        try {
            int dstOffs;
            char c;
            int idLength = tzstr.length();
            int index = 0;
            while ((c = tzstr.charAt(index)) != '+' && c != '-' && c != ',' && c != ':' && !Character.isDigit(c) && c != '\u0000' && ++index < idLength) {
            }
            if (index >= idLength) {
                return new SimpleTimeZone(0, tzstr);
            }
            stdName = tzstr.substring(0, index);
            int prevIndex = index;
            while (((c = tzstr.charAt(index++)) == '-' || c == '+' || c == ':' || Character.isDigit(c)) && index < idLength) {
            }
            if (index < idLength) {
                --index;
            }
            String offset = tzstr.substring(prevIndex, index);
            prevIndex = index;
            int stdOffs = offset.charAt(0) == '+' || offset.charAt(0) == '-' ? ZoneInfo.parseTime(offset.substring(1)) : ZoneInfo.parseTime(offset);
            if (offset.charAt(0) == '-') {
                stdOffs = -stdOffs;
            }
            stdOffs = -stdOffs;
            if (index >= idLength) {
                return new SimpleTimeZone(stdOffs, stdName);
            }
            while ((c = tzstr.charAt(index)) != '+' && c != '-' && c != ',' && c != ':' && !Character.isDigit(c) && c != '\u0000' && ++index < idLength) {
            }
            if (index >= idLength) {
                return new SimpleTimeZone(stdOffs, stdName);
            }
            prevIndex = index;
            while (((c = tzstr.charAt(index++)) == '-' || c == '+' || c == ':' || Character.isDigit(c)) && index < idLength) {
            }
            if (index < idLength) {
                --index;
            }
            if (index == prevIndex && (c == ',' || c == ';')) {
                dstOffs = stdOffs + 3600000;
            } else {
                offset = tzstr.substring(prevIndex, index);
                prevIndex = index;
                dstOffs = offset.charAt(0) == '+' || offset.charAt(0) == '-' ? ZoneInfo.parseTime(offset.substring(1)) : ZoneInfo.parseTime(offset);
                if (offset.charAt(0) == '-') {
                    dstOffs = -dstOffs;
                }
                dstOffs = -dstOffs;
            }
            if (index >= idLength) {
                return new SimpleTimeZone(stdOffs, stdName);
            }
            if (tzstr.charAt(index) == ',' || tzstr.charAt(index) == ';') {
                int endMillis;
                String endDate;
                int startMillis;
                String startDate;
                int offs = ++index;
                while (tzstr.charAt(index) != ',' && tzstr.charAt(index) != ';') {
                    ++index;
                }
                String startTime = tzstr.substring(offs, index);
                String endTime = tzstr.substring(++index);
                index = startTime.indexOf(47);
                if (index != -1) {
                    startDate = startTime.substring(0, index);
                    startMillis = ZoneInfo.parseTime(startTime.substring(index + 1));
                } else {
                    startDate = startTime;
                    startMillis = 0x6DDD00;
                }
                index = endTime.indexOf(47);
                if (index != -1) {
                    endDate = endTime.substring(0, index);
                    endMillis = ZoneInfo.parseTime(endTime.substring(index + 1));
                } else {
                    endDate = endTime;
                    endMillis = 0x6DDD00;
                }
                int[] start = ZoneInfo.getDateParams(startDate);
                int[] end = ZoneInfo.getDateParams(endDate);
                return new SimpleTimeZone(stdOffs, tzstr, start[0], start[1], start[2], startMillis, end[0], end[1], end[2], endMillis, dstOffs - stdOffs);
            }
        }
        catch (IndexOutOfBoundsException indexOutOfBoundsException) {
        }
        catch (NumberFormatException numberFormatException) {}
        return null;
    }

    private static int[] getDateParams(String date) {
        int julianDay;
        int[] nArray = new int[12];
        nArray[1] = 31;
        nArray[2] = 59;
        nArray[3] = 90;
        nArray[4] = 120;
        nArray[5] = 151;
        nArray[6] = 181;
        nArray[7] = 212;
        nArray[8] = 243;
        nArray[9] = 273;
        nArray[10] = 304;
        nArray[11] = 334;
        int[] dayCount = nArray;
        int type = 0;
        if (date.charAt(0) == 'M' || date.charAt(0) == 'm') {
            type = 1;
        } else if (date.charAt(0) == 'A' || date.charAt(0) == 'a') {
            type = 2;
        }
        if (type > 0) {
            int day;
            int month = Integer.parseInt(date.substring(1, date.indexOf(46)));
            int week = Integer.parseInt(date.substring(date.indexOf(46) + 1, date.lastIndexOf(46)));
            int dayOfWeek = Integer.parseInt(date.substring(date.lastIndexOf(46) + 1));
            ++dayOfWeek;
            if (type == 2) {
                day = week;
                dayOfWeek = -dayOfWeek;
            } else if (week == 5) {
                day = -1;
            } else {
                day = (week - 1) * 7 + 1;
                dayOfWeek = -dayOfWeek;
            }
            return new int[]{--month, day, dayOfWeek};
        }
        if (date.charAt(0) != 'J' || date.charAt(0) != 'j') {
            julianDay = Integer.parseInt(date.substring(1));
            ++julianDay;
            int[] nArray2 = new int[12];
            nArray2[1] = 31;
            nArray2[2] = 60;
            nArray2[3] = 91;
            nArray2[4] = 121;
            nArray2[5] = 152;
            nArray2[6] = 182;
            nArray2[7] = 213;
            nArray2[8] = 244;
            nArray2[9] = 274;
            nArray2[10] = 305;
            nArray2[11] = 335;
            dayCount = nArray2;
        } else {
            julianDay = Integer.parseInt(date);
        }
        int i = 11;
        while (i > 0) {
            if (dayCount[i] < julianDay) break;
            --i;
        }
        int month = i;
        int[] nArray3 = new int[3];
        nArray3[0] = month;
        nArray3[1] = julianDay -= dayCount[i];
        return nArray3;
    }

    private static int parseTime(String time) {
        int millis = 0;
        int i = 0;
        while (i < time.length()) {
            if (time.charAt(i) == ':') break;
            ++i;
        }
        millis = 3600000 * Integer.parseInt(time.substring(0, i));
        if (i >= time.length()) {
            return millis;
        }
        int iprev = ++i;
        while (i < time.length()) {
            if (time.charAt(i) == ':') break;
            ++i;
        }
        millis += 60000 * Integer.parseInt(time.substring(iprev, i));
        if (i >= time.length()) {
            return millis;
        }
        return millis += 1000 * Integer.parseInt(time.substring(++i));
    }
}

