/*
 * Decompiled with CFR 0.152.
 */
package gnu.java.security.sig.rsa;

import gnu.java.security.hash.HashFactory;
import gnu.java.security.hash.IMessageDigest;
import gnu.java.security.sig.BaseSignature;
import gnu.java.security.sig.rsa.EMSA_PSS;
import gnu.java.security.sig.rsa.RSA;
import java.math.BigInteger;
import java.security.PrivateKey;
import java.security.PublicKey;
import java.security.interfaces.RSAPrivateKey;
import java.security.interfaces.RSAPublicKey;
import java.util.logging.Logger;

public class RSAPSSSignature
extends BaseSignature {
    private static final Logger log = null;
    private EMSA_PSS pss;
    private int sLen;

    public RSAPSSSignature() {
        this("sha-160", 0);
    }

    public RSAPSSSignature(String mdName) {
        this(mdName, 0);
    }

    public RSAPSSSignature(String mdName, int sLen) {
        this(HashFactory.getInstance(mdName), sLen);
    }

    public RSAPSSSignature(IMessageDigest md, int sLen) {
        super("rsa-pss", md);
        this.pss = EMSA_PSS.getInstance(md.name());
        this.sLen = sLen;
    }

    private RSAPSSSignature(RSAPSSSignature that) {
        this(that.md.name(), that.sLen);
        this.publicKey = that.publicKey;
        this.privateKey = that.privateKey;
        this.md = (IMessageDigest)that.md.clone();
        this.pss = (EMSA_PSS)that.pss.clone();
    }

    public Object clone() {
        return new RSAPSSSignature(this);
    }

    protected void setupForVerification(PublicKey k) throws IllegalArgumentException {
        if (!(k instanceof RSAPublicKey)) {
            throw new IllegalArgumentException();
        }
        this.publicKey = (RSAPublicKey)k;
    }

    protected void setupForSigning(PrivateKey k) throws IllegalArgumentException {
        if (!(k instanceof RSAPrivateKey)) {
            throw new IllegalArgumentException();
        }
        this.privateKey = (RSAPrivateKey)k;
    }

    protected Object generateSignature() throws IllegalStateException {
        int modBits = ((RSAPrivateKey)this.privateKey).getModulus().bitLength();
        byte[] salt = new byte[this.sLen];
        this.nextRandomBytes(salt);
        byte[] EM = this.pss.encode(this.md.digest(), modBits - 1, salt);
        BigInteger m = new BigInteger(1, EM);
        BigInteger s = RSA.sign(this.privateKey, m);
        int k = (modBits + 7) / 8;
        return RSA.I2OSP(s, k);
    }

    protected boolean verifySignature(Object sig) throws IllegalStateException {
        if (this.publicKey == null) {
            throw new IllegalStateException();
        }
        byte[] S = (byte[])sig;
        int modBits = ((RSAPublicKey)this.publicKey).getModulus().bitLength();
        int k = (modBits + 7) / 8;
        if (S.length != k) {
            return false;
        }
        BigInteger s = new BigInteger(1, S);
        BigInteger m = null;
        try {
            m = RSA.verify(this.publicKey, s);
        }
        catch (IllegalArgumentException illegalArgumentException) {
            return false;
        }
        int emBits = modBits - 1;
        int emLen = (emBits + 7) / 8;
        byte[] EM = m.toByteArray();
        if (EM.length > emLen) {
            return false;
        }
        if (EM.length < emLen) {
            byte[] newEM = new byte[emLen];
            System.arraycopy(EM, 0, newEM, emLen - EM.length, EM.length);
            EM = newEM;
        }
        byte[] mHash = this.md.digest();
        boolean result = false;
        try {
            result = this.pss.decode(mHash, EM, emBits, this.sLen);
        }
        catch (IllegalArgumentException illegalArgumentException) {
            result = false;
        }
        return result;
    }
}

