/*
 * Decompiled with CFR 0.152.
 */
package gnu.java.lang.reflect;

import gnu.java.lang.reflect.GenericArrayTypeImpl;
import gnu.java.lang.reflect.ParameterizedTypeImpl;
import gnu.java.lang.reflect.TypeVariableImpl;
import gnu.java.lang.reflect.UnresolvedTypeVariable;
import gnu.java.lang.reflect.WildcardTypeImpl;
import java.lang.reflect.GenericDeclaration;
import java.lang.reflect.GenericSignatureFormatError;
import java.lang.reflect.Type;
import java.lang.reflect.TypeVariable;
import java.util.ArrayList;

class GenericSignatureParser {
    private ClassLoader loader;
    private GenericDeclaration container;
    private String signature;
    private int pos;

    GenericSignatureParser(GenericDeclaration container, ClassLoader loader, String signature) {
        this.container = container;
        this.loader = loader;
        this.signature = signature;
    }

    TypeVariable[] readFormalTypeParameters() {
        this.consume('<');
        ArrayList<TypeVariable> params = new ArrayList<TypeVariable>();
        do {
            params.add(this.readFormalTypeParameter());
        } while (this.peekChar() != '>');
        this.consume('>');
        TypeVariable[] list2 = new TypeVariable[params.size()];
        params.toArray(list2);
        return list2;
    }

    private TypeVariable readFormalTypeParameter() {
        String identifier = this.readIdentifier();
        this.consume(':');
        ArrayList<Type> bounds = new ArrayList<Type>();
        if (this.peekChar() != ':') {
            bounds.add(this.readFieldTypeSignature());
        }
        while (this.peekChar() == ':') {
            this.consume(':');
            bounds.add(this.readFieldTypeSignature());
        }
        Type[] b = new Type[bounds.size()];
        bounds.toArray(b);
        return new TypeVariableImpl(this.container, b, identifier);
    }

    Type readFieldTypeSignature() {
        switch (this.peekChar()) {
            case 'L': {
                return this.readClassTypeSignature();
            }
            case '[': {
                return this.readArrayTypeSignature();
            }
            case 'T': {
                return this.readTypeVariableSignature();
            }
        }
        throw new GenericSignatureFormatError();
    }

    Type readClassTypeSignature() {
        String part;
        this.consume('L');
        String className = "";
        while (true) {
            part = this.readIdentifier();
            if (this.peekChar() != '/') break;
            this.consume('/');
            className = String.valueOf(className) + part + ".";
        }
        className = String.valueOf(className) + part;
        Type[] typeArguments = null;
        if (this.peekChar() == '<') {
            typeArguments = this.readTypeArguments();
        }
        ParameterizedTypeImpl type = new ParameterizedTypeImpl(className, this.loader, null, typeArguments);
        while (this.peekChar() == '.') {
            this.consume('.');
            className = String.valueOf(className) + "$" + this.readIdentifier();
            typeArguments = null;
            if (this.peekChar() == '<') {
                typeArguments = this.readTypeArguments();
            }
            type = new ParameterizedTypeImpl(className, this.loader, type, typeArguments);
        }
        this.consume(';');
        return type;
    }

    private Type[] readTypeArguments() {
        this.consume('<');
        ArrayList<Type> list2 = new ArrayList<Type>();
        do {
            list2.add(this.readTypeArgument());
        } while (this.peekChar() != '>');
        this.consume('>');
        Type[] arr = new Type[list2.size()];
        list2.toArray(arr);
        return arr;
    }

    private Type readTypeArgument() {
        char c = this.peekChar();
        if (c == '+') {
            this.consume('+');
            return new WildcardTypeImpl(null, this.readFieldTypeSignature());
        }
        if (c == '-') {
            this.consume('-');
            return new WildcardTypeImpl(this.readFieldTypeSignature(), (Type)((Object)Object.class));
        }
        if (c == '*') {
            this.consume('*');
            return new WildcardTypeImpl(null, (Type)((Object)Object.class));
        }
        return this.readFieldTypeSignature();
    }

    Type readArrayTypeSignature() {
        this.consume('[');
        switch (this.peekChar()) {
            case 'L': 
            case 'T': 
            case '[': {
                return new GenericArrayTypeImpl(this.readFieldTypeSignature());
            }
            case 'Z': {
                this.consume('Z');
                return boolean[].class;
            }
            case 'B': {
                this.consume('B');
                return byte[].class;
            }
            case 'S': {
                this.consume('S');
                return short[].class;
            }
            case 'C': {
                this.consume('C');
                return char[].class;
            }
            case 'I': {
                this.consume('I');
                return int[].class;
            }
            case 'F': {
                this.consume('F');
                return float[].class;
            }
            case 'J': {
                this.consume('J');
                return long[].class;
            }
            case 'D': {
                this.consume('D');
                return double[].class;
            }
        }
        throw new GenericSignatureFormatError();
    }

    Type readTypeVariableSignature() {
        this.consume('T');
        String identifier = this.readIdentifier();
        this.consume(';');
        return new UnresolvedTypeVariable(this.container, identifier);
    }

    private String readIdentifier() {
        char c;
        int start = this.pos;
        do {
            this.readChar();
        } while (";:./<>-+*".indexOf(c = this.peekChar()) == -1);
        return this.signature.substring(start, this.pos);
    }

    final char peekChar() {
        if (this.pos == this.signature.length()) {
            return '\u0000';
        }
        return this.signature.charAt(this.pos);
    }

    final char readChar() {
        return this.signature.charAt(this.pos++);
    }

    final void consume(char c) {
        if (this.readChar() != c) {
            throw new GenericSignatureFormatError();
        }
    }

    final void end() {
        if (this.pos != this.signature.length()) {
            throw new GenericSignatureFormatError();
        }
    }
}

