/*
 * Decompiled with CFR 0.152.
 */
package gnu.classpath.jdwp.event;

import gnu.classpath.jdwp.VMIdManager;
import gnu.classpath.jdwp.event.Event;
import gnu.classpath.jdwp.id.ReferenceTypeId;
import gnu.classpath.jdwp.id.ThreadId;
import gnu.classpath.jdwp.util.JdwpString;
import gnu.classpath.jdwp.util.Signature;
import java.io.DataOutputStream;
import java.io.IOException;

public class ClassPrepareEvent
extends Event {
    private Thread _thread;
    private Class _class;
    private int _status;
    public static final int STATUS_VERIFIED = 1;
    public static final int STATUS_PREPARED = 2;
    public static final int STATUS_INITIALIZED = 4;
    public static final int STATUS_ERROR = 8;

    public ClassPrepareEvent(Thread thread, Class clazz, int flags) {
        super((byte)8);
        this._thread = thread;
        this._class = clazz;
        this._status = flags;
    }

    public Object getParameter(int type) {
        if (type == 2) {
            return this._thread;
        }
        if (type == 1) {
            return this._class;
        }
        return null;
    }

    protected void _writeData(DataOutputStream outStream) throws IOException {
        VMIdManager idm = VMIdManager.getDefault();
        ThreadId tid = (ThreadId)idm.getObjectId(this._thread);
        ReferenceTypeId rid = idm.getReferenceTypeId(this._class);
        tid.write(outStream);
        rid.writeTagged(outStream);
        JdwpString.writeString(outStream, Signature.computeClassSignature(this._class));
        outStream.writeInt(this._status);
    }
}

