<?php

/**
 * This PHP file is the webapp auth api that gets loaded into an iframe
 * to allow it to integrate with configuration options from the webapp plugin
 */

include_once('../config.php');

$config = <<< heredoc
var config = (function() {
	if (!window.location.origin) {
		// Polyfill for IE which does not support location.origin.
		window.location.origin = window.location.protocol + "//" + window.location.hostname + (window.location.port ? ':' + window.location.port: '');
	}
	var spreedDomain = '%s';
	var webappDomain = '%s';
	var webappUrl = '%s';
	var webappAuthApiUrl = '%s';
	var webappAuthLoginUrl = '%s';
	var webappAuthAuthenticationUrl = '%s';
	var webappAuthTokenUrl = '%s';
	var webappAuthWebmeetingsDataUrl = '%s';
	return {
		spreedDomain: spreedDomain ? spreedDomain : window.location.origin,
		webappDomain: webappDomain ? webappDomain : window.location.origin,
		webappUrl: webappUrl ? webappUrl : '/webapp/',
		webappAuthApiUrl: webappAuthApiUrl ? webappAuthApiUrl : '/webapp/plugins/spreedwebrtc/php/webapp_auth_api.php',
		webappAuthLoginUrl: webappAuthLoginUrl ? webappAuthLoginUrl : '/webapp/plugins/spreedwebrtc/php/webapp_auth_login.php',
		webappAuthAuthenticationUrl: webappAuthAuthenticationUrl ? webappAuthAuthenticationUrl : '/webapp/plugins/spreedwebrtc/php/webapp_auth_auth.php',
		webappAuthTokenUrl: webappAuthTokenUrl ? webappAuthTokenUrl : '/webapp/plugins/spreedwebrtc/php/webapp_auth_token.php',
		webappAuthWebmeetingsDataUrl: webappAuthWebmeetingsDataUrl ? webappAuthWebmeetingsDataUrl : '/webapp/plugins/spreedwebrtc/php/webapp_auth_userinfo.php',
		requireAuthentication: %b
	}
})();
heredoc;

$jsconfig = sprintf($config,
	PLUGIN_SPREEDWEBRTC_SPREED_DOMAIN,                                                         // spreedDomain
	PLUGIN_SPREEDWEBRTC_WEBAPP_DOMAIN,                                                         // webappDomain
	PLUGIN_SPREEDWEBRTC_WEBAPP_URL,                                                            // webappUrl
	PLUGIN_SPREEDWEBRTC_WEBAPP_URL . 'plugins/spreedwebrtc/php/webapp_auth_api.php',           // webappAuthApiUrl
	PLUGIN_SPREEDWEBRTC_WEBAPP_URL . 'plugins/spreedwebrtc/php/webapp_auth_login.php',         // webappAuthLoginUrl
	PLUGIN_SPREEDWEBRTC_WEBAPP_URL . 'plugins/spreedwebrtc/php/webapp_auth_auth.php',          // webappAuthAuthenticationUrl
	PLUGIN_SPREEDWEBRTC_WEBAPP_URL . 'plugins/spreedwebrtc/php/webapp_auth_token.php',         // webappAuthTokenUrl
	PLUGIN_SPREEDWEBRTC_WEBAPP_URL . 'plugins/spreedwebrtc/php/webapp_auth_userinfo.php',      // webappAuthWebmeetingsDataUrl
	PLUGIN_SPREEDWEBRTC_REQUIRE_AUTHENTICATION) . "\n";                                        // requireAuthentication

define('PLUGIN_SPREEDWEBRTC_JS_CONFIG', $jsconfig);

?>