/*
 * Decompiled with CFR 0.152.
 */
package org.pentaho.di.core.database;

import org.pentaho.di.core.Const;
import org.pentaho.di.core.database.Database;
import org.pentaho.di.core.database.DatabaseFactoryInterface;
import org.pentaho.di.core.database.DatabaseMeta;
import org.pentaho.di.core.database.Messages;
import org.pentaho.di.core.database.PartitionDatabaseMeta;
import org.pentaho.di.core.exception.KettleDatabaseException;
import org.pentaho.di.core.exception.KettleException;

public class DatabaseFactory
implements DatabaseFactoryInterface {
    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String getConnectionTestReport(DatabaseMeta databaseMeta) throws KettleDatabaseException {
        if (databaseMeta.getAccessType() != 3) {
            StringBuffer report = new StringBuffer();
            Database db = new Database(databaseMeta);
            if (databaseMeta.isPartitioned()) {
                PartitionDatabaseMeta[] partitioningInformation = databaseMeta.getPartitioningInformation();
                for (int i = 0; i < partitioningInformation.length; ++i) {
                    Object var8_8;
                    try {
                        try {
                            db.connect(partitioningInformation[i].getPartitionId());
                            report.append(Messages.getString("DatabaseMeta.report.ConnectionWithPartOk", databaseMeta.getName(), partitioningInformation[i].getPartitionId()) + Const.CR);
                        }
                        catch (KettleException e) {
                            report.append(Messages.getString("DatabaseMeta.report.ConnectionWithPartError", databaseMeta.getName(), partitioningInformation[i].getPartitionId(), e.toString()) + Const.CR);
                            report.append(Const.getStackTracker((Throwable)e) + Const.CR);
                            var8_8 = null;
                            db.disconnect();
                        }
                        var8_8 = null;
                        db.disconnect();
                    }
                    catch (Throwable throwable) {
                        var8_8 = null;
                        db.disconnect();
                        throw throwable;
                    }
                    this.appendConnectionInfo(report, db.environmentSubstitute(partitioningInformation[i].getHostname()), db.environmentSubstitute(partitioningInformation[i].getPort()), db.environmentSubstitute(partitioningInformation[i].getDatabaseName()));
                    report.append(Const.CR);
                }
            } else {
                try {
                    try {
                        db.connect();
                        report.append(Messages.getString("DatabaseMeta.report.ConnectionOk", databaseMeta.getName()) + Const.CR);
                    }
                    catch (KettleException e) {
                        report.append(Messages.getString("DatabaseMeta.report.ConnectionError", databaseMeta.getName()) + e.toString() + Const.CR);
                        report.append(Const.getStackTracker((Throwable)e) + Const.CR);
                        Object var10_11 = null;
                        db.disconnect();
                    }
                    Object var10_10 = null;
                    db.disconnect();
                }
                catch (Throwable throwable) {
                    Object var10_12 = null;
                    db.disconnect();
                    throw throwable;
                }
                this.appendConnectionInfo(report, db.environmentSubstitute(databaseMeta.getHostname()), db.environmentSubstitute(databaseMeta.getDatabasePortNumberString()), db.environmentSubstitute(databaseMeta.getDatabaseName()));
                report.append(Const.CR);
            }
            return report.toString();
        }
        return Messages.getString("BaseDatabaseMeta.TestConnectionReportNotImplemented.Message");
    }

    private StringBuffer appendConnectionInfo(StringBuffer report, String hostName, String portNumber, String dbName) {
        report.append(Messages.getString("DatabaseMeta.report.Hostname")).append(hostName).append(Const.CR);
        report.append(Messages.getString("DatabaseMeta.report.Port")).append(portNumber).append(Const.CR);
        report.append(Messages.getString("DatabaseMeta.report.DatabaseName")).append(dbName).append(Const.CR);
        return report;
    }
}

