/*  GNU Moe - My Own Editor
    Copyright (C) 2005, 2006, 2007, 2008, 2009, 2010, 2011, 2012, 2013,
    2014 Antonio Diaz Diaz.

    This program is free software: you can redistribute it and/or modify
    it under the terms of the GNU General Public License as published by
    the Free Software Foundation, either version 3 of the License, or
    (at your option) any later version.

    This program is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
    GNU General Public License for more details.

    You should have received a copy of the GNU General Public License
    along with this program.  If not, see <http://www.gnu.org/licenses/>.
*/

namespace Window_vector {

int init();
int load( int new_size = 0 );

void bufhandle_menu( const int abort_key );
void change_buffer_name();
void load_file( const int abort_key );
void split_window();
void save_file( const int abort_key );
int close( bool abort, const bool quiet = false );
int close_and_exit( const bool abort );

Window & curwin();
void last_visited();
void next();
void prev();
Window & window( int i );
int windows();

void add_char( const int key, const bool force = false );
void delete_char( const bool back = false );
void delete_line();
void copy_block();
void delete_block();
void move_block();
void read_block();
void write_block();
void indent_block();
void unindent_block();
void undo();
void redo();

void center_line();
void reformat();
void change_case( const bool to_caps );
void encode_base64();
void decode_base64();
void encode_utf8();
void decode_quoted_printable_utf8( const bool mode_q );
void encode_rot1347( const bool mode13 );
void remove_duplicate_lines( const bool back = false );

const char * copyright_update();
const char * search_word( const int abort_key );
const char * search( const int abort_key, const bool again = false,
                     const std::string & s_ini = "",
                     const bool toggle = false );

} // end namespace Window_vector
