#| -*-Scheme-*-

Copyright (C) 1986, 1987, 1988, 1989, 1990, 1991, 1992, 1993, 1994,
    1995, 1996, 1997, 1998, 1999, 2000, 2001, 2002, 2003, 2004, 2005,
    2006, 2007, 2008, 2009, 2010, 2011, 2012, 2013, 2014, 2015, 2016,
    2017, 2018 Massachusetts Institute of Technology

This file is part of MIT/GNU Scheme.

MIT/GNU Scheme is free software; you can redistribute it and/or modify
it under the terms of the GNU General Public License as published by
the Free Software Foundation; either version 2 of the License, or (at
your option) any later version.

MIT/GNU Scheme is distributed in the hope that it will be useful, but
WITHOUT ANY WARRANTY; without even the implied warranty of
MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
General Public License for more details.

You should have received a copy of the GNU General Public License
along with MIT/GNU Scheme; if not, write to the Free Software
Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA 02110-1301,
USA.

|#

;;;; UCD property: suc (simple-upper-case)

;;; Generated from Unicode 9.0.0

(declare (usual-integrations))

(define (ucd-suc-value char)
  (or (let ((sv (char->integer char)))
        (vector-ref ucd-suc-table-5 (bytevector-u16be-ref ucd-suc-table-4 (fix:lsh (fix:or (fix:lsh (bytevector-u8-ref ucd-suc-table-3 (fix:or (fix:lsh (bytevector-u8-ref ucd-suc-table-2 (fix:or (fix:lsh (bytevector-u8-ref ucd-suc-table-1 (fix:or (fix:lsh (bytevector-u8-ref ucd-suc-table-0 (fix:lsh sv -16)) 4) (fix:and 15 (fix:lsh sv -12)))) 4) (fix:and 15 (fix:lsh sv -8)))) 4) (fix:and 15 (fix:lsh sv -4)))) 4) (fix:and 15 sv)) 1))))
      char))

(define-deferred ucd-suc-table-0
  (vector->bytevector '#(0 1 2 2 2 2 2 2 2 2 2 2 2 2 2 2 2)))

(define-deferred ucd-suc-table-1
  (vector->bytevector '#(0 1 2 3 3 3 3 3 3 3 4 3 3 3 3 5 6 7 3 3 3 3 3 3 3 3 3 3 3 3 8 3 3 3 3 3 3 3 3 3 3 3 3 3 3 3 3 3)))

(define-deferred ucd-suc-table-2
  (vector->bytevector '#(0 1 2 3 4 5 6 6 6 6 6 6 6 6 6 6 6 6 6 7 6 6 6 6 6 6 6 6 8 9 10 11 6 12 6 6 13 6 6 6 6 6 6 6 14 15 6 6 6 6 6 6 6 6 6 6 6 6 6 6 6 6 6 6 6 6 6 6 6 6 16 17 6 6 6 18 6 6 6 6 6 6 6 6 6 6 6 6 6 6 6 6 6 6 6 19 6 6 6 6 20 6 6 6 6 6 6 6 21 6 6 6 6 6 6 6 6 6 6 6 22 6 6 6 6 6 6 6 6 6 6 6 6 6 6 6 6 23 6 6 6 6 6 6)))

(define-deferred ucd-suc-table-3
  (vector->bytevector '#(0 0 0 0 0 0 1 2 0 0 0 3 0 0 4 5 6 7 8 9 10 11 12 13 14 15 16 17 18 19 20 21 22 23 24 25 26 27 28 29 30 31 0 0 0 0 0 0 0 0 0 0 32 0 0 33 0 0 34 35 36 37 38 39 0 0 0 40 41 42 43 44 45 46 47 48 49 50 51 52 53 54 55 0 0 0 56 57 58 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 59 0 0 0 0 0 0 0 0 60 0 0 0 0 0 0 0 0 0 0 0 0 0 0 61 0 0 0 0 0 0 0 0 62 63 64 65 66 67 68 69 70 71 72 73 74 75 76 77 78 79 80 81 82 83 84 85 86 87 88 89 90 91 92 93 0 0 0 0 94 0 0 95 96 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 97 98 0 0 0 0 99 100 101 102 103 104 105 106 107 108 109 110 111 112 113 114 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 115 116 117 0 118 119 0 0 0 0 0 0 0 0 120 121 122 123 124 125 126 127 128 129 0 0 0 0 0 0 0 0 0 130 0 131 132 133 134 135 0 0 0 0 0 0 0 0 136 137 0 0 0 0 0 0 0 0 0 0 0 0 138 139 140 0 0 0 0 0 0 0 0 141 142 143 0 0 0 0 0 0 0 0 0 0 0 0 144 145 146 147 0 0 0 0 0 0 0 0 0 0 0 0 148 149 0 0 0 0 150 151 152 0 0 0 0 0 0 0 0 0 0 0)))

(define-deferred ucd-suc-table-4
  (vector->bytevector-u16be
   '#(0    0    0    0    0    0    0    0    0    0    0    0    0    0    0    0    0    1    2    3    4    5    6    7    8    9    10   11   12   13   14   15   16   17   18   19   20   21   22   23   24   25   26   0    0    0    0    0    0    0    0    0    0    27   0    0    0    0    0    0    0    0    0    0    28   29   30   31  32  33  34  35  36  37  38  39   40   41   42   43   44   45   46   47   48   49   50   0    51   52   53   54   55   56   57   58   0    59   0    60   0    61   0    62   0    63   0    64   0    65   0    66   0    67   0    68   0    69   0    70   0    71   0    72   0    73   0    74   0    75   0    76   0    77   0    78   0    79   0    80   0    81   0    82   0    9    0    83   0    84   0    85   0    0    86   0    87   0    88   0    89   0    90   0    91   0    92   0    93   0    0    94   0    95   0    96   0    97   0    98   0    99   0    100  0    101  0    102  0    103  0    104  0    105  0    106  0    107  0
      108  0    109  0    110  0    111  0    112  0    113  0    114  0    115  0    116  0    0    117  0    118  0    119  19   120  0    0    121  0    122  0    0    123  0    0    0    124  0    0    0    0    0    125  0    0    126  0    0    0    127  128  0    0    0    129  0    0    130  0    131  0    132  0    0    133  0    0   0   0   134 0   0   135 0   0    0    136  0    137  0    0    138  0    0    0    139  0    140  0    0    0    0    0    141  141  0    142  142  0    143  143  0    144  0    145  0    146  0    147  0    148  0    149  0    150  0    151  152  0    153  0    154  0    155  0    156  0    157  0    158  0    159  0    160  0    161  0    0    162  162  0    163  0    0    0    164  0    165  0    166  0    167  0    168  0    169  0    170  0    171  0    172  0    173  0    174  0    175  0    176  0    177  0    178  0    179  0    180  0    181  0    182  0    183  0    0    0    184  0    185  0    186  0    187  0    188  0    189
      0    190  0    191  0    192  0    0    0    0    0    0    0    0    193  0    0    194  195  0    196  0    0    0    0    197  0    198  0    199  0    200  0    201  202  203  204  205  206  0    207  208  0    209  0    210  211  0    0    0    212  213  0    214  0    215  216  0    217  218  219  220  221  0    0    222  0    223 224 0   0   225 0   0   0   0    0    0    0    226  0    0    227  0    0    228  0    0    0    229  230  231  232  233  234  0    0    0    0    0    235  0    0    0    0    0    0    0    0    0    0    236  237  0    0    0    0    0    0    238  0    0    0    0    0    0    0    0    0    0    0    239  0    240  0    0    0    241  0    0    0    242  243  244  0    0    0    0    0    0    0    0    0    0    0    0    0    0    245  246  247  248  0    249  250  251  252  253  254  255  256  238  257  258  27   259  260  261  262  263  264  264  265  266  267  268  269  270  271  272  273  274  275  0    250  256  0    0    0
      267  262  276  0    277  0    278  0    279  0    280  0    281  0    282  0    283  0    284  0    285  0    286  0    287  0    288  257  263  289  290  0    253  0    0    291  0    0    292  0    0    0    0    293  294  295  296  297  298  299  300  301  302  303  304  305  306  307  308  309  310  311  312  313  314  315  316  317 318 319 320 321 322 323 324 325  326  327  328  329  330  331  332  333  334  335  336  337  338  339  340  0    341  0    342  0    343  0    344  0    345  0    346  0    347  0    348  0    349  0    350  0    351  0    352  0    353  0    354  0    355  0    356  0    357  0    0    0    0    0    0    0    0    0    358  0    359  0    360  0    361  0    362  0    363  0    364  0    365  0    366  0    367  0    368  0    369  0    370  0    371  0    372  0    373  0    374  0    375  0    376  0    377  0    378  0    379  0    380  0    381  0    382  0    383  0    384  0    0    385  0    386  0    387  0    388  0    389  0
      390  0    391  392  0    393  0    394  0    395  0    396  0    397  0    398  0    399  0    400  0    401  0    402  0    403  0    404  0    405  0    406  0    407  0    408  0    409  0    410  0    411  0    412  0    413  0    414  0    415  0    416  0    417  0    418  0    419  0    420  0    421  0    422  0    423  0    424 0   425 0   426 0   427 0   428  0    429  0    430  0    431  0    432  0    433  0    434  0    435  0    436  0    437  0    438  0    439  0    440  0    441  442  443  444  445  446  447  448  449  450  451  452  453  454  455  456  457  458  459  460  461  462  463  464  465  466  467  468  469  470  471  472  473  474  475  476  477  478  0    0    0    0    0    0    0    0    0    0    0    0    0    0    0    0    0    479  480  481  482  483  484  0    0    295  297  307  310  311  311  319  342  485  0    0    0    0    0    0    0    0    0    0    0    0    0    0    0    0    486  0    0    0    487  0    0    0    488  0
      489  0    490  0    491  0    492  0    493  0    494  0    495  0    496  0    497  0    498  0    499  0    500  0    501  0    502  0    503  0    504  0    505  0    506  0    507  0    508  0    509  0    510  0    511  0    512  0    513  0    514  0    515  0    516  0    517  0    518  0    519  0    520  0    521  0    522  0   523 0   524 0   525 0   526 0    527  0    528  0    529  0    530  0    531  0    532  0    533  0    534  0    535  0    536  0    537  0    538  0    539  0    540  0    541  0    542  0    543  0    544  0    545  0    546  0    547  0    548  0    549  0    550  0    551  0    552  0    553  0    554  0    555  0    556  0    557  0    558  0    559  0    560  0    561  0    562  0    0    0    0    0    536  0    0    0    0    0    563  0    564  0    565  0    566  0    567  0    568  0    569  0    570  0    571  0    572  0    573  0    574  0    575  0    576  0    577  0    578  0    579  0    580  0    581  0    582  0    583
      0    584  0    585  0    586  0    587  0    588  0    589  0    590  0    591  0    592  0    593  0    594  0    595  0    596  0    597  0    598  0    599  0    600  0    601  0    602  0    603  0    604  0    605  0    606  0    607  0    608  0    609  0    610  611  612  613  614  615  616  617  618  0    0    0    0    0    0   0   0   619 620 621 622 623 624  0    0    0    0    0    0    0    0    0    0    625  626  627  628  629  630  631  632  0    0    0    0    0    0    0    0    633  634  635  636  637  638  639  640  0    0    0    0    0    0    0    0    641  642  643  644  645  646  0    0    0    0    0    0    0    0    0    0    0    647  0    648  0    649  0    650  0    0    0    0    0    0    0    0    651  652  653  654  655  656  657  658  0    0    0    0    0    0    0    0    659  660  661  662  663  664  665  666  667  668  669  670  671  672  0    0    673  674  675  676  677  678  679  680  0    0    0    0    0    0    0    0    681
      682  683  684  685  686  687  688  0    0    0    0    0    0    0    0    689  690  691  692  693  694  695  696  0    0    0    0    0    0    0    0    697  698  0    699  0    0    0    0    0    0    0    0    0    0    238  0    0    0    0    700  0    0    0    0    0    0    0    0    0    0    0    0    701  702  0    0    0   0   0   0   0   0   0   0   0    0    0    0    703  704  0    0    0    705  0    0    0    0    0    0    0    0    0    0    0    0    0    706  0    0    0    0    0    0    0    0    0    0    0    0    0    0    0    0    0    0    0    0    0    0    0    0    0    0    707  0    708  709  710  711  712  713  714  715  716  717  718  719  720  721  722  723  0    0    0    0    724  0    0    0    0    0    0    0    0    0    0    0    725  726  727  728  729  730  731  732  733  734  735  736  737  738  739  740  741  742  743  744  745  746  747  748  749  750  0    0    0    0    0    0    751  752  753  754  755  756  757  758
      759  760  761  762  763  764  765  766  767  768  769  770  771  772  773  774  775  776  777  778  779  780  781  782  783  784  785  786  787  788  789  790  791  792  793  794  795  796  797  0    0    798  0    0    0    799  800  0    801  0    802  0    803  0    0    0    0    0    0    804  0    0    805  0    0    0    0    0   0   0   0   0   0   806 0   807  0    808  0    809  0    810  0    811  0    812  0    813  0    814  0    815  0    816  0    817  0    818  0    819  0    820  0    821  0    822  0    823  0    824  0    825  0    826  0    827  0    828  0    829  0    830  0    831  0    832  0    833  0    834  0    835  0    836  0    837  0    838  0    839  0    840  0    841  0    842  0    843  0    844  0    845  0    846  0    847  0    848  0    849  0    850  0    851  0    852  0    853  0    854  0    855  0    0    0    0    0    0    0    0    856  0    857  0    0    0    0    858  0    0    0    0    0    0    0    0    0    0    0
      0    859  860  861  862  863  864  865  866  867  868  869  870  871  872  873  874  875  876  877  878  879  880  881  882  883  884  885  886  887  888  889  890  891  892  893  894  895  896  0    897  0    0    0    0    0    898  0    0    0    899  0    900  0    901  0    902  0    903  0    485  0    904  0    905  0    906  0   907 0   908 0   909 0   910 0    911  0    912  0    913  0    914  0    915  0    916  0    917  0    918  0    919  0    920  0    0    0    921  0    922  0    923  0    924  0    925  0    926  0    927  0    928  0    929  0    930  0    931  0    932  0    933  0    934  0    0    0    0    0    0    0    935  0    936  0    937  0    938  0    939  0    940  0    941  0    0    0    942  0    943  0    944  0    945  0    946  0    947  0    948  0    949  0    950  0    951  0    952  0    953  0    954  0    955  0    956  0    957  0    958  0    959  0    960  0    961  0    962  0    963  0    964  0    965  0    966  0    967
      0    968  0    969  0    970  0    971  0    972  0    0    0    0    0    0    0    0    0    0    973  0    974  0    0    975  0    976  0    977  0    978  0    979  0    0    0    0    980  0    0    0    0    981  0    982  0    0    0    983  0    984  0    985  0    986  0    987  0    988  0    989  0    990  0    991  0    992 0   0   0   0   0   0   0   0    0    0    0    993  0    994  0    0    0    0    0    0    0    0    0    0    0    995  0    0    0    0    0    0    0    0    0    0    0    0    996  997  998  999  1000 1001 1002 1003 1004 1005 1006 1007 1008 1009 1010 1011 1012 1013 1014 1015 1016 1017 1018 1019 1020 1021 1022 1023 1024 1025 1026 1027 1028 1029 1030 1031 1032 1033 1034 1035 1036 1037 1038 1039 1040 1041 1042 1043 1044 1045 1046 1047 1048 1049 1050 1051 1052 1053 1054 1055 1056 1057 1058 1059 1060 1061 1062 1063 1064 1065 1066 1067 1068 1069 1070 1071 1072 1073 1074 1075 0    1076 1077 1078 1079 1080 1081 1082 1083 1084 1085 1086 1087
      1088 1089 1090 1091 1092 1093 1094 1095 1096 1097 1098 1099 1100 1101 0    0    0    0    0    0    0    0    0    0    0    0    0    1102 1103 1104 1105 1106 1107 1108 1109 1110 1111 1112 1113 1114 1115 1116 1117 1118 1119 1120 1121 1122 1123 1124 1125 1126 1127 1128 1129 1130 1131 1132 1133 1134 1135 1136 1137 1138 1139 1140 1141 0   0   0   0   0   0   0   0   1142 1143 1144 1145 1146 1147 1148 1149 1150 1151 1152 1153 1154 1155 1156 1157 1158 1159 1160 1161 1162 1163 1164 1165 1166 1167 1168 1169 1170 1171 1172 1173 1174 1175 1176 1177 0    0    0    0    1178 1179 1180 1181 1182 1183 1184 1185 1186 1187 1188 1189 1190 1191 1192 1193 1194 1195 1196 1197 1198 1199 1200 1201 1202 1203 1204 1205 1206 1207 1208 1209 1210 1211 1212 1213 1214 1215 1216 1217 1218 1219 1220 1221 1222 1223 1224 1225 1226 1227 1228 0    0    0    0    0    0    0    0    0    0    0    0    0    1229 1230 1231 1232 1233 1234 1235 1236 1237 1238 1239 1240 1241 1242 1243 1244 1245 1246 1247 1248
      1249 1250 1251 1252 1253 1254 1255 1256 1257 1258 1259 1260 0    0    1261 1262 1263 1264 1265 1266 1267 1268 1269 1270 1271 1272 1273 1274 1275 1276 1277 1278 1279 1280 1281 1282 1283 1284 1285 1286 1287 1288 1289 1290 1291 1292 1293 1294 0    0    0    0    0    0    0    0    0    0    0    0)))

(define-deferred ucd-suc-table-5
  #(#f        #\u+41    #\u+42    #\u+43    #\u+44    #\u+45    #\u+46    #\u+47    #\u+48    #\u+49    #\u+4a    #\u+4b    #\u+4c    #\u+4d    #\u+4e    #\u+4f    #\u+50    #\u+51    #\u+52    #\u+53    #\u+54    #\u+55    #\u+56    #\u+57    #\u+58    #\u+59    #\u+5a    #\u+39c   #\u+c0    #\u+c1    #\u+c2    #\u+c3    #\u+c4    #\u+c5    #\u+c6    #\u+c7    #\u+c8    #\u+c9    #\u+ca    #\u+cb    #\u+cc    #\u+cd    #\u+ce    #\u+cf    #\u+d0    #\u+d1    #\u+d2    #\u+d3    #\u+d4    #\u+d5    #\u+d6    #\u+d8    #\u+d9    #\u+da    #\u+db    #\u+dc    #\u+dd    #\u+de    #\u+178   #\u+100   #\u+102   #\u+104   #\u+106   #\u+108   #\u+10a   #\u+10c   #\u+10e   #\u+110   #\u+112   #\u+114   #\u+116   #\u+118   #\u+11a   #\u+11c   #\u+11e   #\u+120   #\u+122   #\u+124   #\u+126   #\u+128   #\u+12a   #\u+12c   #\u+12e   #\u+132   #\u+134   #\u+136   #\u+139   #\u+13b   #\u+13d   #\u+13f   #\u+141   #\u+143   #\u+145   #\u+147   #\u+14a   #\u+14c   #\u+14e   #\u+150
    #\u+152   #\u+154   #\u+156   #\u+158   #\u+15a   #\u+15c   #\u+15e   #\u+160   #\u+162   #\u+164   #\u+166   #\u+168   #\u+16a   #\u+16c   #\u+16e   #\u+170   #\u+172   #\u+174   #\u+176   #\u+179   #\u+17b   #\u+17d   #\u+243   #\u+182   #\u+184   #\u+187   #\u+18b   #\u+191   #\u+1f6   #\u+198   #\u+23d   #\u+220   #\u+1a0   #\u+1a2   #\u+1a4   #\u+1a7   #\u+1ac   #\u+1af   #\u+1b3   #\u+1b5   #\u+1b8   #\u+1bc   #\u+1f7   #\u+1c4   #\u+1c7   #\u+1ca   #\u+1cd   #\u+1cf   #\u+1d1   #\u+1d3   #\u+1d5   #\u+1d7   #\u+1d9   #\u+1db   #\u+18e   #\u+1de   #\u+1e0   #\u+1e2   #\u+1e4   #\u+1e6   #\u+1e8   #\u+1ea   #\u+1ec   #\u+1ee   #\u+1f1   #\u+1f4   #\u+1f8   #\u+1fa   #\u+1fc   #\u+1fe   #\u+200   #\u+202   #\u+204   #\u+206   #\u+208   #\u+20a   #\u+20c   #\u+20e   #\u+210   #\u+212   #\u+214   #\u+216   #\u+218   #\u+21a   #\u+21c   #\u+21e   #\u+222   #\u+224   #\u+226   #\u+228   #\u+22a   #\u+22c   #\u+22e   #\u+230   #\u+232   #\u+23b   #\u+2c7e  #\u+2c7f
    #\u+241   #\u+246   #\u+248   #\u+24a   #\u+24c   #\u+24e   #\u+2c6f  #\u+2c6d  #\u+2c70  #\u+181   #\u+186   #\u+189   #\u+18a   #\u+18f   #\u+190   #\u+a7ab  #\u+193   #\u+a7ac  #\u+194   #\u+a78d  #\u+a7aa  #\u+197   #\u+196   #\u+a7ae  #\u+2c62  #\u+a7ad  #\u+19c   #\u+2c6e  #\u+19d   #\u+19f   #\u+2c64  #\u+1a6   #\u+1a9   #\u+a7b1  #\u+1ae   #\u+244   #\u+1b1   #\u+1b2   #\u+245   #\u+1b7   #\u+a7b2  #\u+a7b0  #\u+399   #\u+370   #\u+372   #\u+376   #\u+3fd   #\u+3fe   #\u+3ff   #\u+386   #\u+388   #\u+389   #\u+38a   #\u+391   #\u+392   #\u+393   #\u+394   #\u+395   #\u+396   #\u+397   #\u+398   #\u+39a   #\u+39b   #\u+39d   #\u+39e   #\u+39f   #\u+3a0   #\u+3a1   #\u+3a3   #\u+3a4   #\u+3a5   #\u+3a6   #\u+3a7   #\u+3a8   #\u+3a9   #\u+3aa   #\u+3ab   #\u+38c   #\u+38e   #\u+38f   #\u+3cf   #\u+3d8   #\u+3da   #\u+3dc   #\u+3de   #\u+3e0   #\u+3e2   #\u+3e4   #\u+3e6   #\u+3e8   #\u+3ea   #\u+3ec   #\u+3ee   #\u+3f9   #\u+37f   #\u+3f7   #\u+3fa   #\u+410
    #\u+411   #\u+412   #\u+413   #\u+414   #\u+415   #\u+416   #\u+417   #\u+418   #\u+419   #\u+41a   #\u+41b   #\u+41c   #\u+41d   #\u+41e   #\u+41f   #\u+420   #\u+421   #\u+422   #\u+423   #\u+424   #\u+425   #\u+426   #\u+427   #\u+428   #\u+429   #\u+42a   #\u+42b   #\u+42c   #\u+42d   #\u+42e   #\u+42f   #\u+400   #\u+401   #\u+402   #\u+403   #\u+404   #\u+405   #\u+406   #\u+407   #\u+408   #\u+409   #\u+40a   #\u+40b   #\u+40c   #\u+40d   #\u+40e   #\u+40f   #\u+460   #\u+462   #\u+464   #\u+466   #\u+468   #\u+46a   #\u+46c   #\u+46e   #\u+470   #\u+472   #\u+474   #\u+476   #\u+478   #\u+47a   #\u+47c   #\u+47e   #\u+480   #\u+48a   #\u+48c   #\u+48e   #\u+490   #\u+492   #\u+494   #\u+496   #\u+498   #\u+49a   #\u+49c   #\u+49e   #\u+4a0   #\u+4a2   #\u+4a4   #\u+4a6   #\u+4a8   #\u+4aa   #\u+4ac   #\u+4ae   #\u+4b0   #\u+4b2   #\u+4b4   #\u+4b6   #\u+4b8   #\u+4ba   #\u+4bc   #\u+4be   #\u+4c1   #\u+4c3   #\u+4c5   #\u+4c7   #\u+4c9   #\u+4cb   #\u+4cd
    #\u+4c0   #\u+4d0   #\u+4d2   #\u+4d4   #\u+4d6   #\u+4d8   #\u+4da   #\u+4dc   #\u+4de   #\u+4e0   #\u+4e2   #\u+4e4   #\u+4e6   #\u+4e8   #\u+4ea   #\u+4ec   #\u+4ee   #\u+4f0   #\u+4f2   #\u+4f4   #\u+4f6   #\u+4f8   #\u+4fa   #\u+4fc   #\u+4fe   #\u+500   #\u+502   #\u+504   #\u+506   #\u+508   #\u+50a   #\u+50c   #\u+50e   #\u+510   #\u+512   #\u+514   #\u+516   #\u+518   #\u+51a   #\u+51c   #\u+51e   #\u+520   #\u+522   #\u+524   #\u+526   #\u+528   #\u+52a   #\u+52c   #\u+52e   #\u+531   #\u+532   #\u+533   #\u+534   #\u+535   #\u+536   #\u+537   #\u+538   #\u+539   #\u+53a   #\u+53b   #\u+53c   #\u+53d   #\u+53e   #\u+53f   #\u+540   #\u+541   #\u+542   #\u+543   #\u+544   #\u+545   #\u+546   #\u+547   #\u+548   #\u+549   #\u+54a   #\u+54b   #\u+54c   #\u+54d   #\u+54e   #\u+54f   #\u+550   #\u+551   #\u+552   #\u+553   #\u+554   #\u+555   #\u+556   #\u+13f0  #\u+13f1  #\u+13f2  #\u+13f3  #\u+13f4  #\u+13f5  #\u+a64a  #\u+a77d  #\u+2c63  #\u+1e00  #\u+1e02
    #\u+1e04  #\u+1e06  #\u+1e08  #\u+1e0a  #\u+1e0c  #\u+1e0e  #\u+1e10  #\u+1e12  #\u+1e14  #\u+1e16  #\u+1e18  #\u+1e1a  #\u+1e1c  #\u+1e1e  #\u+1e20  #\u+1e22  #\u+1e24  #\u+1e26  #\u+1e28  #\u+1e2a  #\u+1e2c  #\u+1e2e  #\u+1e30  #\u+1e32  #\u+1e34  #\u+1e36  #\u+1e38  #\u+1e3a  #\u+1e3c  #\u+1e3e  #\u+1e40  #\u+1e42  #\u+1e44  #\u+1e46  #\u+1e48  #\u+1e4a  #\u+1e4c  #\u+1e4e  #\u+1e50  #\u+1e52  #\u+1e54  #\u+1e56  #\u+1e58  #\u+1e5a  #\u+1e5c  #\u+1e5e  #\u+1e60  #\u+1e62  #\u+1e64  #\u+1e66  #\u+1e68  #\u+1e6a  #\u+1e6c  #\u+1e6e  #\u+1e70  #\u+1e72  #\u+1e74  #\u+1e76  #\u+1e78  #\u+1e7a  #\u+1e7c  #\u+1e7e  #\u+1e80  #\u+1e82  #\u+1e84  #\u+1e86  #\u+1e88  #\u+1e8a  #\u+1e8c  #\u+1e8e  #\u+1e90  #\u+1e92  #\u+1e94  #\u+1ea0  #\u+1ea2  #\u+1ea4  #\u+1ea6  #\u+1ea8  #\u+1eaa  #\u+1eac  #\u+1eae  #\u+1eb0  #\u+1eb2  #\u+1eb4  #\u+1eb6  #\u+1eb8  #\u+1eba  #\u+1ebc  #\u+1ebe  #\u+1ec0  #\u+1ec2  #\u+1ec4  #\u+1ec6  #\u+1ec8  #\u+1eca  #\u+1ecc  #\u+1ece  #\u+1ed0
    #\u+1ed2  #\u+1ed4  #\u+1ed6  #\u+1ed8  #\u+1eda  #\u+1edc  #\u+1ede  #\u+1ee0  #\u+1ee2  #\u+1ee4  #\u+1ee6  #\u+1ee8  #\u+1eea  #\u+1eec  #\u+1eee  #\u+1ef0  #\u+1ef2  #\u+1ef4  #\u+1ef6  #\u+1ef8  #\u+1efa  #\u+1efc  #\u+1efe  #\u+1f08  #\u+1f09  #\u+1f0a  #\u+1f0b  #\u+1f0c  #\u+1f0d  #\u+1f0e  #\u+1f0f  #\u+1f18  #\u+1f19  #\u+1f1a  #\u+1f1b  #\u+1f1c  #\u+1f1d  #\u+1f28  #\u+1f29  #\u+1f2a  #\u+1f2b  #\u+1f2c  #\u+1f2d  #\u+1f2e  #\u+1f2f  #\u+1f38  #\u+1f39  #\u+1f3a  #\u+1f3b  #\u+1f3c  #\u+1f3d  #\u+1f3e  #\u+1f3f  #\u+1f48  #\u+1f49  #\u+1f4a  #\u+1f4b  #\u+1f4c  #\u+1f4d  #\u+1f59  #\u+1f5b  #\u+1f5d  #\u+1f5f  #\u+1f68  #\u+1f69  #\u+1f6a  #\u+1f6b  #\u+1f6c  #\u+1f6d  #\u+1f6e  #\u+1f6f  #\u+1fba  #\u+1fbb  #\u+1fc8  #\u+1fc9  #\u+1fca  #\u+1fcb  #\u+1fda  #\u+1fdb  #\u+1ff8  #\u+1ff9  #\u+1fea  #\u+1feb  #\u+1ffa  #\u+1ffb  #\u+1f88  #\u+1f89  #\u+1f8a  #\u+1f8b  #\u+1f8c  #\u+1f8d  #\u+1f8e  #\u+1f8f  #\u+1f98  #\u+1f99  #\u+1f9a  #\u+1f9b  #\u+1f9c
    #\u+1f9d  #\u+1f9e  #\u+1f9f  #\u+1fa8  #\u+1fa9  #\u+1faa  #\u+1fab  #\u+1fac  #\u+1fad  #\u+1fae  #\u+1faf  #\u+1fb8  #\u+1fb9  #\u+1fbc  #\u+1fcc  #\u+1fd8  #\u+1fd9  #\u+1fe8  #\u+1fe9  #\u+1fec  #\u+1ffc  #\u+2132  #\u+2160  #\u+2161  #\u+2162  #\u+2163  #\u+2164  #\u+2165  #\u+2166  #\u+2167  #\u+2168  #\u+2169  #\u+216a  #\u+216b  #\u+216c  #\u+216d  #\u+216e  #\u+216f  #\u+2183  #\u+24b6  #\u+24b7  #\u+24b8  #\u+24b9  #\u+24ba  #\u+24bb  #\u+24bc  #\u+24bd  #\u+24be  #\u+24bf  #\u+24c0  #\u+24c1  #\u+24c2  #\u+24c3  #\u+24c4  #\u+24c5  #\u+24c6  #\u+24c7  #\u+24c8  #\u+24c9  #\u+24ca  #\u+24cb  #\u+24cc  #\u+24cd  #\u+24ce  #\u+24cf  #\u+2c00  #\u+2c01  #\u+2c02  #\u+2c03  #\u+2c04  #\u+2c05  #\u+2c06  #\u+2c07  #\u+2c08  #\u+2c09  #\u+2c0a  #\u+2c0b  #\u+2c0c  #\u+2c0d  #\u+2c0e  #\u+2c0f  #\u+2c10  #\u+2c11  #\u+2c12  #\u+2c13  #\u+2c14  #\u+2c15  #\u+2c16  #\u+2c17  #\u+2c18  #\u+2c19  #\u+2c1a  #\u+2c1b  #\u+2c1c  #\u+2c1d  #\u+2c1e  #\u+2c1f  #\u+2c20
    #\u+2c21  #\u+2c22  #\u+2c23  #\u+2c24  #\u+2c25  #\u+2c26  #\u+2c27  #\u+2c28  #\u+2c29  #\u+2c2a  #\u+2c2b  #\u+2c2c  #\u+2c2d  #\u+2c2e  #\u+2c60  #\u+23a   #\u+23e   #\u+2c67  #\u+2c69  #\u+2c6b  #\u+2c72  #\u+2c75  #\u+2c80  #\u+2c82  #\u+2c84  #\u+2c86  #\u+2c88  #\u+2c8a  #\u+2c8c  #\u+2c8e  #\u+2c90  #\u+2c92  #\u+2c94  #\u+2c96  #\u+2c98  #\u+2c9a  #\u+2c9c  #\u+2c9e  #\u+2ca0  #\u+2ca2  #\u+2ca4  #\u+2ca6  #\u+2ca8  #\u+2caa  #\u+2cac  #\u+2cae  #\u+2cb0  #\u+2cb2  #\u+2cb4  #\u+2cb6  #\u+2cb8  #\u+2cba  #\u+2cbc  #\u+2cbe  #\u+2cc0  #\u+2cc2  #\u+2cc4  #\u+2cc6  #\u+2cc8  #\u+2cca  #\u+2ccc  #\u+2cce  #\u+2cd0  #\u+2cd2  #\u+2cd4  #\u+2cd6  #\u+2cd8  #\u+2cda  #\u+2cdc  #\u+2cde  #\u+2ce0  #\u+2ce2  #\u+2ceb  #\u+2ced  #\u+2cf2  #\u+10a0  #\u+10a1  #\u+10a2  #\u+10a3  #\u+10a4  #\u+10a5  #\u+10a6  #\u+10a7  #\u+10a8  #\u+10a9  #\u+10aa  #\u+10ab  #\u+10ac  #\u+10ad  #\u+10ae  #\u+10af  #\u+10b0  #\u+10b1  #\u+10b2  #\u+10b3  #\u+10b4  #\u+10b5  #\u+10b6
    #\u+10b7  #\u+10b8  #\u+10b9  #\u+10ba  #\u+10bb  #\u+10bc  #\u+10bd  #\u+10be  #\u+10bf  #\u+10c0  #\u+10c1  #\u+10c2  #\u+10c3  #\u+10c4  #\u+10c5  #\u+10c7  #\u+10cd  #\u+a640  #\u+a642  #\u+a644  #\u+a646  #\u+a648  #\u+a64c  #\u+a64e  #\u+a650  #\u+a652  #\u+a654  #\u+a656  #\u+a658  #\u+a65a  #\u+a65c  #\u+a65e  #\u+a660  #\u+a662  #\u+a664  #\u+a666  #\u+a668  #\u+a66a  #\u+a66c  #\u+a680  #\u+a682  #\u+a684  #\u+a686  #\u+a688  #\u+a68a  #\u+a68c  #\u+a68e  #\u+a690  #\u+a692  #\u+a694  #\u+a696  #\u+a698  #\u+a69a  #\u+a722  #\u+a724  #\u+a726  #\u+a728  #\u+a72a  #\u+a72c  #\u+a72e  #\u+a732  #\u+a734  #\u+a736  #\u+a738  #\u+a73a  #\u+a73c  #\u+a73e  #\u+a740  #\u+a742  #\u+a744  #\u+a746  #\u+a748  #\u+a74a  #\u+a74c  #\u+a74e  #\u+a750  #\u+a752  #\u+a754  #\u+a756  #\u+a758  #\u+a75a  #\u+a75c  #\u+a75e  #\u+a760  #\u+a762  #\u+a764  #\u+a766  #\u+a768  #\u+a76a  #\u+a76c  #\u+a76e  #\u+a779  #\u+a77b  #\u+a77e  #\u+a780  #\u+a782  #\u+a784  #\u+a786
    #\u+a78b  #\u+a790  #\u+a792  #\u+a796  #\u+a798  #\u+a79a  #\u+a79c  #\u+a79e  #\u+a7a0  #\u+a7a2  #\u+a7a4  #\u+a7a6  #\u+a7a8  #\u+a7b4  #\u+a7b6  #\u+a7b3  #\u+13a0  #\u+13a1  #\u+13a2  #\u+13a3  #\u+13a4  #\u+13a5  #\u+13a6  #\u+13a7  #\u+13a8  #\u+13a9  #\u+13aa  #\u+13ab  #\u+13ac  #\u+13ad  #\u+13ae  #\u+13af  #\u+13b0  #\u+13b1  #\u+13b2  #\u+13b3  #\u+13b4  #\u+13b5  #\u+13b6  #\u+13b7  #\u+13b8  #\u+13b9  #\u+13ba  #\u+13bb  #\u+13bc  #\u+13bd  #\u+13be  #\u+13bf  #\u+13c0  #\u+13c1  #\u+13c2  #\u+13c3  #\u+13c4  #\u+13c5  #\u+13c6  #\u+13c7  #\u+13c8  #\u+13c9  #\u+13ca  #\u+13cb  #\u+13cc  #\u+13cd  #\u+13ce  #\u+13cf  #\u+13d0  #\u+13d1  #\u+13d2  #\u+13d3  #\u+13d4  #\u+13d5  #\u+13d6  #\u+13d7  #\u+13d8  #\u+13d9  #\u+13da  #\u+13db  #\u+13dc  #\u+13dd  #\u+13de  #\u+13df  #\u+13e0  #\u+13e1  #\u+13e2  #\u+13e3  #\u+13e4  #\u+13e5  #\u+13e6  #\u+13e7  #\u+13e8  #\u+13e9  #\u+13ea  #\u+13eb  #\u+13ec  #\u+13ed  #\u+13ee  #\u+13ef  #\u+ff21  #\u+ff22
    #\u+ff23  #\u+ff24  #\u+ff25  #\u+ff26  #\u+ff27  #\u+ff28  #\u+ff29  #\u+ff2a  #\u+ff2b  #\u+ff2c  #\u+ff2d  #\u+ff2e  #\u+ff2f  #\u+ff30  #\u+ff31  #\u+ff32  #\u+ff33  #\u+ff34  #\u+ff35  #\u+ff36  #\u+ff37  #\u+ff38  #\u+ff39  #\u+ff3a  #\u+10400 #\u+10401 #\u+10402 #\u+10403 #\u+10404 #\u+10405 #\u+10406 #\u+10407 #\u+10408 #\u+10409 #\u+1040a #\u+1040b #\u+1040c #\u+1040d #\u+1040e #\u+1040f #\u+10410 #\u+10411 #\u+10412 #\u+10413 #\u+10414 #\u+10415 #\u+10416 #\u+10417 #\u+10418 #\u+10419 #\u+1041a #\u+1041b #\u+1041c #\u+1041d #\u+1041e #\u+1041f #\u+10420 #\u+10421 #\u+10422 #\u+10423 #\u+10424 #\u+10425 #\u+10426 #\u+10427 #\u+104b0 #\u+104b1 #\u+104b2 #\u+104b3 #\u+104b4 #\u+104b5 #\u+104b6 #\u+104b7 #\u+104b8 #\u+104b9 #\u+104ba #\u+104bb #\u+104bc #\u+104bd #\u+104be #\u+104bf #\u+104c0 #\u+104c1 #\u+104c2 #\u+104c3 #\u+104c4 #\u+104c5 #\u+104c6 #\u+104c7 #\u+104c8 #\u+104c9 #\u+104ca #\u+104cb #\u+104cc #\u+104cd #\u+104ce #\u+104cf #\u+104d0 #\u+104d1
    #\u+104d2 #\u+104d3 #\u+10c80 #\u+10c81 #\u+10c82 #\u+10c83 #\u+10c84 #\u+10c85 #\u+10c86 #\u+10c87 #\u+10c88 #\u+10c89 #\u+10c8a #\u+10c8b #\u+10c8c #\u+10c8d #\u+10c8e #\u+10c8f #\u+10c90 #\u+10c91 #\u+10c92 #\u+10c93 #\u+10c94 #\u+10c95 #\u+10c96 #\u+10c97 #\u+10c98 #\u+10c99 #\u+10c9a #\u+10c9b #\u+10c9c #\u+10c9d #\u+10c9e #\u+10c9f #\u+10ca0 #\u+10ca1 #\u+10ca2 #\u+10ca3 #\u+10ca4 #\u+10ca5 #\u+10ca6 #\u+10ca7 #\u+10ca8 #\u+10ca9 #\u+10caa #\u+10cab #\u+10cac #\u+10cad #\u+10cae #\u+10caf #\u+10cb0 #\u+10cb1 #\u+10cb2 #\u+118a0 #\u+118a1 #\u+118a2 #\u+118a3 #\u+118a4 #\u+118a5 #\u+118a6 #\u+118a7 #\u+118a8 #\u+118a9 #\u+118aa #\u+118ab #\u+118ac #\u+118ad #\u+118ae #\u+118af #\u+118b0 #\u+118b1 #\u+118b2 #\u+118b3 #\u+118b4 #\u+118b5 #\u+118b6 #\u+118b7 #\u+118b8 #\u+118b9 #\u+118ba #\u+118bb #\u+118bc #\u+118bd #\u+118be #\u+118bf #\u+1e900 #\u+1e901 #\u+1e902 #\u+1e903 #\u+1e904 #\u+1e905 #\u+1e906 #\u+1e907 #\u+1e908 #\u+1e909 #\u+1e90a #\u+1e90b #\u+1e90c
    #\u+1e90d #\u+1e90e #\u+1e90f #\u+1e910 #\u+1e911 #\u+1e912 #\u+1e913 #\u+1e914 #\u+1e915 #\u+1e916 #\u+1e917 #\u+1e918 #\u+1e919 #\u+1e91a #\u+1e91b #\u+1e91c #\u+1e91d #\u+1e91e #\u+1e91f #\u+1e920 #\u+1e921))
