/* -*- Mode: Java; tab-width: 4; indent-tabs-mode: nil; c-basic-offset: 2 -*- 
 * $Id: OPfunction.java,v 1.2 2000/09/09 19:51:48 metlov Exp $
 *
 * This file is part of the Java Expressions Library (JEL).
 *   For more information about JEL visit :
 *    http://galaxy.fzu.cz/JEL/
 *
 * (c) 1998 -- 2000 by Konstantin Metlov(metlov@fzu.cz);
 *
 * JEL is Distributed under the terms of GNU General Public License.
 *    This code comes with ABSOLUTELY NO WARRANTY.
 *  For license details see COPYING file in this directory.
 */

package gnu.jel;

import gnu.jel.debug.Debug;

public abstract class OPfunction extends OP {
 
  /**
   * Returns number of parameters for this function.
   */
  protected abstract int getNParams();

  /**
   * Attempts to evaluate this function.
   * @param list is the list of OPs this one belong to, 
   *             if eval is unsuccessful this list is not modified.
   */
  protected abstract void eval(OPlist list);

  /**
   * Called to generate the code before the parameters processing starts.
   * @param cf class file to write the code into.
   */
  protected void compile_pre(ClassFile cf) {
  };

  /**
   * Called to generate the code after a parameter is processed.
   * @param cf class file to write the code into.
   * @param n the number of parameter (1 is first).
   */
  protected void compile_par(ClassFile cf, int n) {
  };
};
