/* Any copyright is dedicated to the Public Domain.
   http://creativecommons.org/publicdomain/zero/1.0/ */

let SI = {};
subscriptLoader.loadSubScript("resource://gre/modules/SiPduHelper.jsm", SI);
SI.debug = do_print;

function run_test() {
  run_next_test();
}


/**
 * SI in Plain text
 */
add_test(function test_si_parse_plain_text() {
  let contentType = "";
  let data = {};

  contentType = "text/vnd.wap.si";
  data.array = new Uint8Array([
                  0x3C, 0x3F, 0x78, 0x6D, 0x6C, 0x20, 0x76, 0x65,
                  0x72, 0x73, 0x69, 0x6F, 0x6E, 0x3D, 0x27, 0x31,
                  0x2E, 0x30, 0x27, 0x3F, 0x3E, 0x0A, 0x3C, 0x73,
                  0x69, 0x3E, 0x3C, 0x69, 0x6E, 0x64, 0x69, 0x63,
                  0x61, 0x74, 0x69, 0x6F, 0x6E, 0x20, 0x68, 0x72,
                  0x65, 0x66, 0x3D, 0x27, 0x68, 0x74, 0x74, 0x70,
                  0x3A, 0x2F, 0x2F, 0x77, 0x77, 0x77, 0x2E, 0x6F,
                  0x72, 0x65, 0x69, 0x6C, 0x6C, 0x79, 0x2E, 0x63,
                  0x6F, 0x6D, 0x27, 0x3E, 0x43, 0x68, 0x65, 0x63,
                  0x6B, 0x20, 0x74, 0x68, 0x69, 0x73, 0x20, 0x77,
                  0x65, 0x62, 0x73, 0x69, 0x74, 0x65, 0x3C, 0x2F,
                  0x69, 0x6E, 0x64, 0x69, 0x63, 0x61, 0x74, 0x69,
                  0x6F, 0x6E, 0x3E, 0x3C, 0x2F, 0x73, 0x69, 0x3E
                ]);
  data.offset = 0;
  let result = "<?xml version='1.0'?>\n<si><indication href='http://www.oreilly.com'>Check this website</indication></si>";
  let msg = SI.PduHelper.parse(data, contentType);
  do_check_eq(msg.content, result);

  run_next_test();
});

/**
 * Empty SI compressed by WBXML
 */
add_test(function test_si_parse_wbxml_empty() {
  let msg = {};
  let contentType = "";
  let data = {};

  contentType = "application/vnd.wap.sic";
  data.array = new Uint8Array([
                  0x02, 0x05, 0x6A, 0x00, 0x05
                ]);
  data.offset = 0;
  let result = "<si/>";
  msg = SI.PduHelper.parse(data, contentType);
  do_check_eq(msg.content, result);

  run_next_test();
});

/**
 * Empty SI compressed by WBXML, with public ID stored in string table
 */
add_test(function test_si_parse_wbxml_empty_public_id_string_table() {
  let msg = {};
  let contentType = "";
  let data = {};

  contentType = "application/vnd.wap.sic";
  data.array = new Uint8Array([
                  0x02, 0x00, 0x00, 0x6A, 0x1C, 0x2D, 0x2F, 0x2F,
                  0x57, 0x41, 0x50, 0x46, 0x4F, 0x52, 0x55, 0x4D,
                  0x2F, 0x2F, 0x44, 0x54, 0x44, 0x20, 0x53, 0x49,
                  0x20, 0x31, 0x2E, 0x30, 0x2F, 0x2F, 0x45, 0x4E,
                  0x00, 0x05
                ]);
  data.offset = 0;
  let result = "<si/>";
  msg = SI.PduHelper.parse(data, contentType);
  do_check_eq(msg.content, result);

  run_next_test();
});

/**
 * SI compressed by WBXML with href attribute
 */
add_test(function test_si_parse_wbxml_with_href() {
  let msg = {};
  let contentType = "";
  let data = {};

  contentType = "application/vnd.wap.sic";
  data.array = new Uint8Array([
                  0x02, 0x05, 0x6A, 0x00, 0x45, 0xC6, 0x0D, 0x03,
                  0x6F, 0x72, 0x65, 0x69, 0x6C, 0x6C, 0x79, 0x00,
                  0x85, 0x01, 0x03, 0x43, 0x68, 0x65, 0x63, 0x6B,
                  0x20, 0x74, 0x68, 0x69, 0x73, 0x20, 0x77, 0x65,
                  0x62, 0x73, 0x69, 0x74, 0x65, 0x00, 0x01, 0x01
                ]);
  data.offset = 0;
  let result = "<si><indication href=\"http://www.oreilly.com/\">" +
               "Check this website</indication></si>";
  msg = SI.PduHelper.parse(data, contentType);
  do_check_eq(msg.content, result);

  run_next_test();
});

/**
 * SI compressed by WBXML with href attribute containing reserved XML character
 */
add_test(function test_si_parse_wbxml_with_href_reserved_char() {
  let msg = {};
  let contentType = "";
  let data = {};

  contentType = "application/vnd.wap.sic";
  data.array = new Uint8Array([
                  0x02, 0x05, 0x6A, 0x00, 0x45, 0xC6, 0x0D, 0x03,
                  0x6F, 0x72, 0x65, 0x69, 0x6C, 0x6C, 0x79, 0x00,
                  0x85, 0x03, 0x66, 0x6F, 0x6F, 0x26, 0x62, 0x61,
                  0x72, 0x00, 0x01, 0x03, 0x43, 0x68, 0x65, 0x63,
                  0x6B, 0x20, 0x74, 0x68, 0x69, 0x73, 0x20, 0x77,
                  0x65, 0x62, 0x73, 0x69, 0x74, 0x65, 0x00, 0x01,
                  0x01
                ]);
  data.offset = 0;
  let result = "<si><indication href=\"http://www.oreilly.com/foo&amp;bar\">" +
               "Check this website</indication></si>";
  msg = SI.PduHelper.parse(data, contentType);
  do_check_eq(msg.content, result);

  run_next_test();
});

/**
 * SI compressed by WBXML with href and date attribute
 */
add_test(function test_si_parse_wbxml_with_href_date() {
  let msg = {};
  let contentType = "";
  let data = {};

  contentType = "application/vnd.wap.sic";
  data.array = new Uint8Array([
                  0x02, 0x05, 0x6A, 0x00, 0x45, 0xC6, 0x0D, 0x03,
                  0x78, 0x79, 0x7A, 0x00, 0x85, 0x03, 0x65, 0x6D,
                  0x61, 0x69, 0x6C, 0x2F, 0x31, 0x32, 0x33, 0x2F,
                  0x61, 0x62, 0x63, 0x2E, 0x77, 0x6D, 0x6C, 0x00,
                  0x0A, 0xC3, 0x07, 0x19, 0x99, 0x06, 0x25, 0x15,
                  0x23, 0x15, 0x10, 0xC3, 0x04, 0x19, 0x99, 0x06,
                  0x30, 0x01, 0x03, 0x59, 0x6F, 0x75, 0x20, 0x68,
                  0x61, 0x76, 0x65, 0x20, 0x34, 0x20, 0x6E, 0x65,
                  0x77, 0x20, 0x65, 0x6D, 0x61, 0x69, 0x6C, 0x73,
                  0x00, 0x01, 0x01
                ]);
  data.offset = 0;
  let result = "<si><indication href=\"http://www.xyz.com/email/123/abc.wml\"" +
               " created=\"1999-06-25T15:23:15Z\" si-expires=\"1999-06-30T00:00:00Z\">" +
               "You have 4 new emails</indication></si>";
  msg = SI.PduHelper.parse(data, contentType);
  do_check_eq(msg.content, result);

  run_next_test();
});

/**
 * SI compressed by WBXML with attributes and string table
 */
add_test(function test_si_parse_wbxml_with_attr_string_table() {
  let msg = {};
  let contentType = "";
  let data = {};

  contentType = "application/vnd.wap.sic";
  data.array = new Uint8Array([
                  0x02, 0x05, 0x6A, 0x28, 0x65, 0x6D, 0x61, 0x69,
                  0x6C, 0x2F, 0x31, 0x32, 0x33, 0x2F, 0x61, 0x62,
                  0x63, 0x2E, 0x77, 0x6D, 0x6C, 0x00, 0x59, 0x6F,
                  0x75, 0x20, 0x68, 0x61, 0x76, 0x65, 0x20, 0x34,
                  0x20, 0x6E, 0x65, 0x77, 0x20, 0x65, 0x6D, 0x61,
                  0x69, 0x6C, 0x73, 0x00, 0x45, 0xC6, 0x0D, 0x03,
                  0x78, 0x79, 0x7A, 0x00, 0x85, 0x83, 0x00, 0x0A,
                  0xC3, 0x07, 0x19, 0x99, 0x06, 0x25, 0x15, 0x23,
                  0x15, 0x10, 0xC3, 0x04, 0x19, 0x99, 0x06, 0x30,
                  0x01, 0x83, 0x12, 0x01, 0x01
                ]);
  data.offset = 0;
  let result = "<si><indication href=\"http://www.xyz.com/email/123/abc.wml\"" +
               " created=\"1999-06-25T15:23:15Z\" si-expires=\"1999-06-30T00:00:00Z\">" +
               "You have 4 new emails</indication></si>";
  msg = SI.PduHelper.parse(data, contentType);
  do_check_eq(msg.content, result);

  run_next_test();
});
