/* statistics/quantiles_source.c
 * 
 * Copyright (C) 1996, 1997, 1998, 1999, 2000, 2007 Jim Davies, Brian Gough
 * 
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 3 of the License, or (at
 * your option) any later version.
 * 
 * This program is distributed in the hope that it will be useful, but
 * WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * General Public License for more details.
 * 
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 51 Franklin Street, Fifth Floor, Boston, MA 02110-1301, USA.
 */


double
FUNCTION(gsl_stats,quantile_from_sorted_data) (const BASE sorted_data[], 
                                               const size_t stride,
                                               const size_t n,
                                               const double f)
{
  if ((f < 0.0) || (f > 1.0))
    {
      GSL_ERROR_VAL ("invalid quantile fraction", GSL_EDOM, 0.0);
    }
  else
    {
      const double index = f * (n - 1) ;
      const size_t lhs = (int)index ;
      const double delta = index - lhs ;
      double result;

      if (n == 0)
        return 0.0 ;

      if (lhs == n - 1)
        {
          result = sorted_data[lhs * stride] ;
        }
      else 
        {
          result = (1 - delta) * sorted_data[lhs * stride] + delta * sorted_data[(lhs + 1) * stride] ;
        }

      return result ;
    }
}
