/*
 * Decompiled with CFR 0.152.
 */
package org.gnunet.nse;

import java.util.Collection;
import java.util.HashSet;
import org.gnunet.nse.StartMessage;
import org.gnunet.nse.UpdateMessage;
import org.gnunet.util.AbsoluteTime;
import org.gnunet.util.Cancelable;
import org.gnunet.util.Client;
import org.gnunet.util.Configuration;
import org.gnunet.util.Connection;
import org.gnunet.util.MessageTransmitter;
import org.gnunet.util.Program;
import org.gnunet.util.RelativeTime;
import org.gnunet.util.RunaboutMessageReceiver;
import org.gnunet.util.getopt.Argument;
import org.gnunet.util.getopt.ArgumentAction;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class NetworkSizeEstimation {
    private static final Logger logger = LoggerFactory.getLogger(NetworkSizeEstimation.class);
    private Collection<Subscriber> subscribers = new HashSet<Subscriber>(1);
    private boolean disconnected = false;
    private Client client;

    public Cancelable subscribe(Subscriber s) {
        this.subscribers.add(s);
        this.requestUpdate();
        return new Subscription(s);
    }

    public NetworkSizeEstimation(Configuration cfg) {
        this.client = new Client("nse", cfg);
    }

    private void requestUpdate() {
        this.client.notifyTransmitReady(RelativeTime.FOREVER, true, 0, new NSE_Transmitter());
    }

    public void disconnect() {
        this.disconnected = true;
    }

    public static void main(String[] args) {
        new Program(){
            @Argument(action=ArgumentAction.SET, shortname="w", longname="watch", description="wait and watch for more NSE updates")
            boolean cont = false;

            @Override
            public void run() {
                final NetworkSizeEstimation svc = new NetworkSizeEstimation(this.cfg);
                Subscriber subscriber = new Subscriber(){

                    @Override
                    public void update(AbsoluteTime timestamp, double estimate, double deviation) {
                        System.out.println("est: " + estimate + " dev: " + deviation + " t: " + timestamp.toDate());
                        if (!cont) {
                            svc.disconnect();
                        }
                    }
                };
                svc.subscribe(subscriber);
            }
        }.start(args);
    }

    public static interface Subscriber {
        public void update(AbsoluteTime var1, double var2, double var4);
    }

    public class Subscription
    implements Cancelable {
        private Subscriber sub;

        private Subscription(Subscriber sub) {
            this.sub = sub;
        }

        @Override
        public void cancel() {
            NetworkSizeEstimation.this.subscribers.remove(this.sub);
        }
    }

    private class NSE_Transmitter
    implements MessageTransmitter {
        private NSE_Transmitter() {
        }

        @Override
        public void transmit(Connection.MessageSink sink) {
            StartMessage m = new StartMessage();
            sink.send(m);
            NetworkSizeEstimation.this.client.receiveOne(RelativeTime.FOREVER, new NSE_Receiver());
        }

        @Override
        public void handleError() {
            logger.warn("NSE connection lost - trying to reconnect");
            NetworkSizeEstimation.this.client.reconnect();
            NetworkSizeEstimation.this.requestUpdate();
        }
    }

    private class NSE_Receiver
    extends RunaboutMessageReceiver {
        private NSE_Receiver() {
        }

        public void visit(UpdateMessage uMsg) {
            for (Subscriber s : NetworkSizeEstimation.this.subscribers) {
                s.update(AbsoluteTime.fromNetwork(uMsg.timestamp), uMsg.sizeEstimate, uMsg.stdDeviation);
            }
            if (!NetworkSizeEstimation.this.disconnected) {
                NetworkSizeEstimation.this.client.receiveOne(RelativeTime.FOREVER, this);
            }
        }

        @Override
        public void handleError() {
            logger.warn("NSE connection lost - trying to reconnect");
            NetworkSizeEstimation.this.client.reconnect();
            NetworkSizeEstimation.this.requestUpdate();
        }
    }
}

