Esto es CLISP, una implementacin de Common Lisp.


 Qu es LISP ?
---------------

LISP es un lenguaje de programacin inventado por J. McCarthy en
1959. Aunque ha habido muchos dialectos de l, actualmente se ha
estandarizado y difundido ampliamente gracias al estandar industrial
COMMON LISP. Hay aplicaciones en los dominios del procesamiento del
conocimiento simblico (IA), clculo numrico (MACLISP generaba cdigo
tan bueno como el de FORTRAN), y en programas ampliamente utilizados
como editores (EMACS) y CAD (AUTOCAD). Si lo desea, puede consultar la
introduccin al lenguaje LISP:

  Sheila Hughes: Lisp. Pitman Publishing Limited, London 1986.
  107 pages.

Despus de un rato, necesitar el texto estandar que contiene la
definicin del lenguaje:

Guy L. Steele Jr.: Common Lisp - The Language. Digital Press.
  1. edition 1984, 465 pages.
  2. edition 1990, 1032 pages.

Este libro est disponible en formato HTML via FTP en:
  ftp.cs.cmu.edu:/user/ai/lang/lisp/doc/cltl/cltl_ht.tgz

y puede consultarse a travs de WWW en:

  http://www.cs.cmu.edu:8001/Web/Groups/AI/html/cltl/cltl2.html o	
  http://www.cs.cmu.edu:8001/afs/cs/project/ai-repository/ai/html/cltl/cltl2.html .

Nota para los expertos: Este texto estandar se ha convertido en un
estndar ANSI, que puede obtenerse <<<exceptionally>>> sin cargo alguno en:

  http://www.harlequin.com/books/HyperSpec/

LISP se ejecuta en un entorno interactivo. Usted introduce formas, que
sern evaluadas de inmediato. Por lo tanto, puede inspeccionar
variables, invocar funciones con unos argumentos concretos o definir
sus propias funciones.


Contenidos:
-----------

Consta de los siguientes ficheros:

   base/lisp.run          programa principal
   base/lispinit.mem      imagen de memoria necesaria para la inicializacin
   doc/clisp.1            manual en formato man de Unix
   doc/clisp.man          manual
   doc/clisp.html         manual en format HTML
   doc/impnotes.html      notas de la implementacin
   doc/clreadline.3       manual de edicin de lnea en formato man de Unix
   doc/clreadline.man     manual de edicin de lnea
   doc/LISP-tutorial.txt  tutorial de LISP para aprendices
   doc/CLOS-guide.txt     breve gua de CLOS
   README                 este texto
   SUMMARY                pequea descripcin de CLISP
   ANNOUNCE               declaracin
   NEWS                   lista de modificaciones desde la ltima versin
   COPYRIGHT              derechos de autor <<<copyright>>>
   GNU-GPL                licencia de software libre
   doc/readline.dvi       documentacin de la librera GNU readline
                          en formato DVI
   doc/editors.txt        Lista de editores que soportan Lisp
   emacs/*.el             personalizacin de Emacs, vase doc/editors.txt
   src/config.lsp         configuracin dependiente del lugar

y - cuando le apetezca, si le gusta leer cdigo fuente -

   src/*.lsp              el cdigo fuente de lispinit.mem
   src/*.fas              los mismos ficheros, una vez compilados


Instalacin:
------------

Cambie las cadenas en SRC/CONFIG.LSP, empleando para ello un editor de
textos.
Luego ejecute

         base/lisp.run -M base/lispinit.mem

Cuando aparezca el inductor de comandos

      > _

teclee

        (compile-file "src/config.lsp")
        (load "src/config.fas")

y luego

        (cd "base/")
        (saveinitmem)

para sobreescribir el fichero LISPINIT.MEM con su configuracin. A
continuacin

        (exit)

El resto se hace simplemente con

        make install

En vez de esto, puede hacerlo usted mismo, paso por paso:

Luego cree un directorio, y ponga en l el ejecutable con la imagen de
memoria.
Le recomiendo /usr/local/lib/lisp :

   mkdir /usr/local/lib/lisp
   mv base/lisp.run /usr/local/lib/lisp
   mv base/lispinit.mem /usr/local/lib/lisp

Y cree el programa que ejeute lisp:

   cc -O -DLISPLIBDIR='"/usr/local/lib/lisp"' \
         -DLOCALEDIR='"/usr/local/share/locale"' \
      src/clisp.c -o /usr/local/bin/clisp

Ahora, instale las pginas de man.

   mv doc/clisp.1 /usr/local/man/man1/clisp.1
   mv doc/clreadline.3 /usr/local/man/man3/clreadline.3

and try

   man clisp


Cuando encuentre problemas:
---------------------------

Despus de un error, se encontrar en el depurador:

     1. Break> _

En l, usted puede evaluar formas como siempre. Ms an:

     Help
               invoca la ayuda
     Abort     o
     Unwind
               retrocede hasta el bucle de entrada ms reciente
     Backtrace
               muestra los contenidos de la pila, til para la depuracin

Y puede consultar el valor de las variables de las funciones donde se
produjo el error.

Cuando los problemas sean mayores, por ejemplo `core dumps', por favor
enve una descripcin del error y una descripcin de cmo reproducir
el error a los autores o al "mantenedor". Por favor, acompae su mensaje
de la versin de CLISP que puede obtener invocando la funcin
(lisp-implementation-version).


Cdigo fuente:
--------------

El cdigo fuente de CLISP est disponible en
     ftp://clisp.cons.org/pub/lisp/clisp/source/clispsrc*


Lista de correo:
----------------

<<<There are three mailing lists for users of CLISP. You find subscription
information and archives on the homepage http://clisp.cons.org/.>>>


Agradecimientos:
----------------

Estamos muy agradecidos a 
  * Guy L. Steele y otros muchos por la especificacin de Common Lisp.
  * El proyecto GNU de Richard Stallman para el GCC, Autoconf y la librera
    readline.


Autores:
--------

        Bruno Haible
        Michael Stoll

Email: clisp-list@lists.sourceforge.net

"Mantenedor":
-------------

        Marcus Daniels

Email: marcus@sysc.pdx.edu
