;;; -*-  Mode: Lisp; Package: Maxima; Syntax: Common-Lisp; Base: 10 -*- ;;;;
;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;
;;;     The data in this file contains enhancments.                    ;;;;;
;;;                                                                    ;;;;;
;;;  Copyright (c) 1984,1987 by William Schelter,University of Texas   ;;;;;
;;;     All rights reserved                                            ;;;;;
;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;

(in-package "MAXIMA")

(defconstant *doc-start* (code-char 31))

(defun $example (item &optional (file
				 (merge-pathnames "manual.demo"
						  $describe_documentation))
		      )
  (and (symbolp file) (setq file (stripdollar file)))
  (or (probe-file file)
      (return-from $example "Please supply a file name as the second arg"))
  (and (symbolp item) (setq item (symbol-name item))
       (setq item (subseq item 1))
       (with-open-file
	(st file)
	(sloop with tem
	       while (setq tem (read-char st nil))
	       do
	       (cond ((and (eql tem #\&)
			   (eql (setq tem (read-char st nil)) #\&))
		      (cond
		       ((and (symbolp (setq tem (read st nil)))
			     (string-search item (symbol-name tem)))
			(format t "~%Examples for ~a :~%" tem)
			;; This code fulls maxima into thinking that it just
			;; started, by resetting the values of the special
			;; variables $labels and $linenum to their initial
			;; values. They will be reset just after $example
			;; is done. The d-labels will also not be disturbed
			;; by calling example.
		        (progv 
		         ;; Protect the user labels and variables 
			 ;; from being voerwritten by creating a new 
			 ;; binding.
		         (append '($linenum
				   $labels
				   $values)
				 (cdr $labels)
				 (cdr $values))
			 (list 1
			       '((mlist simp))
			       '((mlist simp)))
		         ;; Run the example.
			 (unwind-protect
			     (sloop until
				    (or (null (setq tem (peek-char nil st nil)))
					(eql tem #\&))
				    for expr = (mread st nil)
				    do
				    (let ($display2d) (displa (third  expr)))
				    ;; Make the c-label and d-label.
				    (let ((c-label (makelabel $inchar))
					  (d-label (makelabel $outchar)))
				      ;; Set the c-label to the input
				      ;; expression.
				      (set c-label (third expr))
				      (format t "<~d>==>" $linenum)
				      (displa (setq $% (meval* (third  expr))))
				      (set d-label $%)
				      (incf $linenum)
				      ))
			   ;; Clean-up form, which will be
			   ;; evaluated even if an error occurs,
			   ;; because of unwind-protect.  Kill
			   ;; all labels and values used the
			   ;; example. This is harmless, because
			   ;; the local binding established with
			   ;; progv is in effect.
			   (mapc #'makunbound
				 (append
				  (cdr $labels)
				  (cdr $values))
				 )))))))))))

(defun mread-noprompt (&rest read-args)
  (let ((*mread-prompt* ""))
    (declare (special *mread-prompt*))
    (or read-args (setq read-args (list *query-io*)))
  (caddr (apply #'mread read-args))))

;; Some list creation utilities.


(defmacro $create_list(form &rest l)
  `(create-list2 ',form ',l))

(defun create-list2 (form l)
  (cons '(mlist) (apply 'create-list1 form l)))

(defun create-list1(form &rest l &aux lis var1 top)
  (cond ((null l)(list (meval* form)))
	(t
	 (setq var1 (car l)
	       lis (second l)
	       l (cddr l))
	 (or (symbolp var1) (error "~a not a symbol" var1))
 	 (setq lis (meval* lis))
	 (progv (list var1)
		(list nil)
		(cond ((and (numberp lis)
			    (progn
			      (setq top (car l) l (cdr l))
			      (setq top (meval* top))
			      (numberp top)))
		       (sloop for i from lis to top
			      nodeclare t
			      do (set var1 i)
			      append
			      (apply 'create-list1
				     form l)))
		      (($listp lis)
		       (sloop for v in (cdr lis)
			      do (set var1 v)
			      append
			      (apply 'create-list1
				     form l)
			      ))
		      (T (MAXIMA-ERROR "BAD ARG")))))))

#+gcl
(progn
(defvar si::*info-paths* nil)
(setq  SYSTEM::*INFO-PATHS*
       (cons SYSTEM::*INFO-PATHS*
	     (si::string-concatenate *maxima-directory*
				     "info/")))


(defun $describe(x &aux si::*info-paths*)
  (setq x (string-trim "&$" (symbol-name x)))
  (setq  SYSTEM::*INFO-PATHS*
	 (cons  (si::string-concatenate *maxima-directory*
				     "info/")
		SYSTEM::*INFO-PATHS*))
  (if (fboundp 'si::info)
      (si::info x '("maxima.info"))
    "The documentation is now in INFO format and can be printed using
tex, or viewed using info or gnu emacs.   Versions of maxima built
on GCL have a builtin info retrieval mechanism" ))
)
