/*
 * Decompiled with CFR 0.152.
 */
package com.jayway.android.robotium.solo;

import android.app.Instrumentation;
import android.graphics.PointF;
import android.os.SystemClock;
import android.view.MotionEvent;

class Rotator {
    private final Instrumentation _instrument;
    private static final int EVENT_TIME_INTERVAL_MS = 10;
    public static final int LARGE = 0;
    public static final int SMALL = 1;

    public Rotator(Instrumentation inst) {
        this._instrument = inst;
    }

    public void generateRotateGesture(int size, PointF center1, PointF center2) {
        double incrementFactor = 0.0;
        float startX1 = center1.x;
        float startY1 = center1.y;
        float startX2 = center2.x;
        float startY2 = center2.y;
        long downTime = SystemClock.uptimeMillis();
        long eventTime = SystemClock.uptimeMillis();
        float x1 = startX1;
        float y1 = startY1;
        float x2 = startX2;
        float y2 = startY2;
        MotionEvent.PointerCoords[] pointerCoords = new MotionEvent.PointerCoords[2];
        MotionEvent.PointerCoords pc1 = new MotionEvent.PointerCoords();
        MotionEvent.PointerCoords pc2 = new MotionEvent.PointerCoords();
        pc1.x = x1;
        pc1.y = y1;
        pc1.pressure = 1.0f;
        pc1.size = 1.0f;
        pc2.x = x2;
        pc2.y = y2;
        pc2.pressure = 1.0f;
        pc2.size = 1.0f;
        pointerCoords[0] = pc1;
        pointerCoords[1] = pc2;
        MotionEvent.PointerProperties[] pointerProperties = new MotionEvent.PointerProperties[2];
        MotionEvent.PointerProperties pp1 = new MotionEvent.PointerProperties();
        MotionEvent.PointerProperties pp2 = new MotionEvent.PointerProperties();
        pp1.id = 0;
        pp1.toolType = 1;
        pp2.id = 1;
        pp2.toolType = 1;
        pointerProperties[0] = pp1;
        pointerProperties[1] = pp2;
        MotionEvent event = MotionEvent.obtain((long)downTime, (long)eventTime, (int)0, (int)1, (MotionEvent.PointerProperties[])pointerProperties, (MotionEvent.PointerCoords[])pointerCoords, (int)0, (int)0, (float)1.0f, (float)1.0f, (int)0, (int)0, (int)4098, (int)0);
        this._instrument.sendPointerSync(event);
        event = MotionEvent.obtain((long)downTime, (long)eventTime, (int)(5 + (pp2.id << 8)), (int)2, (MotionEvent.PointerProperties[])pointerProperties, (MotionEvent.PointerCoords[])pointerCoords, (int)0, (int)0, (float)1.0f, (float)1.0f, (int)0, (int)0, (int)4098, (int)0);
        this._instrument.sendPointerSync(event);
        switch (size) {
            case 0: {
                incrementFactor = 0.01;
                break;
            }
            case 1: {
                incrementFactor = 0.1;
            }
        }
        for (double i = 0.0; i < Math.PI; i += incrementFactor) {
            pointerCoords[0].x = (float)((double)pointerCoords[0].x + Math.cos(i));
            pointerCoords[0].y = (float)((double)pointerCoords[0].y + Math.sin(i));
            pointerCoords[1].x = (float)((double)pointerCoords[1].x + Math.cos(i + Math.PI));
            pointerCoords[1].y = (float)((double)pointerCoords[1].y + Math.sin(i + Math.PI));
            event = MotionEvent.obtain((long)downTime, (long)(eventTime += 10L), (int)2, (int)2, (MotionEvent.PointerProperties[])pointerProperties, (MotionEvent.PointerCoords[])pointerCoords, (int)0, (int)0, (float)1.0f, (float)1.0f, (int)0, (int)0, (int)4098, (int)0);
            this._instrument.sendPointerSync(event);
        }
        event = MotionEvent.obtain((long)downTime, (long)(eventTime += 10L), (int)(6 + (pp2.id << 8)), (int)2, (MotionEvent.PointerProperties[])pointerProperties, (MotionEvent.PointerCoords[])pointerCoords, (int)0, (int)0, (float)1.0f, (float)1.0f, (int)0, (int)0, (int)4098, (int)0);
        this._instrument.sendPointerSync(event);
        event = MotionEvent.obtain((long)downTime, (long)(eventTime += 10L), (int)1, (int)1, (MotionEvent.PointerProperties[])pointerProperties, (MotionEvent.PointerCoords[])pointerCoords, (int)0, (int)0, (float)1.0f, (float)1.0f, (int)0, (int)0, (int)4098, (int)0);
        this._instrument.sendPointerSync(event);
    }
}

