/*
 * Decompiled with CFR 0.152.
 */
package com.jayway.android.robotium.solo;

import android.app.Activity;
import android.app.Instrumentation;
import android.content.IntentFilter;
import android.util.Log;
import com.jayway.android.robotium.solo.Sleeper;
import java.lang.ref.WeakReference;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.Stack;
import java.util.Timer;
import java.util.TimerTask;
import junit.framework.Assert;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
class ActivityUtils {
    private final Instrumentation inst;
    private Instrumentation.ActivityMonitor activityMonitor;
    private Activity activity;
    private final Sleeper sleeper;
    private final String LOG_TAG = "Robotium";
    private final int MINISLEEP = 100;
    private static final int ACTIVITYSYNCTIME = 50;
    private Stack<WeakReference<Activity>> activityStack;
    private WeakReference<Activity> weakActivityReference;
    private Stack<String> activitiesStoredInActivityStack;
    private Timer activitySyncTimer;

    public ActivityUtils(Instrumentation inst, Activity activity, Sleeper sleeper) {
        this.inst = inst;
        this.activity = activity;
        this.sleeper = sleeper;
        this.createStackAndPushStartActivity();
        this.activitySyncTimer = new Timer();
        this.activitiesStoredInActivityStack = new Stack();
        this.setupActivityMonitor();
        this.setupActivityStackListener();
    }

    private void createStackAndPushStartActivity() {
        this.activityStack = new Stack();
        if (this.activity != null) {
            WeakReference<Activity> weakReference = new WeakReference<Activity>(this.activity);
            this.activity = null;
            this.activityStack.push(weakReference);
        }
    }

    public ArrayList<Activity> getAllOpenedActivities() {
        ArrayList<Activity> activities = new ArrayList<Activity>();
        Iterator activityStackIterator = this.activityStack.iterator();
        while (activityStackIterator.hasNext()) {
            Activity activity = (Activity)((WeakReference)activityStackIterator.next()).get();
            if (activity == null) continue;
            activities.add(activity);
        }
        return activities;
    }

    private void setupActivityMonitor() {
        try {
            IntentFilter filter = null;
            this.activityMonitor = this.inst.addMonitor(filter, null, false);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    private void setupActivityStackListener() {
        TimerTask activitySyncTimerTask = new TimerTask(){

            public void run() {
                Activity activity;
                if (ActivityUtils.this.activityMonitor != null && (activity = ActivityUtils.this.activityMonitor.getLastActivity()) != null) {
                    if (!ActivityUtils.this.activitiesStoredInActivityStack.isEmpty() && ((String)ActivityUtils.this.activitiesStoredInActivityStack.peek()).equals(activity.toString())) {
                        return;
                    }
                    if (!activity.isFinishing()) {
                        if (ActivityUtils.this.activitiesStoredInActivityStack.remove(activity.toString())) {
                            ActivityUtils.this.removeActivityFromStack(activity);
                        }
                        ActivityUtils.this.addActivityToStack(activity);
                    }
                }
            }
        };
        this.activitySyncTimer.schedule(activitySyncTimerTask, 0L, 50L);
    }

    private void removeActivityFromStack(Activity activity) {
        Iterator activityStackIterator = this.activityStack.iterator();
        while (activityStackIterator.hasNext()) {
            Activity activityFromWeakReference = (Activity)((WeakReference)activityStackIterator.next()).get();
            if (activityFromWeakReference == null) {
                activityStackIterator.remove();
            }
            if (activity == null || activityFromWeakReference == null || !activityFromWeakReference.equals(activity)) continue;
            activityStackIterator.remove();
        }
    }

    public Instrumentation.ActivityMonitor getActivityMonitor() {
        return this.activityMonitor;
    }

    public void setActivityOrientation(int orientation) {
        Activity activity = this.getCurrentActivity();
        activity.setRequestedOrientation(orientation);
    }

    public Activity getCurrentActivity() {
        return this.getCurrentActivity(true);
    }

    private void addActivityToStack(Activity activity) {
        this.activitiesStoredInActivityStack.add(activity.toString());
        this.weakActivityReference = new WeakReference<Activity>(activity);
        activity = null;
        this.activityStack.push(this.weakActivityReference);
    }

    private final void waitForActivityIfNotAvailable() {
        if (this.activityStack.isEmpty() || this.activityStack.peek().get() == null) {
            if (this.activityMonitor != null) {
                Activity activity = this.activityMonitor.getLastActivity();
                while (activity == null) {
                    this.sleeper.sleepMini();
                    activity = this.activityMonitor.getLastActivity();
                }
                this.addActivityToStack(activity);
            } else {
                this.sleeper.sleepMini();
                this.setupActivityMonitor();
                this.waitForActivityIfNotAvailable();
            }
        }
    }

    public Activity getCurrentActivity(boolean shouldSleepFirst) {
        if (shouldSleepFirst) {
            this.sleeper.sleep();
        }
        this.waitForActivityIfNotAvailable();
        if (!this.activityStack.isEmpty()) {
            this.activity = (Activity)this.activityStack.peek().get();
        }
        return this.activity;
    }

    public void goBackToActivity(String name) {
        int i;
        ArrayList<Activity> activitiesOpened = this.getAllOpenedActivities();
        boolean found = false;
        for (i = 0; i < activitiesOpened.size(); ++i) {
            if (!activitiesOpened.get(i).getClass().getSimpleName().equals(name)) continue;
            found = true;
            break;
        }
        if (found) {
            while (!this.getCurrentActivity().getClass().getSimpleName().equals(name)) {
                try {
                    this.inst.sendKeyDownUpSync(4);
                }
                catch (SecurityException ignored) {}
            }
        } else {
            for (i = 0; i < activitiesOpened.size(); ++i) {
                Log.d((String)"Robotium", (String)("Activity priorly opened: " + activitiesOpened.get(i).getClass().getSimpleName()));
            }
            Assert.assertTrue((String)("No Activity named " + name + " has been priorly opened"), (boolean)false);
        }
    }

    public String getString(int resId) {
        Activity activity = this.getCurrentActivity(false);
        return activity.getString(resId);
    }

    public void finalize() throws Throwable {
        this.activitySyncTimer.cancel();
        try {
            if (this.activityMonitor != null) {
                this.inst.removeMonitor(this.activityMonitor);
                this.activityMonitor = null;
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        super.finalize();
    }

    public void finishInactiveActivities() {
        Iterator iter = this.activityStack.iterator();
        while (iter.hasNext()) {
            Activity activity = (Activity)((WeakReference)iter.next()).get();
            if (activity == this.getCurrentActivity()) continue;
            this.finishActivity(activity);
            iter.remove();
        }
    }

    public void finishOpenedActivities() {
        this.activitySyncTimer.cancel();
        ArrayList<Activity> activitiesOpened = this.getAllOpenedActivities();
        for (int i = activitiesOpened.size() - 1; i >= 0; --i) {
            this.sleeper.sleep(100);
            this.finishActivity(activitiesOpened.get(i));
        }
        activitiesOpened = null;
        this.finishActivity(this.getCurrentActivity());
        this.activity = null;
        this.sleeper.sleepMini();
        try {
            this.inst.sendKeyDownUpSync(4);
            this.sleeper.sleep(100);
            this.inst.sendKeyDownUpSync(4);
        }
        catch (Throwable throwable) {
            // empty catch block
        }
        this.clearActivityStack();
    }

    private void clearActivityStack() {
        this.activityStack.clear();
        this.activitiesStoredInActivityStack.clear();
    }

    private void finishActivity(Activity activity) {
        try {
            activity.finish();
        }
        catch (Throwable e) {
            e.printStackTrace();
        }
    }
}

