/* LIBGIMP - The GIMP Library
 * Copyright (C) 1995-2000 Peter Mattis and Spencer Kimball
 *
 * gimptools_pdb.c
 *
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Lesser General Public
 * License as published by the Free Software Foundation; either
 * version 2 of the License, or (at your option) any later version.
 *
 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Lesser General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public
 * License along with this library; if not, write to the
 * Free Software Foundation, Inc., 59 Temple Place - Suite 330,
 * Boston, MA 02111-1307, USA.
 */

/* NOTE: This file is autogenerated by pdbgen.pl */

#include "gimp.h"

void
gimp_airbrush (gint32   drawable_ID,
	       gdouble  pressure,
	       gint     num_strokes,
	       gdouble *strokes)
{
  GimpParam *return_vals;
  gint nreturn_vals;

  return_vals = gimp_run_procedure ("gimp_airbrush",
				    &nreturn_vals,
				    GIMP_PDB_DRAWABLE, drawable_ID,
				    GIMP_PDB_FLOAT, pressure,
				    GIMP_PDB_INT32, num_strokes,
				    GIMP_PDB_FLOATARRAY, strokes,
				    GIMP_PDB_END);

  gimp_destroy_params (return_vals, nreturn_vals);
}

void
gimp_airbrush_default (gint32   drawable_ID,
		       gint     num_strokes,
		       gdouble *strokes)
{
  GimpParam *return_vals;
  gint nreturn_vals;

  return_vals = gimp_run_procedure ("gimp_airbrush_default",
				    &nreturn_vals,
				    GIMP_PDB_DRAWABLE, drawable_ID,
				    GIMP_PDB_INT32, num_strokes,
				    GIMP_PDB_FLOATARRAY, strokes,
				    GIMP_PDB_END);

  gimp_destroy_params (return_vals, nreturn_vals);
}

void
gimp_blend (gint32               drawable_ID,
	    GimpBlendMode        blend_mode,
	    GimpLayerModeEffects paint_mode,
	    GimpGradientType     gradient_type,
	    gdouble              opacity,
	    gdouble              offset,
	    GimpRepeatMode       repeat,
	    gboolean             supersample,
	    gint                 max_depth,
	    gdouble              threshold,
	    gdouble              x1,
	    gdouble              y1,
	    gdouble              x2,
	    gdouble              y2)
{
  GimpParam *return_vals;
  gint nreturn_vals;

  return_vals = gimp_run_procedure ("gimp_blend",
				    &nreturn_vals,
				    GIMP_PDB_DRAWABLE, drawable_ID,
				    GIMP_PDB_INT32, blend_mode,
				    GIMP_PDB_INT32, paint_mode,
				    GIMP_PDB_INT32, gradient_type,
				    GIMP_PDB_FLOAT, opacity,
				    GIMP_PDB_FLOAT, offset,
				    GIMP_PDB_INT32, repeat,
				    GIMP_PDB_INT32, supersample,
				    GIMP_PDB_INT32, max_depth,
				    GIMP_PDB_FLOAT, threshold,
				    GIMP_PDB_FLOAT, x1,
				    GIMP_PDB_FLOAT, y1,
				    GIMP_PDB_FLOAT, x2,
				    GIMP_PDB_FLOAT, y2,
				    GIMP_PDB_END);

  gimp_destroy_params (return_vals, nreturn_vals);
}

void
gimp_bucket_fill (gint32               drawable_ID,
		  GimpBucketFillMode   fill_mode,
		  GimpLayerModeEffects paint_mode,
		  gdouble              opacity,
		  gdouble              threshold,
		  gboolean             sample_merged,
		  gdouble              x,
		  gdouble              y)
{
  GimpParam *return_vals;
  gint nreturn_vals;

  return_vals = gimp_run_procedure ("gimp_bucket_fill",
				    &nreturn_vals,
				    GIMP_PDB_DRAWABLE, drawable_ID,
				    GIMP_PDB_INT32, fill_mode,
				    GIMP_PDB_INT32, paint_mode,
				    GIMP_PDB_FLOAT, opacity,
				    GIMP_PDB_FLOAT, threshold,
				    GIMP_PDB_INT32, sample_merged,
				    GIMP_PDB_FLOAT, x,
				    GIMP_PDB_FLOAT, y,
				    GIMP_PDB_END);

  gimp_destroy_params (return_vals, nreturn_vals);
}

void
gimp_by_color_select (gint32         drawable_ID,
		      guchar         red,
		      guchar         green,
		      guchar         blue,
		      gint           threshold,
		      GimpChannelOps operation,
		      gboolean       antialias,
		      gboolean       feather,
		      gdouble        feather_radius,
		      gboolean       sample_merged)
{
  GimpParam *return_vals;
  gint nreturn_vals;
  guchar color[3];

  color[0] = red;
  color[1] = green;
  color[2] = blue;

  return_vals = gimp_run_procedure ("gimp_by_color_select",
				    &nreturn_vals,
				    GIMP_PDB_DRAWABLE, drawable_ID,
				    GIMP_PDB_COLOR, color,
				    GIMP_PDB_INT32, threshold,
				    GIMP_PDB_INT32, operation,
				    GIMP_PDB_INT32, antialias,
				    GIMP_PDB_INT32, feather,
				    GIMP_PDB_FLOAT, feather_radius,
				    GIMP_PDB_INT32, sample_merged,
				    GIMP_PDB_END);

  gimp_destroy_params (return_vals, nreturn_vals);
}

void
gimp_clone (gint32         drawable_ID,
	    gint32         src_drawable_ID,
	    GimpCloneType  clone_type,
	    gdouble        src_x,
	    gdouble        src_y,
	    gint           num_strokes,
	    gdouble       *strokes)
{
  GimpParam *return_vals;
  gint nreturn_vals;

  return_vals = gimp_run_procedure ("gimp_clone",
				    &nreturn_vals,
				    GIMP_PDB_DRAWABLE, drawable_ID,
				    GIMP_PDB_DRAWABLE, src_drawable_ID,
				    GIMP_PDB_INT32, clone_type,
				    GIMP_PDB_FLOAT, src_x,
				    GIMP_PDB_FLOAT, src_y,
				    GIMP_PDB_INT32, num_strokes,
				    GIMP_PDB_FLOATARRAY, strokes,
				    GIMP_PDB_END);

  gimp_destroy_params (return_vals, nreturn_vals);
}

void
gimp_clone_default (gint32   drawable_ID,
		    gint     num_strokes,
		    gdouble *strokes)
{
  GimpParam *return_vals;
  gint nreturn_vals;

  return_vals = gimp_run_procedure ("gimp_clone_default",
				    &nreturn_vals,
				    GIMP_PDB_DRAWABLE, drawable_ID,
				    GIMP_PDB_INT32, num_strokes,
				    GIMP_PDB_FLOATARRAY, strokes,
				    GIMP_PDB_END);

  gimp_destroy_params (return_vals, nreturn_vals);
}

void
gimp_color_picker (gint32    image_ID,
		   gint32    drawable_ID,
		   gdouble   x,
		   gdouble   y,
		   gboolean  sample_merged,
		   gboolean  sample_average,
		   gdouble   average_radius,
		   gboolean  save_color,
		   guchar   *red,
		   guchar   *green,
		   guchar   *blue)
{
  GimpParam *return_vals;
  gint nreturn_vals;

  return_vals = gimp_run_procedure ("gimp_color_picker",
				    &nreturn_vals,
				    GIMP_PDB_IMAGE, image_ID,
				    GIMP_PDB_DRAWABLE, drawable_ID,
				    GIMP_PDB_FLOAT, x,
				    GIMP_PDB_FLOAT, y,
				    GIMP_PDB_INT32, sample_merged,
				    GIMP_PDB_INT32, sample_average,
				    GIMP_PDB_FLOAT, average_radius,
				    GIMP_PDB_INT32, save_color,
				    GIMP_PDB_END);

  if (return_vals[0].data.d_status == GIMP_PDB_SUCCESS)
    {
      *red = return_vals[1].data.d_color.red;
      *green = return_vals[1].data.d_color.green;
      *blue = return_vals[1].data.d_color.blue;
    }

  gimp_destroy_params (return_vals, nreturn_vals);
}

void
gimp_convolve (gint32            drawable_ID,
	       gdouble           pressure,
	       GimpConvolveType  convolve_type,
	       gint              num_strokes,
	       gdouble          *strokes)
{
  GimpParam *return_vals;
  gint nreturn_vals;

  return_vals = gimp_run_procedure ("gimp_convolve",
				    &nreturn_vals,
				    GIMP_PDB_DRAWABLE, drawable_ID,
				    GIMP_PDB_FLOAT, pressure,
				    GIMP_PDB_INT32, convolve_type,
				    GIMP_PDB_INT32, num_strokes,
				    GIMP_PDB_FLOATARRAY, strokes,
				    GIMP_PDB_END);

  gimp_destroy_params (return_vals, nreturn_vals);
}

void
gimp_convolve_default (gint32   drawable_ID,
		       gint     num_strokes,
		       gdouble *strokes)
{
  GimpParam *return_vals;
  gint nreturn_vals;

  return_vals = gimp_run_procedure ("gimp_convolve_default",
				    &nreturn_vals,
				    GIMP_PDB_DRAWABLE, drawable_ID,
				    GIMP_PDB_INT32, num_strokes,
				    GIMP_PDB_FLOATARRAY, strokes,
				    GIMP_PDB_END);

  gimp_destroy_params (return_vals, nreturn_vals);
}

void
gimp_crop (gint32 image_ID,
	   gint   new_width,
	   gint   new_height,
	   gint   offx,
	   gint   offy)
{
  GimpParam *return_vals;
  gint nreturn_vals;

  return_vals = gimp_run_procedure ("gimp_crop",
				    &nreturn_vals,
				    GIMP_PDB_IMAGE, image_ID,
				    GIMP_PDB_INT32, new_width,
				    GIMP_PDB_INT32, new_height,
				    GIMP_PDB_INT32, offx,
				    GIMP_PDB_INT32, offy,
				    GIMP_PDB_END);

  gimp_destroy_params (return_vals, nreturn_vals);
}

void
gimp_dodgeburn (gint32             drawable_ID,
		gdouble            exposure,
		GimpDodgeBurnType  dodgeburn_type,
		GimpDodgeBurnMode  dodgeburn_mode,
		gint               num_strokes,
		gdouble           *strokes)
{
  GimpParam *return_vals;
  gint nreturn_vals;

  return_vals = gimp_run_procedure ("gimp_dodgeburn",
				    &nreturn_vals,
				    GIMP_PDB_DRAWABLE, drawable_ID,
				    GIMP_PDB_FLOAT, exposure,
				    GIMP_PDB_INT32, dodgeburn_type,
				    GIMP_PDB_INT32, dodgeburn_mode,
				    GIMP_PDB_INT32, num_strokes,
				    GIMP_PDB_FLOATARRAY, strokes,
				    GIMP_PDB_END);

  gimp_destroy_params (return_vals, nreturn_vals);
}

void
gimp_dodgeburn_default (gint32   drawable_ID,
			gint     num_strokes,
			gdouble *strokes)
{
  GimpParam *return_vals;
  gint nreturn_vals;

  return_vals = gimp_run_procedure ("gimp_dodgeburn_default",
				    &nreturn_vals,
				    GIMP_PDB_DRAWABLE, drawable_ID,
				    GIMP_PDB_INT32, num_strokes,
				    GIMP_PDB_FLOATARRAY, strokes,
				    GIMP_PDB_END);

  gimp_destroy_params (return_vals, nreturn_vals);
}

void
gimp_ellipse_select (gint32         image_ID,
		     gdouble        x,
		     gdouble        y,
		     gdouble        width,
		     gdouble        height,
		     GimpChannelOps operation,
		     gboolean       antialias,
		     gboolean       feather,
		     gdouble        feather_radius)
{
  GimpParam *return_vals;
  gint nreturn_vals;

  return_vals = gimp_run_procedure ("gimp_ellipse_select",
				    &nreturn_vals,
				    GIMP_PDB_IMAGE, image_ID,
				    GIMP_PDB_FLOAT, x,
				    GIMP_PDB_FLOAT, y,
				    GIMP_PDB_FLOAT, width,
				    GIMP_PDB_FLOAT, height,
				    GIMP_PDB_INT32, operation,
				    GIMP_PDB_INT32, antialias,
				    GIMP_PDB_INT32, feather,
				    GIMP_PDB_FLOAT, feather_radius,
				    GIMP_PDB_END);

  gimp_destroy_params (return_vals, nreturn_vals);
}

void
gimp_eraser (gint32                    drawable_ID,
	     gint                      num_strokes,
	     gdouble                  *strokes,
	     GimpBrushApplicationMode  hardness,
	     GimpPaintApplicationMode  method)
{
  GimpParam *return_vals;
  gint nreturn_vals;

  return_vals = gimp_run_procedure ("gimp_eraser",
				    &nreturn_vals,
				    GIMP_PDB_DRAWABLE, drawable_ID,
				    GIMP_PDB_INT32, num_strokes,
				    GIMP_PDB_FLOATARRAY, strokes,
				    GIMP_PDB_INT32, hardness,
				    GIMP_PDB_INT32, method,
				    GIMP_PDB_END);

  gimp_destroy_params (return_vals, nreturn_vals);
}

void
gimp_eraser_default (gint32   drawable_ID,
		     gint     num_strokes,
		     gdouble *strokes)
{
  GimpParam *return_vals;
  gint nreturn_vals;

  return_vals = gimp_run_procedure ("gimp_eraser_default",
				    &nreturn_vals,
				    GIMP_PDB_DRAWABLE, drawable_ID,
				    GIMP_PDB_INT32, num_strokes,
				    GIMP_PDB_FLOATARRAY, strokes,
				    GIMP_PDB_END);

  gimp_destroy_params (return_vals, nreturn_vals);
}

gint32
gimp_flip (gint32              drawable_ID,
	   GimpOrientationType flip_type)
{
  GimpParam *return_vals;
  gint nreturn_vals;
  gint32 ret_drawable_ID = -1;

  return_vals = gimp_run_procedure ("gimp_flip",
				    &nreturn_vals,
				    GIMP_PDB_DRAWABLE, drawable_ID,
				    GIMP_PDB_INT32, flip_type,
				    GIMP_PDB_END);

  if (return_vals[0].data.d_status == GIMP_PDB_SUCCESS)
    ret_drawable_ID = return_vals[1].data.d_drawable;

  gimp_destroy_params (return_vals, nreturn_vals);

  return ret_drawable_ID;
}

void
gimp_free_select (gint32          image_ID,
		  gint            num_segs,
		  gdouble        *segs,
		  GimpChannelOps  operation,
		  gboolean        antialias,
		  gboolean        feather,
		  gdouble         feather_radius)
{
  GimpParam *return_vals;
  gint nreturn_vals;

  return_vals = gimp_run_procedure ("gimp_free_select",
				    &nreturn_vals,
				    GIMP_PDB_IMAGE, image_ID,
				    GIMP_PDB_INT32, num_segs,
				    GIMP_PDB_FLOATARRAY, segs,
				    GIMP_PDB_INT32, operation,
				    GIMP_PDB_INT32, antialias,
				    GIMP_PDB_INT32, feather,
				    GIMP_PDB_FLOAT, feather_radius,
				    GIMP_PDB_END);

  gimp_destroy_params (return_vals, nreturn_vals);
}

void
gimp_fuzzy_select (gint32         drawable_ID,
		   gdouble        x,
		   gdouble        y,
		   gint           threshold,
		   GimpChannelOps operation,
		   gboolean       antialias,
		   gboolean       feather,
		   gdouble        feather_radius,
		   gboolean       sample_merged)
{
  GimpParam *return_vals;
  gint nreturn_vals;

  return_vals = gimp_run_procedure ("gimp_fuzzy_select",
				    &nreturn_vals,
				    GIMP_PDB_DRAWABLE, drawable_ID,
				    GIMP_PDB_FLOAT, x,
				    GIMP_PDB_FLOAT, y,
				    GIMP_PDB_INT32, threshold,
				    GIMP_PDB_INT32, operation,
				    GIMP_PDB_INT32, antialias,
				    GIMP_PDB_INT32, feather,
				    GIMP_PDB_FLOAT, feather_radius,
				    GIMP_PDB_INT32, sample_merged,
				    GIMP_PDB_END);

  gimp_destroy_params (return_vals, nreturn_vals);
}

void
gimp_paintbrush (gint32                    drawable_ID,
		 gdouble                   fade_out,
		 gint                      num_strokes,
		 gdouble                  *strokes,
		 GimpPaintApplicationMode  method,
		 gdouble                   gradient_length)
{
  GimpParam *return_vals;
  gint nreturn_vals;

  return_vals = gimp_run_procedure ("gimp_paintbrush",
				    &nreturn_vals,
				    GIMP_PDB_DRAWABLE, drawable_ID,
				    GIMP_PDB_FLOAT, fade_out,
				    GIMP_PDB_INT32, num_strokes,
				    GIMP_PDB_FLOATARRAY, strokes,
				    GIMP_PDB_INT32, method,
				    GIMP_PDB_FLOAT, gradient_length,
				    GIMP_PDB_END);

  gimp_destroy_params (return_vals, nreturn_vals);
}

void
gimp_paintbrush_default (gint32   drawable_ID,
			 gint     num_strokes,
			 gdouble *strokes)
{
  GimpParam *return_vals;
  gint nreturn_vals;

  return_vals = gimp_run_procedure ("gimp_paintbrush_default",
				    &nreturn_vals,
				    GIMP_PDB_DRAWABLE, drawable_ID,
				    GIMP_PDB_INT32, num_strokes,
				    GIMP_PDB_FLOATARRAY, strokes,
				    GIMP_PDB_END);

  gimp_destroy_params (return_vals, nreturn_vals);
}

void
gimp_pencil (gint32   drawable_ID,
	     gint     num_strokes,
	     gdouble *strokes)
{
  GimpParam *return_vals;
  gint nreturn_vals;

  return_vals = gimp_run_procedure ("gimp_pencil",
				    &nreturn_vals,
				    GIMP_PDB_DRAWABLE, drawable_ID,
				    GIMP_PDB_INT32, num_strokes,
				    GIMP_PDB_FLOATARRAY, strokes,
				    GIMP_PDB_END);

  gimp_destroy_params (return_vals, nreturn_vals);
}

gint32
gimp_perspective (gint32   drawable_ID,
		  gboolean interpolation,
		  gdouble  x0,
		  gdouble  y0,
		  gdouble  x1,
		  gdouble  y1,
		  gdouble  x2,
		  gdouble  y2,
		  gdouble  x3,
		  gdouble  y3)
{
  GimpParam *return_vals;
  gint nreturn_vals;
  gint32 ret_drawable_ID = -1;

  return_vals = gimp_run_procedure ("gimp_perspective",
				    &nreturn_vals,
				    GIMP_PDB_DRAWABLE, drawable_ID,
				    GIMP_PDB_INT32, interpolation,
				    GIMP_PDB_FLOAT, x0,
				    GIMP_PDB_FLOAT, y0,
				    GIMP_PDB_FLOAT, x1,
				    GIMP_PDB_FLOAT, y1,
				    GIMP_PDB_FLOAT, x2,
				    GIMP_PDB_FLOAT, y2,
				    GIMP_PDB_FLOAT, x3,
				    GIMP_PDB_FLOAT, y3,
				    GIMP_PDB_END);

  if (return_vals[0].data.d_status == GIMP_PDB_SUCCESS)
    ret_drawable_ID = return_vals[1].data.d_drawable;

  gimp_destroy_params (return_vals, nreturn_vals);

  return ret_drawable_ID;
}

void
gimp_rect_select (gint32         image_ID,
		  gdouble        x,
		  gdouble        y,
		  gdouble        width,
		  gdouble        height,
		  GimpChannelOps operation,
		  gboolean       feather,
		  gdouble        feather_radius)
{
  GimpParam *return_vals;
  gint nreturn_vals;

  return_vals = gimp_run_procedure ("gimp_rect_select",
				    &nreturn_vals,
				    GIMP_PDB_IMAGE, image_ID,
				    GIMP_PDB_FLOAT, x,
				    GIMP_PDB_FLOAT, y,
				    GIMP_PDB_FLOAT, width,
				    GIMP_PDB_FLOAT, height,
				    GIMP_PDB_INT32, operation,
				    GIMP_PDB_INT32, feather,
				    GIMP_PDB_FLOAT, feather_radius,
				    GIMP_PDB_END);

  gimp_destroy_params (return_vals, nreturn_vals);
}

gint32
gimp_rotate (gint32   drawable_ID,
	     gboolean interpolation,
	     gdouble  angle)
{
  GimpParam *return_vals;
  gint nreturn_vals;
  gint32 ret_drawable_ID = -1;

  return_vals = gimp_run_procedure ("gimp_rotate",
				    &nreturn_vals,
				    GIMP_PDB_DRAWABLE, drawable_ID,
				    GIMP_PDB_INT32, interpolation,
				    GIMP_PDB_FLOAT, angle,
				    GIMP_PDB_END);

  if (return_vals[0].data.d_status == GIMP_PDB_SUCCESS)
    ret_drawable_ID = return_vals[1].data.d_drawable;

  gimp_destroy_params (return_vals, nreturn_vals);

  return ret_drawable_ID;
}

gint32
gimp_scale (gint32   drawable_ID,
	    gboolean interpolation,
	    gdouble  x0,
	    gdouble  y0,
	    gdouble  x1,
	    gdouble  y1)
{
  GimpParam *return_vals;
  gint nreturn_vals;
  gint32 ret_drawable_ID = -1;

  return_vals = gimp_run_procedure ("gimp_scale",
				    &nreturn_vals,
				    GIMP_PDB_DRAWABLE, drawable_ID,
				    GIMP_PDB_INT32, interpolation,
				    GIMP_PDB_FLOAT, x0,
				    GIMP_PDB_FLOAT, y0,
				    GIMP_PDB_FLOAT, x1,
				    GIMP_PDB_FLOAT, y1,
				    GIMP_PDB_END);

  if (return_vals[0].data.d_status == GIMP_PDB_SUCCESS)
    ret_drawable_ID = return_vals[1].data.d_drawable;

  gimp_destroy_params (return_vals, nreturn_vals);

  return ret_drawable_ID;
}

gint32
gimp_shear (gint32              drawable_ID,
	    gboolean            interpolation,
	    GimpOrientationType shear_type,
	    gdouble             magnitude)
{
  GimpParam *return_vals;
  gint nreturn_vals;
  gint32 ret_drawable_ID = -1;

  return_vals = gimp_run_procedure ("gimp_shear",
				    &nreturn_vals,
				    GIMP_PDB_DRAWABLE, drawable_ID,
				    GIMP_PDB_INT32, interpolation,
				    GIMP_PDB_INT32, shear_type,
				    GIMP_PDB_FLOAT, magnitude,
				    GIMP_PDB_END);

  if (return_vals[0].data.d_status == GIMP_PDB_SUCCESS)
    ret_drawable_ID = return_vals[1].data.d_drawable;

  gimp_destroy_params (return_vals, nreturn_vals);

  return ret_drawable_ID;
}

void
gimp_smudge (gint32   drawable_ID,
	     gdouble  pressure,
	     gint     num_strokes,
	     gdouble *strokes)
{
  GimpParam *return_vals;
  gint nreturn_vals;

  return_vals = gimp_run_procedure ("gimp_smudge",
				    &nreturn_vals,
				    GIMP_PDB_DRAWABLE, drawable_ID,
				    GIMP_PDB_FLOAT, pressure,
				    GIMP_PDB_INT32, num_strokes,
				    GIMP_PDB_FLOATARRAY, strokes,
				    GIMP_PDB_END);

  gimp_destroy_params (return_vals, nreturn_vals);
}

void
gimp_smudge_default (gint32   drawable_ID,
		     gint     num_strokes,
		     gdouble *strokes)
{
  GimpParam *return_vals;
  gint nreturn_vals;

  return_vals = gimp_run_procedure ("gimp_smudge_default",
				    &nreturn_vals,
				    GIMP_PDB_DRAWABLE, drawable_ID,
				    GIMP_PDB_INT32, num_strokes,
				    GIMP_PDB_FLOATARRAY, strokes,
				    GIMP_PDB_END);

  gimp_destroy_params (return_vals, nreturn_vals);
}

gint32
gimp_transform_2d (gint32   drawable_ID,
		   gboolean interpolation,
		   gdouble  source_x,
		   gdouble  source_y,
		   gdouble  scale_x,
		   gdouble  scale_y,
		   gdouble  angle,
		   gdouble  dest_x,
		   gdouble  dest_y)
{
  GimpParam *return_vals;
  gint nreturn_vals;
  gint32 ret_drawable_ID = -1;

  return_vals = gimp_run_procedure ("gimp_transform_2d",
				    &nreturn_vals,
				    GIMP_PDB_DRAWABLE, drawable_ID,
				    GIMP_PDB_INT32, interpolation,
				    GIMP_PDB_FLOAT, source_x,
				    GIMP_PDB_FLOAT, source_y,
				    GIMP_PDB_FLOAT, scale_x,
				    GIMP_PDB_FLOAT, scale_y,
				    GIMP_PDB_FLOAT, angle,
				    GIMP_PDB_FLOAT, dest_x,
				    GIMP_PDB_FLOAT, dest_y,
				    GIMP_PDB_END);

  if (return_vals[0].data.d_status == GIMP_PDB_SUCCESS)
    ret_drawable_ID = return_vals[1].data.d_drawable;

  gimp_destroy_params (return_vals, nreturn_vals);

  return ret_drawable_ID;
}
