static const char* op_c_source =
"/* This file is an image processing operation for GEGL                        \n"
" * GEGL is free software; you can redistribute it and/or                      \n"
" * modify it under the terms of the GNU Lesser General Public                 \n"
" * License as published by the Free Software Foundation; either               \n"
" * version 3 of the License, or (at your option) any later version.           \n"
" *                                                                            \n"
" * GEGL is distributed in the hope that it will be useful,                    \n"
" * but WITHOUT ANY WARRANTY; without even the implied warranty of             \n"
" * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU          \n"
" * Lesser General Public License for more details.                            \n"
" *                                                                            \n"
" * You should have received a copy of the GNU Lesser General Public           \n"
" * License along with GEGL; if not, see <http://www.gnu.org/licenses/>.       \n"
" *                                                                            \n"
" */                                                                           \n"
"                                                                              \n"
"#include \"config.h\"                                                         \n"
"                                                                              \n"
"#include <glib/gi18n-lib.h>                                                   \n"
"                                                                              \n"
"#ifdef GEGL_PROPERTIES                                                        \n"
"                                                                              \n"
"property_double (s_amount, _(\"shadows amount\"), 0.2)                        \n"
"    value_range (0.0, 1.0)                                                    \n"
"                                                                              \n"
"property_double (s_tonalwidth, _(\"shadows tonal width\"), 0.1)               \n"
"    value_range (0.001, 1.0)                                                  \n"
"                                                                              \n"
"property_double (h_amount, _(\"highlights amount\"), 0.2)                     \n"
"    value_range (0.0, 1.0)                                                    \n"
"                                                                              \n"
"property_double (h_tonalwidth, _(\"highlights tonal width\"), 0.1)            \n"
"    value_range (0.001, 1.0)                                                  \n"
"                                                                              \n"
"#else                                                                         \n"
"                                                                              \n"
"#define GEGL_OP_POINT_COMPOSER3                                               \n"
"#define GEGL_OP_NAME     shadows_highlights_correction                        \n"
"#define GEGL_OP_C_SOURCE shadows-highlights-correction.c                      \n"
"                                                                              \n"
"#include \"gegl-op.h\"                                                        \n"
"#include <math.h>                                                             \n"
"                                                                              \n"
"#define LUT_SIZE 2048                                                         \n"
"                                                                              \n"
"typedef struct                                                                \n"
"{                                                                             \n"
"  gdouble shadows[LUT_SIZE];                                                  \n"
"  gdouble highlights[LUT_SIZE];                                               \n"
"} Luts;                                                                       \n"
"                                                                              \n"
"static void                                                                   \n"
"initialize_luts (GeglProperties *o)                                           \n"
"{                                                                             \n"
"  gint     i, scale = LUT_SIZE - 1;                                           \n"
"  Luts    *luts = (Luts *) o->user_data;                                      \n"
"  gdouble  s_scaled = o->s_tonalwidth * scale;                                \n"
"  gdouble  h_scaled = (1.0 - o->h_tonalwidth) * scale;                        \n"
"                                                                              \n"
"  for (i = 0; i < LUT_SIZE; i++)                                              \n"
"    {                                                                         \n"
"      /* shadows */                                                           \n"
"      if (i < s_scaled)                                                       \n"
"        {                                                                     \n"
"          luts->shadows[i] = 1.0 - pow((i / s_scaled), 2.0);                  \n"
"        }                                                                     \n"
"      else                                                                    \n"
"        {                                                                     \n"
"          luts->shadows[i] = 0.0;                                             \n"
"        }                                                                     \n"
"                                                                              \n"
"      /* highlights */                                                        \n"
"      if (i > h_scaled)                                                       \n"
"        {                                                                     \n"
"          luts->highlights[i] = 1.0 - pow((scale - i) / (scale - h_scaled), 2.0);\n"
"        }                                                                     \n"
"      else                                                                    \n"
"        {                                                                     \n"
"          luts->highlights[i] = 0.0;                                          \n"
"        }                                                                     \n"
"    }                                                                         \n"
"}                                                                             \n"
"                                                                              \n"
"static void                                                                   \n"
"prepare (GeglOperation *operation)                                            \n"
"{                                                                             \n"
"  GeglProperties *o  = GEGL_PROPERTIES (operation);                           \n"
"  const Babl *rgba_f = babl_format (\"R'G'B'A float\");                       \n"
"  const Babl *y_f  = babl_format (\"Y' float\");                              \n"
"                                                                              \n"
"  if (o->user_data == NULL)                                                   \n"
"    o->user_data = g_slice_new0 (Luts);                                       \n"
"                                                                              \n"
"  initialize_luts (o);                                                        \n"
"                                                                              \n"
"  gegl_operation_set_format (operation, \"input\",  rgba_f);                  \n"
"  gegl_operation_set_format (operation, \"aux\",    y_f);                     \n"
"  gegl_operation_set_format (operation, \"aux2\",   y_f);                     \n"
"  gegl_operation_set_format (operation, \"output\", rgba_f);                  \n"
"}                                                                             \n"
"                                                                              \n"
"static void                                                                   \n"
"finalize (GObject *object)                                                    \n"
"{                                                                             \n"
"  GeglProperties *o = GEGL_PROPERTIES (object);                               \n"
"                                                                              \n"
"  if (o->user_data)                                                           \n"
"    {                                                                         \n"
"      g_slice_free (Luts, o->user_data);                                      \n"
"      o->user_data = NULL;                                                    \n"
"    }                                                                         \n"
"                                                                              \n"
"  G_OBJECT_CLASS (gegl_op_parent_class)->finalize (object);                   \n"
"}                                                                             \n"
"                                                                              \n"
"static gboolean                                                               \n"
"process (GeglOperation       *operation,                                      \n"
"         void                *in_buf,                                         \n"
"         void                *aux_buf,                                        \n"
"         void                *aux2_buf,                                       \n"
"         void                *out_buf,                                        \n"
"         glong                n_pixels,                                       \n"
"         const GeglRectangle *roi,                                            \n"
"         gint                 level)                                          \n"
"{                                                                             \n"
"  GeglProperties *o = GEGL_PROPERTIES (operation);                            \n"
"  Luts *luts = (Luts *) o->user_data;                                         \n"
"                                                                              \n"
"  gfloat *src  = in_buf;                                                      \n"
"  gfloat *dst  = out_buf;                                                     \n"
"  gfloat *aux  = aux_buf;                                                     \n"
"  gfloat *aux2 = aux2_buf;                                                    \n"
"                                                                              \n"
"  if (!aux || !aux2)                                                          \n"
"    {                                                                         \n"
"      memcpy (out_buf, in_buf, sizeof (gfloat) * 4 * n_pixels);               \n"
"      return TRUE;                                                            \n"
"    }                                                                         \n"
"                                                                              \n"
"  while (n_pixels--)                                                          \n"
"    {                                                                         \n"
"      gfloat *src_pix               = src;                                    \n"
"      gfloat  shadows_estimation    = *aux;                                   \n"
"      gfloat  highlights_estimation = *aux2;                                  \n"
"                                                                              \n"
"      gdouble correction;                                                     \n"
"      gdouble lut_value;                                                      \n"
"      gint    b;                                                              \n"
"                                                                              \n"
"      /* shadows correction */                                                \n"
"                                                                              \n"
"      if (o->s_amount)                                                        \n"
"        {                                                                     \n"
"          lut_value = luts->shadows[(gint) (shadows_estimation * (LUT_SIZE - 1))];\n"
"                                                                              \n"
"          if (lut_value > 0.0)                                                \n"
"            {                                                                 \n"
"              correction = o->s_amount * lut_value;                           \n"
"                                                                              \n"
"              for (b = 0; b < 3; b++)                                         \n"
"                {                                                             \n"
"                  gfloat new_shadow = 1.0 - shadows_estimation;               \n"
"                                                                              \n"
"                  if (src_pix[b] < 0.5)                                       \n"
"                    new_shadow = 2.0 * src_pix[b] * new_shadow;               \n"
"                  else                                                        \n"
"                    new_shadow = 1.0 - 2.0 * (1.0 - src_pix[b]) * (1.0 - new_shadow);\n"
"                                                                              \n"
"                  src_pix[b] = correction * new_shadow + (1.0 - correction) * src_pix[b];\n"
"                }                                                             \n"
"            }                                                                 \n"
"        }                                                                     \n"
"                                                                              \n"
"      /* highlights correction */                                             \n"
"                                                                              \n"
"      if (o->h_amount)                                                        \n"
"        {                                                                     \n"
"          lut_value = luts->highlights[(gint) (highlights_estimation * (LUT_SIZE - 1))];\n"
"                                                                              \n"
"          if (lut_value > 0.0)                                                \n"
"            {                                                                 \n"
"              correction = o->h_amount * lut_value;                           \n"
"                                                                              \n"
"              for (b = 0; b < 3; b++)                                         \n"
"                {                                                             \n"
"                  gfloat new_highlight = 1.0 - highlights_estimation;         \n"
"                                                                              \n"
"                  if (src_pix[b] < 0.5)                                       \n"
"                    new_highlight = 2.0 * src_pix[b] * new_highlight;         \n"
"                  else                                                        \n"
"                    new_highlight = 1.0 - 2.0 * (1.0 - src_pix[b]) * (1.0 - new_highlight);\n"
"                                                                              \n"
"                  src_pix[b] = correction * new_highlight + (1.0 - correction) * src_pix[b];\n"
"                }                                                             \n"
"            }                                                                 \n"
"        }                                                                     \n"
"                                                                              \n"
"      dst[0] = src_pix[0];                                                    \n"
"      dst[1] = src_pix[1];                                                    \n"
"      dst[2] = src_pix[2];                                                    \n"
"      dst[3] = src[3];                                                        \n"
"                                                                              \n"
"      src += 4;                                                               \n"
"      dst += 4;                                                               \n"
"      aux += 1;                                                               \n"
"      aux2 += 1;                                                              \n"
"    }                                                                         \n"
"                                                                              \n"
"  return TRUE;                                                                \n"
"}                                                                             \n"
"                                                                              \n"
"static GeglRectangle                                                          \n"
"get_bounding_box (GeglOperation *self)                                        \n"
"{                                                                             \n"
"  GeglRectangle  result  = { 0, 0, 0, 0 };                                    \n"
"  GeglRectangle *in_rect = gegl_operation_source_get_bounding_box (self, \"input\");\n"
"                                                                              \n"
"  if (! in_rect)                                                              \n"
"    return result;                                                            \n"
"                                                                              \n"
"  return *in_rect;                                                            \n"
"}                                                                             \n"
"                                                                              \n"
"static void                                                                   \n"
"gegl_op_class_init (GeglOpClass *klass)                                       \n"
"{                                                                             \n"
"  GObjectClass                     *object_class;                             \n"
"  GeglOperationClass               *operation_class;                          \n"
"  GeglOperationPointComposer3Class *point_composer3_class;                    \n"
"                                                                              \n"
"  object_class          = G_OBJECT_CLASS (klass);                             \n"
"  operation_class       = GEGL_OPERATION_CLASS (klass);                       \n"
"  point_composer3_class = GEGL_OPERATION_POINT_COMPOSER3_CLASS (klass);       \n"
"                                                                              \n"
"  object_class->finalize            = finalize;                               \n"
"                                                                              \n"
"  operation_class->prepare          = prepare;                                \n"
"  operation_class->get_bounding_box = get_bounding_box;                       \n"
"  operation_class->opencl_support   = FALSE;                                  \n"
"                                                                              \n"
"  point_composer3_class->process    = process;                                \n"
"                                                                              \n"
"  gegl_operation_class_set_keys (operation_class,                             \n"
"    \"name\",        \"gegl:shadows-highlights-correction\",                  \n"
"    \"categories\",  \"hidden\",                                              \n"
"    \"description\", _(\"Lighten shadows and darken highlights\"),            \n"
"    NULL);                                                                    \n"
"}                                                                             \n"
"                                                                              \n"
"#endif                                                                        \n"
;
