static const char* op_c_source =
"/* This file is an image processing operation for GEGL                        \n"
" *                                                                            \n"
" * GEGL is free software; you can redistribute it and/or                      \n"
" * modify it under the terms of the GNU Lesser General Public                 \n"
" * License as published by the Free Software Foundation; either               \n"
" * version 3 of the License, or (at your option) any later version.           \n"
" *                                                                            \n"
" * GEGL is distributed in the hope that it will be useful,                    \n"
" * but WITHOUT ANY WARRANTY; without even the implied warranty of             \n"
" * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU          \n"
" * Lesser General Public License for more details.                            \n"
" *                                                                            \n"
" * You should have received a copy of the GNU Lesser General Public           \n"
" * License along with GEGL; if not, see <http://www.gnu.org/licenses/>.       \n"
" *                                                                            \n"
" * Copyright 2013 Michael Henning <drawoc@darkrefraction.com>                 \n"
" */                                                                           \n"
"                                                                              \n"
"#include \"config.h\"                                                         \n"
"#include <glib/gi18n-lib.h>                                                   \n"
"                                                                              \n"
"#ifdef GEGL_PROPERTIES                                                        \n"
"                                                                              \n"
"property_pointer (src_profile, _(\"Source Profile\"),                         \n"
"                    _(\"The cmsHPROFILE corresponding to the icc profile for \"\n"
"                      \"the input data.\"))                                   \n"
"                                                                              \n"
"/* These are positioned so their values match up with the LCMS enum */        \n"
"enum_start (gegl_rendering_intent)                                            \n"
"  enum_value (GEGL_RENDERING_INTENT_PERCEPTUAL,                               \n"
"              \"perceptual\",            N_(\"Perceptual\"))                  \n"
"  enum_value (GEGL_RENDERING_INTENT_RELATIVE_COLORIMETRIC,                    \n"
"              \"relative-colorimetric\", N_(\"Relative Colorimetric\"))       \n"
"  enum_value (GEGL_RENDERING_INTENT_SATURATION,                               \n"
"              \"saturation\",            N_(\"Saturation\"))                  \n"
"  enum_value (GEGL_RENDERING_INTENT_ABSOLUTE_COLORIMETRIC,                    \n"
"              \"absolute-colorimetric\", N_(\"Absolute Colorimetric\"))       \n"
"/* TODO: Add the K_ONLY and K_PLANE intents */                                \n"
"enum_end (GeglRenderingIntent)                                                \n"
"                                                                              \n"
"property_enum (intent, _(\"Rendering intent\"),                               \n"
"                 GeglRenderingIntent, gegl_rendering_intent,                  \n"
"                 GEGL_RENDERING_INTENT_PERCEPTUAL)                            \n"
"  description(_(\"The rendering intent to use in the conversion.\"))          \n"
"                                                                              \n"
"property_boolean (black_point_compensation, _(\"Black point compensation\"),  \n"
"                  FALSE)                                                      \n"
"  description (_(\"Convert using black point compensation.\"))                \n"
"                                                                              \n"
"#else                                                                         \n"
"                                                                              \n"
"#define GEGL_OP_FILTER                                                        \n"
"#define GEGL_OP_NAME lcms_from_profile                                        \n"
"#define GEGL_OP_C_SOURCE lcms-from-profile.c                                  \n"
"                                                                              \n"
"#include \"gegl-op.h\"                                                        \n"
"#include <lcms2.h>                                                            \n"
"                                                                              \n"
"static void prepare (GeglOperation *operation)                                \n"
"{                                                                             \n"
"  /* TODO: move input format detection code here */                           \n"
"  gegl_operation_set_format (operation, \"output\", babl_format (\"RGBA float\"));\n"
"}                                                                             \n"
"                                                                              \n"
"/* This profile corresponds to babl_model (\"RGB\") */                        \n"
"static cmsHPROFILE                                                            \n"
"create_lcms_linear_rgb_profile (void)                                         \n"
"{                                                                             \n"
"  cmsHPROFILE ret;                                                            \n"
"                                                                              \n"
"  /* white point is D65 from the sRGB specs */                                \n"
"  cmsCIExyY whitepoint = {0.3127, 0.3290, 1.0};                               \n"
"                                                                              \n"
"  /* primaries are ITU‐R BT.709‐5 (xYY),                                  \n"
"   * which are also the primaries from the sRGB specs,                        \n"
"   * modified to properly account for hexadecimal quantization                \n"
"   * during the profile making process.                                       \n"
"   */                                                                         \n"
"  cmsCIExyYTRIPLE primaries = {                                               \n"
"    /*R {0.6400, 0.3300, 1.0},*/                                              \n"
"    /*G {0.3000, 0.6000, 1.0},*/                                              \n"
"    /*B {0.1500, 0.0600, 1.0} */                                              \n"
"    /*R*/ {0.639998686, 0.330010138, 1.0},                                    \n"
"    /*G*/ {0.300003784, 0.600003357, 1.0},                                    \n"
"    /*B*/ {0.150002046, 0.059997204, 1.0}                                     \n"
"  };                                                                          \n"
"                                                                              \n"
"  /* linear light */                                                          \n"
"  cmsToneCurve* linear[3];                                                    \n"
"  linear[0] = linear[1] = linear[2] = cmsBuildGamma (NULL, 1.0);              \n"
"                                                                              \n"
"  /* create the profile, cleanup, and return */                               \n"
"  ret = cmsCreateRGBProfile (&whitepoint, &primaries, linear);                \n"
"  cmsFreeToneCurve (linear[0]);                                               \n"
"  return ret;                                                                 \n"
"}                                                                             \n"
"                                                                              \n"
"static cmsUInt32Number                                                        \n"
"determine_lcms_format (const Babl *babl, cmsHPROFILE profile)                 \n"
"{                                                                             \n"
"  cmsUInt32Number format = COLORSPACE_SH (PT_ANY);                            \n"
"  gint channels, bpc, alpha;                                                  \n"
"  const Babl *type;                                                           \n"
"                                                                              \n"
"  channels = cmsChannelsOf (cmsGetColorSpace (profile));                      \n"
"  alpha = babl_format_get_n_components (babl) - channels;                     \n"
"  bpc = babl_format_get_bytes_per_pixel (babl)                                \n"
"          / babl_format_get_n_components (babl);                              \n"
"                                                                              \n"
"  type = babl_format_get_type (babl, 0);                                      \n"
"  if (type == babl_type (\"half\") ||                                         \n"
"      type == babl_type (\"float\") ||                                        \n"
"      type == babl_type (\"double\"))                                         \n"
"    format |= FLOAT_SH (1);                                                   \n"
"                                                                              \n"
"  /* bpc == 8 overflows the bitfield otherwise */                             \n"
"  bpc &= 0x07;                                                                \n"
"                                                                              \n"
"  /*                                                                          \n"
"   * This is needed so the alpha component lines up with RGBA float           \n"
"   * for our memcpy hack later on.                                            \n"
"   */                                                                         \n"
"  if (alpha > 1 || (alpha && channels != 3))                                  \n"
"    return 0;                                                                 \n"
"                                                                              \n"
"  format |= EXTRA_SH (alpha) | CHANNELS_SH (channels) | BYTES_SH (bpc);       \n"
"  return format;                                                              \n"
"}                                                                             \n"
"                                                                              \n"
"static gboolean                                                               \n"
"process (GeglOperation       *operation,                                      \n"
"         GeglBuffer          *input,                                          \n"
"         GeglBuffer          *output,                                         \n"
"         const GeglRectangle *result,                                         \n"
"         gint                 level)                                          \n"
"{                                                                             \n"
"  GeglProperties *o = GEGL_PROPERTIES (operation);                            \n"
"                                                                              \n"
"  cmsHTRANSFORM transform;                                                    \n"
"  const Babl *in_format, *out_format;                                         \n"
"                                                                              \n"
"  gboolean alpha;                                                             \n"
"  gint bpp;                                                                   \n"
"                                                                              \n"
"  in_format = babl_format_n (babl_type (\"float\"),                           \n"
"                 babl_format_get_n_components (gegl_buffer_get_format (input)));\n"
"                                                                              \n"
"  bpp = babl_format_get_bytes_per_pixel (in_format);                          \n"
"                                                                              \n"
"  /* create the transformation */                                             \n"
"  {                                                                           \n"
"    cmsHPROFILE in_profile, out_profile;                                      \n"
"    cmsUInt32Number format;                                                   \n"
"                                                                              \n"
"    in_profile = o->src_profile;                                              \n"
"                                                                              \n"
"    format = determine_lcms_format (in_format, in_profile);                   \n"
"                                                                              \n"
"    if (format == 0)                                                          \n"
"      return FALSE;                                                           \n"
"                                                                              \n"
"    if (format & EXTRA_SH (1))                                                \n"
"      alpha = TRUE;                                                           \n"
"    else                                                                      \n"
"      alpha = FALSE;                                                          \n"
"                                                                              \n"
"    out_profile = create_lcms_linear_rgb_profile ();                          \n"
"                                                                              \n"
"    transform = cmsCreateTransform (in_profile, format,                       \n"
"                                    out_profile, alpha ? TYPE_RGBA_FLT : TYPE_RGB_FLT,\n"
"                                    o->intent, o->black_point_compensation ? cmsFLAGS_BLACKPOINTCOMPENSATION : 0);\n"
"                                                                              \n"
"    cmsCloseProfile (out_profile);                                            \n"
"  }                                                                           \n"
"                                                                              \n"
"  out_format = alpha ? babl_format (\"RGBA float\") : babl_format (\"RGB float\");\n"
"                                                                              \n"
"  /* iterate over the pixels */                                               \n"
"  {                                                                           \n"
"    GeglBufferIterator *gi;                                                   \n"
"                                                                              \n"
"    gi = gegl_buffer_iterator_new (input, result, 0, in_format,               \n"
"                                   GEGL_ACCESS_READ, GEGL_ABYSS_NONE);        \n"
"                                                                              \n"
"    gegl_buffer_iterator_add (gi, output, result, 0, out_format,              \n"
"                              GEGL_ACCESS_WRITE, GEGL_ABYSS_NONE);            \n"
"                                                                              \n"
"    while (gegl_buffer_iterator_next (gi))                                    \n"
"      {                                                                       \n"
"        if (alpha)                                                            \n"
"          memcpy (gi->data[1], gi->data[0], bpp * gi->length);                \n"
"                                                                              \n"
"        cmsDoTransform (transform, gi->data[0], gi->data[1], gi->length);     \n"
"      }                                                                       \n"
"  }                                                                           \n"
"                                                                              \n"
"  cmsDeleteTransform (transform);                                             \n"
"                                                                              \n"
"  return TRUE;                                                                \n"
"}                                                                             \n"
"                                                                              \n"
"static gboolean                                                               \n"
"operation_process (GeglOperation        *operation,                           \n"
"                   GeglOperationContext *context,                             \n"
"                   const gchar          *output_prop,                         \n"
"                   const GeglRectangle  *result,                              \n"
"                   gint                  level)                               \n"
"{                                                                             \n"
"  GeglProperties *o = GEGL_PROPERTIES (operation);                            \n"
"  GeglOperationClass  *operation_class;                                       \n"
"                                                                              \n"
"  operation_class = GEGL_OPERATION_CLASS (gegl_op_parent_class);              \n"
"                                                                              \n"
"  /* If the profile is NULL, simply become a nop */                           \n"
"  if (!o->src_profile)                                                        \n"
"    {                                                                         \n"
"      gpointer input = gegl_operation_context_get_object (context, \"input\");\n"
"      gegl_operation_context_take_object (context, \"output\",                \n"
"                                          g_object_ref (input));              \n"
"      return TRUE;                                                            \n"
"    }                                                                         \n"
"                                                                              \n"
"  return operation_class->process (operation, context,                        \n"
"                                   output_prop, result, level);               \n"
"}                                                                             \n"
"                                                                              \n"
"static void                                                                   \n"
"gegl_op_class_init (GeglOpClass *klass)                                       \n"
"{                                                                             \n"
"  GeglOperationClass       *operation_class;                                  \n"
"  GeglOperationFilterClass *filter_class;                                     \n"
"                                                                              \n"
"  operation_class = GEGL_OPERATION_CLASS (klass);                             \n"
"  filter_class    = GEGL_OPERATION_FILTER_CLASS (klass);                      \n"
"                                                                              \n"
"  operation_class->prepare = prepare;                                         \n"
"  operation_class->process = operation_process;                               \n"
"                                                                              \n"
"  filter_class->process = process;                                            \n"
"                                                                              \n"
"  gegl_operation_class_set_keys (operation_class,                             \n"
"    \"name\",        \"gegl:lcms-from-profile\",                              \n"
"    \"title\",       _(\"LCMS From Profile\"),                                \n"
"    \"categories\",  \"color\",                                               \n"
"    \"description\",                                                          \n"
"       _(\"Converts the input from an ICC color profile to \"                 \n"
"         \"a well defined babl format. The buffer's data will then be correctly managed by GEGL for further processing.\"),\n"
"    NULL);                                                                    \n"
"}                                                                             \n"
"#endif                                                                        \n"
;
